/*
 * Decompiled with CFR 0.152.
 */
package ir.amirab.downloader.destination;

import ir.amirab.downloader.destination.DestWriter;
import ir.amirab.downloader.part.DownloadPart;
import ir.amirab.util.FileExtensionsKt;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001b\u001a\u00020\u001cH\u0014J \u0010\u001d\u001a\u00020\u001c2\u0016\b\u0002\u0010\u001e\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010 \u0012\u0004\u0012\u00020\u001c0\u001fH\u0016J\b\u0010!\u001a\u00020\u001cH\u0016J\u0010\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020$H&J\b\u0010%\u001a\u00020\u000fH&J\u0010\u0010&\u001a\u0004\u0018\u00010\u000b2\u0006\u0010'\u001a\u00020\u0015J\b\u0010(\u001a\u00020\u001cH\u0016J$\u0010)\u001a\u00020\u001c2\u0014\u0010\u001e\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010 \u0012\u0004\u0012\u00020\u001c0\u001fH\u00a6@\u00a2\u0006\u0002\u0010*J\u000e\u0010+\u001a\u00020\u000fH\u00a6@\u00a2\u0006\u0002\u0010,J\b\u0010-\u001a\u00020\u001cH&J\u0010\u0010.\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$H\u0016J\u0015\u0010/\u001a\u00020\u001c2\b\u00100\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\u0002\u0010\u0019J\b\u00101\u001a\u00020\u001cH\u0014J\u0010\u00102\u001a\u00020\u001c2\u0006\u00103\u001a\u00020\u0003H\u0016R\u0019\u0010\u0002\u001a\n \u0006*\u0004\u0018\u00010\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0084\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001a\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u00064"}, d2={"Lir/amirab/downloader/destination/DownloadDestination;", "", "outputFile", "Ljava/io/File;", "<init>", "(Ljava/io/File;)V", "kotlin.jvm.PlatformType", "getOutputFile", "()Ljava/io/File;", "fileParts", "", "Lir/amirab/downloader/destination/DestWriter;", "getFileParts", "()Ljava/util/List;", "allPartsDownloaded", "", "getAllPartsDownloaded", "()Z", "setAllPartsDownloaded", "(Z)V", "requestedToChangeLastModified", "", "getRequestedToChangeLastModified", "()Ljava/lang/Long;", "setRequestedToChangeLastModified", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "onAllFilePartsRemoved", "", "onAllPartsCompleted", "onProgressUpdate", "Lkotlin/Function1;", "", "cleanUpJunkFiles", "getWriterFor", "part", "Lir/amirab/downloader/part/DownloadPart;", "canGetFileWriter", "returnIfAlreadyHaveWriter", "partId", "deleteOutputFile", "prepareFile", "(Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isDownloadedPartsIsValid", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "flush", "onPartCancelled", "setLastModified", "timestamp", "updateLastModified", "moveOutput", "to", "core"})
public abstract class DownloadDestination {
    private final File outputFile;
    @NotNull
    private final List<DestWriter> fileParts;
    private boolean allPartsDownloaded;
    @Nullable
    private Long requestedToChangeLastModified;

    public DownloadDestination(@NotNull File outputFile) {
        Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
        this.outputFile = outputFile.getCanonicalFile().getAbsoluteFile();
        this.fileParts = new ArrayList();
    }

    public final File getOutputFile() {
        return this.outputFile;
    }

    @NotNull
    protected final List<DestWriter> getFileParts() {
        return this.fileParts;
    }

    protected final boolean getAllPartsDownloaded() {
        return this.allPartsDownloaded;
    }

    protected final void setAllPartsDownloaded(boolean bl) {
        this.allPartsDownloaded = bl;
    }

    @Nullable
    protected final Long getRequestedToChangeLastModified() {
        return this.requestedToChangeLastModified;
    }

    protected final void setRequestedToChangeLastModified(@Nullable Long l) {
        this.requestedToChangeLastModified = l;
    }

    protected void onAllFilePartsRemoved() {
        this.updateLastModified();
    }

    public void onAllPartsCompleted(@NotNull Function1<? super Integer, Unit> onProgressUpdate) {
        Intrinsics.checkNotNullParameter(onProgressUpdate, (String)"onProgressUpdate");
        this.allPartsDownloaded = true;
        this.cleanUpJunkFiles();
        this.updateLastModified();
    }

    public static /* synthetic */ void onAllPartsCompleted$default(DownloadDestination downloadDestination, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: onAllPartsCompleted");
        }
        if ((n & 1) != 0) {
            function1 = DownloadDestination::onAllPartsCompleted$lambda$0;
        }
        downloadDestination.onAllPartsCompleted((Function1<? super Integer, Unit>)function1);
    }

    public void cleanUpJunkFiles() {
    }

    @NotNull
    public abstract DestWriter getWriterFor(@NotNull DownloadPart var1);

    public abstract boolean canGetFileWriter();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final DestWriter returnIfAlreadyHaveWriter(long partId) {
        DownloadDestination downloadDestination = this;
        synchronized (downloadDestination) {
            Object v0;
            block4: {
                boolean bl = false;
                Iterable iterable = this.fileParts;
                for (Object t : iterable) {
                    DestWriter it = (DestWriter)t;
                    boolean bl2 = false;
                    boolean condition = it.getId() == partId;
                    if (!condition) continue;
                    v0 = t;
                    break block4;
                }
                v0 = null;
            }
            DestWriter destWriter = v0;
            return destWriter;
        }
    }

    public void deleteOutputFile() {
        this.outputFile.delete();
    }

    @Nullable
    public abstract Object prepareFile(@NotNull Function1<? super Integer, Unit> var1, @NotNull Continuation<? super Unit> var2);

    @Nullable
    public abstract Object isDownloadedPartsIsValid(@NotNull Continuation<? super Boolean> var1);

    public abstract void flush();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPartCancelled(@NotNull DownloadPart part) {
        Intrinsics.checkNotNullParameter((Object)part, (String)"part");
        DownloadDestination downloadDestination = this;
        synchronized (downloadDestination) {
            boolean bl = false;
            boolean cleanAny = CollectionsKt.removeAll(this.fileParts, arg_0 -> DownloadDestination.onPartCancelled$lambda$0$0(part, arg_0));
            if (cleanAny && this.fileParts.isEmpty()) {
                this.onAllFilePartsRemoved();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public final void setLastModified(@Nullable Long timestamp) {
        this.requestedToChangeLastModified = timestamp;
    }

    protected void updateLastModified() {
        try {
            Boolean bl;
            boolean bl2 = false;
            Long l = this.requestedToChangeLastModified;
            if (l != null) {
                long it = ((Number)l).longValue();
                boolean bl3 = false;
                bl = this.outputFile.setLastModified(it);
            } else {
                bl = null;
            }
            Object object = Result.constructor-impl(bl);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    public void moveOutput(@NotNull File to) {
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        if (this.outputFile.exists()) {
            try {
                File file = this.outputFile;
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"outputFile");
                FileExtensionsKt.tryAtomicMove((File)file, (File)to);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to move output file to the new destination: " + e.getLocalizedMessage(), e);
            }
        }
    }

    private static final Unit onAllPartsCompleted$lambda$0(Integer it) {
        return Unit.INSTANCE;
    }

    private static final boolean onPartCancelled$lambda$0$0(DownloadPart $part, DestWriter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getId() == $part.getID();
    }
}

