/*
 * Decompiled with CFR 0.152.
 */
package io.lindstrom.m3u8.parser;

import io.lindstrom.m3u8.model.Playlist;
import io.lindstrom.m3u8.parser.PlaylistParserException;
import io.lindstrom.m3u8.parser.TextBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class AbstractPlaylistParser<T extends Playlist, B> {
    private static final String EXTM3U = "#EXTM3U";

    public T readPlaylist(InputStream inputStream) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            T t = this.readPlaylist(reader);
            return t;
        }
    }

    public T readPlaylist(Path path) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
            T t = this.readPlaylist(reader);
            return t;
        }
    }

    public T readPlaylist(final BufferedReader bufferedReader) throws PlaylistParserException {
        Iterator<String> lineIterator = new Iterator<String>(){
            String nextLine = null;

            @Override
            public boolean hasNext() {
                if (this.nextLine != null) {
                    return true;
                }
                try {
                    this.nextLine = bufferedReader.readLine();
                    return this.nextLine != null;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }

            @Override
            public String next() {
                if (this.nextLine != null || this.hasNext()) {
                    String line = this.nextLine;
                    this.nextLine = null;
                    return line;
                }
                throw new NoSuchElementException();
            }
        };
        return this.readPlaylist(lineIterator);
    }

    public T readPlaylist(String string) throws PlaylistParserException {
        return this.readPlaylist(Arrays.asList(string.split("\n")).iterator());
    }

    public T readPlaylist(Iterator<String> lineIterator) throws PlaylistParserException {
        boolean extM3uFound = false;
        while (lineIterator.hasNext() && !extM3uFound) {
            String line = lineIterator.next();
            if (EXTM3U.equals(line)) {
                extM3uFound = true;
                continue;
            }
            if (line.isEmpty()) continue;
            break;
        }
        if (!extM3uFound) {
            throw new PlaylistParserException("Invalid playlist. Expected #EXTM3U.");
        }
        B builder = this.newBuilder();
        while (lineIterator.hasNext()) {
            String line = lineIterator.next();
            if (line.startsWith("#EXT")) {
                int colonPosition = line.indexOf(58);
                String prefix = colonPosition > 0 ? line.substring(1, colonPosition) : line.substring(1);
                String attributes = colonPosition > 0 ? line.substring(colonPosition + 1) : "";
                this.onTag(builder, prefix, attributes, lineIterator);
                continue;
            }
            if (line.isEmpty()) continue;
            if (line.startsWith("#")) {
                this.onComment(builder, line.substring(1));
                continue;
            }
            this.onURI(builder, line);
        }
        return this.build(builder);
    }

    abstract B newBuilder();

    abstract void onTag(B var1, String var2, String var3, Iterator<String> var4) throws PlaylistParserException;

    abstract void onComment(B var1, String var2);

    void onURI(B builder, String uri) throws PlaylistParserException {
        throw new PlaylistParserException("Unexpected URI in playlist: " + uri);
    }

    abstract T build(B var1);

    abstract void write(T var1, TextBuilder var2);

    public String writePlaylistAsString(T playlist) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(EXTM3U).append('\n');
        TextBuilder textBuilder = new TextBuilder(stringBuilder);
        for (String comment : playlist.comments()) {
            if (comment.startsWith("EXT")) continue;
            textBuilder.add("#").add(comment).add("\n");
        }
        this.write(playlist, textBuilder);
        return stringBuilder.toString();
    }

    public byte[] writePlaylistAsBytes(T playlist) {
        return this.writePlaylistAsString(playlist).getBytes(StandardCharsets.UTF_8);
    }

    public ByteBuffer writePlaylistAsByteBuffer(T playlist) {
        return ByteBuffer.wrap(this.writePlaylistAsBytes(playlist));
    }
}

