/*
 * Decompiled with CFR 0.152.
 */
package ir.amirab.util.compose.localizationmanager;

import androidx.compose.runtime.internal.StabilityInferred;
import ir.amirab.util.compose.localizationmanager.LanguageInfo;
import ir.amirab.util.compose.localizationmanager.LanguageManagerKt;
import ir.amirab.util.compose.localizationmanager.LanguageNameProvider;
import ir.amirab.util.compose.localizationmanager.LanguageStorage;
import ir.amirab.util.compose.localizationmanager.LoadedLanguage;
import ir.amirab.util.compose.localizationmanager.MessageData;
import ir.amirab.util.compose.localizationmanager.MyLocale;
import ir.amirab.util.compose.localizationmanager.PropertiesMessageContainer;
import ir.amirab.util.flow.StateFlowUtilKt;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import okio.FileMetadata;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 -2\u00020\u0001:\u0001-B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001d\u001a\u00020\u001c2\b\u0010\u001e\u001a\u0004\u0018\u00010\tJ\u000e\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u0014J\b\u0010!\u001a\u00020\u0014H\u0002J\u0010\u0010'\u001a\u00020&2\u0006\u0010\u001e\u001a\u00020\tH\u0002J\u0010\u0010(\u001a\u00020\t2\u0006\u0010)\u001a\u00020\u0014H\u0002J\b\u0010*\u001a\u00020&H\u0002J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\b\u0010,\u001a\u00020\tH\u0002R\u001a\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001b\u0010\u000e\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u0019\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\rR\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\rR\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lir/amirab/util/compose/localizationmanager/LanguageManager;", "", "storage", "Lir/amirab/util/compose/localizationmanager/LanguageStorage;", "<init>", "(Lir/amirab/util/compose/localizationmanager/LanguageStorage;)V", "_languageList", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "Lir/amirab/util/compose/localizationmanager/LanguageInfo;", "languageList", "Lkotlinx/coroutines/flow/StateFlow;", "getLanguageList", "()Lkotlinx/coroutines/flow/StateFlow;", "systemLanguageOrDefault", "getSystemLanguageOrDefault", "()Lir/amirab/util/compose/localizationmanager/LanguageInfo;", "systemLanguageOrDefault$delegate", "Lkotlin/Lazy;", "selectedLanguageInStorage", "", "getSelectedLanguageInStorage", "()Lkotlinx/coroutines/flow/MutableStateFlow;", "selectedLanguage", "getSelectedLanguage", "isRtl", "", "boot", "", "selectLanguage", "languageInfo", "getMessage", "key", "getRequestedLanguage", "loadedLanguage", "Lir/amirab/util/compose/localizationmanager/LoadedLanguage;", "defaultLanguageData", "Lkotlin/Lazy;", "Lir/amirab/util/compose/localizationmanager/MessageData;", "createMessageContainer", "bestLanguageInfo", "locale", "getMessageContainer", "getAvailableLanguages", "getSystemLanguageIfWeCanUse", "Companion", "compose-utils"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nLanguageManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LanguageManager.kt\nir/amirab/util/compose/localizationmanager/LanguageManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,232:1\n1#2:233\n1#2:244\n1617#3,9:234\n1869#3:243\n1870#3:245\n1626#3:246\n12970#4,2:247\n*S KotlinDebug\n*F\n+ 1 LanguageManager.kt\nir/amirab/util/compose/localizationmanager/LanguageManager\n*L\n125#1:244\n125#1:234,9\n125#1:243\n125#1:245\n125#1:246\n33#1:247,2\n*E\n"})
public final class LanguageManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MutableStateFlow<List<LanguageInfo>> _languageList;
    @NotNull
    private final StateFlow<List<LanguageInfo>> languageList;
    @NotNull
    private final Lazy systemLanguageOrDefault$delegate;
    @NotNull
    private final MutableStateFlow<String> selectedLanguageInStorage;
    @NotNull
    private final StateFlow<String> selectedLanguage;
    @NotNull
    private final StateFlow<Boolean> isRtl;
    @Nullable
    private volatile LoadedLanguage loadedLanguage;
    @NotNull
    private final Lazy<MessageData> defaultLanguageData;
    public static final int $stable = 8;
    public static LanguageManager instance;
    @NotNull
    private static final String LOCALES_PATH = "/com/abdownloadmanager/resources/locales";
    @NotNull
    private static final LanguageInfo DefaultLanguageInfo;
    @NotNull
    private static final String[] rtlLanguages;

    public LanguageManager(@NotNull LanguageStorage storage) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        this._languageList = StateFlowKt.MutableStateFlow((Object)CollectionsKt.emptyList());
        this.languageList = FlowKt.asStateFlow(this._languageList);
        this.systemLanguageOrDefault$delegate = LazyKt.lazy(() -> LanguageManager.systemLanguageOrDefault_delegate$lambda$0(this));
        this.selectedLanguageInStorage = storage.getSelectedLanguage();
        this.selectedLanguage = StateFlowUtilKt.mapStateFlow((StateFlow)((StateFlow)storage.getSelectedLanguage()), arg_0 -> LanguageManager.selectedLanguage$lambda$0(this, arg_0));
        this.isRtl = StateFlowUtilKt.mapStateFlow(this.selectedLanguage, LanguageManager::isRtl$lambda$0);
        this.defaultLanguageData = LazyKt.lazy(() -> LanguageManager.defaultLanguageData$lambda$0(this));
    }

    @NotNull
    public final StateFlow<List<LanguageInfo>> getLanguageList() {
        return this.languageList;
    }

    @NotNull
    public final LanguageInfo getSystemLanguageOrDefault() {
        Lazy lazy = this.systemLanguageOrDefault$delegate;
        return (LanguageInfo)lazy.getValue();
    }

    @NotNull
    public final MutableStateFlow<String> getSelectedLanguageInStorage() {
        return this.selectedLanguageInStorage;
    }

    @NotNull
    public final StateFlow<String> getSelectedLanguage() {
        return this.selectedLanguage;
    }

    @NotNull
    public final StateFlow<Boolean> isRtl() {
        return this.isRtl;
    }

    public final void boot() {
        this._languageList.setValue(this.getAvailableLanguages());
        Companion.setInstance(this);
    }

    public final void selectLanguage(@Nullable LanguageInfo languageInfo) {
        LanguageInfo languageInfo2 = languageInfo;
        this.selectedLanguageInStorage.setValue((Object)(languageInfo2 != null ? languageInfo2.toLocaleString() : null));
    }

    @NotNull
    public final String getMessage(@NotNull String key) {
        String string2;
        block5: {
            block4: {
                String string3;
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                string2 = this.getMessageContainer().getMessage(key);
                if (string2 == null) break block4;
                String it = string3 = string2;
                boolean bl = false;
                string2 = !StringsKt.isBlank((CharSequence)it) ? string3 : null;
                if (string2 != null) break block5;
            }
            if ((string2 = ((MessageData)this.defaultLanguageData.getValue()).getMessage(key)) == null) {
                string2 = key;
            }
        }
        return string2;
    }

    private final String getRequestedLanguage() {
        return (String)this.selectedLanguage.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final MessageData createMessageContainer(LanguageInfo languageInfo) {
        MessageData messageData;
        if (Intrinsics.areEqual((Object)languageInfo, (Object)DefaultLanguageInfo) && this.defaultLanguageData.isInitialized()) {
            messageData = (MessageData)this.defaultLanguageData.getValue();
        } else {
            Object object;
            Object object2;
            Properties properties;
            Properties $this$createMessageContainer_u24lambda_u240 = properties = new Properties();
            boolean bl = false;
            try {
                boolean bl2 = false;
                object2 = new InputStreamReader(Companion.openStream(languageInfo.getPath()), Charsets.UTF_8);
                Throwable throwable = null;
                try {
                    InputStreamReader it = (InputStreamReader)object2;
                    boolean bl3 = false;
                    $this$createMessageContainer_u24lambda_u240.load(it);
                    it = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
                }
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable != null) {
                Object it = object2 = throwable;
                boolean bl4 = false;
                System.out.println((Object)"Error while loading language data!");
                ((Throwable)it).printStackTrace();
            }
            Properties properties2 = properties;
            messageData = new PropertiesMessageContainer(properties2);
        }
        return messageData;
    }

    private final LanguageInfo bestLanguageInfo(String locale) {
        LanguageInfo languageInfo;
        Object v0;
        block2: {
            Iterable iterable = (Iterable)this.languageList.getValue();
            for (Object t : iterable) {
                LanguageInfo it = (LanguageInfo)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.toLocaleString(), (Object)locale)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        if ((languageInfo = (LanguageInfo)v0) == null) {
            languageInfo = DefaultLanguageInfo;
        }
        return languageInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final MessageData getMessageContainer() {
        String requestedLanguage = this.getRequestedLanguage();
        LoadedLanguage loadedLanguage = this.loadedLanguage;
        boolean bl = false;
        if (loadedLanguage != null && Intrinsics.areEqual((Object)loadedLanguage.getLanguageInfo().toLocaleString(), (Object)requestedLanguage)) {
            return loadedLanguage.getMessageData();
        }
        LanguageManager languageManager = this;
        synchronized (languageManager) {
            LoadedLanguage created;
            block5: {
                boolean bl2 = false;
                LoadedLanguage loadedLanguage2 = this.loadedLanguage;
                boolean bl3 = false;
                if (loadedLanguage2 == null || !Intrinsics.areEqual((Object)loadedLanguage2.getLanguageInfo().toLocaleString(), (Object)requestedLanguage)) break block5;
                MessageData messageData = loadedLanguage2.getMessageData();
                return messageData;
            }
            LanguageInfo languageInfo = this.bestLanguageInfo(requestedLanguage);
            this.loadedLanguage = created = new LoadedLanguage(languageInfo, this.createMessageContainer(languageInfo));
            MessageData messageData = created.getMessageData();
            return messageData;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<LanguageInfo> getAvailableLanguages() {
        void $this$mapNotNullTo$iv$iv;
        FileSystem fileSystem = FileSystem.RESOURCES;
        Iterable $this$mapNotNull$iv = fileSystem.list(Path.Companion.get$default((Path.Companion)Path.Companion, (String)LOCALES_PATH, (boolean)false, (int)1, null));
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            LanguageInfo it$iv$iv;
            Object object;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Path path = (Path)element$iv$iv;
            boolean bl2 = false;
            try {
                MyLocale languageCodeAndCountryCode;
                boolean bl3 = false;
                FileMetadata fileMetadata = fileSystem.metadataOrNull(path);
                object = Result.constructor-impl((fileMetadata != null ? !fileMetadata.isRegularFile() : false) ? null : (LanguageManager.Companion.extractLanguageCodeAndCountryCodeFromFileName(path.name()) == null ? null : LanguageManager.Companion.toLanguageInfo(languageCodeAndCountryCode, "app-resource://" + path)));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            if ((LanguageInfo)(Result.isFailure-impl((Object)object) ? null : object) == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final LanguageInfo getSystemLanguageIfWeCanUse() {
        String systemLocale = LanguageManagerKt.access$getSystemLocale().toString();
        return this.bestLanguageInfo(systemLocale);
    }

    private static final LanguageInfo systemLanguageOrDefault_delegate$lambda$0(LanguageManager this$0) {
        return this$0.getSystemLanguageIfWeCanUse();
    }

    private static final String selectedLanguage$lambda$0(LanguageManager this$0, String it) {
        String string2 = it;
        if (string2 == null) {
            string2 = this$0.getSystemLanguageOrDefault().toLocaleString();
        }
        return string2;
    }

    private static final boolean isRtl$lambda$0(String selectedLanguage) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)selectedLanguage, (String)"selectedLanguage");
            String[] $this$any$iv = rtlLanguages;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String it = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                if (!StringsKt.startsWith$default((String)selectedLanguage, (String)it, (boolean)false, (int)2, null)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private static final MessageData defaultLanguageData$lambda$0(LanguageManager this$0) {
        return this$0.createMessageContainer(DefaultLanguageInfo);
    }

    static {
        Companion $this$DefaultLanguageInfo_u24lambda_u240 = Companion;
        boolean bl = false;
        MyLocale locale = new MyLocale("en", "US");
        DefaultLanguageInfo = $this$DefaultLanguageInfo_u24lambda_u240.toLanguageInfo(locale, "app-resource:/com/abdownloadmanager/resources/locales/" + locale + ".properties");
        String[] stringArray = new String[]{"ar", "bqi", "ckb", "fa", "he", "iw", "ji", "ur", "yi"};
        rtlLanguages = stringArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0014\u0010\u0014\u001a\u00020\r*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001b\u001a\u00020\u000bH\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0018X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0019\u00a8\u0006\u001c"}, d2={"Lir/amirab/util/compose/localizationmanager/LanguageManager$Companion;", "", "<init>", "()V", "instance", "Lir/amirab/util/compose/localizationmanager/LanguageManager;", "getInstance", "()Lir/amirab/util/compose/localizationmanager/LanguageManager;", "setInstance", "(Lir/amirab/util/compose/localizationmanager/LanguageManager;)V", "LOCALES_PATH", "", "DefaultLanguageInfo", "Lir/amirab/util/compose/localizationmanager/LanguageInfo;", "getDefaultLanguageInfo", "()Lir/amirab/util/compose/localizationmanager/LanguageInfo;", "openStream", "Ljava/io/InputStream;", "uri", "Ljava/net/URI;", "toLanguageInfo", "Lir/amirab/util/compose/localizationmanager/MyLocale;", "path", "rtlLanguages", "", "[Ljava/lang/String;", "extractLanguageCodeAndCountryCodeFromFileName", "name", "compose-utils"})
    @SourceDebugExtension(value={"SMAP\nLanguageManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LanguageManager.kt\nir/amirab/util/compose/localizationmanager/LanguageManager$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,232:1\n1#2:233\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LanguageManager getInstance() {
            LanguageManager languageManager = instance;
            if (languageManager != null) {
                return languageManager;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"instance");
            return null;
        }

        public final void setInstance(@NotNull LanguageManager languageManager) {
            Intrinsics.checkNotNullParameter((Object)languageManager, (String)"<set-?>");
            instance = languageManager;
        }

        @NotNull
        public final LanguageInfo getDefaultLanguageInfo() {
            return DefaultLanguageInfo;
        }

        @NotNull
        public final InputStream openStream(@NotNull URI uri) {
            Source source;
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            String string2 = uri.getScheme();
            if (Intrinsics.areEqual((Object)string2, (Object)"app-resource")) {
                String string3 = uri.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
                source = FileSystem.RESOURCES.source(Path.Companion.get$default((Path.Companion)Path.Companion, (String)string3, (boolean)false, (int)1, null));
            } else if (Intrinsics.areEqual((Object)string2, (Object)"file")) {
                String string4 = uri.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getPath(...)");
                source = FileSystem.SYSTEM.source(Path.Companion.get$default((Path.Companion)Path.Companion, (String)string4, (boolean)false, (int)1, null));
            } else {
                throw new IllegalStateException("unsupported URI".toString());
            }
            return Okio.buffer((Source)source).inputStream();
        }

        private final LanguageInfo toLanguageInfo(MyLocale $this$toLanguageInfo, String path) {
            return new LanguageInfo(new MyLocale($this$toLanguageInfo.getLanguageCode(), $this$toLanguageInfo.getCountryCode()), LanguageNameProvider.INSTANCE.getNativeName($this$toLanguageInfo), new URI(path));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final MyLocale extractLanguageCodeAndCountryCodeFromFileName(String name) {
            String string2;
            String[] stringArray = new String[]{"."};
            String string3 = (String)CollectionsKt.firstOrNull((List)StringsKt.split$default((CharSequence)name, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
            if (string3 == null) return null;
            String string4 = string2 = string3;
            boolean bl = false;
            if (StringsKt.isBlank((CharSequence)string4)) return null;
            boolean bl2 = true;
            if (!bl2) return null;
            String string5 = string2;
            String string6 = string5;
            if (string6 == null) return null;
            String string7 = string6;
            boolean bl3 = false;
            String[] stringArray2 = new String[]{"_"};
            List $this$extractLanguageCodeAndCountryCodeFromFileName_u24lambda_u241_u240 = StringsKt.split$default((CharSequence)string7, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
            boolean bl4 = false;
            MyLocale myLocale = new MyLocale((String)$this$extractLanguageCodeAndCountryCodeFromFileName_u24lambda_u241_u240.get(0), (String)CollectionsKt.getOrNull((List)$this$extractLanguageCodeAndCountryCodeFromFileName_u24lambda_u241_u240, (int)1));
            return myLocale;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

