/*
 * Decompiled with CFR 0.152.
 */
package com.abdownloadmanager.desktop.pages.settings;

import androidx.compose.ui.text.font.Font;
import androidx.compose.ui.text.font.FontFamily;
import androidx.compose.ui.text.font.FontFamilyKt;
import androidx.compose.ui.text.font.FontFamily_desktopKt;
import androidx.compose.ui.text.platform.FileFont;
import androidx.compose.ui.text.platform.ResourceFont;
import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/abdownloadmanager/desktop/pages/settings/FontFamilyUtil;", "", "<init>", "()V", "fromUri", "Landroidx/compose/ui/text/font/FontFamily;", "uri", "Ljava/net/URI;", "app"})
final class FontFamilyUtil {
    @NotNull
    public static final FontFamilyUtil INSTANCE = new FontFamilyUtil();

    private FontFamilyUtil() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final FontFamily fromUri(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        String string2 = uri.getScheme();
        if (string2 == null) throw new IllegalArgumentException("Unsupported font URI scheme: " + uri.getScheme());
        int n = -1;
        switch (string2.hashCode()) {
            case 3143036: {
                if (string2.equals("file")) {
                    n = 1;
                }
                break;
            }
            case -887328209: {
                if (string2.equals("system")) {
                    n = 2;
                }
                break;
            }
            case -365780422: {
                if (string2.equals("app-resource")) {
                    n = 3;
                }
                break;
            }
        }
        switch (n) {
            case 1: {
                Font[] fontArray = new Font[1];
                Path path = Paths.get(uri);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                File file = path.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
                fontArray[0] = new FileFont(file, null, 0, 6, null);
                return FontFamilyKt.FontFamily((Font[])fontArray);
            }
            case 3: {
                String path = uri.getSchemeSpecificPart();
                Intrinsics.checkNotNull((Object)path);
                if (!(((CharSequence)path).length() > 0)) {
                    String string3 = "Failed requirement.";
                    throw new IllegalArgumentException(string3.toString());
                }
                Font[] fontArray = new Font[1];
                String string4 = uri.getSchemeSpecificPart();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getSchemeSpecificPart(...)");
                fontArray[0] = new ResourceFont(string4, null, 0, 6, null);
                FontFamily fontFamily = FontFamilyKt.FontFamily((Font[])fontArray);
                return fontFamily;
            }
            case 2: {
                String name = uri.getSchemeSpecificPart();
                Intrinsics.checkNotNull((Object)name);
                if (!(((CharSequence)name).length() > 0)) {
                    String string5 = "Failed requirement.";
                    throw new IllegalArgumentException(string5.toString());
                }
                FontFamily fontFamily = FontFamily_desktopKt.FontFamily((String)name);
                return fontFamily;
            }
            default: {
                throw new IllegalArgumentException("Unsupported font URI scheme: " + uri.getScheme());
            }
        }
    }
}

