/*
 * Decompiled with CFR 0.152.
 */
package arrow.core;

import arrow.core.Either;
import arrow.core.EitherKt;
import arrow.core.NonFatalOrThrowKt;
import arrow.core.None;
import arrow.core.OptionKt;
import arrow.core.Some;
import arrow.core.raise.DefaultRaise;
import arrow.core.raise.Raise;
import arrow.core.raise.RaiseCancellationException;
import arrow.core.raise.RaiseKt;
import arrow.core.raise.SingletonRaise;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b6\u0018\u0000 %*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002:\u0001%B\t\b\u0004\u00a2\u0006\u0004\b\u0003\u0010\u0004J-\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0086\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0001 \u0000J3\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b0\nH\u0086\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0001 \u0000J%\u0010\u000b\u001a\u00020\f\u0082\u0002\u001c\n\f\b\u0000\u0012\u0002\u0018\u0001\u001a\u0004\u0010\u0000(\u0000\n\f\b\u0000\u0012\u0002\u0018\u0000\u001a\u0004\u0010\u0000(\u0001J%\u0010\u000f\u001a\u00020\f\u0082\u0002\u001c\n\f\b\u0000\u0012\u0002\u0018\u0000\u001a\u0004\u0010\u0000(\u0000\n\f\b\u0000\u0012\u0002\u0018\u0001\u001a\u0004\u0010\u0000(\u0001J;\u0010\u000f\u001a\u00020\f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\f0\nH\u0086\b\u00f8\u0001\u0000\u0082\u0002\u0018\n\b\b\u0001\u0012\u0002\u0010\u0001 \u0000\n\f\b\u0000\u0012\u0002\u0018\u0000\u001a\u0004\u0010\u0000(\u0000J(\u0010\u0011\u001a\u0004\u0018\u00018\u0000\u0082\u0002\u0018\n\f\b\u0000\u0012\u0002\u0018\u0002\u001a\u0004\u0010\u0000(\u0001\n\b\b\u0002\u001a\u0004\u0010\u0000(\u0000\u00a2\u0006\u0002\u0010\u0012J9\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0000\"\u0004\b\u0001\u0010\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u00140\nH\u0086\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0001 \u0000JP\u0010\u0016\u001a\u0002H\u0017\"\u0004\b\u0001\u0010\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00170\u00072\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u00170\nH\u0086\b\u00f8\u0001\u0000\u0082\u0002\u0014\n\b\b\u0001\u0012\u0002\u0010\u0001 \u0000\n\b\b\u0001\u0012\u0002\u0010\u0002 \u0000\u00a2\u0006\u0002\u0010\u001aJ?\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0000\"\u0004\b\u0001\u0010\u00142\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00140\u00000\nH\u0086\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0001 \u0000J3\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\f0\nH\u0086\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0001 \u0000J3\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\f0\nH\u0086\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0001 \u0000J9\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u0002H \u0012\u0004\u0012\u00028\u00000\u001f\"\u0004\b\u0001\u0010 2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H 0\u0007H\u0086\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0001 \u0000J\f\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\"J\b\u0010#\u001a\u00020$H\u0016\u0082\u0001\u0002\u000e\r\u00f2\u0001\u000e\n\b\u0012\u0004\u0012\u0002H\u00010\r\n\u00020\u000e\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006&"}, d2={"Larrow/core/Option;", "A", "", "<init>", "()V", "onNone", "action", "Lkotlin/Function0;", "", "onSome", "Lkotlin/Function1;", "isNone", "", "Larrow/core/Some;", "Larrow/core/None;", "isSome", "predicate", "getOrNull", "()Ljava/lang/Object;", "map", "B", "f", "fold", "R", "ifEmpty", "ifSome", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "flatMap", "filter", "filterNot", "toEither", "Larrow/core/Either;", "L", "toList", "", "toString", "", "Companion", "arrow-core"})
@SourceDebugExtension(value={"SMAP\nOption.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Option.kt\narrow/core/Option\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Option.kt\narrow/core/OptionKt\n*L\n1#1,658:1\n495#1,3:663\n495#1,3:666\n495#1,3:669\n477#1,3:672\n477#1,3:675\n477#1,3:678\n1#2:659\n554#3,3:660\n*S KotlinDebug\n*F\n+ 1 Option.kt\narrow/core/Option\n*L\n469#1:663,3\n509#1:666,3\n520#1:669,3\n525#1:672,3\n528#1:675,3\n530#1:678,3\n454#1:660,3\n*E\n"})
public abstract class Option<A> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private Option() {
    }

    @NotNull
    public final Option<A> onNone(@NotNull Function0<Unit> action) {
        Option option;
        Intrinsics.checkNotNullParameter(action, (String)"action");
        boolean $i$f$onNone = false;
        Option it = option = this;
        boolean bl = false;
        if (it.isNone()) {
            action.invoke();
        }
        return option;
    }

    @NotNull
    public final Option<A> onSome(@NotNull Function1<? super A, Unit> action) {
        Option option;
        Intrinsics.checkNotNullParameter(action, (String)"action");
        boolean $i$f$onSome = false;
        Option it = option = this;
        boolean bl = false;
        if (it.isSome()) {
            action.invoke(((Some)it).getValue());
        }
        return option;
    }

    public final boolean isNone() {
        return this instanceof None;
    }

    public final boolean isSome() {
        return this instanceof Some;
    }

    public final boolean isSome(@NotNull Function1<? super A, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        boolean $i$f$isSome = false;
        return this instanceof Some && (Boolean)predicate.invoke(((Some)this).getValue()) != false;
    }

    @Nullable
    public final A getOrNull() {
        Object t;
        Option $this$getOrElse$iv = this;
        boolean $i$f$getOrElse = false;
        if ($this$getOrElse$iv instanceof Some) {
            t = ((Some)$this$getOrElse$iv).getValue();
        } else {
            boolean bl = false;
            t = null;
        }
        return (A)t;
    }

    @NotNull
    public final <B> Option<B> map(@NotNull Function1<? super A, ? extends B> f) {
        Option option;
        Intrinsics.checkNotNullParameter(f, (String)"f");
        boolean $i$f$map = false;
        Option this_$iv = this;
        boolean $i$f$flatMap = false;
        Option option2 = this_$iv;
        if (option2 instanceof None) {
            option = this_$iv;
        } else if (option2 instanceof Some) {
            Object a = ((Some)this_$iv).getValue();
            boolean bl = false;
            option = new Some<Object>(f.invoke(a));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return option;
    }

    public final <R> R fold(@NotNull Function0<? extends R> ifEmpty, @NotNull Function1<? super A, ? extends R> ifSome) {
        Object object;
        Intrinsics.checkNotNullParameter(ifEmpty, (String)"ifEmpty");
        Intrinsics.checkNotNullParameter(ifSome, (String)"ifSome");
        boolean $i$f$fold = false;
        Option option = this;
        if (option instanceof None) {
            object = ifEmpty.invoke();
        } else if (option instanceof Some) {
            object = ifSome.invoke(((Some)this).getValue());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return (R)object;
    }

    @NotNull
    public final <B> Option<B> flatMap(@NotNull Function1<? super A, ? extends Option<? extends B>> f) {
        Option option;
        Intrinsics.checkNotNullParameter(f, (String)"f");
        boolean $i$f$flatMap = false;
        Option option2 = this;
        if (option2 instanceof None) {
            option = this;
        } else if (option2 instanceof Some) {
            option = (Option)f.invoke(((Some)this).getValue());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return option;
    }

    @NotNull
    public final Option<A> filter(@NotNull Function1<? super A, Boolean> predicate) {
        Option option;
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        boolean $i$f$filter = false;
        Option this_$iv = this;
        boolean $i$f$flatMap = false;
        Option option2 = this_$iv;
        if (option2 instanceof None) {
            option = this_$iv;
        } else if (option2 instanceof Some) {
            Object a = ((Some)this_$iv).getValue();
            boolean bl = false;
            option = ((Boolean)predicate.invoke(a)).booleanValue() ? (Option)new Some(a) : (Option)None.INSTANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return option;
    }

    @NotNull
    public final Option<A> filterNot(@NotNull Function1<? super A, Boolean> predicate) {
        Option option;
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        boolean $i$f$filterNot = false;
        Option this_$iv = this;
        boolean $i$f$flatMap = false;
        Option option2 = this_$iv;
        if (option2 instanceof None) {
            option = this_$iv;
        } else if (option2 instanceof Some) {
            Object a = ((Some)this_$iv).getValue();
            boolean bl = false;
            option = !((Boolean)predicate.invoke(a)).booleanValue() ? (Option)new Some(a) : (Option)None.INSTANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return option;
    }

    @NotNull
    public final <L> Either<L, A> toEither(@NotNull Function0<? extends L> ifEmpty) {
        Either either;
        Intrinsics.checkNotNullParameter(ifEmpty, (String)"ifEmpty");
        boolean $i$f$toEither = false;
        Option this_$iv = this;
        boolean $i$f$fold = false;
        Option option = this_$iv;
        if (option instanceof None) {
            boolean bl = false;
            either = EitherKt.left(ifEmpty.invoke());
        } else if (option instanceof Some) {
            Object it = ((Some)this_$iv).getValue();
            boolean bl = false;
            either = EitherKt.right(it);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return either;
    }

    @NotNull
    public final List<A> toList() {
        List list;
        Option this_$iv = this;
        boolean $i$f$fold = false;
        Option option = this_$iv;
        if (option instanceof None) {
            boolean bl = false;
            list = CollectionsKt.emptyList();
        } else if (option instanceof Some) {
            Object it = ((Some)this_$iv).getValue();
            boolean bl = false;
            list = CollectionsKt.listOf(it);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }

    @NotNull
    public String toString() {
        String string;
        Option this_$iv = this;
        boolean $i$f$fold = false;
        Option option = this_$iv;
        if (option instanceof None) {
            boolean bl = false;
            string = "Option.None";
        } else if (option instanceof Some) {
            Object it = ((Some)this_$iv).getValue();
            boolean bl = false;
            string = "Option.Some(" + it + ')';
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final <A> Option<A> fromNullable(@Nullable A a) {
        return Companion.fromNullable(a);
    }

    @JvmStatic
    @NotNull
    public static final <A> Option<A> invoke(A a) {
        return Companion.invoke(a);
    }

    @JvmStatic
    @JvmName(name="tryCatchOrNone")
    @NotNull
    public static final <A> Option<A> tryCatchOrNone(@NotNull Function1<? super SingletonRaise<? super None>, ? extends A> f) {
        return Companion.tryCatchOrNone(f);
    }

    @JvmStatic
    @JvmName(name="tryCatch")
    @NotNull
    public static final <A> Option<A> tryCatch(@NotNull Function1<? super Throwable, ? extends Option<? extends A>> recover2, @NotNull Function1<? super SingletonRaise<? super None>, ? extends A> f) {
        return Companion.tryCatch(recover2, f);
    }

    public /* synthetic */ Option(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0004\b\u0001\u0010\u00062\b\u0010\u0007\u001a\u0004\u0018\u0001H\u0006H\u0007\u00a2\u0006\u0002\u0010\bJ\"\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0004\b\u0001\u0010\u00062\u0006\u0010\u0007\u001a\u0002H\u0006H\u0087\u0002\u00a2\u0006\u0002\u0010\bJI\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0004\b\u0001\u0010\u00062\u001d\u0010\u000b\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0004\u0012\u0002H\u00060\f\u00a2\u0006\u0002\b\u000fH\u0087\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0001 \u0000\u00a2\u0006\u0002\b\u0010Jm\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0004\b\u0001\u0010\u00062\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\u00050\f2\u001d\u0010\u000b\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0004\u0012\u0002H\u00060\f\u00a2\u0006\u0002\b\u000fH\u0087\b\u00f8\u0001\u0000\u0082\u0002\u0014\n\b\b\u0001\u0012\u0002\u0010\u0002 \u0000\n\b\b\u0001\u0012\u0002\u0010\u0001 \u0000\u00a2\u0006\u0002\b\u0013\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0014"}, d2={"Larrow/core/Option$Companion;", "", "<init>", "()V", "fromNullable", "Larrow/core/Option;", "A", "a", "(Ljava/lang/Object;)Larrow/core/Option;", "invoke", "catch", "f", "Lkotlin/Function1;", "Larrow/core/raise/SingletonRaise;", "Larrow/core/None;", "Lkotlin/ExtensionFunctionType;", "tryCatchOrNone", "recover", "", "tryCatch", "arrow-core"})
    @SourceDebugExtension(value={"SMAP\nOption.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Option.kt\narrow/core/Option$Companion\n+ 2 Raise.kt\narrow/core/raise/RaiseKt__RaiseKt\n+ 3 Fold.kt\narrow/core/raise/RaiseKt__FoldKt\n+ 4 predef.kt\narrow/core/PredefKt\n*L\n1#1,658:1\n325#1:659\n386#2:660\n386#2:673\n142#3,5:661\n147#3,6:667\n142#3,5:674\n147#3,6:680\n4#4:666\n4#4:679\n*S KotlinDebug\n*F\n+ 1 Option.kt\narrow/core/Option$Companion\n*L\n315#1:659\n315#1:660\n325#1:673\n315#1:661,5\n315#1:667,6\n325#1:674,5\n325#1:680,6\n315#1:666\n325#1:679\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final <A> Option<A> fromNullable(@Nullable A a) {
            return a != null ? (Option)new Some<A>(a) : (Option)None.INSTANCE;
        }

        @JvmStatic
        @NotNull
        public final <A> Option<A> invoke(A a) {
            return new Some<A>(a);
        }

        @JvmStatic
        @JvmName(name="tryCatchOrNone")
        @NotNull
        public final <A> Option<A> tryCatchOrNone(@NotNull Function1<? super SingletonRaise<? super None>, ? extends A> f) {
            Option<Object> option;
            Intrinsics.checkNotNullParameter(f, (String)"f");
            boolean $i$f$tryCatchOrNone = false;
            Companion this_$iv = this;
            boolean $i$f$tryCatch = false;
            boolean $i$f$recover = false;
            boolean $i$f$_fold = false;
            DefaultRaise raise$iv$iv$iv = new DefaultRaise(false);
            try {
                Raise $this$catch_u24lambda_u241$iv = raise$iv$iv$iv;
                boolean bl = false;
                Option<Object> res$iv$iv$iv = OptionKt.some(f.invoke(new SingletonRaise($this$catch_u24lambda_u241$iv)));
                raise$iv$iv$iv.complete();
                Option<Object> p0$iv$iv = res$iv$iv$iv;
                boolean bl2 = false;
                boolean $i$f$identity = false;
                option = p0$iv$iv;
            }
            catch (RaiseCancellationException e$iv$iv$iv) {
                raise$iv$iv$iv.complete();
                Unit it$iv = (Unit)RaiseKt.raisedOrRethrow(e$iv$iv$iv, raise$iv$iv$iv);
                boolean bl = false;
                option = None.INSTANCE;
            }
            catch (Throwable e$iv$iv$iv) {
                raise$iv$iv$iv.complete();
                Throwable it = NonFatalOrThrowKt.nonFatalOrThrow(e$iv$iv$iv);
                boolean bl = false;
                option = None.INSTANCE;
            }
            return option;
        }

        @JvmStatic
        @JvmName(name="tryCatch")
        @NotNull
        public final <A> Option<A> tryCatch(@NotNull Function1<? super Throwable, ? extends Option<? extends A>> recover2, @NotNull Function1<? super SingletonRaise<? super None>, ? extends A> f) {
            Option<Object> option;
            Intrinsics.checkNotNullParameter(recover2, (String)"recover");
            Intrinsics.checkNotNullParameter(f, (String)"f");
            boolean $i$f$tryCatch = false;
            boolean $i$f$recover = false;
            boolean $i$f$_fold = false;
            DefaultRaise raise$iv$iv = new DefaultRaise(false);
            try {
                Raise $this$catch_u24lambda_u241 = raise$iv$iv;
                boolean bl = false;
                Option<Object> res$iv$iv = OptionKt.some(f.invoke(new SingletonRaise($this$catch_u24lambda_u241)));
                raise$iv$iv.complete();
                Option<Object> p0$iv = res$iv$iv;
                boolean bl2 = false;
                boolean $i$f$identity = false;
                option = p0$iv;
            }
            catch (RaiseCancellationException e$iv$iv) {
                raise$iv$iv.complete();
                Unit it = (Unit)RaiseKt.raisedOrRethrow(e$iv$iv, raise$iv$iv);
                boolean bl = false;
                option = None.INSTANCE;
            }
            catch (Throwable e$iv$iv) {
                raise$iv$iv.complete();
                option = recover2.invoke((Object)NonFatalOrThrowKt.nonFatalOrThrow(e$iv$iv));
            }
            return option;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

