/*
 * Decompiled with CFR 0.152.
 */
package io.lindstrom.m3u8.model;

import io.lindstrom.m3u8.model.ByteRange;
import io.lindstrom.m3u8.model.SegmentMap;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;

class SegmentMapBuilder {
    private static final long INIT_BIT_URI = 1L;
    private long initBits = 1L;
    private String uri;
    private ByteRange byteRange;

    SegmentMapBuilder() {
        if (!(this instanceof SegmentMap.Builder)) {
            throw new UnsupportedOperationException("Use: new SegmentMap.Builder()");
        }
    }

    public final SegmentMap.Builder from(SegmentMap instance) {
        Objects.requireNonNull(instance, "instance");
        this.uri(instance.uri());
        Optional<ByteRange> byteRangeOptional = instance.byteRange();
        if (byteRangeOptional.isPresent()) {
            this.byteRange(byteRangeOptional);
        }
        return (SegmentMap.Builder)this;
    }

    public final SegmentMap.Builder uri(String uri) {
        this.uri = Objects.requireNonNull(uri, "uri");
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return (SegmentMap.Builder)this;
    }

    public final SegmentMap.Builder byteRange(ByteRange byteRange) {
        this.byteRange = Objects.requireNonNull(byteRange, "byteRange");
        return (SegmentMap.Builder)this;
    }

    public final SegmentMap.Builder byteRange(Optional<? extends ByteRange> byteRange) {
        this.byteRange = byteRange.orElse(null);
        return (SegmentMap.Builder)this;
    }

    public SegmentMap build() {
        if (this.initBits != 0L) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
        return new ImmutableSegmentMap(this);
    }

    private String formatRequiredAttributesMessage() {
        ArrayList<String> attributes = new ArrayList<String>();
        if ((this.initBits & 1L) != 0L) {
            attributes.add("uri");
        }
        return "Cannot build SegmentMap, some of required attributes are not set " + attributes;
    }

    private static final class ImmutableSegmentMap
    implements SegmentMap {
        private final String uri;
        private final ByteRange byteRange;

        private ImmutableSegmentMap(SegmentMapBuilder builder) {
            this.uri = builder.uri;
            this.byteRange = builder.byteRange;
        }

        @Override
        public String uri() {
            return this.uri;
        }

        @Override
        public Optional<ByteRange> byteRange() {
            return Optional.ofNullable(this.byteRange);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ImmutableSegmentMap && this.equalTo((ImmutableSegmentMap)another);
        }

        private boolean equalTo(ImmutableSegmentMap another) {
            return this.uri.equals(another.uri) && Objects.equals(this.byteRange, another.byteRange);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.uri.hashCode();
            h += (h << 5) + Objects.hashCode(this.byteRange);
            return h;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("SegmentMap{");
            builder.append("uri=").append(this.uri);
            if (this.byteRange != null) {
                builder.append(", ");
                builder.append("byteRange=").append(this.byteRange);
            }
            return builder.append("}").toString();
        }
    }
}

