/*
 * Decompiled with CFR 0.152.
 */
package io.lindstrom.m3u8.model;

import io.lindstrom.m3u8.model.ByteRange;
import io.lindstrom.m3u8.model.PartialSegment;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;

class PartialSegmentBuilder {
    private static final long INIT_BIT_URI = 1L;
    private static final long INIT_BIT_DURATION = 2L;
    private static final long OPT_BIT_INDEPENDENT = 1L;
    private static final long OPT_BIT_GAP = 2L;
    private long initBits = 3L;
    private long optBits;
    private String uri;
    private double duration;
    private boolean independent;
    private ByteRange byterange;
    private boolean gap;

    PartialSegmentBuilder() {
        if (!(this instanceof PartialSegment.Builder)) {
            throw new UnsupportedOperationException("Use: new PartialSegment.Builder()");
        }
    }

    public final PartialSegment.Builder from(PartialSegment instance) {
        Objects.requireNonNull(instance, "instance");
        this.uri(instance.uri());
        this.duration(instance.duration());
        this.independent(instance.independent());
        Optional<ByteRange> byterangeOptional = instance.byterange();
        if (byterangeOptional.isPresent()) {
            this.byterange(byterangeOptional);
        }
        this.gap(instance.gap());
        return (PartialSegment.Builder)this;
    }

    public final PartialSegment.Builder uri(String uri) {
        this.uri = Objects.requireNonNull(uri, "uri");
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return (PartialSegment.Builder)this;
    }

    public final PartialSegment.Builder duration(double duration) {
        this.duration = duration;
        this.initBits &= 0xFFFFFFFFFFFFFFFDL;
        return (PartialSegment.Builder)this;
    }

    public final PartialSegment.Builder independent(boolean independent) {
        this.independent = independent;
        this.optBits |= 1L;
        return (PartialSegment.Builder)this;
    }

    public final PartialSegment.Builder byterange(ByteRange byterange) {
        this.byterange = Objects.requireNonNull(byterange, "byterange");
        return (PartialSegment.Builder)this;
    }

    public final PartialSegment.Builder byterange(Optional<? extends ByteRange> byterange) {
        this.byterange = byterange.orElse(null);
        return (PartialSegment.Builder)this;
    }

    public final PartialSegment.Builder gap(boolean gap) {
        this.gap = gap;
        this.optBits |= 2L;
        return (PartialSegment.Builder)this;
    }

    public PartialSegment build() {
        if (this.initBits != 0L) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
        return new ImmutablePartialSegment(this);
    }

    private boolean independentIsSet() {
        return (this.optBits & 1L) != 0L;
    }

    private boolean gapIsSet() {
        return (this.optBits & 2L) != 0L;
    }

    private String formatRequiredAttributesMessage() {
        ArrayList<String> attributes = new ArrayList<String>();
        if ((this.initBits & 1L) != 0L) {
            attributes.add("uri");
        }
        if ((this.initBits & 2L) != 0L) {
            attributes.add("duration");
        }
        return "Cannot build PartialSegment, some of required attributes are not set " + attributes;
    }

    private static final class ImmutablePartialSegment
    implements PartialSegment {
        private final String uri;
        private final double duration;
        private final boolean independent;
        private final ByteRange byterange;
        private final boolean gap;
        private static final int STAGE_INITIALIZING = -1;
        private static final int STAGE_UNINITIALIZED = 0;
        private static final int STAGE_INITIALIZED = 1;
        private volatile transient InitShim initShim = new InitShim();

        private ImmutablePartialSegment(PartialSegmentBuilder builder) {
            this.uri = builder.uri;
            this.duration = builder.duration;
            this.byterange = builder.byterange;
            if (builder.independentIsSet()) {
                this.initShim.independent(builder.independent);
            }
            if (builder.gapIsSet()) {
                this.initShim.gap(builder.gap);
            }
            this.independent = this.initShim.independent();
            this.gap = this.initShim.gap();
            this.initShim = null;
        }

        private boolean independentInitialize() {
            return PartialSegment.super.independent();
        }

        private boolean gapInitialize() {
            return PartialSegment.super.gap();
        }

        @Override
        public String uri() {
            return this.uri;
        }

        @Override
        public double duration() {
            return this.duration;
        }

        @Override
        public boolean independent() {
            InitShim shim = this.initShim;
            return shim != null ? shim.independent() : this.independent;
        }

        @Override
        public Optional<ByteRange> byterange() {
            return Optional.ofNullable(this.byterange);
        }

        @Override
        public boolean gap() {
            InitShim shim = this.initShim;
            return shim != null ? shim.gap() : this.gap;
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ImmutablePartialSegment && this.equalTo((ImmutablePartialSegment)another);
        }

        private boolean equalTo(ImmutablePartialSegment another) {
            return this.uri.equals(another.uri) && Double.doubleToLongBits(this.duration) == Double.doubleToLongBits(another.duration) && this.independent == another.independent && Objects.equals(this.byterange, another.byterange) && this.gap == another.gap;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.uri.hashCode();
            h += (h << 5) + Double.hashCode(this.duration);
            h += (h << 5) + Boolean.hashCode(this.independent);
            h += (h << 5) + Objects.hashCode(this.byterange);
            h += (h << 5) + Boolean.hashCode(this.gap);
            return h;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("PartialSegment{");
            builder.append("uri=").append(this.uri);
            builder.append(", ");
            builder.append("duration=").append(this.duration);
            builder.append(", ");
            builder.append("independent=").append(this.independent);
            if (this.byterange != null) {
                builder.append(", ");
                builder.append("byterange=").append(this.byterange);
            }
            builder.append(", ");
            builder.append("gap=").append(this.gap);
            return builder.append("}").toString();
        }

        private final class InitShim {
            private boolean independent;
            private int independentBuildStage;
            private boolean gap;
            private int gapBuildStage;

            private InitShim() {
            }

            boolean independent() {
                if (this.independentBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.independentBuildStage == 0) {
                    this.independentBuildStage = -1;
                    this.independent = ImmutablePartialSegment.this.independentInitialize();
                    this.independentBuildStage = 1;
                }
                return this.independent;
            }

            void independent(boolean independent) {
                this.independent = independent;
                this.independentBuildStage = 1;
            }

            boolean gap() {
                if (this.gapBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.gapBuildStage == 0) {
                    this.gapBuildStage = -1;
                    this.gap = ImmutablePartialSegment.this.gapInitialize();
                    this.gapBuildStage = 1;
                }
                return this.gap;
            }

            void gap(boolean gap) {
                this.gap = gap;
                this.gapBuildStage = 1;
            }

            private String formatInitCycleMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if (this.independentBuildStage == -1) {
                    attributes.add("independent");
                }
                if (this.gapBuildStage == -1) {
                    attributes.add("gap");
                }
                return "Cannot build PartialSegment, attribute initializers form cycle" + attributes;
            }
        }
    }
}

