/*
 * Decompiled with CFR 0.152.
 */
package com.abdownloadmanager.shared.downloaderinui.hls;

import androidx.compose.runtime.internal.StabilityInferred;
import ir.amirab.downloader.downloaditem.DownloadJobStatus;
import ir.amirab.downloader.downloaditem.hls.HLSDownloadItem;
import ir.amirab.downloader.downloaditem.hls.HLSDownloadJob;
import ir.amirab.downloader.monitor.DurationBasedProcessingDownloadItemState;
import ir.amirab.downloader.monitor.UiDurationBasedPart;
import ir.amirab.downloader.part.MediaSegment;
import ir.amirab.downloader.part.PartDownloadStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ0\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\tH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/abdownloadmanager/shared/downloaderinui/hls/UiProcessingItemForHSLFactory;", "", "<init>", "()V", "create", "Lir/amirab/downloader/monitor/DurationBasedProcessingDownloadItemState;", "downloadJob", "Lir/amirab/downloader/downloaditem/hls/HLSDownloadJob;", "speed", "", "getPercentFraction", "", "finishedPartsCount", "", "totalPartsCount", "activePartsCount", "activeCountsTotalDownloaded", "activeCountsTotalLength", "app"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nUiProcessingItemForHSLFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UiProcessingItemForHSLFactory.kt\ncom/abdownloadmanager/shared/downloaderinui/hls/UiProcessingItemForHSLFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,89:1\n1563#2:90\n1634#2,3:91\n*S KotlinDebug\n*F\n+ 1 UiProcessingItemForHSLFactory.kt\ncom/abdownloadmanager/shared/downloaderinui/hls/UiProcessingItemForHSLFactory\n*L\n16#1:90\n16#1:91,3\n*E\n"})
public final class UiProcessingItemForHSLFactory {
    @NotNull
    public static final UiProcessingItemForHSLFactory INSTANCE = new UiProcessingItemForHSLFactory();
    public static final int $stable;

    private UiProcessingItemForHSLFactory() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DurationBasedProcessingDownloadItemState create(@NotNull HLSDownloadJob downloadJob, long speed) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)downloadJob, (String)"downloadJob");
        HLSDownloadItem item = downloadJob.getDownloadItem();
        List downloadParts = downloadJob.getParts();
        int totalPartsCount = downloadParts.size();
        Iterable $this$map$iv = downloadParts;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MediaSegment mediaSegment = (MediaSegment)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(UiDurationBasedPart.Companion.fromPart((MediaSegment)it, totalPartsCount));
        }
        List uiParts = (List)destination$iv$iv;
        int finishedPartsCount = 0;
        long downloadedBytes = 0L;
        int activeCount = 0;
        long activeCountTotalLength = 0L;
        long activeCountProgress = 0L;
        for (UiDurationBasedPart part : uiParts) {
            Long length;
            PartDownloadStatus status = part.getStatus();
            long howMuchProceed = part.getHowMuchProceed();
            if (status instanceof PartDownloadStatus.Completed) {
                ++finishedPartsCount;
            } else if (status instanceof PartDownloadStatus.IsActive && (length = part.getLength()) != null) {
                ++activeCount;
                activeCountProgress += howMuchProceed;
                activeCountTotalLength += length.longValue();
            }
            downloadedBytes += howMuchProceed;
        }
        double percentFraction = this.getPercentFraction(finishedPartsCount, totalPartsCount, activeCount, activeCountProgress, activeCountTotalLength);
        long length = (long)((double)downloadedBytes / percentFraction);
        long l = downloadJob.getId();
        String string2 = item.getName();
        String string3 = item.getFolder();
        DownloadJobStatus downloadJobStatus = (DownloadJobStatus)downloadJob.getStatus().getValue();
        long l2 = item.getContentLength();
        String string4 = item.getLink();
        String string5 = item.getName();
        long l3 = item.getDateAdded();
        Long l4 = item.getStartTime();
        long l5 = l4 != null ? l4 : 0L;
        Long l6 = item.getCompleteTime();
        long l7 = l6 != null ? l6 : 0L;
        Double d = item.getDuration();
        long l8 = downloadedBytes;
        int n = (int)(percentFraction * (double)100);
        return new DurationBasedProcessingDownloadItemState(l, string3, string2, string4, l2, string5, l3, l5, l7, downloadJobStatus, speed, uiParts, Boolean.valueOf(true), length, d, l8, n);
    }

    private final double getPercentFraction(int finishedPartsCount, int totalPartsCount, int activePartsCount, long activeCountsTotalDownloaded, long activeCountsTotalLength) {
        double activePartCountProgress = activeCountsTotalLength == 0L ? 0.0 : (double)activeCountsTotalDownloaded / (double)activeCountsTotalLength * (double)activePartsCount;
        return ((double)finishedPartsCount + activePartCountProgress) / (double)totalPartsCount;
    }
}

