/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.core;

import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.core.Body;
import org.http4k.core.HeadersKt;
import org.http4k.core.Method;
import org.http4k.core.ParametersKt;
import org.http4k.core.Request;
import org.http4k.core.RequestSource;
import org.http4k.core.Uri;
import org.http4k.core.UriKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B]\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012$\b\u0002\u0010\u0006\u001a\u001e\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\bj\u0002`\n0\u0007j\u0002`\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\t\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u001a\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\t2\b\u0010!\u001a\u0004\u0018\u00010\tH\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\t2\u0006\u0010 \u001a\u00020\tH\u0016J\u0018\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u00072\u0006\u0010 \u001a\u00020\tH\u0016J\u001a\u0010#\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\t2\b\u0010!\u001a\u0004\u0018\u00010\tH\u0016J,\u0010$\u001a\u00020\u00002\"\u0010\u000f\u001a\u001e\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\bj\u0002`\n0\u0007j\u0002`\u000bH\u0016J,\u0010\u0006\u001a\u00020\u00002\"\u0010\u0006\u001a\u001e\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\bj\u0002`\n0\u0007j\u0002`\u000bH\u0016J\u001a\u0010%\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\t2\b\u0010!\u001a\u0004\u0018\u00010\tH\u0016J\u0010\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010&\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\tH\u0016J\u0010\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\tH\u0016J\u0010\u0010)\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\tH\u0016J\u0010\u0010*\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\tH\u0016J\u0010\u0010\f\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\f\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\tH\u0016J\u001f\u0010\f\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010-H\u0016\u00a2\u0006\u0002\u0010.J\b\u0010/\u001a\u00020\tH\u0016J\u0013\u00100\u001a\u0002012\b\u00102\u001a\u0004\u0018\u000103H\u0096\u0002J\t\u00104\u001a\u00020\u0003H\u00c6\u0003J\t\u00105\u001a\u00020\u0005H\u00c6\u0003J%\u00106\u001a\u001e\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\bj\u0002`\n0\u0007j\u0002`\u000bH\u00c6\u0003J\t\u00107\u001a\u00020\rH\u00c6\u0003J\t\u00108\u001a\u00020\tH\u00c6\u0003J\u000b\u00109\u001a\u0004\u0018\u00010\u0010H\u00c6\u0003Jc\u0010:\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052$\b\u0002\u0010\u0006\u001a\u001e\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\bj\u0002`\n0\u0007j\u0002`\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\t2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00c6\u0001J\t\u0010;\u001a\u00020<H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R0\u0010\u0006\u001a\u001e\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\bj\u0002`\n0\u0007j\u0002`\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u000e\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006="}, d2={"Lorg/http4k/core/MemoryRequest;", "Lorg/http4k/core/Request;", "method", "Lorg/http4k/core/Method;", "uri", "Lorg/http4k/core/Uri;", "headers", "", "Lkotlin/Pair;", "", "Lorg/http4k/core/Parameter;", "Lorg/http4k/core/Headers;", "body", "Lorg/http4k/core/Body;", "version", "source", "Lorg/http4k/core/RequestSource;", "<init>", "(Lorg/http4k/core/Method;Lorg/http4k/core/Uri;Ljava/util/List;Lorg/http4k/core/Body;Ljava/lang/String;Lorg/http4k/core/RequestSource;)V", "getMethod", "()Lorg/http4k/core/Method;", "getUri", "()Lorg/http4k/core/Uri;", "getHeaders", "()Ljava/util/List;", "getBody", "()Lorg/http4k/core/Body;", "getVersion", "()Ljava/lang/String;", "getSource", "()Lorg/http4k/core/RequestSource;", "query", "name", "value", "queries", "header", "replaceHeaders", "replaceHeader", "removeHeader", "removeHeaders", "prefix", "removeQuery", "removeQueries", "Ljava/io/InputStream;", "length", "", "(Ljava/io/InputStream;Ljava/lang/Long;)Lorg/http4k/core/MemoryRequest;", "toString", "equals", "", "other", "", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "hashCode", "", "http4k-core"})
public final class MemoryRequest
implements Request {
    @NotNull
    private final Method method;
    @NotNull
    private final Uri uri;
    @NotNull
    private final List<Pair<String, String>> headers;
    @NotNull
    private final Body body;
    @NotNull
    private final String version;
    @Nullable
    private final RequestSource source;

    public MemoryRequest(@NotNull Method method, @NotNull Uri uri2, @NotNull List<Pair<String, String>> headers, @NotNull Body body, @NotNull String version, @Nullable RequestSource source) {
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        Intrinsics.checkNotNullParameter((Object)uri2, (String)"uri");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        this.method = method;
        this.uri = uri2;
        this.headers = headers;
        this.body = body;
        this.version = version;
        this.source = source;
    }

    public /* synthetic */ MemoryRequest(Method method, Uri uri2, List list, Body body, String string, RequestSource requestSource, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            body = Body.EMPTY;
        }
        if ((n & 0x10) != 0) {
            string = "HTTP/1.1";
        }
        if ((n & 0x20) != 0) {
            requestSource = null;
        }
        this(method, uri2, list, body, string, requestSource);
    }

    @Override
    @NotNull
    public Method getMethod() {
        return this.method;
    }

    @Override
    @NotNull
    public Uri getUri() {
        return this.uri;
    }

    @Override
    @NotNull
    public List<Pair<String, String>> getHeaders() {
        return this.headers;
    }

    @Override
    @NotNull
    public Body getBody() {
        return this.body;
    }

    @Override
    @NotNull
    public String getVersion() {
        return this.version;
    }

    @Override
    @Nullable
    public RequestSource getSource() {
        return this.source;
    }

    @Override
    @NotNull
    public Request method(@NotNull Method method) {
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        return MemoryRequest.copy$default(this, method, null, null, null, null, null, 62, null);
    }

    @Override
    @NotNull
    public MemoryRequest uri(@NotNull Uri uri2) {
        Intrinsics.checkNotNullParameter((Object)uri2, (String)"uri");
        return MemoryRequest.copy$default(this, null, uri2, null, null, null, null, 61, null);
    }

    @Override
    @NotNull
    public MemoryRequest query(@NotNull String name, @Nullable String value2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return MemoryRequest.copy$default(this, null, UriKt.query(this.getUri(), name, value2), null, null, null, null, 61, null);
    }

    @Override
    @Nullable
    public String query(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return ParametersKt.findSingle(ParametersKt.queries(this.getUri()), name);
    }

    @Override
    @NotNull
    public List<String> queries(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return ParametersKt.findMultiple(ParametersKt.queries(this.getUri()), name);
    }

    @Override
    @NotNull
    public MemoryRequest header(@NotNull String name, @Nullable String value2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return MemoryRequest.copy$default(this, null, null, CollectionsKt.plus((Collection)this.getHeaders(), (Object)TuplesKt.to((Object)name, (Object)value2)), null, null, null, 59, null);
    }

    @Override
    @NotNull
    public MemoryRequest replaceHeaders(@NotNull List<Pair<String, String>> source) {
        Intrinsics.checkNotNullParameter(source, (String)"source");
        return MemoryRequest.copy$default(this, null, null, source, null, null, null, 59, null);
    }

    @Override
    @NotNull
    public MemoryRequest headers(@NotNull List<Pair<String, String>> headers) {
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        return MemoryRequest.copy$default(this, null, null, CollectionsKt.plus((Collection)this.getHeaders(), (Iterable)headers), null, null, null, 59, null);
    }

    @Override
    @NotNull
    public MemoryRequest replaceHeader(@NotNull String name, @Nullable String value2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return MemoryRequest.copy$default(this, null, null, HeadersKt.replaceHeader(this.getHeaders(), name, value2), null, null, null, 59, null);
    }

    @Override
    @NotNull
    public MemoryRequest source(@NotNull RequestSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return MemoryRequest.copy$default(this, null, null, null, null, null, source, 31, null);
    }

    @Override
    @NotNull
    public MemoryRequest removeHeader(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return MemoryRequest.copy$default(this, null, null, HeadersKt.removeHeader(this.getHeaders(), name), null, null, null, 59, null);
    }

    @Override
    @NotNull
    public MemoryRequest removeHeaders(@NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        return MemoryRequest.copy$default(this, null, null, HeadersKt.removeHeaders(this.getHeaders(), prefix), null, null, null, 59, null);
    }

    @Override
    @NotNull
    public MemoryRequest removeQuery(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return MemoryRequest.copy$default(this, null, UriKt.removeQuery(this.getUri(), name), null, null, null, null, 61, null);
    }

    @Override
    @NotNull
    public MemoryRequest removeQueries(@NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        return MemoryRequest.copy$default(this, null, UriKt.removeQueries(this.getUri(), prefix), null, null, null, null, 61, null);
    }

    @Override
    @NotNull
    public MemoryRequest body(@NotNull Body body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        return MemoryRequest.copy$default(this, null, null, null, body, null, null, 55, null);
    }

    @Override
    @NotNull
    public MemoryRequest body(@NotNull String body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        return MemoryRequest.copy$default(this, null, null, null, Body.Companion.create(body), null, null, 55, null);
    }

    @Override
    @NotNull
    public MemoryRequest body(@NotNull InputStream body, @Nullable Long length) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        return MemoryRequest.copy$default(this, null, null, null, Body.Companion.create(body, length), null, null, 55, null);
    }

    @NotNull
    public String toString() {
        return this.toMessage();
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof Request && HeadersKt.areSameHeadersAs(this.getHeaders(), ((Request)other).getHeaders()) && this.getMethod() == ((Request)other).getMethod() && Intrinsics.areEqual((Object)this.getUri(), (Object)((Request)other).getUri()) && Intrinsics.areEqual((Object)this.getBody(), (Object)((Request)other).getBody());
    }

    @NotNull
    public final Method component1() {
        return this.method;
    }

    @NotNull
    public final Uri component2() {
        return this.uri;
    }

    @NotNull
    public final List<Pair<String, String>> component3() {
        return this.headers;
    }

    @NotNull
    public final Body component4() {
        return this.body;
    }

    @NotNull
    public final String component5() {
        return this.version;
    }

    @Nullable
    public final RequestSource component6() {
        return this.source;
    }

    @NotNull
    public final MemoryRequest copy(@NotNull Method method, @NotNull Uri uri2, @NotNull List<Pair<String, String>> headers, @NotNull Body body, @NotNull String version, @Nullable RequestSource source) {
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        Intrinsics.checkNotNullParameter((Object)uri2, (String)"uri");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        return new MemoryRequest(method, uri2, headers, body, version, source);
    }

    public static /* synthetic */ MemoryRequest copy$default(MemoryRequest memoryRequest, Method method, Uri uri2, List list, Body body, String string, RequestSource requestSource, int n, Object object) {
        if ((n & 1) != 0) {
            method = memoryRequest.method;
        }
        if ((n & 2) != 0) {
            uri2 = memoryRequest.uri;
        }
        if ((n & 4) != 0) {
            list = memoryRequest.headers;
        }
        if ((n & 8) != 0) {
            body = memoryRequest.body;
        }
        if ((n & 0x10) != 0) {
            string = memoryRequest.version;
        }
        if ((n & 0x20) != 0) {
            requestSource = memoryRequest.source;
        }
        return memoryRequest.copy(method, uri2, list, body, string, requestSource);
    }

    public int hashCode() {
        int result = this.method.hashCode();
        result = result * 31 + this.uri.hashCode();
        result = result * 31 + ((Object)this.headers).hashCode();
        result = result * 31 + this.body.hashCode();
        result = result * 31 + this.version.hashCode();
        result = result * 31 + (this.source == null ? 0 : this.source.hashCode());
        return result;
    }
}

