/*
 * Decompiled with CFR 0.152.
 */
package ir.amirab.downloader.downloaditem.hls;

import io.lindstrom.m3u8.model.KeyMethod;
import io.lindstrom.m3u8.model.MediaPlaylist;
import io.lindstrom.m3u8.model.MediaSegment;
import io.lindstrom.m3u8.model.Playlist;
import io.lindstrom.m3u8.model.SegmentKey;
import io.lindstrom.m3u8.parser.MediaPlaylistParser;
import ir.amirab.downloader.connection.Connection;
import ir.amirab.downloader.connection.IResponseInfo;
import ir.amirab.downloader.connection.response.HttpResponseInfo;
import ir.amirab.downloader.connection.response.HttpResponseInfoKt;
import ir.amirab.downloader.downloaditem.hls.BadHLSResponseException;
import ir.amirab.downloader.utils.FileNameUtil;
import ir.amirab.util.HttpUrlUtils;
import java.io.Closeable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 '2\u00020\u0001:\u0001'B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010!\u001a\u00020\u00162\b\u0010\"\u001a\u0004\u0018\u00010#H\u00d6\u0003J\t\u0010$\u001a\u00020%H\u00d6\u0001J\t\u0010&\u001a\u00020\rH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0015\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017R\u0014\u0010\u001a\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0017R\u0014\u0010\u001c\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0017\u00a8\u0006("}, d2={"Lir/amirab/downloader/downloaditem/hls/HLSResponseInfo;", "Lir/amirab/downloader/connection/IResponseInfo;", "httpResponseInfo", "Lir/amirab/downloader/connection/response/HttpResponseInfo;", "hlsManifest", "Lio/lindstrom/m3u8/model/MediaPlaylist;", "<init>", "(Lir/amirab/downloader/connection/response/HttpResponseInfo;Lio/lindstrom/m3u8/model/MediaPlaylist;)V", "getHttpResponseInfo", "()Lir/amirab/downloader/connection/response/HttpResponseInfo;", "getHlsManifest", "()Lio/lindstrom/m3u8/model/MediaPlaylist;", "name", "", "getName", "()Ljava/lang/String;", "duration", "", "getDuration", "()Ljava/lang/Double;", "Ljava/lang/Double;", "isSuccessFul", "", "()Z", "requiresAuth", "getRequiresAuth", "requireBasicAuth", "getRequireBasicAuth", "resumeSupport", "getResumeSupport", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "toString", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nHLSResponseInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HLSResponseInfo.kt\nir/amirab/downloader/downloaditem/hls/HLSResponseInfo\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,127:1\n1#2:128\n*E\n"})
public final class HLSResponseInfo
implements IResponseInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HttpResponseInfo httpResponseInfo;
    @NotNull
    private final MediaPlaylist hlsManifest;
    @Nullable
    private final String name;
    @Nullable
    private final Double duration;
    @NotNull
    private static final List<String> HALS_POSSIBLE_HEADERS;
    private static final int MAXIMUM_ALLOWED_SIZE = 0x200000;

    /*
     * WARNING - void declaration
     */
    public HLSResponseInfo(@NotNull HttpResponseInfo httpResponseInfo, @NotNull MediaPlaylist hlsManifest) {
        void it;
        double d;
        Intrinsics.checkNotNullParameter((Object)httpResponseInfo, (String)"httpResponseInfo");
        Intrinsics.checkNotNullParameter((Object)hlsManifest, (String)"hlsManifest");
        this.httpResponseInfo = httpResponseInfo;
        this.hlsManifest = hlsManifest;
        this.name = this.httpResponseInfo.getFileName();
        List list = this.hlsManifest.mediaSegments();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"mediaSegments(...)");
        Object object = list;
        HLSResponseInfo hLSResponseInfo = this;
        double d2 = 0.0;
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            void it2;
            Object t = iterator.next();
            MediaSegment mediaSegment = (MediaSegment)t;
            d = d2;
            boolean bl = false;
            double d3 = it2.duration();
            d2 = d + d3;
        }
        d = d2;
        object = d;
        d2 = ((Number)object).doubleValue();
        boolean bl = false;
        boolean bl2 = it > 0.0;
        hLSResponseInfo.duration = bl2 ? object : null;
    }

    @NotNull
    public final HttpResponseInfo getHttpResponseInfo() {
        return this.httpResponseInfo;
    }

    @NotNull
    public final MediaPlaylist getHlsManifest() {
        return this.hlsManifest;
    }

    @Nullable
    public final String getName() {
        return this.name;
    }

    @Nullable
    public final Double getDuration() {
        return this.duration;
    }

    @Override
    public boolean isSuccessFul() {
        return this.httpResponseInfo.isSuccessFul();
    }

    @Override
    public boolean getRequiresAuth() {
        return this.httpResponseInfo.getRequireBasicAuth();
    }

    @Override
    public boolean getRequireBasicAuth() {
        return this.httpResponseInfo.getRequireBasicAuth();
    }

    @Override
    public boolean getResumeSupport() {
        return true;
    }

    @NotNull
    public final HttpResponseInfo component1() {
        return this.httpResponseInfo;
    }

    @NotNull
    public final MediaPlaylist component2() {
        return this.hlsManifest;
    }

    @NotNull
    public final HLSResponseInfo copy(@NotNull HttpResponseInfo httpResponseInfo, @NotNull MediaPlaylist hlsManifest) {
        Intrinsics.checkNotNullParameter((Object)httpResponseInfo, (String)"httpResponseInfo");
        Intrinsics.checkNotNullParameter((Object)hlsManifest, (String)"hlsManifest");
        return new HLSResponseInfo(httpResponseInfo, hlsManifest);
    }

    public static /* synthetic */ HLSResponseInfo copy$default(HLSResponseInfo hLSResponseInfo, HttpResponseInfo httpResponseInfo, MediaPlaylist mediaPlaylist, int n, Object object) {
        if ((n & 1) != 0) {
            httpResponseInfo = hLSResponseInfo.httpResponseInfo;
        }
        if ((n & 2) != 0) {
            mediaPlaylist = hLSResponseInfo.hlsManifest;
        }
        return hLSResponseInfo.copy(httpResponseInfo, mediaPlaylist);
    }

    @NotNull
    public String toString() {
        return "HLSResponseInfo(httpResponseInfo=" + this.httpResponseInfo + ", hlsManifest=" + this.hlsManifest + ")";
    }

    public int hashCode() {
        int result2 = this.httpResponseInfo.hashCode();
        result2 = result2 * 31 + this.hlsManifest.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HLSResponseInfo)) {
            return false;
        }
        HLSResponseInfo hLSResponseInfo = (HLSResponseInfo)other;
        if (!Intrinsics.areEqual((Object)this.httpResponseInfo, (Object)hLSResponseInfo.httpResponseInfo)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.hlsManifest, (Object)hLSResponseInfo.hlsManifest);
    }

    static {
        Object[] objectArray = new String[]{"application/x-mpegurl", "application/vnd.apple.mpegurl"};
        HALS_POSSIBLE_HEADERS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\u0011\u001a\u00020\u00122\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\nH\u0002R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lir/amirab/downloader/downloaditem/hls/HLSResponseInfo$Companion;", "", "<init>", "()V", "fromConnection", "Lir/amirab/downloader/downloaditem/hls/HLSResponseInfo;", "connection", "Lir/amirab/downloader/connection/Connection;", "Lir/amirab/downloader/connection/response/HttpResponseInfo;", "parseHLSAsMediaPlaylist", "Lio/lindstrom/m3u8/model/MediaPlaylist;", "data", "", "HALS_POSSIBLE_HEADERS", "", "MAXIMUM_ALLOWED_SIZE", "", "expectSuccess", "", "isMediaPlayListEncrypted", "", "playlist", "core"})
    @SourceDebugExtension(value={"SMAP\nHLSResponseInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HLSResponseInfo.kt\nir/amirab/downloader/downloaditem/hls/HLSResponseInfo$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,127:1\n1#2:128\n1761#3,3:129\n1761#3,2:132\n1761#3,3:134\n1763#3:137\n*S KotlinDebug\n*F\n+ 1 HLSResponseInfo.kt\nir/amirab/downloader/downloaditem/hls/HLSResponseInfo$Companion\n*L\n92#1:129,3\n115#1:132,2\n116#1:134,3\n115#1:137\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @NotNull
        public final HLSResponseInfo fromConnection(@NotNull Connection<HttpResponseInfo> connection) {
            Intrinsics.checkNotNullParameter(connection, (String)"connection");
            this.expectSuccess(connection);
            var3_2 = (Closeable)Okio.buffer((Source)connection.getSource());
            var4_3 = null;
            try {
                it /* !! */  = (BufferedSource)var3_2;
                $i$a$-use-HLSResponseInfo$Companion$fromConnection$data$1 = false;
                it /* !! */  = it /* !! */ .readUtf8();
            }
            catch (Throwable var6_7) {
                var4_3 = var6_7;
                throw var6_7;
            }
            finally {
                CloseableKt.closeFinally((Closeable)var3_2, (Throwable)var4_3);
            }
            data /* !! */  = it /* !! */ ;
            try {
                var4_3 = this.parseHLSAsMediaPlaylist((String)data /* !! */ );
            }
            catch (Exception e) {
                throw new BadHLSResponseException("can't parse HLS playlist", e);
            }
            playlist = var4_3;
            mediaSegments = playlist.mediaSegments();
            if (mediaSegments.isEmpty()) {
                throw new UnsupportedOperationException("playlist has no segments");
            }
            v0 = HttpUrlUtils.INSTANCE.createURL(connection.getResponseInfo().getRequestUrl());
            v1 = ((MediaSegment)mediaSegments.get(0)).uri();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"uri(...)");
            var6_9 = v0.resolve(v1);
            if (var6_9 == null || (var7_11 = var6_9.toString()) == null) ** GOTO lbl-1000
            var9_12 = var7_11;
            var10_13 /* !! */  = HttpUrlUtils.INSTANCE;
            p0 = var9_12;
            $i$a$-let-HLSResponseInfo$Companion$fromConnection$firstSegmentExtension$1 = false;
            var8_17 = var10_13 /* !! */ .extractNameFromLink(p0);
            if (var8_17 == null) ** GOTO lbl-1000
            var10_13 /* !! */  = var8_17;
            var11_14 = FileNameUtil.INSTANCE;
            p0 /* !! */  = var10_13 /* !! */ ;
            $i$a$-let-HLSResponseInfo$Companion$fromConnection$firstSegmentExtension$2 = false;
            var9_12 = var11_14.getExtensionOrNull((String)p0 /* !! */ );
            if (var9_12 != null) {
                v2 = var9_12.toLowerCase(Locale.ROOT);
                v3 = v2;
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"toLowerCase(...)");
            } else lbl-1000:
            // 3 sources

            {
                v3 = firstSegmentExtension = null;
            }
            if (!Intrinsics.areEqual(firstSegmentExtension, (Object)"ts")) {
                throw new UnsupportedOperationException("Only HLS .ts segments supported at the moment, but '" + firstSegmentExtension + "' provided");
            }
            if (this.isMediaPlayListEncrypted((MediaPlaylist)playlist)) {
                throw new UnsupportedOperationException("Encrypted HLS playlists are not supported");
            }
            return new HLSResponseInfo(connection.getResponseInfo(), (MediaPlaylist)playlist);
        }

        private final MediaPlaylist parseHLSAsMediaPlaylist(String data) {
            MediaPlaylistParser playlistParser = new MediaPlaylistParser();
            Playlist playlist = playlistParser.readPlaylist(data);
            Intrinsics.checkNotNullExpressionValue((Object)playlist, (String)"readPlaylist(...)");
            return (MediaPlaylist)playlist;
        }

        private final void expectSuccess(Connection<HttpResponseInfo> connection) {
            HttpResponseInfoKt.expectSuccess(connection.getResponseInfo());
            List hlsPossibleHeaders = HALS_POSSIBLE_HEADERS;
            String contentType = connection.getResponseInfo().getResponseHeaders().get("content-type");
            Object error = null;
            if (contentType == null) {
                error = "no content type is provided";
            } else {
                boolean isHLSContentType;
                block8: {
                    Iterable $this$any$iv = hlsPossibleHeaders;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v0 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl = false;
                            if (!StringsKt.startsWith((String)it, (String)contentType, (boolean)true)) continue;
                            v0 = true;
                            break block8;
                        }
                        v0 = isHLSContentType = false;
                    }
                }
                if (!isHLSContentType) {
                    error = "content type is not hls compatible: " + contentType;
                }
            }
            if (error != null) {
                Long contentLength = connection.getResponseInfo().getContentLength();
                error = contentLength == null ? (String)error + ", and content length is unknown" : (contentLength > 0x200000L ? (String)error + ", and returned content length is too big for hls playlist" : null);
            }
            if (error != null) {
                throw new BadHLSResponseException((String)error, null, 2, null);
            }
        }

        private final boolean isMediaPlayListEncrypted(MediaPlaylist playlist) {
            boolean bl;
            block7: {
                List list = playlist.mediaSegments();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"mediaSegments(...)");
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        boolean bl2;
                        block6: {
                            MediaSegment it = (MediaSegment)element$iv;
                            boolean bl3 = false;
                            List list2 = it.segmentKeys();
                            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"segmentKeys(...)");
                            Iterable $this$any$iv2 = list2;
                            boolean $i$f$any2 = false;
                            if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                bl2 = false;
                            } else {
                                for (Object element$iv2 : $this$any$iv2) {
                                    SegmentKey key = (SegmentKey)element$iv2;
                                    boolean bl4 = false;
                                    if (!(key.method() != KeyMethod.NONE)) continue;
                                    bl2 = true;
                                    break block6;
                                }
                                bl2 = false;
                            }
                        }
                        if (!bl2) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

