import { NgbModal } from '@ng-bootstrap/ng-bootstrap';
import { BaseTabComponent, TabContextMenuItemProvider, NotificationsService, MenuItemOptions, TranslateService, ConfigService } from 'tabby-core';
import { TerminalContextMenuItemProvider } from './api/contextMenuProvider';
import { MultifocusService } from './services/multifocus.service';
/** @hidden */
export declare class CopyPasteContextMenu extends TabContextMenuItemProvider {
    private notifications;
    private translate;
    weight: number;
    constructor(notifications: NotificationsService, translate: TranslateService);
    getItems(tab: BaseTabComponent, tabHeader?: boolean): Promise<MenuItemOptions[]>;
}
/** @hidden */
export declare class MiscContextMenu extends TabContextMenuItemProvider {
    private translate;
    private multifocus;
    weight: number;
    constructor(translate: TranslateService, multifocus: MultifocusService);
    getItems(tab: BaseTabComponent): Promise<MenuItemOptions[]>;
}
/** @hidden */
export declare class ReconnectContextMenu extends TabContextMenuItemProvider {
    private translate;
    private notifications;
    weight: number;
    constructor(translate: TranslateService, notifications: NotificationsService);
    getItems(tab: BaseTabComponent): Promise<MenuItemOptions[]>;
}
/** @hidden */
export declare class LegacyContextMenu extends TabContextMenuItemProvider {
    protected contextMenuProviders: TerminalContextMenuItemProvider[] | null;
    weight: number;
    constructor(contextMenuProviders: TerminalContextMenuItemProvider[] | null);
    getItems(tab: BaseTabComponent): Promise<MenuItemOptions[]>;
}
/** @hidden */
export declare class SaveAsProfileContextMenu extends TabContextMenuItemProvider {
    private config;
    private ngbModal;
    private notifications;
    private translate;
    constructor(config: ConfigService, ngbModal: NgbModal, notifications: NotificationsService, translate: TranslateService);
    getItems(tab: BaseTabComponent): Promise<MenuItemOptions[]>;
}
