import { EventEmitter } from '@angular/core';
import { TranslateService } from '@ngx-translate/core';
import { FileTransfer, PlatformService } from '../api/platform';
/** @hidden */
export declare class TransfersMenuComponent {
    private platform;
    private translate;
    transfers: FileTransfer[];
    transfersChange: EventEmitter<FileTransfer[]>;
    constructor(platform: PlatformService, translate: TranslateService);
    isDownload(transfer: FileTransfer): boolean;
    getProgress(transfer: FileTransfer): number;
    showTransfer(transfer: FileTransfer): void;
    removeTransfer(transfer: FileTransfer): void;
    removeAll(): Promise<void>;
}
