"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClientEventInterface = void 0;
const rxjs_1 = require("rxjs");
class ClientEventInterface {
    constructor() {
        this.data$ = new rxjs_1.Subject();
        this.extendedData$ = new rxjs_1.Subject();
        this.eof$ = new rxjs_1.Subject();
        this.close$ = new rxjs_1.Subject();
        this.disconnect$ = new rxjs_1.Subject();
        this.x11ChannelOpen$ = new rxjs_1.Subject();
        this.tcpChannelOpen$ = new rxjs_1.Subject();
        this.agentChannelOpen$ = new rxjs_1.Subject();
        this.banner$ = new rxjs_1.AsyncSubject();
        this.dataCallback = (_, channel, data) => {
            this.data$.next([channel, data]);
        };
        this.extendedDataCallback = (_, channel, ext, data) => {
            this.extendedData$.next([channel, ext, data]);
        };
        this.eofCallback = (_, channel) => {
            this.eof$.next(channel);
        };
        this.closeCallback = (_, channel) => {
            this.close$.next(channel);
        };
        this.disconnectCallback = () => {
            this.disconnect$.next();
        };
        this.x11ChannelOpenCallback = (_, channel, address, port) => {
            this.x11ChannelOpen$.next([channel, address, port]);
        };
        this.tcpChannelOpenCallback = (_, channel, connectedAddress, connectedPort, originatorAddress, originatorPort) => {
            this.tcpChannelOpen$.next([channel, connectedAddress, connectedPort, originatorAddress, originatorPort]);
        };
        this.agentChannelOpenCallback = (_, channel) => {
            this.agentChannelOpen$.next([channel]);
        };
        this.bannerCallback = (_, banner) => {
            this.banner$.next(banner);
            this.banner$.complete();
        };
    }
    complete() {
        this.data$.complete();
        this.extendedData$.complete();
        this.eof$.complete();
        this.close$.complete();
        this.disconnect$.complete();
        this.x11ChannelOpen$.complete();
        this.tcpChannelOpen$.complete();
        this.agentChannelOpen$.complete();
        this.banner$.complete();
    }
}
exports.ClientEventInterface = ClientEventInterface;
