import { NgbDropdown, NgbModal } from '@ng-bootstrap/ng-bootstrap';
import { CdkDragDrop } from '@angular/cdk/drag-drop';
import { HostAppService, Platform } from '../api/hostApp';
import { HotkeysService } from '../services/hotkeys.service';
import { LogService } from '../services/log.service';
import { ConfigService } from '../services/config.service';
import { ThemesService } from '../services/themes.service';
import { UpdaterService } from '../services/updater.service';
import { CommandService } from '../services/commands.service';
import { BaseTabComponent } from './baseTab.component';
import { TabBodyComponent } from './tabBody.component';
import { AppService, Command, FileTransfer, HostWindowService, PlatformService } from '../api';
/** @hidden */
export declare class AppRootComponent {
    private hotkeys;
    private commands;
    updater: UpdaterService;
    hostWindow: HostWindowService;
    hostApp: HostAppService;
    config: ConfigService;
    app: AppService;
    Platform: typeof Platform;
    ready: boolean;
    leftToolbarButtons: Command[];
    rightToolbarButtons: Command[];
    platformClassWindows: boolean;
    platformClassMacOS: boolean;
    platformClassLinux: boolean;
    noTabs: boolean;
    tabBodies: TabBodyComponent[];
    activeTransfersDropdown: NgbDropdown;
    unsortedTabs: BaseTabComponent[];
    updatesAvailable: boolean;
    activeTransfers: FileTransfer[];
    private logger;
    constructor(hotkeys: HotkeysService, commands: CommandService, updater: UpdaterService, hostWindow: HostWindowService, hostApp: HostAppService, config: ConfigService, app: AppService, platform: PlatformService, log: LogService, ngbModal: NgbModal, _themes: ThemesService);
    ngOnInit(): Promise<void>;
    onDragOver(): boolean;
    onDrop(): boolean;
    hasVerticalTabs(): boolean;
    get targetTabSize(): any;
    onTabsReordered(event: CdkDragDrop<BaseTabComponent[]>): void;
    onTransfersChange(): void;
    get isVibrant(): any;
    private getToolbarButtons;
    toggleMaximize(): void;
    protected isTitleBarNeeded(): boolean;
}
