/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr.parser;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import oracle.jrockit.jfr.parser.FLRInput;

final class RandomAccessFileFLRInput
implements FLRInput {
    private static final int BLOCK_SIZE = 0x1000000;
    private final RandomAccessFile file;
    private Block currentBlock = new Block();
    private Block previousBlock = new Block();
    private long position;

    public RandomAccessFileFLRInput(String string) throws FileNotFoundException {
        this(new File(string));
    }

    public RandomAccessFileFLRInput(File file) throws FileNotFoundException {
        this(new RandomAccessFile(file, "r"));
    }

    public RandomAccessFileFLRInput(RandomAccessFile randomAccessFile) {
        this.file = randomAccessFile;
    }

    @Override
    public byte get() throws IOException {
        if (!this.currentBlock.contains(this.position)) {
            this.position(this.position);
        }
        return this.currentBlock.get(this.position++);
    }

    @Override
    public void get(byte[] byArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            byArray[i + n] = this.get();
        }
    }

    @Override
    public void get(byte[] byArray) throws IOException {
        this.get(byArray, 0, byArray.length);
    }

    @Override
    public char getChar() throws IOException {
        byte by = this.get();
        byte by2 = this.get();
        return (char)((by2 & 0xFF) + (by << 8));
    }

    @Override
    public short getShort() throws IOException {
        byte by = this.get();
        byte by2 = this.get();
        return (short)((by2 & 0xFF) + (by << 8));
    }

    @Override
    public double getDouble() throws IOException {
        return Double.longBitsToDouble(this.getLong());
    }

    @Override
    public float getFloat() throws IOException {
        return Float.intBitsToFloat(this.getInt());
    }

    @Override
    public int getInt() throws IOException {
        byte by = this.get();
        byte by2 = this.get();
        byte by3 = this.get();
        byte by4 = this.get();
        return (by4 & 0xFF) + ((by3 & 0xFF) << 8) + ((by2 & 0xFF) << 16) + (by << 24);
    }

    @Override
    public long getLong() throws IOException {
        byte by = this.get();
        byte by2 = this.get();
        byte by3 = this.get();
        byte by4 = this.get();
        byte by5 = this.get();
        byte by6 = this.get();
        byte by7 = this.get();
        byte by8 = this.get();
        return ((long)by8 & 0xFFL) + (((long)by7 & 0xFFL) << 8) + (((long)by6 & 0xFFL) << 16) + (((long)by5 & 0xFFL) << 24) + (((long)by4 & 0xFFL) << 32) + (((long)by3 & 0xFFL) << 40) + (((long)by2 & 0xFFL) << 48) + ((long)by << 56);
    }

    @Override
    public long position() throws IOException {
        return this.position;
    }

    @Override
    public void position(long l) throws IOException {
        if (!this.currentBlock.contains(l)) {
            if (!this.previousBlock.contains(l)) {
                if (l > this.size()) {
                    throw new EOFException("Trying to read at " + l + ", but file is only " + this.size() + " bytes.");
                }
                long l2 = this.trimToFileSize(this.calculateBlockStart(l));
                this.file.seek(l2);
                long l3 = Math.min(this.size() - l2, 0x1000000L);
                this.previousBlock.read(this.file, (int)l3);
            }
            Block block = this.currentBlock;
            this.currentBlock = this.previousBlock;
            this.previousBlock = block;
        }
        this.position = l;
    }

    private long trimToFileSize(long l) throws IOException {
        return Math.min(this.size(), Math.max(0L, l));
    }

    private long calculateBlockStart(long l) {
        if (this.currentBlock.contains(l - 0x1000000L)) {
            return this.currentBlock.blockPosition + (long)this.currentBlock.bytes.length;
        }
        if (this.currentBlock.contains(l + 0x1000000L)) {
            return this.currentBlock.blockPosition - 0x1000000L;
        }
        return l - 0x800000L;
    }

    @Override
    public long size() throws IOException {
        return this.file.length();
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }

    private static final class Block {
        private byte[] bytes = new byte[0];
        private long blockPosition;

        private Block() {
        }

        boolean contains(long l) {
            return l >= this.blockPosition && l < this.blockPosition + (long)this.bytes.length;
        }

        public void read(RandomAccessFile randomAccessFile, int n) throws IOException {
            this.blockPosition = randomAccessFile.getFilePointer();
            if (n != this.bytes.length) {
                this.bytes = new byte[n];
            }
            randomAccessFile.readFully(this.bytes);
        }

        public byte get(long l) {
            return this.bytes[(int)(l - this.blockPosition)];
        }
    }
}

