/*
 * Decompiled with CFR 0.152.
 */
package sun.security.rsa;

import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.PSSParameterSpec;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;

public class RSAUtil {
    private static void requireNonNull(Object object, String string) {
        if (object == null) {
            throw new ProviderException(string);
        }
    }

    public static AlgorithmParameterSpec checkParamsAgainstType(KeyType keyType, AlgorithmParameterSpec algorithmParameterSpec) throws ProviderException {
        if (algorithmParameterSpec == null) {
            return null;
        }
        Class<? extends AlgorithmParameterSpec> clazz = keyType.paramSpecCls;
        if (clazz == null) {
            throw new ProviderException("null params expected for " + keyType.keyAlgo);
        }
        if (!clazz.isInstance(algorithmParameterSpec)) {
            throw new ProviderException(clazz + " expected for " + keyType.keyAlgo);
        }
        return algorithmParameterSpec;
    }

    public static AlgorithmParameters getParams(KeyType keyType, AlgorithmParameterSpec algorithmParameterSpec) throws ProviderException {
        if (algorithmParameterSpec == null) {
            return null;
        }
        try {
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance(keyType.keyAlgo);
            algorithmParameters.init(algorithmParameterSpec);
            return algorithmParameters;
        }
        catch (NoSuchAlgorithmException | InvalidParameterSpecException generalSecurityException) {
            throw new ProviderException(generalSecurityException);
        }
    }

    public static AlgorithmId createAlgorithmId(KeyType keyType, AlgorithmParameterSpec algorithmParameterSpec) throws ProviderException {
        RSAUtil.checkParamsAgainstType(keyType, algorithmParameterSpec);
        ObjectIdentifier objectIdentifier = keyType.oid;
        AlgorithmParameters algorithmParameters = RSAUtil.getParams(keyType, algorithmParameterSpec);
        return new AlgorithmId(objectIdentifier, algorithmParameters);
    }

    public static AlgorithmParameterSpec getParamSpec(AlgorithmParameters algorithmParameters) throws ProviderException {
        if (algorithmParameters == null) {
            return null;
        }
        String string = algorithmParameters.getAlgorithm();
        KeyType keyType = KeyType.lookup(string);
        Class<? extends AlgorithmParameterSpec> clazz = keyType.paramSpecCls;
        if (clazz == null) {
            throw new ProviderException("No params accepted for " + keyType.keyAlgo);
        }
        try {
            return algorithmParameters.getParameterSpec(clazz);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new ProviderException(invalidParameterSpecException);
        }
    }

    public static Object[] getTypeAndParamSpec(AlgorithmId algorithmId) throws ProviderException {
        RSAUtil.requireNonNull(algorithmId, "AlgorithmId should not be null");
        Object[] objectArray = new Object[2];
        String string = algorithmId.getName();
        try {
            objectArray[0] = KeyType.lookup(string);
        }
        catch (ProviderException providerException) {
            if (string.indexOf("RSA") != -1) {
                objectArray[0] = KeyType.RSA;
            }
            throw providerException;
        }
        objectArray[1] = RSAUtil.getParamSpec(algorithmId.getParameters());
        return objectArray;
    }

    public static enum KeyType {
        RSA("RSA", AlgorithmId.RSAEncryption_oid, null),
        PSS("RSASSA-PSS", AlgorithmId.RSASSA_PSS_oid, PSSParameterSpec.class);

        final String keyAlgo;
        final ObjectIdentifier oid;
        final Class<? extends AlgorithmParameterSpec> paramSpecCls;

        private KeyType(String string2, ObjectIdentifier objectIdentifier, Class<? extends AlgorithmParameterSpec> clazz) {
            this.keyAlgo = string2;
            this.oid = objectIdentifier;
            this.paramSpecCls = clazz;
        }

        public static KeyType lookup(String string) throws ProviderException {
            RSAUtil.requireNonNull(string, "Key algorithm should not be null");
            if (string.indexOf("PSS") != -1) {
                return PSS;
            }
            if (string.indexOf("RSA") != -1) {
                return RSA;
            }
            throw new ProviderException("Unsupported algorithm " + string);
        }
    }
}

