/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.signature;

import com.sun.org.apache.xml.internal.security.algorithms.SignatureAlgorithm;
import com.sun.org.apache.xml.internal.security.c14n.CanonicalizationException;
import com.sun.org.apache.xml.internal.security.c14n.Canonicalizer;
import com.sun.org.apache.xml.internal.security.c14n.InvalidCanonicalizerException;
import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.signature.Manifest;
import com.sun.org.apache.xml.internal.security.signature.MissingResourceFailureException;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureException;
import com.sun.org.apache.xml.internal.security.transforms.params.InclusiveNamespaces;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SignedInfo
extends Manifest {
    private final SignatureAlgorithm signatureAlgorithm;
    private byte[] c14nizedBytes;
    private Element c14nMethod;
    private Element signatureMethod;

    public SignedInfo(Document document) throws XMLSecurityException {
        this(document, "http://www.w3.org/2000/09/xmldsig#dsa-sha1", "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
    }

    public SignedInfo(Document document, String string, String string2) throws XMLSecurityException {
        this(document, string, 0, string2, null, null);
    }

    public SignedInfo(Document document, String string, String string2, Provider provider) throws XMLSecurityException {
        this(document, string, 0, string2, provider, null);
    }

    public SignedInfo(Document document, String string, int n, String string2) throws XMLSecurityException {
        this(document, string, n, string2, null, null);
    }

    public SignedInfo(Document document, String string, int n, String string2, Provider provider, AlgorithmParameterSpec algorithmParameterSpec) throws XMLSecurityException {
        super(document);
        this.c14nMethod = XMLUtils.createElementInSignatureSpace(this.getDocument(), "CanonicalizationMethod");
        this.c14nMethod.setAttributeNS(null, "Algorithm", string2);
        this.appendSelf(this.c14nMethod);
        this.addReturnToSelf();
        this.signatureAlgorithm = n > 0 ? new SignatureAlgorithm(this.getDocument(), string, n, provider) : new SignatureAlgorithm(this.getDocument(), string, provider, algorithmParameterSpec);
        this.signatureMethod = this.signatureAlgorithm.getElement();
        this.appendSelf(this.signatureMethod);
        this.addReturnToSelf();
    }

    public SignedInfo(Document document, Element element, Element element2) throws XMLSecurityException {
        this(document, element, element2, null);
    }

    public SignedInfo(Document document, Element element, Element element2, Provider provider) throws XMLSecurityException {
        super(document);
        this.c14nMethod = element2;
        this.appendSelf(this.c14nMethod);
        this.addReturnToSelf();
        this.signatureAlgorithm = new SignatureAlgorithm(element, null, provider);
        this.signatureMethod = this.signatureAlgorithm.getElement();
        this.appendSelf(this.signatureMethod);
        this.addReturnToSelf();
    }

    public SignedInfo(Element element, String string) throws XMLSecurityException {
        this(element, string, true, null);
    }

    public SignedInfo(Element element, String string, boolean bl) throws XMLSecurityException {
        this(element, string, bl, null);
    }

    public SignedInfo(Element element, String string, boolean bl, Provider provider) throws XMLSecurityException {
        super(element, string, bl);
        this.c14nMethod = XMLUtils.getNextElement(element.getFirstChild());
        if (this.c14nMethod == null || !"http://www.w3.org/2000/09/xmldsig#".equals(this.c14nMethod.getNamespaceURI()) || !"CanonicalizationMethod".equals(this.c14nMethod.getLocalName())) {
            Object[] objectArray = new Object[]{"CanonicalizationMethod", "SignedInfo"};
            throw new XMLSignatureException("xml.WrongContent", objectArray);
        }
        this.signatureMethod = XMLUtils.getNextElement(this.c14nMethod.getNextSibling());
        if (this.signatureMethod == null || !"http://www.w3.org/2000/09/xmldsig#".equals(this.signatureMethod.getNamespaceURI()) || !"SignatureMethod".equals(this.signatureMethod.getLocalName())) {
            Object[] objectArray = new Object[]{"SignatureMethod", "SignedInfo"};
            throw new XMLSignatureException("xml.WrongContent", objectArray);
        }
        this.signatureAlgorithm = new SignatureAlgorithm(this.signatureMethod, this.getBaseURI(), bl, provider);
    }

    public boolean verify() throws MissingResourceFailureException, XMLSecurityException {
        return super.verifyReferences(false);
    }

    public boolean verify(boolean bl) throws MissingResourceFailureException, XMLSecurityException {
        return super.verifyReferences(bl);
    }

    public byte[] getCanonicalizedOctetStream() throws CanonicalizationException, InvalidCanonicalizerException, XMLSecurityException, IOException {
        if (this.c14nizedBytes == null) {
            Canonicalizer canonicalizer = Canonicalizer.getInstance(this.getCanonicalizationMethodURI());
            String string = this.getInclusiveNamespaces();
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                if (string == null) {
                    canonicalizer.canonicalizeSubtree(this.getElement(), byteArrayOutputStream);
                } else {
                    canonicalizer.canonicalizeSubtree(this.getElement(), string, byteArrayOutputStream);
                }
                this.c14nizedBytes = byteArrayOutputStream.toByteArray();
            }
        }
        return (byte[])this.c14nizedBytes.clone();
    }

    public void signInOctetStream(OutputStream outputStream) throws CanonicalizationException, InvalidCanonicalizerException, XMLSecurityException {
        if (this.c14nizedBytes == null) {
            Canonicalizer canonicalizer = Canonicalizer.getInstance(this.getCanonicalizationMethodURI());
            String string = this.getInclusiveNamespaces();
            if (string == null) {
                canonicalizer.canonicalizeSubtree(this.getElement(), outputStream);
            } else {
                canonicalizer.canonicalizeSubtree(this.getElement(), string, outputStream);
            }
        } else {
            try {
                outputStream.write(this.c14nizedBytes);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    public String getCanonicalizationMethodURI() {
        return this.c14nMethod.getAttributeNS(null, "Algorithm");
    }

    public String getSignatureMethodURI() {
        Element element = this.getSignatureMethodElement();
        if (element != null) {
            return element.getAttributeNS(null, "Algorithm");
        }
        return null;
    }

    public Element getSignatureMethodElement() {
        return this.signatureMethod;
    }

    public SecretKey createSecretKey(byte[] byArray) {
        return new SecretKeySpec(byArray, this.signatureAlgorithm.getJCEAlgorithmString());
    }

    public SignatureAlgorithm getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    @Override
    public String getBaseLocalName() {
        return "SignedInfo";
    }

    public String getInclusiveNamespaces() {
        String string = this.getCanonicalizationMethodURI();
        if (!"http://www.w3.org/2001/10/xml-exc-c14n#".equals(string) && !"http://www.w3.org/2001/10/xml-exc-c14n#WithComments".equals(string)) {
            return null;
        }
        Element element = XMLUtils.getNextElement(this.c14nMethod.getFirstChild());
        if (element != null) {
            try {
                String string2 = new InclusiveNamespaces(element, "http://www.w3.org/2001/10/xml-exc-c14n#").getInclusiveNamespaces();
                return string2;
            }
            catch (XMLSecurityException xMLSecurityException) {
                return null;
            }
        }
        return null;
    }
}

