/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import com.sun.java.swing.SwingUtilities3;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.MenuItemUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.basic.LazyActionMap;
import javax.swing.text.View;
import sun.swing.MenuItemCheckIconFactory;
import sun.swing.MenuItemLayoutHelper;
import sun.swing.SwingUtilities2;
import sun.swing.UIAction;

public class BasicMenuItemUI
extends MenuItemUI {
    protected JMenuItem menuItem = null;
    protected Color selectionBackground;
    protected Color selectionForeground;
    protected Color disabledForeground;
    protected Color acceleratorForeground;
    protected Color acceleratorSelectionForeground;
    protected String acceleratorDelimiter;
    protected int defaultTextIconGap;
    protected Font acceleratorFont;
    protected MouseInputListener mouseInputListener;
    protected MenuDragMouseListener menuDragMouseListener;
    protected MenuKeyListener menuKeyListener;
    protected PropertyChangeListener propertyChangeListener;
    Handler handler;
    protected Icon arrowIcon = null;
    protected Icon checkIcon = null;
    protected boolean oldBorderPainted;
    private static final boolean TRACE = false;
    private static final boolean VERBOSE = false;
    private static final boolean DEBUG = false;

    static void loadActionMap(LazyActionMap lazyActionMap) {
        lazyActionMap.put(new Actions("doClick"));
        BasicLookAndFeel.installAudioActionMap(lazyActionMap);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicMenuItemUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.menuItem = (JMenuItem)jComponent;
        this.installDefaults();
        this.installComponents(this.menuItem);
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void installDefaults() {
        Object object;
        String string = this.getPropertyPrefix();
        this.acceleratorFont = UIManager.getFont("MenuItem.acceleratorFont");
        if (this.acceleratorFont == null) {
            this.acceleratorFont = UIManager.getFont("MenuItem.font");
        }
        if ((object = UIManager.get(this.getPropertyPrefix() + ".opaque")) != null) {
            LookAndFeel.installProperty(this.menuItem, "opaque", object);
        } else {
            LookAndFeel.installProperty(this.menuItem, "opaque", Boolean.TRUE);
        }
        if (this.menuItem.getMargin() == null || this.menuItem.getMargin() instanceof UIResource) {
            this.menuItem.setMargin(UIManager.getInsets(string + ".margin"));
        }
        LookAndFeel.installProperty(this.menuItem, "iconTextGap", 4);
        this.defaultTextIconGap = this.menuItem.getIconTextGap();
        LookAndFeel.installBorder(this.menuItem, string + ".border");
        this.oldBorderPainted = this.menuItem.isBorderPainted();
        LookAndFeel.installProperty(this.menuItem, "borderPainted", UIManager.getBoolean(string + ".borderPainted"));
        LookAndFeel.installColorsAndFont(this.menuItem, string + ".background", string + ".foreground", string + ".font");
        if (this.selectionBackground == null || this.selectionBackground instanceof UIResource) {
            this.selectionBackground = UIManager.getColor(string + ".selectionBackground");
        }
        if (this.selectionForeground == null || this.selectionForeground instanceof UIResource) {
            this.selectionForeground = UIManager.getColor(string + ".selectionForeground");
        }
        if (this.disabledForeground == null || this.disabledForeground instanceof UIResource) {
            this.disabledForeground = UIManager.getColor(string + ".disabledForeground");
        }
        if (this.acceleratorForeground == null || this.acceleratorForeground instanceof UIResource) {
            this.acceleratorForeground = UIManager.getColor(string + ".acceleratorForeground");
        }
        if (this.acceleratorSelectionForeground == null || this.acceleratorSelectionForeground instanceof UIResource) {
            this.acceleratorSelectionForeground = UIManager.getColor(string + ".acceleratorSelectionForeground");
        }
        this.acceleratorDelimiter = UIManager.getString("MenuItem.acceleratorDelimiter");
        if (this.acceleratorDelimiter == null) {
            this.acceleratorDelimiter = "+";
        }
        if (this.arrowIcon == null || this.arrowIcon instanceof UIResource) {
            this.arrowIcon = UIManager.getIcon(string + ".arrowIcon");
        }
        this.updateCheckIcon();
    }

    private void updateCheckIcon() {
        String string = this.getPropertyPrefix();
        if (this.checkIcon == null || this.checkIcon instanceof UIResource) {
            MenuItemCheckIconFactory menuItemCheckIconFactory;
            this.checkIcon = UIManager.getIcon(string + ".checkIcon");
            boolean bl = MenuItemLayoutHelper.isColumnLayout(BasicGraphicsUtils.isLeftToRight(this.menuItem), this.menuItem);
            if (bl && (menuItemCheckIconFactory = (MenuItemCheckIconFactory)UIManager.get(string + ".checkIconFactory")) != null && MenuItemLayoutHelper.useCheckAndArrow(this.menuItem) && menuItemCheckIconFactory.isCompatible(this.checkIcon, string)) {
                this.checkIcon = menuItemCheckIconFactory.getIcon(this.menuItem);
            }
        }
    }

    protected void installComponents(JMenuItem jMenuItem) {
        BasicHTML.updateRenderer(jMenuItem, jMenuItem.getText());
    }

    protected String getPropertyPrefix() {
        return "MenuItem";
    }

    protected void installListeners() {
        this.mouseInputListener = this.createMouseInputListener(this.menuItem);
        if (this.mouseInputListener != null) {
            this.menuItem.addMouseListener(this.mouseInputListener);
            this.menuItem.addMouseMotionListener(this.mouseInputListener);
        }
        if ((this.menuDragMouseListener = this.createMenuDragMouseListener(this.menuItem)) != null) {
            this.menuItem.addMenuDragMouseListener(this.menuDragMouseListener);
        }
        if ((this.menuKeyListener = this.createMenuKeyListener(this.menuItem)) != null) {
            this.menuItem.addMenuKeyListener(this.menuKeyListener);
        }
        if ((this.propertyChangeListener = this.createPropertyChangeListener(this.menuItem)) != null) {
            this.menuItem.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    protected void installKeyboardActions() {
        this.installLazyActionMap();
        this.updateAcceleratorBinding();
    }

    void installLazyActionMap() {
        LazyActionMap.installLazyActionMap(this.menuItem, BasicMenuItemUI.class, this.getPropertyPrefix() + ".actionMap");
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.menuItem = (JMenuItem)jComponent;
        this.uninstallDefaults();
        this.uninstallComponents(this.menuItem);
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        MenuItemLayoutHelper.clearUsedParentClientProperties(this.menuItem);
        this.menuItem = null;
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.menuItem);
        LookAndFeel.installProperty(this.menuItem, "borderPainted", this.oldBorderPainted);
        if (this.menuItem.getMargin() instanceof UIResource) {
            this.menuItem.setMargin(null);
        }
        if (this.arrowIcon instanceof UIResource) {
            this.arrowIcon = null;
        }
        if (this.checkIcon instanceof UIResource) {
            this.checkIcon = null;
        }
    }

    protected void uninstallComponents(JMenuItem jMenuItem) {
        BasicHTML.updateRenderer(jMenuItem, "");
    }

    protected void uninstallListeners() {
        if (this.mouseInputListener != null) {
            this.menuItem.removeMouseListener(this.mouseInputListener);
            this.menuItem.removeMouseMotionListener(this.mouseInputListener);
        }
        if (this.menuDragMouseListener != null) {
            this.menuItem.removeMenuDragMouseListener(this.menuDragMouseListener);
        }
        if (this.menuKeyListener != null) {
            this.menuItem.removeMenuKeyListener(this.menuKeyListener);
        }
        if (this.propertyChangeListener != null) {
            this.menuItem.removePropertyChangeListener(this.propertyChangeListener);
        }
        this.mouseInputListener = null;
        this.menuDragMouseListener = null;
        this.menuKeyListener = null;
        this.propertyChangeListener = null;
        this.handler = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.menuItem, null);
        SwingUtilities.replaceUIInputMap(this.menuItem, 2, null);
    }

    protected MouseInputListener createMouseInputListener(JComponent jComponent) {
        return this.getHandler();
    }

    protected MenuDragMouseListener createMenuDragMouseListener(JComponent jComponent) {
        return this.getHandler();
    }

    protected MenuKeyListener createMenuKeyListener(JComponent jComponent) {
        return null;
    }

    protected PropertyChangeListener createPropertyChangeListener(JComponent jComponent) {
        return this.getHandler();
    }

    Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    InputMap createInputMap(int n) {
        if (n == 2) {
            return new ComponentInputMapUIResource(this.menuItem);
        }
        return null;
    }

    void updateAcceleratorBinding() {
        KeyStroke keyStroke = this.menuItem.getAccelerator();
        InputMap inputMap = SwingUtilities.getUIInputMap(this.menuItem, 2);
        if (inputMap != null) {
            inputMap.clear();
        }
        if (keyStroke != null) {
            if (inputMap == null) {
                inputMap = this.createInputMap(2);
                SwingUtilities.replaceUIInputMap(this.menuItem, 2, inputMap);
            }
            inputMap.put(keyStroke, "doClick");
            int n = keyStroke.getModifiers();
            if ((n & 0x200) != 0 && (n & 0x2000) != 0) {
                n &= 0xFFFFDFFF;
                KeyStroke keyStroke2 = KeyStroke.getKeyStroke(keyStroke.getKeyCode(), n &= 0xFFFFFFDF, keyStroke.isOnKeyRelease());
                inputMap.put(keyStroke2, "doClick");
            } else if ((n & 0x200) != 0 && (n & 0x2000) == 0) {
                KeyStroke keyStroke3 = KeyStroke.getKeyStroke(keyStroke.getKeyCode(), n |= 0x2000, keyStroke.isOnKeyRelease());
                inputMap.put(keyStroke3, "doClick");
            } else if ((n & 0x2000) != 0) {
                n &= 0xFFFFDFFF;
                n &= 0xFFFFFFDF;
                KeyStroke keyStroke4 = KeyStroke.getKeyStroke(keyStroke.getKeyCode(), n |= 0x200, keyStroke.isOnKeyRelease());
                inputMap.put(keyStroke4, "doClick");
                keyStroke4 = KeyStroke.getKeyStroke(keyStroke.getKeyCode(), n |= 0x2000, keyStroke.isOnKeyRelease());
                inputMap.put(keyStroke4, "doClick");
            }
        }
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = null;
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension = this.getPreferredSize(jComponent);
            dimension.width = (int)((float)dimension.width - (view.getPreferredSpan(0) - view.getMinimumSpan(0)));
        }
        return dimension;
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        return this.getPreferredMenuItemSize(jComponent, this.checkIcon, this.arrowIcon, this.defaultTextIconGap);
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = null;
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension = this.getPreferredSize(jComponent);
            dimension.width = (int)((float)dimension.width + (view.getMaximumSpan(0) - view.getPreferredSpan(0)));
        }
        return dimension;
    }

    protected Dimension getPreferredMenuItemSize(JComponent jComponent, Icon icon, Icon icon2, int n) {
        JMenuItem jMenuItem = (JMenuItem)jComponent;
        MenuItemLayoutHelper menuItemLayoutHelper = new MenuItemLayoutHelper(jMenuItem, icon, icon2, MenuItemLayoutHelper.createMaxRect(), n, this.acceleratorDelimiter, BasicGraphicsUtils.isLeftToRight(jMenuItem), jMenuItem.getFont(), this.acceleratorFont, MenuItemLayoutHelper.useCheckAndArrow(this.menuItem), this.getPropertyPrefix());
        Dimension dimension = new Dimension();
        dimension.width = menuItemLayoutHelper.getLeadingGap();
        MenuItemLayoutHelper.addMaxWidth(menuItemLayoutHelper.getCheckSize(), menuItemLayoutHelper.getAfterCheckIconGap(), dimension);
        if (!menuItemLayoutHelper.isTopLevelMenu() && menuItemLayoutHelper.getMinTextOffset() > 0 && dimension.width < menuItemLayoutHelper.getMinTextOffset()) {
            dimension.width = menuItemLayoutHelper.getMinTextOffset();
        }
        MenuItemLayoutHelper.addMaxWidth(menuItemLayoutHelper.getLabelSize(), menuItemLayoutHelper.getGap(), dimension);
        MenuItemLayoutHelper.addMaxWidth(menuItemLayoutHelper.getAccSize(), menuItemLayoutHelper.getGap(), dimension);
        MenuItemLayoutHelper.addMaxWidth(menuItemLayoutHelper.getArrowSize(), menuItemLayoutHelper.getGap(), dimension);
        dimension.height = MenuItemLayoutHelper.max(menuItemLayoutHelper.getCheckSize().getHeight(), menuItemLayoutHelper.getLabelSize().getHeight(), menuItemLayoutHelper.getAccSize().getHeight(), menuItemLayoutHelper.getArrowSize().getHeight());
        Insets insets = menuItemLayoutHelper.getMenuItem().getInsets();
        if (insets != null) {
            dimension.width += insets.left + insets.right;
            dimension.height += insets.top + insets.bottom;
        }
        if (dimension.width % 2 == 0) {
            ++dimension.width;
        }
        if (dimension.height % 2 == 0 && Boolean.TRUE != UIManager.get(this.getPropertyPrefix() + ".evenHeight")) {
            ++dimension.height;
        }
        return dimension;
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        this.paint(graphics, jComponent);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        this.paintMenuItem(graphics, jComponent, this.checkIcon, this.arrowIcon, this.selectionBackground, this.selectionForeground, this.defaultTextIconGap);
    }

    protected void paintMenuItem(Graphics graphics, JComponent jComponent, Icon icon, Icon icon2, Color color, Color color2, int n) {
        Font font = graphics.getFont();
        Color color3 = graphics.getColor();
        JMenuItem jMenuItem = (JMenuItem)jComponent;
        graphics.setFont(jMenuItem.getFont());
        Rectangle rectangle = new Rectangle(0, 0, jMenuItem.getWidth(), jMenuItem.getHeight());
        this.applyInsets(rectangle, jMenuItem.getInsets());
        MenuItemLayoutHelper menuItemLayoutHelper = new MenuItemLayoutHelper(jMenuItem, icon, icon2, rectangle, n, this.acceleratorDelimiter, BasicGraphicsUtils.isLeftToRight(jMenuItem), jMenuItem.getFont(), this.acceleratorFont, MenuItemLayoutHelper.useCheckAndArrow(this.menuItem), this.getPropertyPrefix());
        MenuItemLayoutHelper.LayoutResult layoutResult = menuItemLayoutHelper.layoutMenuItem();
        this.paintBackground(graphics, jMenuItem, color);
        this.paintCheckIcon(graphics, menuItemLayoutHelper, layoutResult, color3, color2);
        this.paintIcon(graphics, menuItemLayoutHelper, layoutResult, color3);
        this.paintText(graphics, menuItemLayoutHelper, layoutResult);
        this.paintAccText(graphics, menuItemLayoutHelper, layoutResult);
        this.paintArrowIcon(graphics, menuItemLayoutHelper, layoutResult, color2);
        graphics.setColor(color3);
        graphics.setFont(font);
    }

    private void paintIcon(Graphics graphics, MenuItemLayoutHelper menuItemLayoutHelper, MenuItemLayoutHelper.LayoutResult layoutResult, Color color) {
        SwingUtilities3.paintIcon(graphics, menuItemLayoutHelper, layoutResult, color);
    }

    private void paintCheckIcon(Graphics graphics, MenuItemLayoutHelper menuItemLayoutHelper, MenuItemLayoutHelper.LayoutResult layoutResult, Color color, Color color2) {
        SwingUtilities3.paintCheckIcon(graphics, menuItemLayoutHelper, layoutResult, color, color2);
    }

    private void paintAccText(Graphics graphics, MenuItemLayoutHelper menuItemLayoutHelper, MenuItemLayoutHelper.LayoutResult layoutResult) {
        SwingUtilities3.setDisabledForeground(this.disabledForeground);
        SwingUtilities3.setAcceleratorSelectionForeground(this.acceleratorSelectionForeground);
        SwingUtilities3.setAcceleratorForeground(this.acceleratorForeground);
        SwingUtilities3.paintAccText(graphics, menuItemLayoutHelper, layoutResult);
    }

    private void paintText(Graphics graphics, MenuItemLayoutHelper menuItemLayoutHelper, MenuItemLayoutHelper.LayoutResult layoutResult) {
        if (!menuItemLayoutHelper.getText().equals("")) {
            if (menuItemLayoutHelper.getHtmlView() != null) {
                menuItemLayoutHelper.getHtmlView().paint(graphics, layoutResult.getTextRect());
            } else {
                this.paintText(graphics, menuItemLayoutHelper.getMenuItem(), layoutResult.getTextRect(), menuItemLayoutHelper.getText());
            }
        }
    }

    private void paintArrowIcon(Graphics graphics, MenuItemLayoutHelper menuItemLayoutHelper, MenuItemLayoutHelper.LayoutResult layoutResult, Color color) {
        SwingUtilities3.paintArrowIcon(graphics, menuItemLayoutHelper, layoutResult, color);
    }

    private void applyInsets(Rectangle rectangle, Insets insets) {
        SwingUtilities3.applyInsets(rectangle, insets);
    }

    protected void paintBackground(Graphics graphics, JMenuItem jMenuItem, Color color) {
        ButtonModel buttonModel = jMenuItem.getModel();
        Color color2 = graphics.getColor();
        int n = jMenuItem.getWidth();
        int n2 = jMenuItem.getHeight();
        if (jMenuItem.isOpaque()) {
            if (buttonModel.isArmed() || jMenuItem instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(color);
                graphics.fillRect(0, 0, n, n2);
            } else {
                graphics.setColor(jMenuItem.getBackground());
                graphics.fillRect(0, 0, n, n2);
            }
            graphics.setColor(color2);
        } else if (buttonModel.isArmed() || jMenuItem instanceof JMenu && buttonModel.isSelected()) {
            graphics.setColor(color);
            graphics.fillRect(0, 0, n, n2);
            graphics.setColor(color2);
        }
    }

    protected void paintText(Graphics graphics, JMenuItem jMenuItem, Rectangle rectangle, String string) {
        ButtonModel buttonModel = jMenuItem.getModel();
        FontMetrics fontMetrics = SwingUtilities2.getFontMetrics((JComponent)jMenuItem, graphics);
        int n = jMenuItem.getDisplayedMnemonicIndex();
        if (!buttonModel.isEnabled()) {
            if (UIManager.get("MenuItem.disabledForeground") instanceof Color) {
                graphics.setColor(UIManager.getColor("MenuItem.disabledForeground"));
                SwingUtilities2.drawStringUnderlineCharAt(jMenuItem, graphics, string, n, rectangle.x, rectangle.y + fontMetrics.getAscent());
            } else {
                graphics.setColor(jMenuItem.getBackground().brighter());
                SwingUtilities2.drawStringUnderlineCharAt(jMenuItem, graphics, string, n, rectangle.x, rectangle.y + fontMetrics.getAscent());
                graphics.setColor(jMenuItem.getBackground().darker());
                SwingUtilities2.drawStringUnderlineCharAt(jMenuItem, graphics, string, n, rectangle.x - 1, rectangle.y + fontMetrics.getAscent() - 1);
            }
        } else {
            if (buttonModel.isArmed() || jMenuItem instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(this.selectionForeground);
            }
            SwingUtilities2.drawStringUnderlineCharAt(jMenuItem, graphics, string, n, rectangle.x, rectangle.y + fontMetrics.getAscent());
        }
    }

    public MenuElement[] getPath() {
        MenuElement[] menuElementArray;
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        MenuElement[] menuElementArray2 = menuSelectionManager.getSelectedPath();
        int n = menuElementArray2.length;
        if (n == 0) {
            return new MenuElement[0];
        }
        Container container = this.menuItem.getParent();
        if (menuElementArray2[n - 1].getComponent() == container) {
            menuElementArray = new MenuElement[n + 1];
            System.arraycopy(menuElementArray2, 0, menuElementArray, 0, n);
            menuElementArray[n] = this.menuItem;
        } else {
            int n2;
            for (n2 = menuElementArray2.length - 1; n2 >= 0 && menuElementArray2[n2].getComponent() != container; --n2) {
            }
            menuElementArray = new MenuElement[n2 + 2];
            System.arraycopy(menuElementArray2, 0, menuElementArray, 0, n2 + 1);
            menuElementArray[n2 + 1] = this.menuItem;
        }
        return menuElementArray;
    }

    void printMenuElementArray(MenuElement[] menuElementArray, boolean bl) {
        System.out.println("Path is(");
        int n = menuElementArray.length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j <= i; ++j) {
                System.out.print("  ");
            }
            MenuElement menuElement = menuElementArray[i];
            if (menuElement instanceof JMenuItem) {
                System.out.println(((JMenuItem)menuElement).getText() + ", ");
                continue;
            }
            if (menuElement == null) {
                System.out.println("NULL , ");
                continue;
            }
            System.out.println("" + menuElement + ", ");
        }
        System.out.println(")");
        if (bl) {
            Thread.dumpStack();
        }
    }

    protected void doClick(MenuSelectionManager menuSelectionManager) {
        if (!this.isInternalFrameSystemMenu()) {
            BasicLookAndFeel.playSound(this.menuItem, this.getPropertyPrefix() + ".commandSound");
        }
        if (menuSelectionManager == null) {
            menuSelectionManager = MenuSelectionManager.defaultManager();
        }
        menuSelectionManager.clearSelectedPath();
        this.menuItem.doClick(0);
    }

    private boolean isInternalFrameSystemMenu() {
        String string = this.menuItem.getActionCommand();
        return string == "Close" || string == "Minimize" || string == "Restore" || string == "Maximize";
    }

    class Handler
    implements MenuDragMouseListener,
    MouseInputListener,
    PropertyChangeListener {
        Handler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (!BasicMenuItemUI.this.menuItem.isEnabled()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            Point point = mouseEvent.getPoint();
            if (point.x >= 0 && point.x < BasicMenuItemUI.this.menuItem.getWidth() && point.y >= 0 && point.y < BasicMenuItemUI.this.menuItem.getHeight()) {
                BasicMenuItemUI.this.doClick(menuSelectionManager);
            } else {
                menuSelectionManager.processMouseEvent(mouseEvent);
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            int n = mouseEvent.getModifiers();
            if ((n & 0x1C) != 0) {
                MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
            } else {
                menuSelectionManager.setSelectedPath(BasicMenuItemUI.this.getPath());
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            int n = mouseEvent.getModifiers();
            if ((n & 0x1C) != 0) {
                MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
            } else {
                MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
                if (menuElementArray.length > 1 && menuElementArray[menuElementArray.length - 1] == BasicMenuItemUI.this.menuItem) {
                    MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length - 1];
                    int n2 = menuElementArray.length - 1;
                    for (int i = 0; i < n2; ++i) {
                        menuElementArray2[i] = menuElementArray[i];
                    }
                    menuSelectionManager.setSelectedPath(menuElementArray2);
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void menuDragMouseEntered(MenuDragMouseEvent menuDragMouseEvent) {
            MenuSelectionManager menuSelectionManager = menuDragMouseEvent.getMenuSelectionManager();
            MenuElement[] menuElementArray = menuDragMouseEvent.getPath();
            menuSelectionManager.setSelectedPath(menuElementArray);
        }

        @Override
        public void menuDragMouseDragged(MenuDragMouseEvent menuDragMouseEvent) {
            MenuSelectionManager menuSelectionManager = menuDragMouseEvent.getMenuSelectionManager();
            MenuElement[] menuElementArray = menuDragMouseEvent.getPath();
            menuSelectionManager.setSelectedPath(menuElementArray);
        }

        @Override
        public void menuDragMouseExited(MenuDragMouseEvent menuDragMouseEvent) {
        }

        @Override
        public void menuDragMouseReleased(MenuDragMouseEvent menuDragMouseEvent) {
            if (!BasicMenuItemUI.this.menuItem.isEnabled()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = menuDragMouseEvent.getMenuSelectionManager();
            MenuElement[] menuElementArray = menuDragMouseEvent.getPath();
            Point point = menuDragMouseEvent.getPoint();
            if (point.x >= 0 && point.x < BasicMenuItemUI.this.menuItem.getWidth() && point.y >= 0 && point.y < BasicMenuItemUI.this.menuItem.getHeight()) {
                BasicMenuItemUI.this.doClick(menuSelectionManager);
            } else {
                menuSelectionManager.clearSelectedPath();
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == "labelFor" || string == "displayedMnemonic" || string == "accelerator") {
                BasicMenuItemUI.this.updateAcceleratorBinding();
            } else if (string == "text" || "font" == string || "foreground" == string) {
                JMenuItem jMenuItem = (JMenuItem)propertyChangeEvent.getSource();
                String string2 = jMenuItem.getText();
                BasicHTML.updateRenderer(jMenuItem, string2);
            } else if (string == "iconTextGap") {
                BasicMenuItemUI.this.defaultTextIconGap = ((Number)propertyChangeEvent.getNewValue()).intValue();
            } else if (string == "horizontalTextPosition") {
                BasicMenuItemUI.this.updateCheckIcon();
            }
        }
    }

    private static class Actions
    extends UIAction {
        private static final String CLICK = "doClick";

        Actions(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            MenuSelectionManager.defaultManager().clearSelectedPath();
            jMenuItem.doClick();
        }
    }

    protected class MouseInputHandler
    implements MouseInputListener {
        protected MouseInputHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            BasicMenuItemUI.this.getHandler().mouseClicked(mouseEvent);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            BasicMenuItemUI.this.getHandler().mousePressed(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            BasicMenuItemUI.this.getHandler().mouseReleased(mouseEvent);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            BasicMenuItemUI.this.getHandler().mouseEntered(mouseEvent);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            BasicMenuItemUI.this.getHandler().mouseExited(mouseEvent);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            BasicMenuItemUI.this.getHandler().mouseDragged(mouseEvent);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            BasicMenuItemUI.this.getHandler().mouseMoved(mouseEvent);
        }
    }
}

