/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.krb5;

import java.io.IOException;
import sun.security.jgss.GSSToken;
import sun.security.jgss.krb5.Krb5MechFactory;
import sun.security.util.ObjectIdentifier;

abstract class Krb5Token
extends GSSToken {
    public static final int AP_REQ_ID = 256;
    public static final int AP_REP_ID = 512;
    public static final int ERR_ID = 768;
    public static final int MIC_ID = 257;
    public static final int WRAP_ID = 513;
    public static final int MIC_ID_v2 = 1028;
    public static final int WRAP_ID_v2 = 1284;
    public static ObjectIdentifier OID;

    Krb5Token() {
    }

    public static String getTokenName(int n) {
        String string = null;
        switch (n) {
            case 256: 
            case 512: {
                string = "Context Establishment Token";
                break;
            }
            case 257: {
                string = "MIC Token";
                break;
            }
            case 1028: {
                string = "MIC Token (new format)";
                break;
            }
            case 513: {
                string = "Wrap Token";
                break;
            }
            case 1284: {
                string = "Wrap Token (new format)";
                break;
            }
            default: {
                string = "Kerberos GSS-API Mechanism Token";
            }
        }
        return string;
    }

    static {
        try {
            OID = ObjectIdentifier.of(Krb5MechFactory.GSS_KRB5_MECH_OID.toString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

