/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.VersionHelper;
import java.net.MalformedURLException;
import java.net.URLClassLoader;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.misc.SharedSecrets;

final class VersionHelper12
extends VersionHelper {
    private static final String trustURLCodebase = VersionHelper12.getPrivilegedProperty("com.sun.jndi.ldap.object.trustURLCodebase", "false");
    private static final boolean trustSerialData;

    VersionHelper12() {
    }

    private static String getPrivilegedProperty(String string, String string2) {
        PrivilegedAction<String> privilegedAction = () -> System.getProperty(string, string2);
        if (System.getSecurityManager() == null) {
            return privilegedAction.run();
        }
        return AccessController.doPrivileged(privilegedAction);
    }

    @Override
    ClassLoader getURLClassLoader(String[] stringArray) throws MalformedURLException {
        ClassLoader classLoader = this.getContextClassLoader();
        if (stringArray != null && "true".equalsIgnoreCase(trustURLCodebase)) {
            return URLClassLoader.newInstance(VersionHelper12.getUrlArray(stringArray), classLoader);
        }
        return classLoader;
    }

    @Override
    Class<?> loadClass(String string) throws ClassNotFoundException {
        ClassLoader classLoader = this.getContextClassLoader();
        return Class.forName(string, true, classLoader);
    }

    @Override
    boolean isSerialDataAllowed() {
        return trustSerialData;
    }

    private ClassLoader getContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    @Override
    Thread createThread(final Runnable runnable) {
        final AccessControlContext accessControlContext = AccessController.getContext();
        return AccessController.doPrivileged(new PrivilegedAction<Thread>(){

            @Override
            public Thread run() {
                return SharedSecrets.getJavaLangAccess().newThreadWithAcc(runnable, accessControlContext);
            }
        });
    }

    static {
        String string = VersionHelper12.getPrivilegedProperty("com.sun.jndi.ldap.object.trustSerialData", "false");
        trustSerialData = "true".equalsIgnoreCase(string);
    }
}

