/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_tr extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_zbl = "Blis Sembolleri";
        final String metaValue_bug = "Bugis";
        final String metaValue_ccp = "Chakma";
        final String metaValue_CY = "K\u0131br\u0131s";
        final String metaValue_ET = "Etiyopya";
        final String metaValue_ko = "Korece";
        final String metaValue_nqo = "N\u2019Ko";
        final String metaValue_saz = "Saurashtra";
        final String metaValue_vai = "Vai";
        final String metaValue_ssy = "Saho";
        final Object[][] data = new Object[][] {
            { "001", "D\u00fcnya" },
            { "002", "Afrika" },
            { "003", "Kuzey Amerika" },
            { "005", "G\u00fcney Amerika" },
            { "009", "Okyanusya" },
            { "011", "Bat\u0131 Afrika" },
            { "013", "Orta Amerika" },
            { "014", "Do\u011fu Afrika" },
            { "015", "Kuzey Afrika" },
            { "017", "Orta Afrika" },
            { "018", "Afrika\u2019n\u0131n G\u00fcneyi" },
            { "019", "Amerika" },
            { "021", "Amerika\u2019n\u0131n Kuzeyi" },
            { "029", "Karayipler" },
            { "030", "Do\u011fu Asya" },
            { "034", "G\u00fcney Asya" },
            { "035", "G\u00fcneydo\u011fu Asya" },
            { "039", "G\u00fcney Avrupa" },
            { "053", "Avustralasya" },
            { "054", "Melanezya" },
            { "057", "Mikronezya B\u00f6lgesi" },
            { "061", "Polinezya" },
            { "142", "Asya" },
            { "143", "Orta Asya" },
            { "145", "Bat\u0131 Asya" },
            { "150", "Avrupa" },
            { "151", "Do\u011fu Avrupa" },
            { "154", "Kuzey Avrupa" },
            { "155", "Bat\u0131 Avrupa" },
            { "202", "Sahra Alt\u0131 Afrika" },
            { "419", "Latin Amerika" },
            { "AC", "Ascension Adas\u0131" },
            { "AD", "Andorra" },
            { "AE", "Birle\u015fik Arap Emirlikleri" },
            { "AF", "Afganistan" },
            { "AG", "Antigua ve Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Arnavutluk" },
            { "AM", "Ermenistan" },
            { "AO", "Angola" },
            { "AQ", "Antarktika" },
            { "AR", "Arjantin" },
            { "AS", "Amerikan Samoas\u0131" },
            { "AT", "Avusturya" },
            { "AU", "Avustralya" },
            { "AW", "Aruba" },
            { "AX", "\u00c5land Adalar\u0131" },
            { "AZ", "Azerbaycan" },
            { "BA", "Bosna-Hersek" },
            { "BB", "Barbados" },
            { "BD", "Banglade\u015f" },
            { "BE", "Bel\u00e7ika" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaristan" },
            { "BH", "Bahreyn" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint Barthelemy" },
            { "BM", "Bermuda" },
            { "BN", "Brunei" },
            { "BO", "Bolivya" },
            { "BQ", "Karayip Hollandas\u0131" },
            { "BR", "Brezilya" },
            { "BS", "Bahamalar" },
            { "BT", "Butan" },
            { "BV", "Bouvet Adas\u0131" },
            { "BW", "Botsvana" },
            { "BY", "Belarus" },
            { "BZ", "Belize" },
            { "CA", "Kanada" },
            { "CC", "Cocos (Keeling) Adalar\u0131" },
            { "CD", "Kongo - Kin\u015fasa" },
            { "CF", "Orta Afrika Cumhuriyeti" },
            { "CG", "Kongo - Brazavil" },
            { "CH", "\u0130svi\u00e7re" },
            { "CI", "C\u00f4te d\u2019Ivoire" },
            { "CK", "Cook Adalar\u0131" },
            { "CL", "\u015eili" },
            { "CM", "Kamerun" },
            { "CN", "\u00c7in" },
            { "CO", "Kolombiya" },
            { "CP", "Clipperton Adas\u0131" },
            { "CR", "Kosta Rika" },
            { "CU", "K\u00fcba" },
            { "CV", "Cabo Verde" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Christmas Adas\u0131" },
            { "CY", metaValue_CY },
            { "CZ", "\u00c7ekya" },
            { "DE", "Almanya" },
            { "DG", "Diego Garcia" },
            { "DJ", "Cibuti" },
            { "DK", "Danimarka" },
            { "DM", "Dominika" },
            { "DO", "Dominik Cumhuriyeti" },
            { "DZ", "Cezayir" },
            { "EA", "Ceuta ve Melilla" },
            { "EC", "Ekvador" },
            { "EE", "Estonya" },
            { "EG", "M\u0131s\u0131r" },
            { "EH", "Bat\u0131 Sahra" },
            { "ER", "Eritre" },
            { "ES", "\u0130spanya" },
            { "ET", metaValue_ET },
            { "EU", "Avrupa Birli\u011fi" },
            { "EZ", "Euro B\u00f6lgesi" },
            { "FI", "Finlandiya" },
            { "FJ", "Fiji" },
            { "FK", "Falkland Adalar\u0131" },
            { "FM", "Mikronezya" },
            { "FO", "Faroe Adalar\u0131" },
            { "FR", "Fransa" },
            { "GA", "Gabon" },
            { "GB", "Birle\u015fik Krall\u0131k" },
            { "GD", "Grenada" },
            { "GE", "G\u00fcrcistan" },
            { "GF", "Frans\u0131z Guyanas\u0131" },
            { "GG", "Guernsey" },
            { "GH", "Gana" },
            { "GI", "Cebelitar\u0131k" },
            { "GL", "Gr\u00f6nland" },
            { "GM", "Gambiya" },
            { "GN", "Gine" },
            { "GP", "Guadeloupe" },
            { "GQ", "Ekvator Ginesi" },
            { "GR", "Yunanistan" },
            { "GS", "G\u00fcney Georgia ve G\u00fcney Sandwich Adalar\u0131" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Gine-Bissau" },
            { "GY", "Guyana" },
            { "HK", "\u00c7in Hong Kong \u00d6\u0130B" },
            { "HM", "Heard Adas\u0131 ve McDonald Adalar\u0131" },
            { "HN", "Honduras" },
            { "HR", "H\u0131rvatistan" },
            { "HT", "Haiti" },
            { "HU", "Macaristan" },
            { "IC", "Kanarya Adalar\u0131" },
            { "ID", "Endonezya" },
            { "IE", "\u0130rlanda" },
            { "IL", "\u0130srail" },
            { "IM", "Man Adas\u0131" },
            { "IN", "Hindistan" },
            { "IO", "Britanya Hint Okyanusu Topraklar\u0131" },
            { "IQ", "Irak" },
            { "IR", "\u0130ran" },
            { "IS", "\u0130zlanda" },
            { "IT", "\u0130talya" },
            { "JE", "Jersey" },
            { "JM", "Jamaika" },
            { "JO", "\u00dcrd\u00fcn" },
            { "JP", "Japonya" },
            { "KE", "Kenya" },
            { "KG", "K\u0131rg\u0131zistan" },
            { "KH", "Kambo\u00e7ya" },
            { "KI", "Kiribati" },
            { "KM", "Komorlar" },
            { "KN", "Saint Kitts ve Nevis" },
            { "KP", "Kuzey Kore" },
            { "KR", "G\u00fcney Kore" },
            { "KW", "Kuveyt" },
            { "KY", "Cayman Adalar\u0131" },
            { "KZ", "Kazakistan" },
            { "LA", "Laos" },
            { "LB", "L\u00fcbnan" },
            { "LC", "Saint Lucia" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberya" },
            { "LS", "Lesotho" },
            { "LT", "Litvanya" },
            { "LU", "L\u00fcksemburg" },
            { "LV", "Letonya" },
            { "LY", "Libya" },
            { "MA", "Fas" },
            { "MC", "Monako" },
            { "MD", "Moldova" },
            { "ME", "Karada\u011f" },
            { "MF", "Saint Martin" },
            { "MG", "Madagaskar" },
            { "MH", "Marshall Adalar\u0131" },
            { "MK", "Kuzey Makedonya" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Burma)" },
            { "MN", "Mo\u011folistan" },
            { "MO", "\u00c7in Makao \u00d6\u0130B" },
            { "MP", "Kuzey Mariana Adalar\u0131" },
            { "MQ", "Martinik" },
            { "MR", "Moritanya" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauritius" },
            { "MV", "Maldivler" },
            { "MW", "Malavi" },
            { "MX", "Meksika" },
            { "MY", "Malezya" },
            { "MZ", "Mozambik" },
            { "NA", "Namibya" },
            { "NC", "Yeni Kaledonya" },
            { "NE", "Nijer" },
            { "NF", "Norfolk Adas\u0131" },
            { "NG", "Nijerya" },
            { "NI", "Nikaragua" },
            { "NL", "Hollanda" },
            { "NO", "Norve\u00e7" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Yeni Zelanda" },
            { "OM", "Umman" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Frans\u0131z Polinezyas\u0131" },
            { "PG", "Papua Yeni Gine" },
            { "PH", "Filipinler" },
            { "PK", "Pakistan" },
            { "PL", "Polonya" },
            { "PM", "Saint Pierre ve Miquelon" },
            { "PN", "Pitcairn Adalar\u0131" },
            { "PR", "Porto Riko" },
            { "PS", "Filistin B\u00f6lgeleri" },
            { "PT", "Portekiz" },
            { "PW", "Palau" },
            { "PY", "Paraguay" },
            { "QA", "Katar" },
            { "QO", "Uzak Okyanusya" },
            { "RE", "Reunion" },
            { "RO", "Romanya" },
            { "RS", "S\u0131rbistan" },
            { "RU", "Rusya" },
            { "RW", "Ruanda" },
            { "SA", "Suudi Arabistan" },
            { "SB", "Solomon Adalar\u0131" },
            { "SC", "Sey\u015feller" },
            { "SD", "Sudan" },
            { "SE", "\u0130sve\u00e7" },
            { "SG", "Singapur" },
            { "SH", "Saint Helena" },
            { "SI", "Slovenya" },
            { "SJ", "Svalbard ve Jan Mayen" },
            { "SK", "Slovakya" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somali" },
            { "SR", "Surinam" },
            { "SS", "G\u00fcney Sudan" },
            { "ST", "Sao Tome ve Principe" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Suriye" },
            { "SZ", "Esvatini" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Turks ve Caicos Adalar\u0131" },
            { "TD", "\u00c7ad" },
            { "TF", "Frans\u0131z G\u00fcney Topraklar\u0131" },
            { "TG", "Togo" },
            { "TH", "Tayland" },
            { "TJ", "Tacikistan" },
            { "TK", "Tokelau" },
            { "TL", "Timor-Leste" },
            { "TM", "T\u00fcrkmenistan" },
            { "TN", "Tunus" },
            { "TO", "Tonga" },
            { "TR", "T\u00fcrkiye" },
            { "TT", "Trinidad ve Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Tayvan" },
            { "TZ", "Tanzanya" },
            { "UA", "Ukrayna" },
            { "UG", "Uganda" },
            { "UM", "ABD K\u00fc\u00e7\u00fck Harici Adalar\u0131" },
            { "UN", "Birle\u015fmi\u015f Milletler" },
            { "US", "Amerika Birle\u015fik Devletleri" },
            { "UY", "Uruguay" },
            { "UZ", "\u00d6zbekistan" },
            { "VA", "Vatikan" },
            { "VC", "Saint Vincent ve Grenadinler" },
            { "VE", "Venezuela" },
            { "VG", "Britanya Virjin Adalar\u0131" },
            { "VI", "ABD Virjin Adalar\u0131" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis ve Futuna" },
            { "WS", "Samoa" },
            { "XA", "Ps\u00f6do Aksanlar" },
            { "XB", "Ps\u00f6do Bidi" },
            { "XK", "Kosova" },
            { "YE", "Yemen" },
            { "YT", "Mayotte" },
            { "ZA", "G\u00fcney Afrika" },
            { "ZM", "Zambiya" },
            { "ZW", "Zimbabve" },
            { "ZZ", "Bilinmeyen B\u00f6lge" },
            { "aa", "Afar" },
            { "ab", "Abhazca" },
            { "ae", "Avest\u00e7e" },
            { "af", "Afrikaanca" },
            { "ak", "Akan" },
            { "am", "Amharca" },
            { "an", "Aragonca" },
            { "ar", "Arap\u00e7a" },
            { "as", "Assamca" },
            { "av", "Avar dili" },
            { "ay", "Aymara" },
            { "az", "Azerbaycan dili" },
            { "ba", "Ba\u015fk\u0131rt\u00e7a" },
            { "be", "Belarus\u00e7a" },
            { "bg", "Bulgarca" },
            { "bi", "Bislama" },
            { "bm", "Bambara" },
            { "bn", "Bengalce" },
            { "bo", "Tibet\u00e7e" },
            { "br", "Bretonca" },
            { "bs", "Bo\u015fnak\u00e7a" },
            { "ca", "Katalanca" },
            { "ce", "\u00c7e\u00e7ence" },
            { "ch", "\u00c7amorro dili" },
            { "co", "Korsikaca" },
            { "cr", "Krice" },
            { "cs", "\u00c7ek\u00e7e" },
            { "cu", "Kilise Slavcas\u0131" },
            { "cv", "\u00c7uva\u015f\u00e7a" },
            { "cy", "Galce" },
            { "da", "Danca" },
            { "de", "Almanca" },
            { "dv", "Divehi dili" },
            { "dz", "Dzongkha" },
            { "ee", "Ewe" },
            { "el", "Yunanca" },
            { "en", "\u0130ngilizce" },
            { "eo", "Esperanto" },
            { "es", "\u0130spanyolca" },
            { "et", "Estonca" },
            { "eu", "Bask\u00e7a" },
            { "fa", "Fars\u00e7a" },
            { "ff", "Fula dili" },
            { "fi", "Fince" },
            { "fj", "Fiji dili" },
            { "fo", "Faroe dili" },
            { "fr", "Frans\u0131zca" },
            { "fy", "Bat\u0131 Frizcesi" },
            { "ga", "\u0130rlandaca" },
            { "gd", "\u0130sko\u00e7 Gaelcesi" },
            { "gl", "Gali\u00e7yaca" },
            { "gn", "Guarani dili" },
            { "gu", "G\u00fccerat\u00e7a" },
            { "gv", "Man dili" },
            { "ha", "Hausa dili" },
            { "he", "\u0130branice" },
            { "hi", "Hint\u00e7e" },
            { "ho", "Hiri Motu" },
            { "hr", "H\u0131rvat\u00e7a" },
            { "ht", "Haiti Kreyolu" },
            { "hu", "Macarca" },
            { "hy", "Ermenice" },
            { "hz", "Herero dili" },
            { "ia", "\u0130nterlingua" },
            { "id", "Endonezce" },
            { "ie", "Interlingue" },
            { "ig", "\u0130bo dili" },
            { "ii", "Sichuan Yi" },
            { "ik", "\u0130nyupik\u00e7e" },
            { "io", "Ido" },
            { "is", "\u0130zlandaca" },
            { "it", "\u0130talyanca" },
            { "iu", "\u0130nuktitut dili" },
            { "ja", "Japonca" },
            { "jv", "Cava dili" },
            { "ka", "G\u00fcrc\u00fcce" },
            { "kg", "Kongo dili" },
            { "ki", "Kikuyu" },
            { "kj", "Kuanyama" },
            { "kk", "Kazak\u00e7a" },
            { "kl", "Gr\u00f6nland dili" },
            { "km", "Khmer dili" },
            { "kn", "Kannada dili" },
            { "ko", metaValue_ko },
            { "kr", "Kanuri dili" },
            { "ks", "Ke\u015fmir dili" },
            { "ku", "K\u00fcrt\u00e7e" },
            { "kv", "Komi" },
            { "kw", "Kernevek\u00e7e" },
            { "ky", "K\u0131rg\u0131zca" },
            { "la", "Latince" },
            { "lb", "L\u00fcksemburgca" },
            { "lg", "Ganda" },
            { "li", "Limburgca" },
            { "ln", "Lingala" },
            { "lo", "Lao dili" },
            { "lt", "Litvanca" },
            { "lu", "Luba-Katanga" },
            { "lv", "Letonca" },
            { "mg", "Malga\u015f\u00e7a" },
            { "mh", "Marshall Adalar\u0131 dili" },
            { "mi", "Maori dili" },
            { "mk", "Makedonca" },
            { "ml", "Malayalam dili" },
            { "mn", "Mo\u011folca" },
            { "mr", "Marathi dili" },
            { "ms", "Malayca" },
            { "mt", "Maltaca" },
            { "my", "Birman dili" },
            { "na", "Nauru dili" },
            { "nb", "Norve\u00e7\u00e7e Bokm\u00e5l" },
            { "nd", "Kuzey Ndebele" },
            { "ne", "Nepalce" },
            { "ng", "Ndonga" },
            { "nl", "Felemenk\u00e7e" },
            { "nn", "Norve\u00e7\u00e7e Nynorsk" },
            { "no", "Norve\u00e7\u00e7e" },
            { "nr", "G\u00fcney Ndebele" },
            { "nv", "Navaho dili" },
            { "ny", "Nyanja" },
            { "oc", "Oksitan dili" },
            { "oj", "Ojibva dili" },
            { "om", "Oromo dili" },
            { "or", "Oriya dili" },
            { "os", "Oset\u00e7e" },
            { "pa", "Pencap\u00e7a" },
            { "pi", "Pali" },
            { "pl", "Leh\u00e7e" },
            { "ps", "Pe\u015ftuca" },
            { "pt", "Portekizce" },
            { "qu", "Ke\u00e7uva dili" },
            { "rm", "Roman\u015f\u00e7a" },
            { "rn", "Kirundi" },
            { "ro", "Rumence" },
            { "ru", "Rus\u00e7a" },
            { "rw", "Kinyarwanda" },
            { "sa", "Sanskrit" },
            { "sc", "Sardunya dili" },
            { "sd", "Sindhi dili" },
            { "se", "Kuzey Laponcas\u0131" },
            { "sg", "Sango" },
            { "sh", "S\u0131rp-H\u0131rvat Dili" },
            { "si", "Sinhali dili" },
            { "sk", "Slovak\u00e7a" },
            { "sl", "Slovence" },
            { "sm", "Samoa dili" },
            { "sn", "\u015eona dili" },
            { "so", "Somalice" },
            { "sq", "Arnavut\u00e7a" },
            { "sr", "S\u0131rp\u00e7a" },
            { "ss", "Sisvati" },
            { "st", "G\u00fcney Sotho dili" },
            { "su", "Sunda dili" },
            { "sv", "\u0130sve\u00e7\u00e7e" },
            { "sw", "Svahili dili" },
            { "ta", "Tamilce" },
            { "te", "Telugu dili" },
            { "tg", "Tacik\u00e7e" },
            { "th", "Tayca" },
            { "ti", "Tigrinya dili" },
            { "tk", "T\u00fcrkmence" },
            { "tl", "Tagalogca" },
            { "tn", "Setsvana" },
            { "to", "Tonga dili" },
            { "tr", "T\u00fcrk\u00e7e" },
            { "ts", "Tsonga" },
            { "tt", "Tatarca" },
            { "tw", "Tvi" },
            { "ty", "Tahiti dili" },
            { "ug", "Uygurca" },
            { "uk", "Ukraynaca" },
            { "ur", "Urduca" },
            { "uz", "\u00d6zbek\u00e7e" },
            { "ve", "Venda dili" },
            { "vi", "Vietnamca" },
            { "vo", "Volap\u00fck" },
            { "wa", "Valonca" },
            { "wo", "Volof\u00e7a" },
            { "xh", "Zosa dili" },
            { "yi", "Yidi\u015f" },
            { "yo", "Yorubaca" },
            { "za", "Zhuangca" },
            { "zh", "\u00c7ince" },
            { "zu", "Zuluca" },
            { "ace", "A\u00e7ece" },
            { "ach", "Acoli" },
            { "ada", "Adangme" },
            { "ady", "Adigece" },
            { "aeb", "Tunus Arap\u00e7as\u0131" },
            { "afh", "Afrihili" },
            { "agq", "Aghem" },
            { "ain", "Aynuca" },
            { "akk", "Akad Dili" },
            { "akz", "Alabamaca" },
            { "ale", "Aleut dili" },
            { "aln", "Gheg Arnavut\u00e7as\u0131" },
            { "alt", "G\u00fcney Altayca" },
            { "ang", "Eski \u0130ngilizce" },
            { "ann", "Obolo dili" },
            { "anp", "Angika" },
            { "arc", "Aramice" },
            { "arn", "Mapu\u00e7e dili" },
            { "aro", "Araona" },
            { "arp", "Arapaho dili" },
            { "arq", "Cezayir Arap\u00e7as\u0131" },
            { "ars", "Necd Arap\u00e7as\u0131" },
            { "arw", "Arawak Dili" },
            { "ary", "Fas Arap\u00e7as\u0131" },
            { "arz", "M\u0131s\u0131r Arap\u00e7as\u0131" },
            { "asa", "Asu" },
            { "ase", "Amerikan \u0130\u015faret Dili" },
            { "ast", "Asturyas\u00e7a" },
            { "atj", "Atikamek\u00e7e" },
            { "avk", "Kotava" },
            { "awa", "Awadhi" },
            { "bal", "Belu\u00e7\u00e7a" },
            { "ban", "Bali dili" },
            { "bar", "Bavyera dili" },
            { "bas", "Basa Dili" },
            { "bax", "Bamun" },
            { "bbc", "Batak Toba" },
            { "bbj", "Ghomala" },
            { "bej", "Beja dili" },
            { "bem", "Bemba" },
            { "bew", "Betawi" },
            { "bez", "Bena" },
            { "bfd", "Bafut" },
            { "bfq", "Badaga" },
            { "bgc", "Haryanvi dili" },
            { "bgn", "Bat\u0131 Balochi" },
            { "bho", "Arayanice" },
            { "bik", "Bikol" },
            { "bin", "Bini" },
            { "bjn", "Banjar Dili" },
            { "bkm", "Kom" },
            { "bla", "Karaayak dili" },
            { "blo", "Aniice" },
            { "bpy", "Bishnupriya" },
            { "bqi", "Bahtiyari" },
            { "bra", "Braj" },
            { "brh", "Brohice" },
            { "brx", "Bodo" },
            { "bss", "Akoose" },
            { "bua", "Buryat\u00e7a" },
            { "bug", metaValue_bug },
            { "bum", "Bulu" },
            { "byn", "Blin" },
            { "byv", "Medumba" },
            { "cad", "Kado dili" },
            { "car", "Carib" },
            { "cay", "Kayuga dili" },
            { "cch", "Atsam" },
            { "ccp", metaValue_ccp },
            { "ceb", "Sebuano dili" },
            { "cgg", "Kiga" },
            { "chb", "\u00c7ib\u00e7a dili" },
            { "chg", "\u00c7a\u011fatayca" },
            { "chk", "Chuukese" },
            { "chm", "Mari dili" },
            { "chn", "\u00c7inuk dili" },
            { "cho", "\u00c7oktav dili" },
            { "chp", "\u00c7ipevya dili" },
            { "chr", "\u00c7erokice" },
            { "chy", "\u015eayence" },
            { "ckb", "Orta K\u00fcrt\u00e7e" },
            { "clc", "\u00c7ilkotince" },
            { "cop", "K\u0131ptice" },
            { "cps", "Capiznon" },
            { "crg", "Michif dili" },
            { "crh", "K\u0131r\u0131m Tatarcas\u0131" },
            { "crj", "G\u00fcney Do\u011fu Kricesi" },
            { "crk", "Ova Kricesi" },
            { "crl", "Kuzey Do\u011fu Kricesi" },
            { "crm", "Moose Kricesi" },
            { "crr", "Carolina Algonkin dili" },
            { "crs", "Seselwa Kreole Frans\u0131zcas\u0131" },
            { "csb", "Kashubian" },
            { "csw", "Batakl\u0131k Kricesi" },
            { "dak", "Dakotaca" },
            { "dar", "Dargince" },
            { "dav", "Taita" },
            { "del", "Delaware" },
            { "den", "Slavey dili" },
            { "dgr", "Dogrib" },
            { "din", "Dinka dili" },
            { "dje", "Zarma" },
            { "doi", "Dogri" },
            { "dsb", "A\u015fa\u011f\u0131 Sorb\u00e7a" },
            { "dtp", "Orta Kadazan" },
            { "dua", "Duala" },
            { "dum", "Orta\u00e7a\u011f Felemenk\u00e7esi" },
            { "dyo", "Jola-Fonyi" },
            { "dyu", "Dyula" },
            { "dzg", "Dazaga" },
            { "ebu", "Embu" },
            { "efi", "Efik" },
            { "egl", "Emilia Dili" },
            { "egy", "Eski M\u0131s\u0131r Dili" },
            { "eka", "Ekajuk" },
            { "elx", "Elam" },
            { "enm", "Orta\u00e7a\u011f \u0130ngilizcesi" },
            { "esu", "Merkezi Yupik\u00e7e" },
            { "ewo", "Ewondo" },
            { "ext", "Ekstremadura Dili" },
            { "fan", "Fang" },
            { "fat", "Fanti" },
            { "fil", "Filipince" },
            { "fit", "Tornedalin Fincesi" },
            { "fon", "Fon" },
            { "frc", "Cajun Frans\u0131zcas\u0131" },
            { "frm", "Orta\u00e7a\u011f Frans\u0131zcas\u0131" },
            { "fro", "Eski Frans\u0131zca" },
            { "frp", "Arpitanca" },
            { "frr", "Kuzey Frizce" },
            { "frs", "Do\u011fu Frizcesi" },
            { "fur", "Friuli dili" },
            { "gaa", "Ga dili" },
            { "gag", "Gagavuzca" },
            { "gan", "Gan \u00c7incesi" },
            { "gay", "Gayo dili" },
            { "gba", "Gbaya" },
            { "gbz", "Zerd\u00fc\u015ft Daricesi" },
            { "gez", "Geez" },
            { "gil", "Kiribatice" },
            { "glk", "Gilanice" },
            { "gmh", "Orta\u00e7a\u011f Y\u00fcksek Almancas\u0131" },
            { "goh", "Eski Y\u00fcksek Almanca" },
            { "gon", "Gondi dili" },
            { "gor", "Gorontalo dili" },
            { "got", "Got\u00e7a" },
            { "grb", "Grebo dili" },
            { "grc", "Antik Yunanca" },
            { "gsw", "\u0130svi\u00e7re Almancas\u0131" },
            { "guc", "Wayuu dili" },
            { "gur", "Frafra" },
            { "guz", "Gusii" },
            { "gwi", "Gu\u00e7ince" },
            { "hai", "Haydaca" },
            { "hak", "Hakka \u00c7incesi" },
            { "haw", "Hawaii dili" },
            { "hax", "G\u00fcney Haydaca" },
            { "hif", "Fiji Hint\u00e7esi" },
            { "hil", "Hiligaynon dili" },
            { "hit", "Hitit\u00e7e" },
            { "hmn", "Hmong" },
            { "hsb", "Yukar\u0131 Sorb\u00e7a" },
            { "hsn", "Xiang \u00c7incesi" },
            { "hup", "Hupaca" },
            { "hur", "Halkomelemce" },
            { "iba", "Iban" },
            { "ibb", "\u0130bibio dili" },
            { "ikt", "Bat\u0131 Kanada \u0130nuktitut dili" },
            { "ilo", "Iloko" },
            { "inh", "\u0130ngu\u015f\u00e7a" },
            { "izh", "\u0130ngriya Dili" },
            { "jam", "Jamaika Patois Dili" },
            { "jbo", "Lojban" },
            { "jgo", "Ngomba" },
            { "jmc", "Machame" },
            { "jpr", "Yahudi Fars\u00e7as\u0131" },
            { "jrb", "Yahudi Arap\u00e7as\u0131" },
            { "jut", "Yutland Dili" },
            { "kaa", "Karakalpak\u00e7a" },
            { "kab", "Kabiliyece" },
            { "kac", "Ka\u00e7in dili" },
            { "kaj", "Jju" },
            { "kam", "Kamba" },
            { "kaw", "Kawi" },
            { "kbd", "Kabardeyce" },
            { "kbl", "Kanembu" },
            { "kcg", "Tyap" },
            { "kde", "Makonde" },
            { "kea", "Kabuverdianu" },
            { "ken", "Kenyang" },
            { "kfo", "Koro" },
            { "kgp", "Kaingang" },
            { "kha", "Khasi dili" },
            { "kho", "Hotanca" },
            { "khq", "Koyra Chiini" },
            { "khw", "\u00c7itral Dili" },
            { "kiu", "K\u0131rman\u00e7\u00e7a" },
            { "kkj", "Kako" },
            { "kln", "Kalenjin" },
            { "kmb", "Kimbundu" },
            { "koi", "Komi-Permyak" },
            { "kok", "Konkani dili" },
            { "kos", "Kosraean" },
            { "kpe", "Kpelle dili" },
            { "krc", "Kara\u00e7ay-Balkarca" },
            { "kri", "Krio" },
            { "krj", "Kinaray-a" },
            { "krl", "Karelyaca" },
            { "kru", "Kurukh dili" },
            { "ksb", "\u015eambala" },
            { "ksf", "Bafia" },
            { "ksh", "K\u00f6ln leh\u00e7esi" },
            { "kum", "Kumuk\u00e7a" },
            { "kut", "Kutenai dili" },
            { "kwk", "Kwak\u02bcwala dili" },
            { "kxv", "Kuvi" },
            { "lad", "Ladino" },
            { "lag", "Langi" },
            { "lah", "Lahnda" },
            { "lam", "Lamba dili" },
            { "lez", "Lezgice" },
            { "lfn", "Lingua Franca Nova" },
            { "lij", "Ligurca" },
            { "lil", "Lillooet dili" },
            { "liv", "Livonca" },
            { "lkt", "Lakotaca" },
            { "lmo", "Lombard\u00e7a" },
            { "lol", "Mongo" },
            { "lou", "Louisiana Kreolcesi" },
            { "loz", "Lozi" },
            { "lrc", "Kuzey Luri" },
            { "lsm", "Samia dili" },
            { "ltg", "Latgalian" },
            { "lua", "Luba-Lulua" },
            { "lui", "Luiseno" },
            { "lun", "Lunda" },
            { "luo", "Luo" },
            { "lus", "Lushai" },
            { "luy", "Luyia" },
            { "lzh", "Edebi \u00c7ince" },
            { "lzz", "Lazca" },
            { "mad", "Madura Dili" },
            { "maf", "Mafa" },
            { "mag", "Magahi" },
            { "mai", "Maithili" },
            { "mak", "Makasar" },
            { "man", "Mandingo" },
            { "mas", "Masai" },
            { "mde", "Maba" },
            { "mdf", "Mok\u015fa dili" },
            { "mdr", "Mandar" },
            { "men", "Mende dili" },
            { "mer", "Meru" },
            { "mfe", "Morisyen" },
            { "mga", "Orta\u00e7a\u011f \u0130rlandacas\u0131" },
            { "mgh", "Makhuwa-Meetto" },
            { "mgo", "Meta\u2019" },
            { "mic", "Micmac" },
            { "min", "Minangkabau" },
            { "mnc", "Man\u00e7urya dili" },
            { "mni", "Manipuri dili" },
            { "moe", "Do\u011fu \u0130nnucas\u0131" },
            { "moh", "Mohavk dili" },
            { "mos", "Mossi" },
            { "mrj", "Ova \u00c7irmi\u015f\u00e7esi" },
            { "mua", "Mundang" },
            { "mul", "Birden Fazla Dil" },
            { "mus", "Krik\u00e7e" },
            { "mwl", "Miranda dili" },
            { "mwr", "Marvari" },
            { "mwv", "Mentawai" },
            { "mye", "Myene" },
            { "myv", "Erzya" },
            { "mzn", "Mazenderanca" },
            { "nan", "Min Nan \u00c7incesi" },
            { "nap", "Napolice" },
            { "naq", "Nama" },
            { "nds", "A\u015fa\u011f\u0131 Almanca" },
            { "new", "Nevari" },
            { "nia", "Nias" },
            { "niu", "Niue dili" },
            { "njo", "Ao Naga" },
            { "nmg", "Kwasio" },
            { "nnh", "Ngiemboon" },
            { "nog", "Nogayca" },
            { "non", "Eski Nors dili" },
            { "nov", "Novial" },
            { "nqo", metaValue_nqo },
            { "nso", "Kuzey Sotho dili" },
            { "nus", "Nuer" },
            { "nwc", "Klasik Nevari" },
            { "nym", "Nyamvezi" },
            { "nyn", "Nyankole" },
            { "nyo", "Nyoro" },
            { "nzi", "Nzima dili" },
            { "ojb", "Kuzeybat\u0131 Ojibwe dili" },
            { "ojc", "Orta Ojibwe dili" },
            { "ojs", "Ani\u015fininice" },
            { "ojw", "Bat\u0131 Ojibwe dili" },
            { "oka", "Okanagan dili" },
            { "osa", "Osage" },
            { "ota", "Osmanl\u0131 T\u00fcrk\u00e7esi" },
            { "pag", "Pangasinan dili" },
            { "pal", "Pehlevi Dili" },
            { "pam", "Pampanga" },
            { "pap", "Papiamento" },
            { "pau", "Palau dili" },
            { "pcd", "Picard Dili" },
            { "pcm", "Nijerya Pidgin dili" },
            { "pdc", "Pensilvanya Almancas\u0131" },
            { "pdt", "Plautdietsch" },
            { "peo", "Eski Fars\u00e7a" },
            { "pfl", "Palatin Almancas\u0131" },
            { "phn", "Fenike dili" },
            { "pis", "Pijin dili" },
            { "pms", "Piyemontece" },
            { "pnt", "Kuzeybat\u0131 Kafkasya" },
            { "pon", "Pohnpeian" },
            { "pqm", "Maliset\u00e7e-Passamaquoddy" },
            { "prg", "Prusyaca" },
            { "pro", "Eski Provensal" },
            { "quc", "Ki\u00e7ece" },
            { "qug", "Chimborazo Highland Quichua" },
            { "raj", "Rajasthani" },
            { "rap", "Rapanui dili" },
            { "rar", "Rarotongan" },
            { "rgn", "Romanyolca" },
            { "rhg", "Rohingya dili" },
            { "rif", "Rif Berbericesi" },
            { "rof", "Rombo" },
            { "rom", "Romanca" },
            { "rtm", "Rotuman" },
            { "rue", "Rusince" },
            { "rug", "Roviana" },
            { "rup", "Ulah\u00e7a" },
            { "rwk", "Rwa" },
            { "sad", "Sandave" },
            { "sah", "Yakut\u00e7a" },
            { "sam", "Samarit Aramcas\u0131" },
            { "saq", "Samburu" },
            { "sas", "Sasak" },
            { "sat", "Santali" },
            { "saz", metaValue_saz },
            { "sba", "Ngambay" },
            { "sbp", "Sangu" },
            { "scn", "Sicilyaca" },
            { "sco", "\u0130sko\u00e7\u00e7a" },
            { "sdc", "Sassari Sarduca" },
            { "sdh", "G\u00fcney K\u00fcrt\u00e7esi" },
            { "see", "Seneca dili" },
            { "seh", "Sena" },
            { "sei", "Seri" },
            { "sel", "Selkup dili" },
            { "ses", "Koyraboro Senni" },
            { "sga", "Eski \u0130rlandaca" },
            { "sgs", "Samogit\u00e7e" },
            { "shi", "Ta\u015felit" },
            { "shn", "Shan dili" },
            { "shu", "\u00c7ad Arap\u00e7as\u0131" },
            { "sid", "Sidamo dili" },
            { "slh", "G\u00fcney Lushootseed" },
            { "sli", "A\u015fa\u011f\u0131 Silezyaca" },
            { "sly", "Selayar" },
            { "sma", "G\u00fcney Laponcas\u0131" },
            { "smj", "Lule Laponcas\u0131" },
            { "smn", "\u0130nari Laponcas\u0131" },
            { "sms", "Skolt Laponcas\u0131" },
            { "snk", "Soninke" },
            { "sog", "Sogdiana Dili" },
            { "srn", "Sranan Tongo" },
            { "srr", "Serer dili" },
            { "ssy", metaValue_ssy },
            { "stq", "Saterland Frizcesi" },
            { "str", "Bo\u011fazlar Sali\u015f dili" },
            { "suk", "Sukuma dili" },
            { "sus", "Susu" },
            { "sux", "S\u00fcmerce" },
            { "swb", "Komorca" },
            { "syc", "Klasik S\u00fcryanice" },
            { "syr", "S\u00fcryanice" },
            { "szl", "Silezyaca" },
            { "tce", "G\u00fcney Tu\u00e7oncas\u0131" },
            { "tcy", "Tuluca" },
            { "tem", "Timne" },
            { "teo", "Teso" },
            { "ter", "Tereno" },
            { "tet", "Tetum" },
            { "tgx", "Tagi\u015f\u00e7e" },
            { "tht", "Tahltanca" },
            { "tig", "Tigre" },
            { "tiv", "Tiv" },
            { "tkl", "Tokelau dili" },
            { "tkr", "Sahurca" },
            { "tlh", "Klingonca" },
            { "tli", "Tlingit\u00e7e" },
            { "tly", "Tal\u0131\u015f\u00e7a" },
            { "tmh", "Tama\u015fek" },
            { "tog", "Nyasa Tonga" },
            { "tok", "Toki Pona" },
            { "tpi", "Tok Pisin" },
            { "tru", "Turoyo" },
            { "trv", "Taroko" },
            { "tsd", "Tsakonca" },
            { "tsi", "Tsimshian" },
            { "ttm", "Kuzey Tu\u00e7oncas\u0131" },
            { "ttt", "Tat\u00e7a" },
            { "tum", "Tumbuka" },
            { "tvl", "Tuvalyanca" },
            { "twq", "Tasawaq" },
            { "tyv", "Tuvaca" },
            { "tzm", "Orta Atlas Tamazigti" },
            { "udm", "Udmurt\u00e7a" },
            { "uga", "Ugarit dili" },
            { "umb", "Umbundu" },
            { "und", "Bilinmeyen Dil" },
            { "vai", metaValue_vai },
            { "vec", "Venedik\u00e7e" },
            { "vep", "Veps dili" },
            { "vls", "Bat\u0131 Flamanca" },
            { "vmf", "Main Frankonya Dili" },
            { "vmw", "Makuaca" },
            { "vot", "Vot\u00e7a" },
            { "vro", "V\u00f5ro" },
            { "vun", "Vunjo" },
            { "wae", "Walser" },
            { "wal", "Valamo" },
            { "war", "Varay" },
            { "was", "Va\u015fo" },
            { "wbp", "Warlpiri" },
            { "wuu", "Wu \u00c7incesi" },
            { "xal", "Kalm\u0131k\u00e7a" },
            { "xmf", "Megrelce" },
            { "xnr", "Kangrice" },
            { "xog", "Soga" },
            { "yao", "Yao" },
            { "yap", "Yap\u00e7a" },
            { "yav", "Yangben" },
            { "ybb", "Yemba" },
            { "yrl", "Nheengatu" },
            { "yue", "Kantonca" },
            { "zap", "Zapotek dili" },
            { "zbl", metaValue_zbl },
            { "zea", "Zelandaca" },
            { "zen", "Zenaga dili" },
            { "zgh", "Standart Fas Tamazigti" },
            { "zun", "Zunice" },
            { "zxx", "Dilbilim i\u00e7eri\u011fi yok" },
            { "zza", "Zazaca" },
            { "Adlm", "Adlam" },
            { "Afak", "Afaka" },
            { "Aghb", "Kafkas Albanyas\u0131" },
            { "Arab", "Arap" },
            { "Aran", "Nest\u00e2lik" },
            { "Armi", "\u0130mparatorluk Aramicesi" },
            { "Armn", "Ermeni" },
            { "Avst", "Avesta" },
            { "Bali", "Bali Dili" },
            { "Bamu", "Bamum" },
            { "Bass", "Bassa Vah" },
            { "Batk", "Batak" },
            { "Beng", "Bengal" },
            { "Blis", metaValue_zbl },
            { "Bopo", "Bopomofo" },
            { "Brah", "Brahmi" },
            { "Brai", "Braille" },
            { "Bugi", metaValue_bug },
            { "Buhd", "Buhid" },
            { "Cakm", metaValue_ccp },
            { "Cans", "UCAS" },
            { "Cari", "Karya" },
            { "Cher", "\u00c7eroki" },
            { "Cirt", "Cirth" },
            { "Copt", "K\u0131pti" },
            { "Cprt", metaValue_CY },
            { "Cyrl", "Kiril" },
            { "Cyrs", "Eski Kilise Slavcas\u0131 Kiril" },
            { "Deva", "Devanagari" },
            { "Dsrt", "Deseret" },
            { "Dupl", "Duploy\u00e9 Stenografi" },
            { "Egyd", "Demotik M\u0131s\u0131r" },
            { "Egyh", "Hiyeratik M\u0131s\u0131r" },
            { "Egyp", "M\u0131s\u0131r Hiyeroglifleri" },
            { "Elba", "Elbasan" },
            { "Ethi", metaValue_ET },
            { "Geok", "Hutsuri G\u00fcrc\u00fc" },
            { "Geor", "G\u00fcrc\u00fc" },
            { "Glag", "Glagolit" },
            { "Goth", "Gotik" },
            { "Gran", "Grantha" },
            { "Grek", "Yunan" },
            { "Gujr", "G\u00fccerat" },
            { "Guru", "Gurmukhi" },
            { "Hanb", "Han - Bopomofo" },
            { "Hang", "Hang\u0131l" },
            { "Hani", "Han" },
            { "Hano", "Hanunoo" },
            { "Hans", "Basitle\u015ftirilmi\u015f" },
            { "Hant", "Geleneksel" },
            { "Hebr", "\u0130brani" },
            { "Hira", "Hiragana" },
            { "Hluw", "Anadolu Hiyeroglifleri" },
            { "Hmng", "Pahavh Hmong" },
            { "Hrkt", "Japon hece alfabeleri" },
            { "Hung", "Eski Macar" },
            { "Inds", "Indus" },
            { "Ital", "Eski \u0130talyan" },
            { "Java", "Cava Dili" },
            { "Jpan", "Japon" },
            { "Jurc", "Jurchen" },
            { "Kali", "Kayah Li" },
            { "Kana", "Katakana" },
            { "Khar", "Kharoshthi" },
            { "Khmr", "Kmer" },
            { "Khoj", "Khojki" },
            { "Knda", "Kannada" },
            { "Kore", metaValue_ko },
            { "Kpel", "Kpelle" },
            { "Kthi", "Kaithi" },
            { "Lana", "Lanna" },
            { "Laoo", "Lao" },
            { "Latf", "Fraktur Latin" },
            { "Latg", "Gael Latin" },
            { "Latn", "Latin" },
            { "Lepc", "Lepcha" },
            { "Limb", "Limbu" },
            { "Lina", "Lineer A" },
            { "Linb", "Lineer B" },
            { "Lisu", "Fraser" },
            { "Loma", "Loma" },
            { "Lyci", "Likya" },
            { "Lydi", "Lidya" },
            { "Mahj", "Mahajani" },
            { "Mand", "Manden" },
            { "Mani", "Maniheist" },
            { "Maya", "Maya Hiyeroglifleri" },
            { "Mend", "Mende" },
            { "Merc", "Meroitik El Yaz\u0131s\u0131" },
            { "Mero", "Meroitik" },
            { "Mlym", "Malayalam" },
            { "Mong", "Mo\u011fol" },
            { "Moon", "Moon" },
            { "Mroo", "Mro" },
            { "Mtei", "Meitei Mayek" },
            { "Mymr", "Burma" },
            { "Narb", "Eski Kuzey Arap" },
            { "Nbat", "Nebati" },
            { "Nkgb", "Naksi Geba" },
            { "Nkoo", metaValue_nqo },
            { "Nshu", "N\u00fcshu" },
            { "Ogam", "Ogham" },
            { "Olck", "Ol Chiki" },
            { "Orkh", "Orhun" },
            { "Orya", "Oriya" },
            { "Osma", "Osmanya" },
            { "Palm", "Palmira" },
            { "Pauc", "Pau Cin Hau" },
            { "Perm", "Eski Permik" },
            { "Phag", "Phags-pa" },
            { "Phli", "Pehlevi Kitabe Dili" },
            { "Phlp", "Psalter Pehlevi" },
            { "Phlv", "Kitap Pehlevi Dili" },
            { "Phnx", "Fenike" },
            { "Plrd", "Pollard Fonetik" },
            { "Prti", "Part\u00e7a Kitabe Dili" },
            { "Qaag", "Zawgyi" },
            { "Rjng", "Rejang" },
            { "Rohg", "Hanifi" },
            { "Roro", "Rongorongo" },
            { "Runr", "Runik" },
            { "Samr", "Samarit" },
            { "Sara", "Sarati" },
            { "Sarb", "Eski G\u00fcney Arap" },
            { "Saur", metaValue_saz },
            { "Sgnw", "\u0130\u015faret Dili" },
            { "Shaw", "Shavian" },
            { "Shrd", "Sharada" },
            { "Sidd", "Siddham" },
            { "Sind", "Khudabadi" },
            { "Sinh", "Seylan" },
            { "Sora", "Sora Sompeng" },
            { "Sund", "Sunda" },
            { "Sylo", "Syloti Nagri" },
            { "Syrc", "S\u00fcryani" },
            { "Syre", "Estrangela S\u00fcryani" },
            { "Syrj", "Bat\u0131 S\u00fcryani" },
            { "Syrn", "Do\u011fu S\u00fcryani" },
            { "Tagb", "Tagbanva" },
            { "Takr", "Takri" },
            { "Tale", "Tai Le" },
            { "Talu", "New Tai Lue" },
            { "Taml", "Tamil" },
            { "Tang", "Tangut" },
            { "Tavt", "Tai Viet" },
            { "Telu", "Telugu" },
            { "Teng", "Tengvar" },
            { "Tfng", "Tifinag" },
            { "Tglg", "Takalot" },
            { "Thaa", "Thaana" },
            { "Thai", "Tay" },
            { "Tibt", "Tibet" },
            { "Tirh", "Tirhuta" },
            { "Ugar", "Ugarit \u00c7ivi Yaz\u0131s\u0131" },
            { "Vaii", metaValue_vai },
            { "Visp", "Konu\u015fma Sesleri \u00c7izimlemesi" },
            { "Wara", "Varang Kshiti" },
            { "Wole", "Woleai" },
            { "Xpeo", "Eski Fars" },
            { "Xsux", "S\u00fcmer-Akad \u00c7ivi Yaz\u0131s\u0131" },
            { "Yiii", "Yi" },
            { "Zinh", "Kal\u0131tsal" },
            { "Zmth", "Matematiksel G\u00f6sterim" },
            { "Zsye", "Emoji" },
            { "Zsym", "Sembol" },
            { "Zxxx", "Yaz\u0131l\u0131 Olmayan" },
            { "Zyyy", "Ortak" },
            { "Zzzz", "Bilinmeyen Alfabe" },
            { "de_AT", "Avusturya Almancas\u0131" },
            { "de_CH", "\u0130svi\u00e7re Y\u00fcksek Almancas\u0131" },
            { "en_AU", "Avustralya \u0130ngilizcesi" },
            { "en_CA", "Kanada \u0130ngilizcesi" },
            { "en_GB", "\u0130ngiliz \u0130ngilizcesi" },
            { "en_US", "Amerikan \u0130ngilizcesi" },
            { "es_ES", "Avrupa \u0130spanyolcas\u0131" },
            { "es_MX", "Meksika \u0130spanyolcas\u0131" },
            { "fa_AF", "Darice" },
            { "fr_CA", "Kanada Frans\u0131zcas\u0131" },
            { "fr_CH", "\u0130svi\u00e7re Frans\u0131zcas\u0131" },
            { "nl_BE", "Flamanca" },
            { "pt_BR", "Brezilya Portekizcesi" },
            { "pt_PT", "Avrupa Portekizcesi" },
            { "ro_MD", "Moldovaca" },
            { "sw_CD", "Kongo Svahili" },
            { "%%1901", "Geleneksel Almanca Yaz\u0131m Kurallar\u0131" },
            { "%%1994", "Standart Resia Yaz\u0131m Kurallar\u0131" },
            { "%%1996", "1996 Almanca Yaz\u0131m Kurallar\u0131" },
            { "ar_001", "Modern Standart Arap\u00e7a" },
            { "es_419", "Latin Amerika \u0130spanyolcas\u0131" },
            { "key.ca", "Takvim" },
            { "key.cf", "Para Birimi Bi\u00e7imi" },
            { "key.co", "S\u0131ralama D\u00fczeni" },
            { "key.cu", "Para Birimi" },
            { "key.hc", "Saat Sistemi (12 - 24)" },
            { "key.lb", "Sat\u0131r Sonu Stili" },
            { "key.ms", "\u00d6l\u00e7\u00fc Sistemi" },
            { "key.nu", "Rakamlar" },
            { "key.tz", "Saat Dilimi" },
            { "key.va", "Yerel Varyant" },
            { "nds_NL", "A\u015fa\u011f\u0131 Saksonca" },
            { "%%BISKE", "San Giorgio/Bila Leh\u00e7esi" },
            { "%%BOONT", "Boontling" },
            { "%%KKCOR", "Ortak Yaz\u0131m Kurallar\u0131" },
            { "%%LIPAW", "Resia Lipovaz Leh\u00e7esi" },
            { "%%NEDIS", "Natisone Leh\u00e7esi" },
            { "%%NJIVA", "Gniva/Njiva Leh\u00e7esi" },
            { "%%OSOJS", "Oseacco/Osojane Leh\u00e7esi" },
            { "%%POSIX", "Bilgisayar" },
            { "%%ROZAJ", "Resia Leh\u00e7esi" },
            { "%%SAAHO", metaValue_ssy },
            { "%%SOLBA", "Stolvizza/Solbica Leh\u00e7esi" },
            { "%%UCCOR", "Birle\u015ftirilmi\u015f Yaz\u0131m Kurallar\u0131" },
            { "az_Arab", "G\u00fcney Azerice" },
            { "zh_Hans", "Basitle\u015ftirilmi\u015f \u00c7ince" },
            { "zh_Hant", "Geleneksel \u00c7ince" },
            { "%%FONIPA", "IPA Ses Bilimi" },
            { "%%FONUPA", "UPA Ses Bilimi" },
            { "%%PINYIN", "Pinyin (Latin Alfabesinde Yaz\u0131m\u0131)" },
            { "%%SCOUSE", "Scouse" },
            { "%%TARASK", "Taraskievica Yaz\u0131m Kurallar\u0131" },
            { "%%UCRCOR", "G\u00f6zden Ge\u00e7irilmi\u015f Birle\u015ftirilmi\u015f Yaz\u0131m Kurallar\u0131" },
            { "%%AREVELA", "Do\u011fu Ermenicesi" },
            { "%%AREVMDA", "Bat\u0131 Ermenicesi" },
            { "%%MONOTON", "Monotonik" },
            { "%%POLYTON", "Politonik" },
            { "%%REVISED", "G\u00f6zden Ge\u00e7irilmi\u015f Yaz\u0131m Kurallar\u0131" },
            { "%%1606NICT", "1606\u2018ya Dek Ge\u00e7 Orta\u00e7a\u011f Frans\u0131zcas\u0131" },
            { "%%1694ACAD", "Erken Modern Frans\u0131zca" },
            { "%%1959ACAD", "Akademik" },
            { "%%BAKU1926", "Birle\u015ftirilmi\u015f Yeni T\u00fcrk Alfabesi" },
            { "%%SCOTLAND", "Standart \u0130sko\u00e7 \u0130ngilizcesi" },
            { "%%VALENCIA", "Valensiyaca" },
            { "%%WADEGILE", "Wade-Giles (Latin Alfabesinde Yaz\u0131m\u0131)" },
            { "type.ca.roc", "\u00c7in Cumhuriyeti Takvimi" },
            { "type.co.eor", "Avrupa S\u0131ralama Kurallar\u0131" },
            { "type.hc.h11", "12 Saat Sistemi (0\u201311)" },
            { "type.hc.h12", "12 Saat Sistemi (1\u201312)" },
            { "type.hc.h23", "24 Saat Sistemi (0\u201323)" },
            { "type.hc.h24", "24 Saat Sistemi (1\u201324)" },
            { "type.m0.bgn", "US BGN Transliterasyon" },
            { "type.nu.ahom", "Ahom Rakamlar\u0131" },
            { "type.nu.arab", "Hint-Arap Rakamlar\u0131" },
            { "type.nu.armn", "Ermeni Rakamlar\u0131" },
            { "type.nu.bali", "Bali Rakamlar\u0131" },
            { "type.nu.beng", "Bengal Rakamlar\u0131" },
            { "type.nu.brah", "Brahmi Rakamlar\u0131" },
            { "type.nu.cakm", "Chakma Rakamlar\u0131" },
            { "type.nu.cham", "Cham Rakamlar\u0131" },
            { "type.nu.cyrl", "Kiril Rakamlar\u0131" },
            { "type.nu.deva", "Devanagari Rakamlar\u0131" },
            { "type.nu.ethi", "Ge\u2019ez Rakamlar\u0131" },
            { "type.nu.geor", "G\u00fcrc\u00fc Rakamlar\u0131" },
            { "type.nu.gonm", "Masaram Gondi Rakamlar\u0131" },
            { "type.nu.grek", "Yunan Rakamlar\u0131" },
            { "type.nu.gujr", "G\u00fccerat Rakamlar\u0131" },
            { "type.nu.guru", "Gurmukhi Rakamlar\u0131" },
            { "type.nu.hans", "Basitle\u015ftirilmi\u015f \u00c7in Rakamlar\u0131" },
            { "type.nu.hant", "Geleneksel \u00c7in Rakamlar\u0131" },
            { "type.nu.hebr", "\u0130brani Rakamlar\u0131" },
            { "type.nu.hmng", "Pahawh Hmong Rakamlar\u0131" },
            { "type.nu.java", "Cava Rakamlar\u0131" },
            { "type.nu.jpan", "Japon Rakamlar\u0131" },
            { "type.nu.kali", "Kayah Li Rakamlar\u0131" },
            { "type.nu.khmr", "Kmer Rakamlar\u0131" },
            { "type.nu.knda", "Kannada Rakamlar\u0131" },
            { "type.nu.lana", "Tai Tham Hora Rakamlar\u0131" },
            { "type.nu.laoo", "Lao Rakamlar\u0131" },
            { "type.nu.latn", "Bat\u0131 Rakamlar\u0131" },
            { "type.nu.lepc", "Lep\u00e7a Rakamlar\u0131" },
            { "type.nu.limb", "Limbu Rakamlar\u0131" },
            { "type.nu.mlym", "Malayalam Rakamlar\u0131" },
            { "type.nu.modi", "Modi Rakamlar\u0131" },
            { "type.nu.mong", "Mo\u011folca Rakamlar" },
            { "type.nu.mroo", "Mro Rakamlar\u0131" },
            { "type.nu.mtei", "Meetei Mayek Rakamlar\u0131" },
            { "type.nu.mymr", "Myanmar Rakamlar\u0131" },
            { "type.nu.nkoo", "N\u2019Ko Rakamlar\u0131" },
            { "type.nu.olck", "Ol Chiki Rakamlar\u0131" },
            { "type.nu.orya", "Oriya Rakamlar\u0131" },
            { "type.nu.osma", "Osmanya Rakamlar\u0131" },
            { "type.nu.saur", "Saurashtra Rakamlar\u0131" },
            { "type.nu.shrd", "Sharada Rakamlar\u0131" },
            { "type.nu.sind", "Khudawadi Rakamlar\u0131" },
            { "type.nu.sinh", "Sinhala Lith Rakamlar\u0131" },
            { "type.nu.sora", "Sora Sompeng Rakamlar\u0131" },
            { "type.nu.sund", "Sunda Rakamlar\u0131" },
            { "type.nu.takr", "Takri Basamaklar\u0131" },
            { "type.nu.talu", "New Tai Lue Rakamlar\u0131" },
            { "type.nu.taml", "Geleneksel Tamil Rakamlar\u0131" },
            { "type.nu.telu", "Telugu Rakamlar\u0131" },
            { "type.nu.thai", "Tay Rakamlar\u0131" },
            { "type.nu.tibt", "Tibet Rakamlar\u0131" },
            { "type.nu.tirh", "Tirhuta Rakamlar\u0131" },
            { "type.nu.vaii", "Vai Rakamlar\u0131" },
            { "type.nu.wara", "Warang Citi Rakamlar\u0131" },
            { "type.ca.dangi", "Dangi Takvimi" },
            { "type.co.ducet", "Saptanm\u0131\u015f Unicode S\u0131ralama D\u00fczeni" },
            { "type.co.emoji", "Emoji S\u0131ralama D\u00fczeni" },
            { "type.lb.loose", "Serbest Sat\u0131r Sonu Stili" },
            { "type.nu.roman", "Roma Rakamlar\u0131" },
            { "type.ca.coptic", "K\u0131pti Takvim" },
            { "type.ca.hebrew", "\u0130brani Takvimi" },
            { "type.ca.indian", "Ulusal Hint Takvimi" },
            { "type.co.compat", "\u00d6nceki S\u0131ralama D\u00fczeni (uyumluluk i\u00e7in)" },
            { "type.co.pinyin", "Pinyin S\u0131ralama D\u00fczeni" },
            { "type.co.search", "Genel Ama\u00e7l\u0131 Arama" },
            { "type.co.stroke", "Vuru\u015f S\u0131ralama D\u00fczeni" },
            { "type.co.unihan", "Radikal-Vuru\u015f S\u0131ralama D\u00fczeni" },
            { "type.co.zhuyin", "Zhuyin S\u0131ralama D\u00fczeni" },
            { "type.d0.fwidth", "Tam Geni\u015flik" },
            { "type.d0.hwidth", "Yar\u0131m geni\u015flik" },
            { "type.lb.normal", "Normal Sat\u0131r Sonu Stili" },
            { "type.lb.strict", "Kat\u0131 Sat\u0131r Sonu Stili" },
            { "type.m0.ungegn", "UN GEGN Transliterasyon" },
            { "type.ms.metric", "Metrik Sistem" },
            { "type.nu.native", "Yerel Rakamlar" },
            { "type.ca.chinese", "\u00c7in Takvimi" },
            { "type.ca.islamic", "Hicri Takvim" },
            { "type.ca.iso8601", "ISO-8601 Takvimi" },
            { "type.ca.persian", "\u0130ran Takvimi" },
            { "type.cf.account", "Muhasebe Para Bi\u00e7imi" },
            { "type.co.big5han", "Geleneksel \u00c7ince S\u0131ralama D\u00fczeni - Big5" },
            { "type.d0.npinyin", "Rakam" },
            { "type.nu.arabext", "Geni\u015fletilmi\u015f Hint-Arap Rakamlar\u0131" },
            { "type.nu.armnlow", "K\u00fc\u00e7\u00fck Harf Ermeni Rakamlar\u0131" },
            { "type.nu.finance", "Finansal Say\u0131lar" },
            { "type.nu.greklow", "K\u00fc\u00e7\u00fck Harf Yunan Rakamlar\u0131" },
            { "type.nu.hanidec", "\u00c7in Ondal\u0131k Rakamlar\u0131" },
            { "type.nu.hansfin", "Finansal Basitle\u015ftirilmi\u015f \u00c7in Rakamlar\u0131" },
            { "type.nu.hantfin", "Finansal Geleneksel \u00c7in Rakamlar\u0131" },
            { "type.nu.jpanfin", "Finansal Japon Rakamlar\u0131" },
            { "type.nu.mathdbl", "\u00c7ift \u00c7izgili Matematiksel Rakamlar" },
            { "type.nu.tamldec", "Tamil Rakamlar\u0131" },
            { "type.ca.buddhist", "Budist Takvimi" },
            { "type.ca.ethiopic", "Etiyopik Takvim" },
            { "type.ca.japanese", "Japon Takvimi" },
            { "type.cf.standard", "Standart Para Bi\u00e7imi" },
            { "type.co.phonetic", "Fonetik S\u0131ralama D\u00fczeni" },
            { "type.co.searchjl", "Hangul \u0130lk Sessiz Harfe G\u00f6re Arama" },
            { "type.co.standard", "Standart S\u0131ralama D\u00fczeni" },
            { "type.ms.uksystem", "\u0130ngiliz \u00d6l\u00e7\u00fc Sistemi" },
            { "type.ms.ussystem", "ABD \u00d6l\u00e7\u00fc Sistemi" },
            { "type.nu.fullwide", "Tam Geni\u015flikte Rakamlar" },
            { "type.nu.lanatham", "Tai Tham Tham Rakamlar\u0131" },
            { "type.nu.mathbold", "Kal\u0131n Matematiksel Rakamlar" },
            { "type.nu.mathmono", "E\u015fit Aral\u0131kl\u0131 Matematiksel Rakamlar" },
            { "type.nu.mathsanb", "Kal\u0131n Sans Serif Matematiksel Rakamlar" },
            { "type.nu.mathsans", "Sans Serif Matematiksel Rakamlar" },
            { "type.nu.mymrshan", "Myanmar Shan Rakamlar\u0131" },
            { "type.nu.mymrtlng", "Myanmar Tai Laing Rakamlar\u0131" },
            { "type.nu.romanlow", "K\u00fc\u00e7\u00fck Harf Roma Rakamlar\u0131" },
            { "type.ca.gregorian", "Miladi Takvim" },
            { "type.co.gb2312han", "Basitle\u015ftirilmi\u015f \u00c7ince S\u0131ralama D\u00fczeni - GB2312" },
            { "type.co.phonebook", "Telefon Defteri S\u0131ralama D\u00fczeni" },
            { "type.co.dictionary", "S\u00f6zl\u00fck S\u0131ralama D\u00fczeni" },
            { "type.co.traditional", "Geleneksel S\u0131ralama D\u00fczeni" },
            { "type.nu.traditional", "Geleneksel Rakamlar" },
            { "type.ca.islamic-rgsa", "Hicri Takvim (Suudi)" },
            { "type.ca.islamic-tbla", "Hicri Takvim (15 Temmuz 622)" },
            { "type.ca.islamic-civil", "Hicri Takvim (16 Temmuz 622)" },
            { "type.ca.islamic-umalqura", "Hicri Takvim (\u00dcmm\u00fc-l Kurra Takvimi)" },
            { "type.ca.ethiopic-amete-alem", "Etiyopik Amete Alem Takvimi" },
        };
        return data;
    }
}
