/*
 * Copyright (c) 1998, 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

/**
 * Provides classes and interfaces that deal with editable and noneditable text
 * components. Examples of text components are text fields and text areas, of
 * which password fields and document editors are special instantiations.
 * Features that are supported by this package include selection/highlighting,
 * editing, style, and key mapping.
 * <p>
 * <strong>Note:</strong>
 * Most of the Swing API is <em>not</em> thread safe. For details, see
 * <a
 * href="https://docs.oracle.com/javase/tutorial/uiswing/concurrency/index.html"
 * target="_top">Concurrency in Swing</a>,
 * a section in
 * <em><a href="https://docs.oracle.com/javase/tutorial/"
 * target="_top">The Java Tutorial</a></em>.
 *
 * <h2>Related Documentation</h2>
 * For overviews, tutorials, examples, guides, and tool documentation,
 * please see:
 * <ul>
 *     <li><a href="https://docs.oracle.com/javase/tutorial/uiswing/components/text.html"
 *     target="_top">Using Text Components</a>,
 *     a section in <em>The Java Tutorial</em></li>
 * </ul>
 *
 * @since 1.2
 * @serial exclude
 */
package javax.swing.text;
