/*
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is furnished to do
 * so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package jdk.nashorn.internal.runtime.regexp.joni.constants.internal;

@SuppressWarnings("javadoc")
public interface OPCode {
    int FINISH                        = 0;            /* matching process terminator (no more alternative) */
    int END                           = 1;            /* pattern code terminator (success end) */

    int EXACT1                        = 2;            /* single byte, N = 1 */
    int EXACT2                        = 3;            /* single byte, N = 2 */
    int EXACT3                        = 4;            /* single byte, N = 3 */
    int EXACT4                        = 5;            /* single byte, N = 4 */
    int EXACT5                        = 6;            /* single byte, N = 5 */
    int EXACTN                        = 7;            /* single byte */

    int EXACT1_IC                     = 14;           /* single byte, N = 1, ignore case */
    int EXACTN_IC                     = 15;           /* single byte,        ignore case */

    int CCLASS                        = 16;
    int CCLASS_MB                     = 17;
    int CCLASS_MIX                    = 18;
    int CCLASS_NOT                    = 19;
    int CCLASS_MB_NOT                 = 20;
    int CCLASS_MIX_NOT                = 21;
    int CCLASS_NODE                   = 22;           /* pointer to CClassNode node */

    int ANYCHAR                       = 23;           /* "."  */
    int ANYCHAR_ML                    = 24;           /* "."  multi-line */
    int ANYCHAR_STAR                  = 25;           /* ".*" */
    int ANYCHAR_ML_STAR               = 26;           /* ".*" multi-line */
    int ANYCHAR_STAR_PEEK_NEXT        = 27;
    int ANYCHAR_ML_STAR_PEEK_NEXT     = 28;

    int WORD                          = 29;
    int NOT_WORD                      = 30;
    int WORD_BOUND                    = 31;
    int NOT_WORD_BOUND                = 32;
    int WORD_BEGIN                    = 33;
    int WORD_END                      = 34;

    int BEGIN_BUF                     = 35;
    int END_BUF                       = 36;
    int BEGIN_LINE                    = 37;
    int END_LINE                      = 38;
    int SEMI_END_BUF                  = 39;
    int BEGIN_POSITION                = 40;

    int BACKREF1                      = 41;
    int BACKREF2                      = 42;
    int BACKREFN                      = 43;
    int BACKREFN_IC                   = 44;
    int BACKREF_MULTI                 = 45;
    int BACKREF_MULTI_IC              = 46;
    int BACKREF_WITH_LEVEL            = 47;           /* \k<xxx+n>, \k<xxx-n> */

    int MEMORY_START                  = 48;
    int MEMORY_START_PUSH             = 49;           /* push back-tracker to stack */
    int MEMORY_END_PUSH               = 50;           /* push back-tracker to stack */
    int MEMORY_END_PUSH_REC           = 51;           /* push back-tracker to stack */
    int MEMORY_END                    = 52;
    int MEMORY_END_REC                = 53;           /* push marker to stack */

    int FAIL                          = 54;           /* pop stack and move */
    int JUMP                          = 55;
    int PUSH                          = 56;
    int POP                           = 57;
    int PUSH_OR_JUMP_EXACT1           = 58;           /* if match exact then push, else jump. */
    int PUSH_IF_PEEK_NEXT             = 59;           /* if match exact then push, else none. */

    int REPEAT                        = 60;           /* {n,m} */
    int REPEAT_NG                     = 61;           /* {n,m}? (non greedy) */
    int REPEAT_INC                    = 62;
    int REPEAT_INC_NG                 = 63;           /* non greedy */
    int REPEAT_INC_SG                 = 64;           /* search and get in stack */
    int REPEAT_INC_NG_SG              = 65;           /* search and get in stack (non greedy) */

    int NULL_CHECK_START              = 66;           /* null loop checker start */
    int NULL_CHECK_END                = 67;           /* null loop checker end   */
    int NULL_CHECK_END_MEMST          = 68;           /* null loop checker end (with capture status) */
    int NULL_CHECK_END_MEMST_PUSH     = 69;           /* with capture status and push check-end */

    int PUSH_POS                      = 70;           /* (?=...)  start */
    int POP_POS                       = 71;           /* (?=...)  end   */
    int PUSH_POS_NOT                  = 72;           /* (?!...)  start */
    int FAIL_POS                      = 73;           /* (?!...)  end   */
    int PUSH_STOP_BT                  = 74;           /* (?>...)  start */
    int POP_STOP_BT                   = 75;           /* (?>...)  end   */
    int LOOK_BEHIND                   = 76;           /* (?<=...) start (no needs end opcode) */
    int PUSH_LOOK_BEHIND_NOT          = 77;           /* (?<!...) start */
    int FAIL_LOOK_BEHIND_NOT          = 78;           /* (?<!...) end   */

    int CALL                          = 79;           /* \g<name> */
    int RETURN                        = 80;

    int STATE_CHECK_PUSH              = 81;           /* combination explosion check and push */
    int STATE_CHECK_PUSH_OR_JUMP      = 82;           /* check ok -> push, else jump  */
    int STATE_CHECK                   = 83;           /* check only */
    int STATE_CHECK_ANYCHAR_STAR      = 84;
    int STATE_CHECK_ANYCHAR_ML_STAR   = 85;

      /* no need: IS_DYNAMIC_OPTION() == 0 */
    int SET_OPTION_PUSH               = 86;           /* set option and push recover option */
    int SET_OPTION                    = 87;           /* set option */

}
