/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_ga extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Me\u00e1n-Am Greenwich",
               "MAG",
               "",
               "",
               "",
               "",
            };
        final String[] Acre = new String[] {
               "Am Caighde\u00e1nach Acre",
               "",
               "Am Samhraidh Acre",
               "",
               "Am Acre",
               "",
            };
        final String[] Apia = new String[] {
               "Am Caighde\u00e1nach Apia",
               "",
               "Am Samhraidh Apia",
               "",
               "Am Apia",
               "",
            };
        final String[] Cook = new String[] {
               "Am Caighde\u00e1nach Oile\u00e1in Cook",
               "",
               "Am Leathshamhraidh Oile\u00e1in Cook",
               "",
               "Am Oile\u00e1in Cook",
               "",
            };
        final String[] Cuba = new String[] {
               "Am Caighde\u00e1nach Ch\u00faba",
               "",
               "Am Samhraidh Ch\u00faba",
               "",
               "Am Ch\u00faba",
               "",
            };
        final String[] Fiji = new String[] {
               "Am Caighde\u00e1nach Fhids\u00ed",
               "",
               "Am Samhraidh Fhids\u00ed",
               "",
               "Am Fhids\u00ed",
               "",
            };
        final String[] Gulf = new String[] {
               "Am Caighde\u00e1nach na Murascaille",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Am Caighde\u00e1nach Hovd",
               "",
               "Am Samhraidh Hovd",
               "",
               "Am Hovd",
               "",
            };
        final String[] Iran = new String[] {
               "Am Caighde\u00e1nach na hIar\u00e1ine",
               "",
               "Am Samhraidh na hIar\u00e1ine",
               "",
               "Am na hIar\u00e1ine",
               "",
            };
        final String[] Niue = new String[] {
               "Am Niue",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Am Caighde\u00e1nach Omsk",
               "",
               "Am Samhraidh Omsk",
               "",
               "Am Omsk",
               "",
            };
        final String[] Peru = new String[] {
               "Am Caighde\u00e1nach Pheiri\u00fa",
               "",
               "Am Samhraidh Pheiri\u00fa",
               "",
               "Am Pheiri\u00fa",
               "",
            };
        final String[] Truk = new String[] {
               "Am Chuuk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Am Oile\u00e1n Wake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Casey = new String[] {
               "Am St\u00e1isi\u00fan Casey",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Am Caighde\u00e1nach na Sile",
               "",
               "Am Samhraidh na Sile",
               "",
               "Am na Sile",
               "",
            };
        final String[] China = new String[] {
               "Am Caighde\u00e1nach na S\u00edne",
               "",
               "Am Samhraidh na S\u00edne",
               "",
               "Am na S\u00edne",
               "",
            };
        final String[] Cocos = new String[] {
               "Am Oile\u00e1in Cocos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Am St\u00e1isi\u00fan Davis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Am Caighde\u00e1nach na hIndia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Japan = new String[] {
               "Am Caighde\u00e1nach na Seap\u00e1ine",
               "",
               "Am Samhraidh na Seap\u00e1ine",
               "",
               "Am na Seap\u00e1ine",
               "",
            };
        final String[] Korea = new String[] {
               "Am Caighde\u00e1nach na C\u00f3ir\u00e9",
               "",
               "Am Samhraidh na C\u00f3ir\u00e9",
               "",
               "Am na C\u00f3ir\u00e9",
               "",
            };
        final String[] Nauru = new String[] {
               "Am N\u00e1r\u00fa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Am Neipeal",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Am Oile\u00e1in Palau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Am Caighde\u00e1nach Sham\u00f3",
               "",
               "Am Samhraidh Sham\u00f3",
               "",
               "Am Sham\u00f3",
               "",
            };
        final String[] Syowa = new String[] {
               "Am St\u00e1isi\u00fan Syowa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Am Caighde\u00e1nach Thonga",
               "",
               "Am Samhraidh Thonga",
               "",
               "Am Thonga",
               "",
            };
        final String[] Alaska = new String[] {
               "Am Caighde\u00e1nach Alasca",
               "",
               "Am Samhraidh Alasca",
               "",
               "Am Alasca",
               "",
            };
        final String[] Amazon = new String[] {
               "Am Caighde\u00e1nach na hAmas\u00f3ine",
               "",
               "Am Samhraidh na hAmas\u00f3ine",
               "",
               "Am na hAmas\u00f3ine",
               "",
            };
        final String[] Anadyr = new String[] {
               "Am Caighde\u00e1nach Anadyr",
               "",
               "Am Samhraidh Anadyr",
               "",
               "Am Anadyr",
               "",
            };
        final String[] Azores = new String[] {
               "Am Caighde\u00e1nach na nAs\u00f3r",
               "",
               "Am Samhraidh na nAs\u00f3r",
               "",
               "Am na nAs\u00f3r",
               "",
            };
        final String[] Bhutan = new String[] {
               "Am na B\u00fat\u00e1ine",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Am Br\u00fain\u00e9 Darasal\u00e1m",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Am Caighde\u00e1nach Oile\u00e1n na C\u00e1sca",
               "",
               "Am Samhraidh Oile\u00e1n na C\u00e1sca",
               "",
               "Am Oile\u00e1n na C\u00e1sca",
               "",
            };
        final String[] Guyana = new String[] {
               "Am na Gu\u00e1ine",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Am Caighde\u00e1nach Iosrael",
               "",
               "Am Samhraidh Iosrael",
               "",
               "Am Iosrael",
               "",
            };
        final String[] Kosrae = new String[] {
               "Am Kosrae",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Am St\u00e1isi\u00fan Mawson",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Am Caighde\u00e1nach Mhosc\u00f3",
               "",
               "Am Samhraidh Mhosc\u00f3",
               "",
               "Am Mhosc\u00f3",
               "",
            };
        final String[] Ponape = new String[] {
               "Am Phohnpei",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "Am Caighde\u00e1nach Shamara",
               "",
               "Am Samhraidh Shamara",
               "",
               "Am Shamara",
               "",
            };
        final String[] Tahiti = new String[] {
               "Am Thaih\u00edt\u00ed",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Am Caighde\u00e1nach Thaipei",
               "",
               "Am Samhraidh Thaipei",
               "",
               "Am Thaipei",
               "",
            };
        final String[] Tuvalu = new String[] {
               "Am Thuvalu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Am St\u00e1isi\u00fan Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Am Vail\u00eds agus Fut\u00fana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Am Caighde\u00e1nach na hAraibe",
               "",
               "Am Samhraidh na hAraibe",
               "",
               "Am na hAraibe",
               "",
            };
        final String[] Armenia = new String[] {
               "Am Caighde\u00e1nach na hAirm\u00e9ine",
               "",
               "Am Samhraidh na hAirm\u00e9ine",
               "",
               "Am na hAirm\u00e9ine",
               "",
            };
        final String[] Bolivia = new String[] {
               "Am na Bolaive",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Am Caighde\u00e1nach Chatham",
               "",
               "Am Samhraidh Chatham",
               "",
               "Am Chatham",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Am Uil\u00edoch L\u00e1rnach",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Am Eacuad\u00f3r",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Am Ghambier",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Am Caighde\u00e1nach na Seoirsia",
               "",
               "Am Samhraidh na Seoirsia",
               "",
               "Am na Seoirsia",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Am Caighde\u00e1nach Irkutsk",
               "",
               "Am Samhraidh Irkutsk",
               "",
               "Am Irkutsk",
               "",
            };
        final String[] Magadan = new String[] {
               "Am Caighde\u00e1nach Mhagadan",
               "",
               "Am Samhraidh Mhagadan",
               "",
               "Am Mhagadan",
               "",
            };
        final String[] Myanmar = new String[] {
               "Am Mhaenmar",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Am Oile\u00e1n Norfolk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Noronha = new String[] {
               "Am Caighde\u00e1nach Fhernando de Noronha",
               "",
               "Am Samhraidh Fhernando de Noronha",
               "",
               "Am Fhernando de Noronha",
               "",
            };
        final String[] Reunion = new String[] {
               "Am R\u00e9union",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Am St\u00e1isi\u00fan Rothera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Am Oile\u00e1in Sholom\u00f3n",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Am Oile\u00e1in T\u00f3cal\u00e1",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Am Caighde\u00e1nach Uragua",
               "",
               "Am Samhraidh Uragua",
               "",
               "Am Uragua",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Am Caighde\u00e1nach Vanuat\u00fa",
               "",
               "Am Samhraidh Vanuat\u00fa",
               "",
               "Am Vanuat\u00fa",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Am Caighde\u00e1nach Iac\u00fatsc",
               "",
               "Am Samhraidh Iac\u00fatsc",
               "",
               "Am Iac\u00fatsc",
               "",
            };
        final String[] Atlantic = new String[] {
               "Am Caighde\u00e1nach an Atlantaigh",
               "",
               "Am Samhraidh an Atlantaigh",
               "",
               "Am an Atlantaigh",
               "",
            };
        final String[] Brasilia = new String[] {
               "Am Caighde\u00e1nach Bhras\u00edlia",
               "",
               "Am Samhraidh Bhras\u00edlia",
               "",
               "Am Bhras\u00edlia",
               "",
            };
        final String[] Chamorro = new String[] {
               "Am Caighde\u00e1nach Seam\u00f3rach",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Colombia = new String[] {
               "Am Caighde\u00e1nach na Col\u00f3ime",
               "",
               "Am Samhraidh na Col\u00f3ime",
               "",
               "Am na Col\u00f3ime",
               "",
            };
        final String[] Falkland = new String[] {
               "Am Caighde\u00e1nach Oile\u00e1in Fh\u00e1clainne",
               "",
               "Am Samhraidh Oile\u00e1in Fh\u00e1clainne",
               "",
               "Am Oile\u00e1in Fh\u00e1clainne",
               "",
            };
        final String[] Malaysia = new String[] {
               "Am na Malaeisia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Am Oile\u00e1in Mhaild\u00edve",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Am Caighde\u00e1nach Ul\u00e1nb\u00e1tar",
               "",
               "Am Samhraidh Ul\u00e1nb\u00e1tar",
               "",
               "Am Ul\u00e1nb\u00e1tar",
               "",
            };
        final String[] Pakistan = new String[] {
               "Am Caighde\u00e1nach na Pacast\u00e1ine",
               "",
               "Am Samhraidh na Pacast\u00e1ine",
               "",
               "Am na Pacast\u00e1ine",
               "",
            };
        final String[] Paraguay = new String[] {
               "Am Caighde\u00e1nach Pharagua",
               "",
               "Am Samhraidh Pharagua",
               "",
               "Am Pharagua",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Am Oile\u00e1n Pitcairn",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Am Caighde\u00e1nach Shakhalin",
               "",
               "Am Samhraidh Shakhalin",
               "",
               "Am Shakhalin",
               "",
            };
        final String[] Suriname = new String[] {
               "Am Shuranam",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Am Caighde\u00e1nach na hAirgint\u00edne",
               "",
               "Am Samhraidh na hAirgint\u00edne",
               "",
               "Am na hAirgint\u00edne",
               "",
            };
        final String[] Christmas = new String[] {
               "Am Oile\u00e1n na Nollag",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Am Oile\u00e1in Gal\u00e1pagos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Am Caighde\u00e1nach Hong Cong",
               "",
               "Am Samhraidh Hong Cong",
               "",
               "Am Hong Cong",
               "",
            };
        final String[] Indochina = new String[] {
               "Am na hInd-S\u00edne",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Am Caighde\u00e1nach Phetropavlovsk-Kamchatski",
               "",
               "Am Samhraidh Phetropavlovsk-Kamchatski",
               "",
               "Am Phetropavlovsk-Kamchatski",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Am na Cirgeast\u00e1ine",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Am Caighde\u00e1nach Lord Howe",
               "",
               "Am Samhraidh Lord Howe",
               "",
               "Am Lord Howe",
               "",
            };
        final String[] Macquarie = new String[] {
               "Am Oile\u00e1n Mhic Guaire",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Marquesas = new String[] {
               "Am na nOile\u00e1n Marcasach",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Am Caighde\u00e1nach Oile\u00e1n Mhuir\u00eds",
               "",
               "Am Samhraidh Oile\u00e1n Mhuir\u00eds",
               "",
               "Am Oile\u00e1n Mhuir\u00eds",
               "",
            };
        final String[] Pyongyang = new String[] {
               "Am Pyongyang",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Singapore = new String[] {
               "Am Caighde\u00e1nach Shingeap\u00f3r",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Am Veinis\u00e9ala",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "Am Caighde\u00e1nach na hAsarbaise\u00e1ine",
               "",
               "Am Samhraidh na hAsarbaise\u00e1ine",
               "",
               "Am na hAsarbaise\u00e1ine",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Am Caighde\u00e1nach na Banglaid\u00e9ise",
               "",
               "Am Samhraidh na Banglaid\u00e9ise",
               "",
               "Am na Banglaid\u00e9ise",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Am Caighde\u00e1nach Rinn Verde",
               "",
               "Am Samhraidh Rinn Verde",
               "",
               "Am Rinn Verde",
               "",
            };
        final String[] Choibalsan = new String[] {
               "Am Caighde\u00e1nach Choibalsan",
               "",
               "Am Samhraidh Choibalsan",
               "",
               "Am Choibalsan",
               "",
            };
        final String[] East_Timor = new String[] {
               "Am Th\u00edom\u00f3r Thoir",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Am na S\u00e9is\u00e9al",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Am na T\u00e1ids\u00edceast\u00e1ine",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Am Caighde\u00e1nach na h\u00daisb\u00e9iceast\u00e1ine",
               "",
               "Am Samhraidh na h\u00daisb\u00e9iceast\u00e1ine",
               "",
               "Am na h\u00daisb\u00e9iceast\u00e1ine",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Am na hAfganast\u00e1ine",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Am Caighde\u00e1nach Krasnoyarsk",
               "",
               "Am Samhraidh Krasnoyarsk",
               "",
               "Am Krasnoyarsk",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Am Caighde\u00e1nach na Nua-Sh\u00e9alainne",
               "",
               "Am Samhraidh na Nua-Sh\u00e9alainne",
               "",
               "Am na Nua-Sh\u00e9alainne",
               "",
            };
        final String[] Novosibirsk = new String[] {
               "Am Caighde\u00e1nach Novosibirsk",
               "",
               "Am Samhraidh Novosibirsk",
               "",
               "Am Novosibirsk",
               "",
            };
        final String[] Philippines = new String[] {
               "Am Caighde\u00e1nach na nOile\u00e1n Filip\u00edneach",
               "",
               "Am Samhraidh na nOile\u00e1n Filip\u00edneach",
               "",
               "Am na nOile\u00e1n Filip\u00edneach",
               "",
            };
        final String[] Vladivostok = new String[] {
               "Am Caighde\u00e1nach Vladivostok",
               "",
               "Am Samhraidh Vladivostok",
               "",
               "Am Vladivostok",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Am an Aig\u00e9in Indiaigh",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Am Oile\u00e1in na L\u00edne",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Am Caighde\u00e1nach Thalamh an \u00c9isc",
               "",
               "Am Samhraidh Thalamh an \u00c9isc",
               "",
               "Am Thalamh an \u00c9isc",
               "",
            };
        final String[] Turkmenistan = new String[] {
               "Am Caighde\u00e1nach na Tuircm\u00e9anast\u00e1ine",
               "",
               "Am Samhraidh na Tuircm\u00e9anast\u00e1ine",
               "",
               "Am na Tuircm\u00e9anast\u00e1ine",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Am Ghu\u00e1in na Fraince",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Am Caighde\u00e1nach na Nua-Chalad\u00f3ine",
               "",
               "Am Samhraidh na Nua-Chalad\u00f3ine",
               "",
               "Am na Nua-Chalad\u00f3ine",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Am na Seoirsia Theas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Am Caighde\u00e1nach Yekaterinburg",
               "",
               "Am Samhraidh Yekaterinburg",
               "",
               "Am Yekaterinburg",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Am L\u00e1r na hAfraice",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Eastern = new String[] {
               "Am Oirthear na hAfraice",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Western = new String[] {
               "Am Caighde\u00e1nach Iarthar na hAfraice",
               "",
               "Am Samhraidh Iarthar na hAfraice",
               "",
               "Am Iarthar na hAfraice",
               "",
            };
        final String[] DumontDUrville = new String[] {
               "Am St\u00e1isi\u00fan Dumont-d\u2019Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Am Caighde\u00e1nach L\u00e1r na hEorpa",
               "CET",
               "Am Samhraidh L\u00e1r na hEorpa",
               "CEST",
               "Am L\u00e1r na hEorpa",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Am Caighde\u00e1nach Oirthear na hEorpa",
               "EET",
               "Am Samhraidh Oirthear na hEorpa",
               "EEST",
               "Am Oirthear na hEorpa",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Am Caighde\u00e1nach Iarthar na hEorpa",
               "WET",
               "Am Samhraidh Iarthar na hEorpa",
               "WEST",
               "Am Iarthar na hEorpa",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Am Caighde\u00e1nach Meicsiceach an Aig\u00e9in Chi\u00fain",
               "",
               "Am Samhraidh Meicsiceach an Aig\u00e9in Chi\u00fain",
               "",
               "Am Meicsiceach an Aig\u00e9in Chi\u00fain",
               "",
            };
        final String[] Africa_Southern = new String[] {
               "Am Caighde\u00e1nach na hAfraice Theas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] America_Central = new String[] {
               "Am Caighde\u00e1nach L\u00e1rnach",
               "",
               "Am Samhraidh L\u00e1rnach",
               "",
               "Am L\u00e1rnach",
               "",
            };
        final String[] America_Eastern = new String[] {
               "Am Caighde\u00e1nach an Oirthir",
               "",
               "Am Samhraidh an Oirthir",
               "",
               "Am an Oirthir",
               "",
            };
        final String[] America_Pacific = new String[] {
               "Am Caighde\u00e1nach an Aig\u00e9in Chi\u00fain",
               "ACAC",
               "Am Samhraidh an Aig\u00e9in Chi\u00fain",
               "ASAC",
               "Am an Aig\u00e9in Chi\u00fain",
               "AAC",
            };
        final String[] French_Southern = new String[] {
               "Am Chr\u00edocha Francacha Deisceart an Domhain",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Am Chireabait\u00ed",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Am Caighde\u00e1nach Hav\u00e1\u00ed-Aili\u00fait",
               "",
               "Am Samhraidh Hav\u00e1\u00ed-Aili\u00fait",
               "",
               "Am Hav\u00e1\u00ed-Aili\u00fait",
               "",
            };
        final String[] Phoenix_Islands = new String[] {
               "Am Oile\u00e1in an Fh\u00e9inics",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Am Caighde\u00e1nach Saint-Pierre-et-Miquelon",
               "",
               "Am Samhraidh Saint-Pierre-et-Miquelon",
               "",
               "Am Saint-Pierre-et-Miquelon",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Am Caighde\u00e1nach na Sl\u00e9ibhte",
               "",
               "Am Samhraidh na Sl\u00e9ibhte",
               "",
               "Am na Sl\u00e9ibhte",
               "",
            };
        final String[] Marshall_Islands = new String[] {
               "Am Oile\u00e1in Marshall",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mexico_Northwest = new String[] {
               "Am Caighde\u00e1nach Iarthuaisceart Mheicsiceo",
               "",
               "Am Samhraidh Iarthuaisceart Mheicsiceo",
               "",
               "Am Iarthuaisceart Mheicsiceo",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Am Nua-Ghuine Phapua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina_Western = new String[] {
               "Am Caighde\u00e1nach Iarthar na hAirgint\u00edne",
               "",
               "Am Samhraidh Iarthar na hAirgint\u00edne",
               "",
               "Am Iarthar na hAirgint\u00edne",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Am Caighde\u00e1nach L\u00e1r na hAstr\u00e1ile",
               "",
               "Am Samhraidh L\u00e1r na hAstr\u00e1ile",
               "",
               "Am L\u00e1r na hAstr\u00e1ile",
               "",
            };
        final String[] Australia_Eastern = new String[] {
               "Am Caighde\u00e1nach Oirthear na hAstr\u00e1ile",
               "",
               "Am Samhraidh Oirthear na hAstr\u00e1ile",
               "",
               "Am Oirthear na hAstr\u00e1ile",
               "",
            };
        final String[] Australia_Western = new String[] {
               "Am Caighde\u00e1nach Iarthar na hAstr\u00e1ile",
               "",
               "Am Samhraidh Iarthar na hAstr\u00e1ile",
               "",
               "Am Iarthar na hAstr\u00e1ile",
               "",
            };
        final String[] Greenland_Eastern = new String[] {
               "Am Caighde\u00e1nach Oirthear na Graonlainne",
               "",
               "Am Samhraidh Oirthear na Graonlainne",
               "",
               "Am Oirthear na Graonlainne",
               "",
            };
        final String[] Greenland_Western = new String[] {
               "Am Caighde\u00e1nach Iarthar na Graonlainne",
               "",
               "Am Samhraidh Iarthar na Graonlainne",
               "",
               "Am Iarthar na Graonlainne",
               "",
            };
        final String[] Indonesia_Central = new String[] {
               "Am L\u00e1r na hIndin\u00e9ise",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Am Oirthear na hIndin\u00e9ise",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Indonesia_Western = new String[] {
               "Am Iarthar na hIndin\u00e9ise",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Am Oirthear na Casacst\u00e1ine",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Am Iarthar na Casacst\u00e1ine",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Am Caighde\u00e1nach Mhe\u00e1niarthar na hAstr\u00e1ile",
               "",
               "Am Samhraidh Mhe\u00e1niarthar na hAstr\u00e1ile",
               "",
               "Am Mhe\u00e1niarthar na hAstr\u00e1ile",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "JST", Japan },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "SST", Solomon },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UTC", ETC_UTC },
            { "MST7MDT", America_Mountain },
            { "PST8PDT", America_Pacific },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan_Western },
            { "Asia/Amman", Europe_Eastern },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Africa/Juba", Africa_Eastern },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Truk },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kuching", Malaysia },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Damascus", Europe_Eastern },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Ust-Nera", Vladivostok },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Me\u00e1n-Am Greenwich",
                    "MAG",
                    "Am Caighd\u00e9anach na h\u00c9ireann",
                    "AC\u00c9",
                    "",
                    "",
                }
            },
            { "Europe/Jersey", GMT },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Me\u00e1n-Am Greenwich",
                    "MAG",
                    "Am Samhraidh na Breataine",
                    "ASB",
                    "",
                    "",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", America_Pacific },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "Asia/Chongqing", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Pyongyang },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Me\u00e1n-Am Greenwich",
                    "MAG",
                    "Am Samhraidh na Breataine",
                    "ASB",
                    "",
                    "",
                }
            },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Pacific/Easter", Easter },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Ponape },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Pacific/Wallis", Wallis },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", Africa_Western },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Godthab", Greenland_Western },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Phnom_Penh", Indochina },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/Perth", Australia_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey", GMT },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", Maldives },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Casey },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Moscow },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", America_Pacific },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Europe/Isle_of_Man", GMT },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Antarctica/Macquarie", Macquarie },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "\u00c1idin" },
            { "timezone.excity.Asia/Baku", "Baku" },
            { "timezone.excity.Asia/Dili", "Dili" },
            { "timezone.excity.Asia/Gaza", "Gaza" },
            { "timezone.excity.Asia/Hovd", "Hovd" },
            { "timezone.excity.Asia/Omsk", "Omsk" },
            { "timezone.excity.Asia/Oral", "Oral" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Amman" },
            { "timezone.excity.Asia/Aqtau", "Aqtau" },
            { "timezone.excity.Asia/Chita", "Chita" },
            { "timezone.excity.Asia/Dhaka", "Dhaka" },
            { "timezone.excity.Asia/Dubai", "Dubai" },
            { "timezone.excity.Asia/Kabul", "Cab\u00fal" },
            { "timezone.excity.Asia/Macau", "Macao" },
            { "timezone.excity.Asia/Qatar", "Catar" },
            { "timezone.excity.Asia/Seoul", "S\u00fal" },
            { "timezone.excity.Asia/Tokyo", "T\u00f3iceo" },
            { "timezone.excity.Asia/Tomsk", "Tomsk" },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "Juba" },
            { "timezone.excity.Africa/Lome", "Lome" },
            { "timezone.excity.Asia/Almaty", "Almaty" },
            { "timezone.excity.Asia/Anadyr", "Anadyr" },
            { "timezone.excity.Asia/Aqtobe", "Aqtobe" },
            { "timezone.excity.Asia/Atyrau", "Atyrau" },
            { "timezone.excity.Asia/Beirut", "B\u00e9iri\u00fat" },
            { "timezone.excity.Asia/Brunei", "Br\u00fain\u00e9" },
            { "timezone.excity.Asia/Hebron", "Heabr\u00f3n" },
            { "timezone.excity.Asia/Kuwait", "Cu\u00e1it" },
            { "timezone.excity.Asia/Manila", "Mainile" },
            { "timezone.excity.Asia/Muscat", "Muscat" },
            { "timezone.excity.Asia/Riyadh", "Riyadh" },
            { "timezone.excity.Asia/Saigon", "Cathair Ho Chi Minh" },
            { "timezone.excity.Asia/Taipei", "Taipei" },
            { "timezone.excity.Asia/Tehran", "Tehran" },
            { "timezone.excity.Asia/Urumqi", "Urumqi" },
            { "timezone.excity.Etc/Unknown", "Cathair Anaithnid" },
            { "timezone.excity.Europe/Kiev", "C\u00edv" },
            { "timezone.excity.Europe/Oslo", "Osl\u00f3" },
            { "timezone.excity.Europe/Riga", "R\u00edge" },
            { "timezone.excity.Europe/Rome", "an R\u00f3imh" },
            { "timezone.excity.Indian/Mahe", "Mahe" },
            { "timezone.excity.Africa/Accra", "Accra" },
            { "timezone.excity.Africa/Cairo", "Caireo" },
            { "timezone.excity.Africa/Ceuta", "Ceuta" },
            { "timezone.excity.Africa/Dakar", "Dac\u00e1r" },
            { "timezone.excity.Africa/Lagos", "Lagos" },
            { "timezone.excity.Africa/Tunis", "T\u00fainis" },
            { "timezone.excity.America/Adak", "Adak" },
            { "timezone.excity.America/Lima", "L\u00edoma" },
            { "timezone.excity.America/Nome", "Nome" },
            { "timezone.excity.Asia/Baghdad", "Bagdad" },
            { "timezone.excity.Asia/Bahrain", "Bair\u00e9in" },
            { "timezone.excity.Asia/Bangkok", "Bangkok" },
            { "timezone.excity.Asia/Barnaul", "Barnaul" },
            { "timezone.excity.Asia/Bishkek", "Bishkek" },
            { "timezone.excity.Asia/Colombo", "Colombo" },
            { "timezone.excity.Asia/Irkutsk", "Irkutsk" },
            { "timezone.excity.Asia/Jakarta", "Iac\u00e1rta" },
            { "timezone.excity.Asia/Karachi", "Karachi" },
            { "timezone.excity.Asia/Kuching", "Kuching" },
            { "timezone.excity.Asia/Magadan", "Magadan" },
            { "timezone.excity.Asia/Nicosia", "an Nioc\u00f3is" },
            { "timezone.excity.Asia/Rangoon", "Rang\u00fan" },
            { "timezone.excity.Asia/Tbilisi", "Tbilisi" },
            { "timezone.excity.Asia/Thimphu", "Thimphu" },
            { "timezone.excity.Asia/Yakutsk", "Iac\u00fatsc" },
            { "timezone.excity.Asia/Yerevan", "Eireav\u00e1n" },
            { "timezone.excity.Europe/Kirov", "Kirov" },
            { "timezone.excity.Europe/Malta", "M\u00e1lta" },
            { "timezone.excity.Europe/Minsk", "Mionsc" },
            { "timezone.excity.Europe/Paris", "P\u00e1ras" },
            { "timezone.excity.Europe/Sofia", "S\u00f3ifia" },
            { "timezone.excity.Europe/Vaduz", "Vad\u00fas" },
            { "timezone.excity.Indian/Cocos", "Oile\u00e1n Cocos" },
            { "timezone.excity.Pacific/Apia", "Apia" },
            { "timezone.excity.Pacific/Fiji", "Fids\u00ed" },
            { "timezone.excity.Pacific/Guam", "Guam" },
            { "timezone.excity.Pacific/Niue", "Niue" },
            { "timezone.excity.Pacific/Wake", "Oile\u00e1n Wake" },
            { "timezone.excity.Africa/Bamako", "Bamako" },
            { "timezone.excity.Africa/Bangui", "Bangui" },
            { "timezone.excity.Africa/Banjul", "Banjul" },
            { "timezone.excity.Africa/Bissau", "Bissau" },
            { "timezone.excity.Africa/Douala", "Douala" },
            { "timezone.excity.Africa/Harare", "Harare" },
            { "timezone.excity.Africa/Kigali", "Kigali" },
            { "timezone.excity.Africa/Luanda", "Luanda" },
            { "timezone.excity.Africa/Lusaka", "Lusaka" },
            { "timezone.excity.Africa/Malabo", "Malabo" },
            { "timezone.excity.Africa/Maputo", "Map\u00fat\u00f3" },
            { "timezone.excity.Africa/Maseru", "Maseru" },
            { "timezone.excity.Africa/Niamey", "Niamey" },
            { "timezone.excity.America/Aruba", "Ar\u00faba" },
            { "timezone.excity.America/Bahia", "Bahia" },
            { "timezone.excity.America/Belem", "Bel\u00e9m" },
            { "timezone.excity.America/Boise", "Boise" },
            { "timezone.excity.America/Jujuy", "Jujuy" },
            { "timezone.excity.America/Sitka", "Sitka" },
            { "timezone.excity.America/Thule", "Thule" },
            { "timezone.excity.Asia/Ashgabat", "Ashgabat" },
            { "timezone.excity.Asia/Calcutta", "Calc\u00fata" },
            { "timezone.excity.Asia/Damascus", "an Damaisc" },
            { "timezone.excity.Asia/Dushanbe", "Dushanbe" },
            { "timezone.excity.Asia/Jayapura", "Jayapura" },
            { "timezone.excity.Asia/Khandyga", "Khandyga" },
            { "timezone.excity.Asia/Makassar", "Makassar" },
            { "timezone.excity.Asia/Sakhalin", "Sakhalin" },
            { "timezone.excity.Asia/Shanghai", "Shang-hai" },
            { "timezone.excity.Asia/Tashkent", "Tashkent" },
            { "timezone.excity.Asia/Ust-Nera", "Ust-Nera" },
            { "timezone.excity.Europe/Athens", "an Aithin" },
            { "timezone.excity.Europe/Berlin", "Beirl\u00edn" },
            { "timezone.excity.Europe/Dublin", "Baile \u00c1tha Cliath" },
            { "timezone.excity.Europe/Jersey", "Geirs\u00ed" },
            { "timezone.excity.Europe/Lisbon", "Liosp\u00f3in" },
            { "timezone.excity.Europe/London", "Londain" },
            { "timezone.excity.Europe/Madrid", "Maidrid" },
            { "timezone.excity.Europe/Monaco", "Monac\u00f3" },
            { "timezone.excity.Europe/Moscow", "Mosc\u00f3" },
            { "timezone.excity.Europe/Prague", "Pr\u00e1g" },
            { "timezone.excity.Europe/Samara", "Samara" },
            { "timezone.excity.Europe/Skopje", "Sc\u00f3ip\u00e9" },
            { "timezone.excity.Europe/Tirane", "Tirane" },
            { "timezone.excity.Europe/Vienna", "V\u00edn" },
            { "timezone.excity.Europe/Warsaw", "V\u00e1rs\u00e1" },
            { "timezone.excity.Europe/Zagreb", "S\u00e1grab" },
            { "timezone.excity.Europe/Zurich", "Z\u00fcrich" },
            { "timezone.excity.Indian/Chagos", "Chagos" },
            { "timezone.excity.Indian/Comoro", "Oile\u00e1in Chom\u00f3ra" },
            { "timezone.excity.Pacific/Efate", "Efate" },
            { "timezone.excity.Pacific/Nauru", "N\u00e1r\u00fa" },
            { "timezone.excity.Pacific/Palau", "Palau" },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "Abidjan" },
            { "timezone.excity.Africa/Algiers", "Cathair na hAilg\u00e9ire" },
            { "timezone.excity.Africa/Conakry", "Conacra\u00ed" },
            { "timezone.excity.Africa/Kampala", "Kampala" },
            { "timezone.excity.Africa/Mbabane", "Mbabane" },
            { "timezone.excity.Africa/Nairobi", "Nairobi" },
            { "timezone.excity.Africa/Tripoli", "Tripil\u00ed" },
            { "timezone.excity.America/Belize", "an Bheil\u00eds" },
            { "timezone.excity.America/Bogota", "Bogat\u00e1" },
            { "timezone.excity.America/Cayman", "Cayman" },
            { "timezone.excity.America/Cuiaba", "Cuiab\u00e1" },
            { "timezone.excity.America/Dawson", "Dawson" },
            { "timezone.excity.America/Denver", "Denver" },
            { "timezone.excity.America/Guyana", "an Ghu\u00e1in" },
            { "timezone.excity.America/Havana", "Hav\u00e1na" },
            { "timezone.excity.America/Inuvik", "Inuvik" },
            { "timezone.excity.America/Juneau", "Juneau" },
            { "timezone.excity.America/La_Paz", "La Paz" },
            { "timezone.excity.America/Maceio", "Macei\u00f3" },
            { "timezone.excity.America/Manaus", "Manaus" },
            { "timezone.excity.America/Merida", "Merida" },
            { "timezone.excity.America/Nassau", "Nassau" },
            { "timezone.excity.America/Panama", "Panama" },
            { "timezone.excity.America/Recife", "Recife" },
            { "timezone.excity.America/Regina", "Regina" },
            { "timezone.excity.Asia/Famagusta", "Famagusta" },
            { "timezone.excity.Asia/Hong_Kong", "Hong Cong" },
            { "timezone.excity.Asia/Jerusalem", "Iar\u00fasail\u00e9im" },
            { "timezone.excity.Asia/Kamchatka", "Kamchatka" },
            { "timezone.excity.Asia/Pontianak", "Pontianak" },
            { "timezone.excity.Asia/Pyongyang", "Pyongyang" },
            { "timezone.excity.Asia/Qyzylorda", "Qyzylorda" },
            { "timezone.excity.Asia/Samarkand", "Samarkand" },
            { "timezone.excity.Asia/Singapore", "Singeap\u00f3r" },
            { "timezone.excity.Asia/Vientiane", "Vientiane" },
            { "timezone.excity.Europe/Andorra", "And\u00f3ra" },
            { "timezone.excity.Europe/Saratov", "Saratov" },
            { "timezone.excity.Europe/Tallinn", "Taillinn" },
            { "timezone.excity.Europe/Vatican", "Cathair na Vatac\u00e1ine" },
            { "timezone.excity.Europe/Vilnius", "Vilnias" },
            { "timezone.excity.Indian/Mayotte", "Mayotte" },
            { "timezone.excity.Indian/Reunion", "La R\u00e9union" },
            { "timezone.excity.Pacific/Easter", "Oile\u00e1n na C\u00e1sca" },
            { "timezone.excity.Pacific/Kosrae", "Kosrae" },
            { "timezone.excity.Pacific/Majuro", "Majuro" },
            { "timezone.excity.Pacific/Midway", "Oile\u00e1in Midway" },
            { "timezone.excity.Pacific/Noumea", "Noumea" },
            { "timezone.excity.Pacific/Saipan", "Saipan" },
            { "timezone.excity.Pacific/Tahiti", "Taih\u00edt\u00ed" },
            { "timezone.excity.Pacific/Tarawa", "Tarawa" },
            { "timezone.excity.Pacific/Wallis", "Vail\u00eds" },
            { "timezone.excity.Africa/Blantyre", "Baile an tSaoir" },
            { "timezone.excity.Africa/Djibouti", "Djibouti" },
            { "timezone.excity.Africa/El_Aaiun", "El Aaiun" },
            { "timezone.excity.Africa/Freetown", "Freetown" },
            { "timezone.excity.Africa/Gaborone", "Gaborone" },
            { "timezone.excity.Africa/Khartoum", "Cart\u00fam" },
            { "timezone.excity.Africa/Kinshasa", "Cinseasa" },
            { "timezone.excity.Africa/Monrovia", "Monrovia" },
            { "timezone.excity.Africa/Ndjamena", "Ndjamena" },
            { "timezone.excity.Africa/Sao_Tome", "S\u00e3o Tom\u00e9" },
            { "timezone.excity.Africa/Windhoek", "Windhoek" },
            { "timezone.excity.America/Antigua", "Antigua" },
            { "timezone.excity.America/Caracas", "Caracas" },
            { "timezone.excity.America/Cayenne", "Cayenne" },
            { "timezone.excity.America/Chicago", "Chicago" },
            { "timezone.excity.America/Cordoba", "C\u00f3rdoba" },
            { "timezone.excity.America/Creston", "Creston" },
            { "timezone.excity.America/Curacao", "Cura\u00e7ao" },
            { "timezone.excity.America/Detroit", "Detroit" },
            { "timezone.excity.America/Grenada", "Grean\u00e1da" },
            { "timezone.excity.America/Halifax", "Halifax" },
            { "timezone.excity.America/Iqaluit", "Iqaluit" },
            { "timezone.excity.America/Jamaica", "Iam\u00e1ice" },
            { "timezone.excity.America/Managua", "Managua" },
            { "timezone.excity.America/Marigot", "Marigot" },
            { "timezone.excity.America/Mendoza", "Mendoza" },
            { "timezone.excity.America/Moncton", "Moncton" },
            { "timezone.excity.America/Nipigon", "Nipigon" },
            { "timezone.excity.America/Noronha", "Noronha" },
            { "timezone.excity.America/Ojinaga", "Ojinaga" },
            { "timezone.excity.America/Phoenix", "Phoenix" },
            { "timezone.excity.America/Tijuana", "Tijuana" },
            { "timezone.excity.America/Toronto", "Toronto" },
            { "timezone.excity.America/Tortola", "Tortola" },
            { "timezone.excity.America/Yakutat", "Yakutat" },
            { "timezone.excity.Asia/Choibalsan", "Choibalsan" },
            { "timezone.excity.Asia/Phnom_Penh", "Phnom Penh" },
            { "timezone.excity.Atlantic/Azores", "na hAs\u00f3ir" },
            { "timezone.excity.Atlantic/Canary", "na hOile\u00e1in Chan\u00e1racha" },
            { "timezone.excity.Atlantic/Faeroe", "Oile\u00e1in Fhar\u00f3" },
            { "timezone.excity.Australia/Eucla", "Eucla" },
            { "timezone.excity.Australia/Perth", "Perth" },
            { "timezone.excity.Europe/Belgrade", "B\u00e9algr\u00e1d" },
            { "timezone.excity.Europe/Brussels", "an Bhruis\u00e9il" },
            { "timezone.excity.Europe/Budapest", "B\u00fadaipeist" },
            { "timezone.excity.Europe/Busingen", "Busingen" },
            { "timezone.excity.Europe/Chisinau", "C\u00edsine\u00e1" },
            { "timezone.excity.Europe/Guernsey", "Geansa\u00ed" },
            { "timezone.excity.Europe/Helsinki", "Heilsinc\u00ed" },
            { "timezone.excity.Europe/Istanbul", "Iostanb\u00fal" },
            { "timezone.excity.Europe/Sarajevo", "Sair\u00e9av\u00f3" },
            { "timezone.excity.Europe/Uzhgorod", "Uzhgorod" },
            { "timezone.excity.Indian/Maldives", "Oile\u00e1in Mhaild\u00edve" },
            { "timezone.excity.Pacific/Chatham", "Chatham" },
            { "timezone.excity.Pacific/Fakaofo", "Fakaofo" },
            { "timezone.excity.Pacific/Gambier", "Gambier" },
            { "timezone.excity.Pacific/Norfolk", "Norfolk" },
            { "timezone.excity.Africa/Bujumbura", "Bujumbura" },
            { "timezone.excity.Africa/Mogadishu", "Mogaidisi\u00fa" },
            { "timezone.excity.America/Anguilla", "Anga\u00edle" },
            { "timezone.excity.America/Asuncion", "As\u00fainseon" },
            { "timezone.excity.America/Barbados", "Barbad\u00f3s" },
            { "timezone.excity.America/Dominica", "Doiminice" },
            { "timezone.excity.America/Edmonton", "Edmonton" },
            { "timezone.excity.America/Eirunepe", "Eirunep\u00e9" },
            { "timezone.excity.America/Mazatlan", "Mazatlan" },
            { "timezone.excity.America/Miquelon", "Miquelon" },
            { "timezone.excity.America/New_York", "Nua-Eabhrac" },
            { "timezone.excity.America/Resolute", "Resolute" },
            { "timezone.excity.America/Santarem", "Santar\u00e9m" },
            { "timezone.excity.America/Santiago", "Saintiag\u00f3" },
            { "timezone.excity.America/St_Kitts", "San Cr\u00edost\u00f3ir" },
            { "timezone.excity.America/Winnipeg", "Winnipeg" },
            { "timezone.excity.Antarctica/Casey", "Casey" },
            { "timezone.excity.Antarctica/Davis", "Davis" },
            { "timezone.excity.Antarctica/Syowa", "Syowa" },
            { "timezone.excity.Antarctica/Troll", "Troll" },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnoyarsk" },
            { "timezone.excity.Asia/Novosibirsk", "Novosibirsk" },
            { "timezone.excity.Asia/Ulaanbaatar", "Ulaanbaatar" },
            { "timezone.excity.Asia/Vladivostok", "Vladivostok" },
            { "timezone.excity.Atlantic/Bermuda", "Beirmi\u00fada" },
            { "timezone.excity.Atlantic/Madeira", "Maid\u00e9ara" },
            { "timezone.excity.Atlantic/Stanley", "Stanley" },
            { "timezone.excity.Australia/Currie", "Currie" },
            { "timezone.excity.Australia/Darwin", "Darwin" },
            { "timezone.excity.Australia/Hobart", "Hobart" },
            { "timezone.excity.Australia/Sydney", "Sydney" },
            { "timezone.excity.Europe/Amsterdam", "Amstardam" },
            { "timezone.excity.Europe/Astrakhan", "an Astrac\u00e1in" },
            { "timezone.excity.Europe/Bucharest", "B\u00facairist" },
            { "timezone.excity.Europe/Gibraltar", "Giobr\u00e1ltar" },
            { "timezone.excity.Europe/Ljubljana", "Li\u00faible\u00e1na" },
            { "timezone.excity.Europe/Mariehamn", "Mariehamn" },
            { "timezone.excity.Europe/Podgorica", "Podgair\u00edtse" },
            { "timezone.excity.Europe/Stockholm", "St\u00f3c\u00f3lm" },
            { "timezone.excity.Europe/Ulyanovsk", "Ulyanovsk" },
            { "timezone.excity.Europe/Volgograd", "Volgograd" },
            { "timezone.excity.Indian/Christmas", "Oile\u00e1n na Nollag" },
            { "timezone.excity.Indian/Kerguelen", "Kerguelen" },
            { "timezone.excity.Indian/Mauritius", "Oile\u00e1n Mhuir\u00eds" },
            { "timezone.excity.Pacific/Auckland", "Auckland" },
            { "timezone.excity.Pacific/Funafuti", "Funafuti" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "timezone.excity.Pacific/Johnston", "Johnston" },
            { "timezone.excity.Pacific/Pitcairn", "Pitcairn" },
            { "timezone.excity.Africa/Casablanca", "Casablanca" },
            { "timezone.excity.Africa/Libreville", "Libreville" },
            { "timezone.excity.Africa/Lubumbashi", "Lubumbashi" },
            { "timezone.excity.Africa/Nouakchott", "Nuacsat" },
            { "timezone.excity.Africa/Porto-Novo", "Porto-Novo" },
            { "timezone.excity.America/Anchorage", "Anchorage" },
            { "timezone.excity.America/Araguaina", "Araguaina" },
            { "timezone.excity.America/Boa_Vista", "Boa Vista" },
            { "timezone.excity.America/Catamarca", "Catamarca" },
            { "timezone.excity.America/Chihuahua", "Chihuahua" },
            { "timezone.excity.America/Fortaleza", "Fortaleza" },
            { "timezone.excity.America/Glace_Bay", "Glace Bay" },
            { "timezone.excity.America/Goose_Bay", "Goose Bay" },
            { "timezone.excity.America/Guatemala", "Guatamala" },
            { "timezone.excity.America/Guayaquil", "Guayaquil" },
            { "timezone.excity.America/Matamoros", "Matamoros" },
            { "timezone.excity.America/Menominee", "Menominee" },
            { "timezone.excity.America/Monterrey", "Monterrey" },
            { "timezone.excity.America/Sao_Paulo", "S\u00e3o Paulo" },
            { "timezone.excity.America/Vancouver", "Vancouver" },
            { "timezone.excity.Antarctica/Mawson", "Mawson" },
            { "timezone.excity.Antarctica/Palmer", "Palmer" },
            { "timezone.excity.Antarctica/Vostok", "Vostok" },
            { "timezone.excity.Asia/Kuala_Lumpur", "Kuala Lumpur" },
            { "timezone.excity.Asia/Novokuznetsk", "Novokuznetsk" },
            { "timezone.excity.Europe/Bratislava", "an Bhratasl\u00e1iv" },
            { "timezone.excity.Europe/Copenhagen", "C\u00f3banh\u00e1van" },
            { "timezone.excity.Europe/Luxembourg", "Lucsamburg" },
            { "timezone.excity.Europe/San_Marino", "San Mair\u00edne" },
            { "timezone.excity.Europe/Simferopol", "Simferopol" },
            { "timezone.excity.Europe/Zaporozhye", "Zaporozhye" },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.Pacific/Galapagos", "Gal\u00e1pagos" },
            { "timezone.excity.Pacific/Kwajalein", "Kwajalein" },
            { "timezone.excity.Pacific/Marquesas", "na hOile\u00e1in Mharcasacha" },
            { "timezone.excity.Pacific/Pago_Pago", "Pago Pago" },
            { "timezone.excity.Pacific/Rarotonga", "Rarotonga" },
            { "timezone.excity.Pacific/Tongatapu", "Tongatapu" },
            { "timezone.excity.Africa/Addis_Ababa", "Adas Ababa" },
            { "timezone.excity.Africa/Brazzaville", "Brazzaville" },
            { "timezone.excity.Africa/Ouagadougou", "Ouagadougou" },
            { "timezone.excity.America/Costa_Rica", "C\u00f3sta R\u00edce" },
            { "timezone.excity.America/Grand_Turk", "Grand Turk" },
            { "timezone.excity.America/Guadeloupe", "Guadal\u00faip" },
            { "timezone.excity.America/Hermosillo", "Hermosillo" },
            { "timezone.excity.America/Kralendijk", "Kralendijk" },
            { "timezone.excity.America/Louisville", "Louisville" },
            { "timezone.excity.America/Martinique", "Martinique" },
            { "timezone.excity.America/Metlakatla", "Metlakatla" },
            { "timezone.excity.America/Montevideo", "Montevideo" },
            { "timezone.excity.America/Montserrat", "Montsarat" },
            { "timezone.excity.America/Paramaribo", "Paramaribo" },
            { "timezone.excity.America/Rio_Branco", "Rio Branco" },
            { "timezone.excity.America/St_Vincent", "San Uinseann" },
            { "timezone.excity.America/Whitehorse", "Whitehorse" },
            { "timezone.excity.Antarctica/McMurdo", "McMurdo" },
            { "timezone.excity.Antarctica/Rothera", "Rothera" },
            { "timezone.excity.Asia/Srednekolymsk", "Srednekolymsk" },
            { "timezone.excity.Asia/Yekaterinburg", "Yekaterinburg" },
            { "timezone.excity.Atlantic/Reykjavik", "R\u00e9iciv\u00edc" },
            { "timezone.excity.Atlantic/St_Helena", "San H\u00e9ilin" },
            { "timezone.excity.Australia/Adelaide", "Adelaide" },
            { "timezone.excity.Australia/Brisbane", "Brisbane" },
            { "timezone.excity.Australia/Lindeman", "Lindeman" },
            { "timezone.excity.Europe/Isle_of_Man", "Oile\u00e1n Mhanann" },
            { "timezone.excity.Europe/Kaliningrad", "Kaliningrad" },
            { "timezone.excity.Pacific/Kiritimati", "Kiritimati" },
            { "timezone.excity.Africa/Johannesburg", "Johannesburg" },
            { "timezone.excity.America/El_Salvador", "an tSalvad\u00f3ir" },
            { "timezone.excity.America/Fort_Nelson", "Fort Nelson" },
            { "timezone.excity.America/Los_Angeles", "Los Angeles" },
            { "timezone.excity.America/Mexico_City", "Cathair Mheicsiceo" },
            { "timezone.excity.America/Pangnirtung", "Pangnirtung" },
            { "timezone.excity.America/Porto_Velho", "Porto Velho" },
            { "timezone.excity.America/Puerto_Rico", "Port\u00f3 R\u00edce" },
            { "timezone.excity.America/Rainy_River", "Rainy River" },
            { "timezone.excity.America/Tegucigalpa", "Tegucigalpa" },
            { "timezone.excity.America/Thunder_Bay", "Thunder Bay" },
            { "timezone.excity.America/Yellowknife", "Yellowknife" },
            { "timezone.excity.Arctic/Longyearbyen", "Longyearbyen" },
            { "timezone.excity.Atlantic/Cape_Verde", "Rinn Verde" },
            { "timezone.excity.Australia/Lord_Howe", "Lord Howe" },
            { "timezone.excity.Australia/Melbourne", "Melbourne" },
            { "timezone.excity.Indian/Antananarivo", "Antananair\u00edveo" },
            { "timezone.excity.Pacific/Guadalcanal", "Guadalcanal" },
            { "timezone.excity.Africa/Dar_es_Salaam", "D\u00e1rasal\u00e1m" },
            { "timezone.excity.America/Blanc-Sablon", "Blanc-Sablon" },
            { "timezone.excity.America/Buenos_Aires", "Buenos Aires" },
            { "timezone.excity.America/Campo_Grande", "Campo Grande" },
            { "timezone.excity.America/Danmarkshavn", "Danmarkshavn" },
            { "timezone.excity.America/Dawson_Creek", "Dawson Creek" },
            { "timezone.excity.America/Indianapolis", "Indianapolis" },
            { "timezone.excity.America/Punta_Arenas", "Punta Arenas" },
            { "timezone.excity.America/Rankin_Inlet", "Rankin Inlet" },
            { "timezone.excity.America/Santa_Isabel", "Santa Isabel" },
            { "timezone.excity.Antarctica/Macquarie", "Mac Guaire" },
            { "timezone.excity.Pacific/Bougainville", "Bougainville" },
            { "timezone.excity.Pacific/Port_Moresby", "Port Moresby" },
            { "timezone.excity.America/Cambridge_Bay", "Cambridge Bay" },
            { "timezone.excity.America/Port_of_Spain", "Port of Spain" },
            { "timezone.excity.America/Santo_Domingo", "Santo Domingo" },
            { "timezone.excity.America/St_Barthelemy", "Saint Barth\u00e9lemy" },
            { "timezone.excity.America/Swift_Current", "Swift Current" },
            { "timezone.excity.Australia/Broken_Hill", "Broken Hill" },
            { "timezone.excity.America/Bahia_Banderas", "Bahia Banderas" },
            { "timezone.excity.America/Port-au-Prince", "Port-au-Prince" },
            { "timezone.excity.Atlantic/South_Georgia", "an tSeoirsia Theas" },
            { "timezone.excity.America/Argentina/Salta", "Salta" },
            { "timezone.excity.America/Argentina/Tucuman", "Tucuman" },
            { "timezone.excity.America/Argentina/Ushuaia", "Ushuaia" },
            { "timezone.excity.America/Argentina/La_Rioja", "La Rioja" },
            { "timezone.excity.America/Argentina/San_Juan", "San Juan" },
            { "timezone.excity.America/Argentina/San_Luis", "San Luis" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "Rio Gallegos" },
        };
        return data;
    }
}
