/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ec;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.SM2ParameterSpec;
import java.security.spec.SM2SignatureParameterSpec;
import sun.security.ec.ECOperations;
import sun.security.ec.point.MutablePoint;
import sun.security.jca.JCAUtil;
import sun.security.provider.SM3MessageDigest;
import sun.security.util.ArrayUtil;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.SMUtil;

public final class SM2Signature
extends SignatureSpi {
    private static final byte[] DEFAULT_ID = new byte[]{49, 50, 51, 52, 53, 54, 55, 56, 49, 50, 51, 52, 53, 54, 55, 56};
    private BigInteger privS;
    private ECPoint pubPoint;
    private byte[] id;
    private SecureRandom random;
    private byte[] z;
    private final MessageDigest sm3MD = new SM3MessageDigest();
    private static final byte[] A = SMUtil.bigIntToBytes32((BigInteger)SM2ParameterSpec.CURVE.getA());
    private static final byte[] B = SMUtil.bigIntToBytes32((BigInteger)SM2ParameterSpec.CURVE.getB());
    private static final byte[] GEN_X = SMUtil.bigIntToBytes32((BigInteger)SM2ParameterSpec.GENERATOR.getAffineX());
    private static final byte[] GEN_Y = SMUtil.bigIntToBytes32((BigInteger)SM2ParameterSpec.GENERATOR.getAffineY());

    @Override
    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        this.privS = null;
        this.z = null;
        if (!(privateKey instanceof ECPrivateKey)) {
            throw new InvalidKeyException("Only ECPrivateKey accepted");
        }
        ECPrivateKey eCPrivateKey = (ECPrivateKey)privateKey;
        BigInteger bigInteger = eCPrivateKey.getS();
        if (bigInteger.compareTo(BigInteger.ZERO) <= 0 || bigInteger.compareTo(SM2ParameterSpec.ORDER.subtract(BigInteger.ONE)) >= 0) {
            throw new InvalidKeyException("The private key must be within the range [1, n - 2]");
        }
        if (this.pubPoint == null) {
            this.pubPoint = ECOperations.toECPoint(ECOperations.SM2OPS.multiply(ECOperations.SM2OPS.toAffPoint(SM2ParameterSpec.GENERATOR), SMUtil.toByteArrayLE((BigInteger)bigInteger)));
        } else {
            SMUtil.validatePublicKey((ECPoint)this.pubPoint, (ECParameterSpec)SM2ParameterSpec.instance());
        }
        this.privS = bigInteger;
        SecureRandom secureRandom2 = this.random = secureRandom != null ? secureRandom : JCAUtil.getSecureRandom();
        if (this.id == null) {
            this.id = DEFAULT_ID;
        }
        this.resetDigest();
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.engineInitSign(privateKey, null);
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        this.privS = null;
        this.pubPoint = null;
        this.z = null;
        if (!(publicKey instanceof ECPublicKey)) {
            throw new InvalidKeyException("Only ECPublicKey accepted");
        }
        ECPublicKey eCPublicKey = (ECPublicKey)publicKey;
        SMUtil.validatePublicKey((ECPoint)eCPublicKey.getW(), (ECParameterSpec)SM2ParameterSpec.instance());
        this.pubPoint = eCPublicKey.getW();
        if (this.id == null) {
            this.id = DEFAULT_ID;
        }
        this.resetDigest();
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof SM2SignatureParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Only accept SM2SignatureParameterSpec");
        }
        SM2SignatureParameterSpec sM2SignatureParameterSpec = (SM2SignatureParameterSpec)algorithmParameterSpec;
        this.pubPoint = sM2SignatureParameterSpec.getPublicKey().getW();
        this.id = sM2SignatureParameterSpec.getId();
    }

    @Override
    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new UnsupportedOperationException("Use SetParameter(AlgorithmParameterSpec params) instead");
    }

    @Override
    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw new UnsupportedOperationException("getParameter(String param) not supported");
    }

    private void resetDigest() {
        this.sm3MD.reset();
        if (this.z == null) {
            this.z = this.z();
        }
        this.sm3MD.update(this.z);
    }

    private byte[] getDigestValue() {
        byte[] byArray = this.sm3MD.digest();
        this.resetDigest();
        return byArray;
    }

    @Override
    protected void engineUpdate(byte by) throws SignatureException {
        this.sm3MD.update(by);
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        this.sm3MD.update(byArray, n, n2);
    }

    @Override
    protected void engineUpdate(ByteBuffer byteBuffer) {
        int n = byteBuffer.remaining();
        if (n <= 0) {
            return;
        }
        this.sm3MD.update(byteBuffer);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        MutablePoint mutablePoint;
        BigInteger bigInteger3;
        if (this.privS == null) {
            throw new SignatureException("Private key not initialized");
        }
        byte[] byArray = this.getDigestValue();
        BigInteger bigInteger4 = new BigInteger(1, byArray);
        do {
            byte[] byArray2 = this.nextK();
            mutablePoint = ECOperations.SM2OPS.multiply(ECOperations.SM2OPS.toAffPoint(SM2ParameterSpec.GENERATOR), byArray2);
            ArrayUtil.reverse(byArray2);
            bigInteger2 = new BigInteger(1, byArray2);
        } while ((bigInteger3 = bigInteger4.add(ECOperations.toECPoint(mutablePoint).getAffineX()).mod(SM2ParameterSpec.ORDER)).equals(BigInteger.ZERO) || bigInteger3.add(bigInteger2).equals(SM2ParameterSpec.ORDER) || (bigInteger = this.privS.add(BigInteger.ONE).modInverse(SM2ParameterSpec.ORDER).multiply(bigInteger2.subtract(bigInteger3.multiply(this.privS)).mod(SM2ParameterSpec.ORDER)).mod(SM2ParameterSpec.ORDER)).equals(BigInteger.ZERO));
        return this.encodeSignature(bigInteger3, bigInteger);
    }

    private byte[] nextK() {
        return ECOperations.SM2OPS.generatePrivateScalar(this.random);
    }

    private byte[] encodeSignature(BigInteger bigInteger, BigInteger bigInteger2) throws SignatureException {
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putInteger(bigInteger);
            derOutputStream.putInteger(bigInteger2);
            DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
            return derValue.toByteArray();
        }
        catch (Exception exception) {
            throw new SignatureException("Could not encode signature", exception);
        }
    }

    @Override
    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        if (this.pubPoint == null) {
            throw new SignatureException("Public key not initialized");
        }
        try {
            SMUtil.validatePublicKey((ECPoint)this.pubPoint, (ECParameterSpec)SM2ParameterSpec.instance());
        }
        catch (InvalidKeyException invalidKeyException) {
            return false;
        }
        BigInteger[] bigIntegerArray = this.decodeSignature(byArray);
        BigInteger bigInteger = bigIntegerArray[0];
        BigInteger bigInteger2 = bigIntegerArray[1];
        if (bigInteger.compareTo(BigInteger.ONE) < 0 || bigInteger.compareTo(SM2ParameterSpec.ORDER) >= 0) {
            return false;
        }
        if (bigInteger2.compareTo(BigInteger.ONE) < 0 || bigInteger2.compareTo(SM2ParameterSpec.ORDER) >= 0) {
            return false;
        }
        byte[] byArray2 = this.getDigestValue();
        BigInteger bigInteger3 = new BigInteger(1, byArray2);
        BigInteger bigInteger4 = bigInteger.add(bigInteger2).mod(SM2ParameterSpec.ORDER);
        if (bigInteger4.equals(BigInteger.ZERO)) {
            return false;
        }
        MutablePoint mutablePoint = ECOperations.SM2OPS.multiply(ECOperations.SM2OPS.toAffPoint(SM2ParameterSpec.GENERATOR), SMUtil.toByteArrayLE((BigInteger)bigInteger2));
        MutablePoint mutablePoint2 = ECOperations.SM2OPS.multiply(ECOperations.SM2OPS.toAffPoint(this.pubPoint), SMUtil.toByteArrayLE((BigInteger)bigInteger4));
        ECOperations.SM2OPS.setSum(mutablePoint, mutablePoint2.asAffine());
        if (ECOperations.isInfinitePoint(mutablePoint)) {
            return false;
        }
        ECPoint eCPoint = ECOperations.toECPoint(mutablePoint);
        BigInteger bigInteger5 = bigInteger3.add(eCPoint.getAffineX()).mod(SM2ParameterSpec.ORDER);
        return bigInteger5.equals(bigInteger);
    }

    private BigInteger[] decodeSignature(byte[] byArray) throws SignatureException {
        try {
            DerInputStream derInputStream = new DerInputStream(byArray, 0, byArray.length, false);
            DerValue[] derValueArray = derInputStream.getSequence(2);
            if (derValueArray.length != 2 || derInputStream.available() != 0) {
                throw new IOException("Invalid encoding for signature");
            }
            BigInteger bigInteger = derValueArray[0].getPositiveBigInteger();
            BigInteger bigInteger2 = derValueArray[1].getPositiveBigInteger();
            return new BigInteger[]{bigInteger, bigInteger2};
        }
        catch (Exception exception) {
            throw new SignatureException("Could not decode signature", exception);
        }
    }

    private byte[] z() {
        SM3MessageDigest sM3MessageDigest = new SM3MessageDigest();
        int n = this.id.length << 3;
        sM3MessageDigest.update((byte)(n >>> 8));
        sM3MessageDigest.update((byte)n);
        sM3MessageDigest.update(this.id);
        sM3MessageDigest.update(A);
        sM3MessageDigest.update(B);
        sM3MessageDigest.update(GEN_X);
        sM3MessageDigest.update(GEN_Y);
        sM3MessageDigest.update(SMUtil.bigIntToBytes32((BigInteger)this.pubPoint.getAffineX()));
        sM3MessageDigest.update(SMUtil.bigIntToBytes32((BigInteger)this.pubPoint.getAffineY()));
        return sM3MessageDigest.digest();
    }
}

