/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ec;

import java.math.BigInteger;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.SM2ParameterSpec;
import java.util.Arrays;
import sun.security.util.SMUtil;

public final class SM2PrivateKey
implements ECPrivateKey {
    private static final long serialVersionUID = 8891019868158427133L;
    private final BigInteger keyS;
    private final byte[] encoded;

    public SM2PrivateKey(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            throw new IllegalArgumentException("Missing encoded private key");
        }
        if (byArray.length != 32 && (byArray.length != 33 || byArray[0] != 0)) {
            throw new IllegalArgumentException("Private key must be 32-bytes");
        }
        this.keyS = new BigInteger(1, byArray);
        this.encoded = SMUtil.bigIntToBytes32((BigInteger)this.keyS);
    }

    public SM2PrivateKey(BigInteger bigInteger) {
        if (bigInteger == null) {
            throw new IllegalArgumentException("Missing private key");
        }
        this.encoded = SMUtil.bigIntToBytes32((BigInteger)bigInteger);
        this.keyS = bigInteger;
    }

    public SM2PrivateKey(ECPrivateKey eCPrivateKey) {
        this(eCPrivateKey.getS());
    }

    @Override
    public String getAlgorithm() {
        return "SM2";
    }

    @Override
    public String getFormat() {
        return "RAW";
    }

    @Override
    public byte[] getEncoded() {
        return (byte[])this.encoded.clone();
    }

    @Override
    public BigInteger getS() {
        return this.keyS;
    }

    @Override
    public ECParameterSpec getParams() {
        return SM2ParameterSpec.instance();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SM2PrivateKey sM2PrivateKey = (SM2PrivateKey)object;
        return Arrays.equals(this.encoded, sM2PrivateKey.encoded);
    }

    public int hashCode() {
        return Arrays.hashCode(this.encoded);
    }
}

