/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.gc_interface;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.gc_interface.CollectedHeapName;
import sun.jvm.hotspot.memory.MemRegion;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class CollectedHeap
extends VMObject {
    private static long reservedFieldOffset;
    private static CIntegerField currentMaxHeapSizeField;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("CollectedHeap");
        reservedFieldOffset = type.getField("_reserved").getOffset();
        currentMaxHeapSizeField = type.getCIntegerField("_current_max_heap_size");
    }

    public CollectedHeap(Address addr) {
        super(addr);
    }

    public Address start() {
        return this.reservedRegion().start();
    }

    public long capacity() {
        return 0L;
    }

    public long used() {
        return 0L;
    }

    public long currentMaxHeapSize() {
        return currentMaxHeapSizeField.getValue(this.addr);
    }

    public MemRegion reservedRegion() {
        return new MemRegion(this.addr.addOffsetTo(reservedFieldOffset));
    }

    public boolean isIn(Address a) {
        return this.isInReserved(a);
    }

    public boolean isInReserved(Address a) {
        return this.reservedRegion().contains(a);
    }

    public CollectedHeapName kind() {
        return CollectedHeapName.ABSTRACT;
    }

    public void print() {
        this.printOn(System.out);
    }

    public void printOn(PrintStream tty) {
        MemRegion mr = this.reservedRegion();
        tty.println("unknown subtype of CollectedHeap @ " + this.getAddress() + " (" + mr.start() + "," + mr.end() + ")");
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                CollectedHeap.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

