/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import sun.security.util.SMUtil;

public final class SM3Engine
implements Cloneable {
    private static final int[] IV = new int[]{1937774191, 1226093241, 388252375, -628488704, -1452330820, 372324522, -477237683, -1325724082};
    private static final int[] T = new int[]{2043430169, -208106958, -416213915, -832427829, -1664855657, 965255983, 1930511966, -433943364, -867886727, -1735773453, 823420391, 1646840782, -1001285732, -2002571463, 289824371, 579648742, -1651869049, 991229199, 1982458398, -330050500, -660100999, -1320201997, 1654563303, -985840690, -1971681379, 351604539, 703209078, 1406418156, -1482130984, 1330705329, -1633556638, 1027854021, 2055708042, -183551212, -367102423, -734204845, -1468409689, 1358147919, -1578671458, 1137624381, -2019718534, 255530229, 511060458, 1022120916, 2044241832, -206483632, -412967263, -825934525, -1651869049, 991229199, 1982458398, -330050500, -660100999, -1320201997, 1654563303, -985840690, -1971681379, 351604539, 703209078, 1406418156, -1482130984, 1330705329, -1633556638, 1027854021};
    private static final int SM3_BLOCK_INT_SIZE = 16;
    private static final byte[][] TAILS = new byte[][]{{-128, 0, 0, 0}, {-128, 0, 0}, {-128, 0}, {-128}};
    private int[] v;
    private int[] w = new int[68];
    private byte[] word = new byte[4];
    private int wordOffset;
    private int[] block = new int[16];
    private int blockOffset;
    private long countOfBytes;

    public SM3Engine() {
        this.reset();
    }

    public void reset() {
        this.v = (int[])IV.clone();
        this.wordOffset = 0;
        this.blockOffset = 0;
        this.countOfBytes = 0L;
    }

    public void update(byte by) {
        this.word[this.wordOffset++] = by;
        if (this.wordOffset >= this.word.length) {
            this.processWord(this.word, 0);
            this.wordOffset = 0;
        }
        ++this.countOfBytes;
    }

    public void update(byte[] byArray) {
        this.update(byArray, 0, byArray.length);
    }

    public void update(byte[] byArray, int n, int n2) {
        int n3 = 0;
        if (this.wordOffset != 0) {
            while (n3 < n2) {
                this.word[this.wordOffset++] = byArray[n + n3++];
                if (this.wordOffset < this.word.length) continue;
                this.processWord(this.word, 0);
                this.wordOffset = 0;
                break;
            }
        }
        while (n3 < n2 - 3) {
            this.processWord(byArray, n + n3);
            n3 += 4;
        }
        while (n3 < n2) {
            this.word[this.wordOffset++] = byArray[n + n3++];
        }
        this.countOfBytes += (long)n2;
    }

    public void doFinal(byte[] byArray) {
        this.doFinal(byArray, 0);
    }

    public void doFinal(byte[] byArray, int n) {
        long l = this.countOfBytes << 3;
        this.update(TAILS[this.wordOffset]);
        this.processLength(l);
        this.processBlock();
        SMUtil.intsToBytes(this.v, 0, byArray, n, this.v.length);
        this.reset();
    }

    public byte[] doFinal() {
        byte[] byArray = new byte[32];
        this.doFinal(byArray);
        return byArray;
    }

    private void processWord(byte[] byArray, int n) {
        this.block[this.blockOffset] = (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
        ++this.blockOffset;
        if (this.blockOffset >= 16) {
            this.processBlock();
        }
    }

    private void processBlock() {
        this.expand();
        this.compress();
        this.blockOffset = 0;
    }

    private void processLength(long l) {
        if (this.blockOffset > 14) {
            this.block[this.blockOffset] = 0;
            ++this.blockOffset;
            this.processBlock();
        }
        while (this.blockOffset < 14) {
            this.block[this.blockOffset] = 0;
            ++this.blockOffset;
        }
        this.block[this.blockOffset++] = (int)(l >>> 32);
        this.block[this.blockOffset++] = (int)l;
    }

    private void expand() {
        int n;
        for (n = 0; n < this.block.length; ++n) {
            this.w[n] = this.block[n];
        }
        for (n = 16; n < 68; ++n) {
            this.w[n] = SM3Engine.p1(this.w[n - 16] ^ this.w[n - 9] ^ SMUtil.rotateLeft(this.w[n - 3], 15)) ^ SMUtil.rotateLeft(this.w[n - 13], 7) ^ this.w[n - 6];
        }
    }

    private void compress() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = this.v[0];
        int n8 = this.v[1];
        int n9 = this.v[2];
        int n10 = this.v[3];
        int n11 = this.v[4];
        int n12 = this.v[5];
        int n13 = this.v[6];
        int n14 = this.v[7];
        for (n6 = 0; n6 < 16; ++n6) {
            n5 = SMUtil.rotateLeft(n7, 12);
            n4 = SMUtil.rotateLeft(n5 + n11 + T[n6], 7);
            n3 = n4 ^ n5;
            n2 = SM3Engine.ff0(n7, n8, n9) + n10 + n3 + (this.w[n6] ^ this.w[n6 + 4]);
            n = SM3Engine.gg0(n11, n12, n13) + n14 + n4 + this.w[n6];
            n10 = n9;
            n9 = SMUtil.rotateLeft(n8, 9);
            n8 = n7;
            n7 = n2;
            n14 = n13;
            n13 = SMUtil.rotateLeft(n12, 19);
            n12 = n11;
            n11 = SM3Engine.p0(n);
        }
        for (n6 = 16; n6 < 64; ++n6) {
            n5 = SMUtil.rotateLeft(n7, 12);
            n4 = SMUtil.rotateLeft(n5 + n11 + T[n6], 7);
            n3 = n4 ^ n5;
            n2 = SM3Engine.ff1(n7, n8, n9) + n10 + n3 + (this.w[n6] ^ this.w[n6 + 4]);
            n = SM3Engine.gg1(n11, n12, n13) + n14 + n4 + this.w[n6];
            n10 = n9;
            n9 = SMUtil.rotateLeft(n8, 9);
            n8 = n7;
            n7 = n2;
            n14 = n13;
            n13 = SMUtil.rotateLeft(n12, 19);
            n12 = n11;
            n11 = SM3Engine.p0(n);
        }
        this.v[0] = this.v[0] ^ n7;
        this.v[1] = this.v[1] ^ n8;
        this.v[2] = this.v[2] ^ n9;
        this.v[3] = this.v[3] ^ n10;
        this.v[4] = this.v[4] ^ n11;
        this.v[5] = this.v[5] ^ n12;
        this.v[6] = this.v[6] ^ n13;
        this.v[7] = this.v[7] ^ n14;
    }

    public SM3Engine clone() throws CloneNotSupportedException {
        SM3Engine sM3Engine = (SM3Engine)super.clone();
        sM3Engine.v = (int[])this.v.clone();
        sM3Engine.w = (int[])this.w.clone();
        sM3Engine.word = (byte[])this.word.clone();
        sM3Engine.block = (int[])this.block.clone();
        return sM3Engine;
    }

    private static int ff0(int n, int n2, int n3) {
        return n ^ n2 ^ n3;
    }

    private static int ff1(int n, int n2, int n3) {
        return n & n2 | n & n3 | n2 & n3;
    }

    private static int gg0(int n, int n2, int n3) {
        return SM3Engine.ff0(n, n2, n3);
    }

    private static int gg1(int n, int n2, int n3) {
        return n & n2 | ~n & n3;
    }

    private static int p0(int n) {
        return n ^ SMUtil.rotateLeft(n, 9) ^ SMUtil.rotateLeft(n, 17);
    }

    private static int p1(int n) {
        return n ^ SMUtil.rotateLeft(n, 15) ^ SMUtil.rotateLeft(n, 23);
    }
}

