/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpConnectSocketImpl;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PlainSocketImpl;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketImplFactory;
import java.net.SocksSocketImpl;
import java.net.StandardSocketOptions;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import sun.net.ApplicationProxy;
import sun.security.action.GetPropertyAction;
import sun.security.util.SecurityConstants;

public class Socket
implements Closeable {
    private boolean created = false;
    private boolean bound = false;
    private boolean connected = false;
    private boolean closed = false;
    private Object closeLock = new Object();
    private boolean shutIn = false;
    private boolean shutOut = false;
    SocketImpl impl;
    private boolean oldImpl = false;
    private static SocketImplFactory factory = null;

    public Socket() {
        this.setImpl();
    }

    public Socket(Proxy proxy) {
        if (proxy == null) {
            throw new IllegalArgumentException("Invalid Proxy");
        }
        Proxy proxy2 = proxy == Proxy.NO_PROXY ? Proxy.NO_PROXY : ApplicationProxy.create(proxy);
        Proxy.Type type = proxy2.type();
        if (type == Proxy.Type.SOCKS || type == Proxy.Type.HTTP) {
            SecurityManager securityManager = System.getSecurityManager();
            InetSocketAddress inetSocketAddress = (InetSocketAddress)proxy2.address();
            if (inetSocketAddress.getAddress() != null) {
                this.checkAddress(inetSocketAddress.getAddress(), "Socket");
            }
            if (securityManager != null) {
                if (inetSocketAddress.isUnresolved()) {
                    inetSocketAddress = new InetSocketAddress(inetSocketAddress.getHostName(), inetSocketAddress.getPort());
                }
                if (inetSocketAddress.isUnresolved()) {
                    securityManager.checkConnect(inetSocketAddress.getHostName(), inetSocketAddress.getPort());
                } else {
                    securityManager.checkConnect(inetSocketAddress.getAddress().getHostAddress(), inetSocketAddress.getPort());
                }
            }
            this.impl = type == Proxy.Type.SOCKS ? new SocksSocketImpl(proxy2) : new HttpConnectSocketImpl(proxy2);
            this.impl.setSocket(this);
        } else if (proxy2 == Proxy.NO_PROXY) {
            if (factory == null) {
                this.impl = new PlainSocketImpl();
                this.impl.setSocket(this);
            } else {
                this.setImpl();
            }
        } else {
            throw new IllegalArgumentException("Invalid Proxy");
        }
    }

    protected Socket(SocketImpl socketImpl) throws SocketException {
        Socket.checkPermission(socketImpl);
        this.impl = socketImpl;
        if (socketImpl != null) {
            this.checkOldImpl();
            this.impl.setSocket(this);
            String string = AccessController.doPrivileged(new GetPropertyAction("kona.socket.tos.value"));
            if (string != null) {
                try {
                    socketImpl.setOption(StandardSocketOptions.IP_TOS, Integer.valueOf(Integer.valueOf(string)));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private static Void checkPermission(SocketImpl socketImpl) {
        if (socketImpl == null) {
            return null;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SecurityConstants.SET_SOCKETIMPL_PERMISSION);
        }
        return null;
    }

    public Socket(String string, int n) throws UnknownHostException, IOException {
        this(string != null ? new InetSocketAddress(string, n) : new InetSocketAddress(InetAddress.getByName(null), n), null, true);
    }

    public Socket(InetAddress inetAddress, int n) throws IOException {
        this(inetAddress != null ? new InetSocketAddress(inetAddress, n) : null, null, true);
    }

    public Socket(String string, int n, InetAddress inetAddress, int n2) throws IOException {
        this(string != null ? new InetSocketAddress(string, n) : new InetSocketAddress(InetAddress.getByName(null), n), new InetSocketAddress(inetAddress, n2), true);
    }

    public Socket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        this(inetAddress != null ? new InetSocketAddress(inetAddress, n) : null, new InetSocketAddress(inetAddress2, n2), true);
    }

    @Deprecated
    public Socket(String string, int n, boolean bl) throws IOException {
        this(string != null ? new InetSocketAddress(string, n) : new InetSocketAddress(InetAddress.getByName(null), n), null, bl);
    }

    @Deprecated
    public Socket(InetAddress inetAddress, int n, boolean bl) throws IOException {
        this(inetAddress != null ? new InetSocketAddress(inetAddress, n) : null, new InetSocketAddress(0), bl);
    }

    private Socket(SocketAddress socketAddress, SocketAddress socketAddress2, boolean bl) throws IOException {
        this.setImpl();
        if (socketAddress == null) {
            throw new NullPointerException();
        }
        try {
            this.createImpl(bl);
            if (socketAddress2 != null) {
                this.bind(socketAddress2);
            }
            this.connect(socketAddress);
        }
        catch (IOException | IllegalArgumentException | SecurityException exception) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                exception.addSuppressed(iOException);
            }
            throw exception;
        }
    }

    void createImpl(boolean bl) throws SocketException {
        if (this.impl == null) {
            this.setImpl();
        }
        try {
            this.impl.create(bl);
            String string = AccessController.doPrivileged(new GetPropertyAction("kona.socket.tos.value"));
            if (string != null) {
                try {
                    this.impl.setOption(StandardSocketOptions.IP_TOS, Integer.valueOf(Integer.valueOf(string)));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.created = true;
        }
        catch (IOException iOException) {
            throw new SocketException(iOException.getMessage());
        }
    }

    private void checkOldImpl() {
        if (this.impl == null) {
            return;
        }
        this.oldImpl = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                Class<?> clazz = Socket.this.impl.getClass();
                while (true) {
                    try {
                        clazz.getDeclaredMethod("connect", SocketAddress.class, Integer.TYPE);
                        return Boolean.FALSE;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        if (!(clazz = clazz.getSuperclass()).equals(SocketImpl.class)) continue;
                        return Boolean.TRUE;
                    }
                    break;
                }
            }
        });
    }

    void setImpl() {
        if (factory != null) {
            this.impl = factory.createSocketImpl();
            this.checkOldImpl();
        } else {
            this.impl = new SocksSocketImpl();
        }
        if (this.impl != null) {
            this.impl.setSocket(this);
            String string = AccessController.doPrivileged(new GetPropertyAction("kona.socket.tos.value"));
            if (string != null) {
                try {
                    this.impl.setOption(StandardSocketOptions.IP_TOS, Integer.valueOf(Integer.valueOf(string)));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    SocketImpl getImpl() throws SocketException {
        if (!this.created) {
            this.createImpl(true);
        }
        return this.impl;
    }

    public void connect(SocketAddress socketAddress) throws IOException {
        this.connect(socketAddress, 0);
    }

    public void connect(SocketAddress socketAddress, int n) throws IOException {
        if (socketAddress == null) {
            throw new IllegalArgumentException("connect: The address can't be null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("connect: timeout can't be negative");
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.oldImpl && this.isConnected()) {
            throw new SocketException("already connected");
        }
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        InetAddress inetAddress = inetSocketAddress.getAddress();
        int n2 = inetSocketAddress.getPort();
        this.checkAddress(inetAddress, "connect");
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (inetSocketAddress.isUnresolved()) {
                securityManager.checkConnect(inetSocketAddress.getHostName(), n2);
            } else {
                securityManager.checkConnect(inetAddress.getHostAddress(), n2);
            }
        }
        if (!this.created) {
            this.createImpl(true);
        }
        if (!this.oldImpl) {
            this.impl.connect(inetSocketAddress, n);
        } else if (n == 0) {
            if (inetSocketAddress.isUnresolved()) {
                this.impl.connect(inetAddress.getHostName(), n2);
            } else {
                this.impl.connect(inetAddress, n2);
            }
        } else {
            throw new UnsupportedOperationException("SocketImpl.connect(addr, timeout)");
        }
        this.connected = true;
        this.bound = true;
    }

    public void bind(SocketAddress socketAddress) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.oldImpl && this.isBound()) {
            throw new SocketException("Already bound");
        }
        if (socketAddress != null && !(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        if (inetSocketAddress != null && inetSocketAddress.isUnresolved()) {
            throw new SocketException("Unresolved address");
        }
        if (inetSocketAddress == null) {
            inetSocketAddress = new InetSocketAddress(0);
        }
        InetAddress inetAddress = inetSocketAddress.getAddress();
        int n = inetSocketAddress.getPort();
        this.checkAddress(inetAddress, "bind");
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkListen(n);
        }
        this.getImpl().bind(inetAddress, n);
        this.bound = true;
    }

    private void checkAddress(InetAddress inetAddress, String string) {
        if (inetAddress == null) {
            return;
        }
        if (!(inetAddress instanceof Inet4Address) && !(inetAddress instanceof Inet6Address)) {
            throw new IllegalArgumentException(string + ": invalid address type");
        }
    }

    final void postAccept() {
        this.connected = true;
        this.created = true;
        this.bound = true;
    }

    void setCreated() {
        this.created = true;
    }

    void setBound() {
        this.bound = true;
    }

    void setConnected() {
        this.connected = true;
    }

    public InetAddress getInetAddress() {
        if (!this.isConnected()) {
            return null;
        }
        try {
            return this.getImpl().getInetAddress();
        }
        catch (SocketException socketException) {
            return null;
        }
    }

    public InetAddress getLocalAddress() {
        if (!this.isBound()) {
            return InetAddress.anyLocalAddress();
        }
        InetAddress inetAddress = null;
        try {
            inetAddress = (InetAddress)this.getImpl().getOption(15);
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkConnect(inetAddress.getHostAddress(), -1);
            }
            if (inetAddress.isAnyLocalAddress()) {
                inetAddress = InetAddress.anyLocalAddress();
            }
        }
        catch (SecurityException securityException) {
            inetAddress = InetAddress.getLoopbackAddress();
        }
        catch (Exception exception) {
            inetAddress = InetAddress.anyLocalAddress();
        }
        return inetAddress;
    }

    public int getPort() {
        if (!this.isConnected()) {
            return 0;
        }
        try {
            return this.getImpl().getPort();
        }
        catch (SocketException socketException) {
            return -1;
        }
    }

    public int getLocalPort() {
        if (!this.isBound()) {
            return -1;
        }
        try {
            return this.getImpl().getLocalPort();
        }
        catch (SocketException socketException) {
            return -1;
        }
    }

    public SocketAddress getRemoteSocketAddress() {
        if (!this.isConnected()) {
            return null;
        }
        return new InetSocketAddress(this.getInetAddress(), this.getPort());
    }

    public SocketAddress getLocalSocketAddress() {
        if (!this.isBound()) {
            return null;
        }
        return new InetSocketAddress(this.getLocalAddress(), this.getLocalPort());
    }

    public SocketChannel getChannel() {
        return null;
    }

    public InputStream getInputStream() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (this.isInputShutdown()) {
            throw new SocketException("Socket input is shutdown");
        }
        Socket socket = this;
        InputStream inputStream = null;
        try {
            inputStream = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                @Override
                public InputStream run() throws IOException {
                    return Socket.this.impl.getInputStream();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
        return inputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (this.isOutputShutdown()) {
            throw new SocketException("Socket output is shutdown");
        }
        Socket socket = this;
        OutputStream outputStream = null;
        try {
            outputStream = AccessController.doPrivileged(new PrivilegedExceptionAction<OutputStream>(){

                @Override
                public OutputStream run() throws IOException {
                    return Socket.this.impl.getOutputStream();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
        return outputStream;
    }

    public void setTcpNoDelay(boolean bl) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(1, (Object)bl);
    }

    public boolean getTcpNoDelay() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        return (Boolean)this.getImpl().getOption(1);
    }

    public void setSoLinger(boolean bl, int n) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!bl) {
            this.getImpl().setOption(128, new Boolean(bl));
        } else {
            if (n < 0) {
                throw new IllegalArgumentException("invalid value for SO_LINGER");
            }
            if (n > 65535) {
                n = 65535;
            }
            this.getImpl().setOption(128, new Integer(n));
        }
    }

    public int getSoLinger() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        Object object = this.getImpl().getOption(128);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return -1;
    }

    public void sendUrgentData(int n) throws IOException {
        if (!this.getImpl().supportsUrgentData()) {
            throw new SocketException("Urgent data not supported");
        }
        this.getImpl().sendUrgentData(n);
    }

    public void setOOBInline(boolean bl) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(4099, (Object)bl);
    }

    public boolean getOOBInline() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        return (Boolean)this.getImpl().getOption(4099);
    }

    public synchronized void setSoTimeout(int n) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (n < 0) {
            throw new IllegalArgumentException("timeout can't be negative");
        }
        this.getImpl().setOption(4102, new Integer(n));
    }

    public synchronized int getSoTimeout() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        Object object = this.getImpl().getOption(4102);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return 0;
    }

    public synchronized void setSendBufferSize(int n) throws SocketException {
        if (n <= 0) {
            throw new IllegalArgumentException("negative send size");
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(4097, new Integer(n));
    }

    public synchronized int getSendBufferSize() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        int n = 0;
        Object object = this.getImpl().getOption(4097);
        if (object instanceof Integer) {
            n = (Integer)object;
        }
        return n;
    }

    public synchronized void setReceiveBufferSize(int n) throws SocketException {
        if (n <= 0) {
            throw new IllegalArgumentException("invalid receive size");
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(4098, new Integer(n));
    }

    public synchronized int getReceiveBufferSize() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        int n = 0;
        Object object = this.getImpl().getOption(4098);
        if (object instanceof Integer) {
            n = (Integer)object;
        }
        return n;
    }

    public void setKeepAlive(boolean bl) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(8, (Object)bl);
    }

    public boolean getKeepAlive() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        return (Boolean)this.getImpl().getOption(8);
    }

    public void setTrafficClass(int n) throws SocketException {
        block4: {
            if (n < 0 || n > 255) {
                throw new IllegalArgumentException("tc is not in range 0 -- 255");
            }
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            try {
                this.getImpl().setOption(3, (Object)n);
            }
            catch (SocketException socketException) {
                if (this.isConnected()) break block4;
                throw socketException;
            }
        }
    }

    public int getTrafficClass() throws SocketException {
        return (Integer)this.getImpl().getOption(3);
    }

    public void setReuseAddress(boolean bl) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(4, (Object)bl);
    }

    public boolean getReuseAddress() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        return (Boolean)this.getImpl().getOption(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.isClosed()) {
                return;
            }
            if (this.created) {
                this.impl.close();
            }
            this.closed = true;
        }
    }

    public void shutdownInput() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (this.isInputShutdown()) {
            throw new SocketException("Socket input is already shutdown");
        }
        this.getImpl().shutdownInput();
        this.shutIn = true;
    }

    public void shutdownOutput() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (this.isOutputShutdown()) {
            throw new SocketException("Socket output is already shutdown");
        }
        this.getImpl().shutdownOutput();
        this.shutOut = true;
    }

    public String toString() {
        try {
            if (this.isConnected()) {
                return "Socket[addr=" + this.getImpl().getInetAddress() + ",port=" + this.getImpl().getPort() + ",localport=" + this.getImpl().getLocalPort() + "]";
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return "Socket[unconnected]";
    }

    public boolean isConnected() {
        return this.connected || this.oldImpl;
    }

    public boolean isBound() {
        return this.bound || this.oldImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this.closeLock;
        synchronized (object) {
            return this.closed;
        }
    }

    public boolean isInputShutdown() {
        return this.shutIn;
    }

    public boolean isOutputShutdown() {
        return this.shutOut;
    }

    public static synchronized void setSocketImplFactory(SocketImplFactory socketImplFactory) throws IOException {
        if (factory != null) {
            throw new SocketException("factory already defined");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        factory = socketImplFactory;
    }

    public void setPerformancePreferences(int n, int n2, int n3) {
    }
}

