/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.Map;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.HandshakeProducer;
import sun.security.ssl.SM2ClientKeyExchange;
import sun.security.ssl.SM2EClientKeyExchange;
import sun.security.ssl.SM2EKeyExchange;
import sun.security.ssl.SM2EServerKeyExchange;
import sun.security.ssl.SM2KeyExchange;
import sun.security.ssl.SM2ServerKeyExchange;
import sun.security.ssl.SSLConsumer;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLKeyAgreement;
import sun.security.ssl.SSLKeyAgreementGenerator;
import sun.security.ssl.SSLKeyDerivation;
import sun.security.ssl.SSLPossession;
import sun.security.ssl.SSLPossessionGenerator;

final class TLCPKeyExchange {
    TLCPKeyExchange() {
    }

    static enum TLCP11KeyAgreement implements SSLKeyAgreement
    {
        SM2("sm2", SM2KeyExchange.sm2PoGenerator, SM2KeyExchange.sm2KAGenerator),
        SM2E("sm2e", SM2EKeyExchange.sm2ePoGenerator, SM2EKeyExchange.sm2eKAGenerator);

        final String name;
        final SSLPossessionGenerator possessionGenerator;
        final SSLKeyAgreementGenerator keyAgreementGenerator;

        private TLCP11KeyAgreement(String string2, SSLPossessionGenerator sSLPossessionGenerator, SSLKeyAgreementGenerator sSLKeyAgreementGenerator) {
            this.name = string2;
            this.possessionGenerator = sSLPossessionGenerator;
            this.keyAgreementGenerator = sSLKeyAgreementGenerator;
        }

        @Override
        public SSLPossession createPossession(HandshakeContext handshakeContext) {
            if (this.possessionGenerator != null) {
                return this.possessionGenerator.createPossession(handshakeContext);
            }
            return null;
        }

        @Override
        public SSLKeyDerivation createKeyDerivation(HandshakeContext handshakeContext) throws IOException {
            return this.keyAgreementGenerator.createKeyDerivation(handshakeContext);
        }

        @Override
        public SSLHandshake[] getRelatedHandshakers(HandshakeContext handshakeContext) {
            if (!handshakeContext.negotiatedProtocol.useTLS13PlusSpec() && this.possessionGenerator != null) {
                return new SSLHandshake[]{SSLHandshake.SERVER_KEY_EXCHANGE};
            }
            return new SSLHandshake[0];
        }

        @Override
        public Map.Entry<Byte, HandshakeProducer>[] getHandshakeProducers(HandshakeContext handshakeContext) {
            if (handshakeContext.negotiatedProtocol.useTLS13PlusSpec()) {
                return new Map.Entry[0];
            }
            if (handshakeContext.sslConfig.isClientMode) {
                switch (this) {
                    case SM2: {
                        return new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Byte, HandshakeProducer>(SSLHandshake.CLIENT_KEY_EXCHANGE.id, SM2ClientKeyExchange.sm2HandshakeProducer)};
                    }
                    case SM2E: {
                        return new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Byte, HandshakeProducer>(SSLHandshake.CLIENT_KEY_EXCHANGE.id, SM2EClientKeyExchange.sm2eHandshakeProducer)};
                    }
                }
            } else {
                switch (this) {
                    case SM2: {
                        return new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Byte, HandshakeProducer>(SSLHandshake.SERVER_KEY_EXCHANGE.id, SM2ServerKeyExchange.sm2HandshakeProducer)};
                    }
                    case SM2E: {
                        return new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Byte, HandshakeProducer>(SSLHandshake.SERVER_KEY_EXCHANGE.id, SM2EServerKeyExchange.sm2eHandshakeProducer)};
                    }
                }
            }
            return new Map.Entry[0];
        }

        @Override
        public Map.Entry<Byte, SSLConsumer>[] getHandshakeConsumers(HandshakeContext handshakeContext) {
            if (handshakeContext.negotiatedProtocol.useTLS13PlusSpec()) {
                return new Map.Entry[0];
            }
            if (handshakeContext.sslConfig.isClientMode) {
                switch (this) {
                    case SM2: {
                        return new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Byte, SSLConsumer>(SSLHandshake.SERVER_KEY_EXCHANGE.id, SM2ServerKeyExchange.sm2HandshakeConsumer)};
                    }
                    case SM2E: {
                        return new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Byte, SSLConsumer>(SSLHandshake.SERVER_KEY_EXCHANGE.id, SM2EServerKeyExchange.sm2eHandshakeConsumer)};
                    }
                }
            } else {
                switch (this) {
                    case SM2: {
                        return new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Byte, SSLConsumer>(SSLHandshake.CLIENT_KEY_EXCHANGE.id, SM2ClientKeyExchange.sm2HandshakeConsumer)};
                    }
                    case SM2E: {
                        return new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Byte, SSLConsumer>(SSLHandshake.CLIENT_KEY_EXCHANGE.id, SM2EClientKeyExchange.sm2eHandshakeConsumer)};
                    }
                }
            }
            return new Map.Entry[0];
        }
    }
}

