/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.util.ArrayList;
import java.util.List;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.SSLContextImpl;

public class TLCPContexts {

    public static final class TLCPContext
    extends SSLContextImpl.AbstractTLSContext {
        private static final List<ProtocolVersion> serverDefaultProtocols;
        private static final List<CipherSuite> serverDefaultCipherSuites;
        private static final List<ProtocolVersion> clientDefaultProtocols;
        private static final List<CipherSuite> clientDefaultCipherSuites;
        private static final IllegalArgumentException reservedException;

        private static List<ProtocolVersion> customizedProtocols(boolean bl, List<ProtocolVersion> list) {
            ArrayList<ProtocolVersion> arrayList = new ArrayList<ProtocolVersion>();
            for (ProtocolVersion protocolVersion : list) {
                arrayList.add(protocolVersion);
            }
            ProtocolVersion[] protocolVersionArray = arrayList.isEmpty() ? new ProtocolVersion[]{ProtocolVersion.TLS13, ProtocolVersion.TLS12, ProtocolVersion.TLCP11, ProtocolVersion.TLS11, ProtocolVersion.TLS10} : arrayList.toArray(new ProtocolVersion[0]);
            return TLCPContext.getAvailableProtocols(protocolVersionArray);
        }

        @Override
        List<ProtocolVersion> getServerDefaultProtocolVersions() {
            return serverDefaultProtocols;
        }

        @Override
        List<CipherSuite> getServerDefaultCipherSuites() {
            return serverDefaultCipherSuites;
        }

        @Override
        List<ProtocolVersion> getClientDefaultProtocolVersions() {
            return clientDefaultProtocols;
        }

        @Override
        List<CipherSuite> getClientDefaultCipherSuites() {
            return clientDefaultCipherSuites;
        }

        static {
            reservedException = SSLContextImpl.CustomizedSSLProtocols.reservedException;
            if (reservedException == null) {
                clientDefaultProtocols = TLCPContext.customizedProtocols(true, SSLContextImpl.CustomizedSSLProtocols.customizedClientProtocols);
                serverDefaultProtocols = TLCPContext.customizedProtocols(false, SSLContextImpl.CustomizedSSLProtocols.customizedServerProtocols);
                clientDefaultCipherSuites = TLCPContext.getApplicableEnabledCipherSuites(clientDefaultProtocols, true);
                serverDefaultCipherSuites = TLCPContext.getApplicableEnabledCipherSuites(serverDefaultProtocols, false);
            } else {
                clientDefaultProtocols = null;
                serverDefaultProtocols = null;
                clientDefaultCipherSuites = null;
                serverDefaultCipherSuites = null;
            }
        }
    }

    public static final class TLCP11Context
    extends SSLContextImpl.AbstractTLSContext {
        private static final List<ProtocolVersion> serverDefaultProtocols = TLCP11Context.getAvailableProtocols(new ProtocolVersion[]{ProtocolVersion.TLCP11});
        private static final List<CipherSuite> serverDefaultCipherSuites;
        private static final List<ProtocolVersion> clientDefaultProtocols;
        private static final List<CipherSuite> clientDefaultCipherSuites;

        @Override
        List<ProtocolVersion> getServerDefaultProtocolVersions() {
            return serverDefaultProtocols;
        }

        @Override
        List<CipherSuite> getServerDefaultCipherSuites() {
            return serverDefaultCipherSuites;
        }

        @Override
        List<ProtocolVersion> getClientDefaultProtocolVersions() {
            return clientDefaultProtocols;
        }

        @Override
        List<CipherSuite> getClientDefaultCipherSuites() {
            return clientDefaultCipherSuites;
        }

        static {
            clientDefaultProtocols = TLCP11Context.getAvailableProtocols(new ProtocolVersion[]{ProtocolVersion.TLCP11});
            serverDefaultCipherSuites = TLCP11Context.getApplicableEnabledCipherSuites(serverDefaultProtocols, false);
            clientDefaultCipherSuites = TLCP11Context.getApplicableEnabledCipherSuites(clientDefaultProtocols, true);
        }
    }
}

