/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Map;
import javax.net.ssl.X509ExtendedKeyManager;
import sun.security.ssl.ClientHandshakeContext;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.HandshakeProducer;
import sun.security.ssl.SSLAuthentication;
import sun.security.ssl.SSLCredentials;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLPossession;
import sun.security.ssl.ServerHandshakeContext;
import sun.security.ssl.SupportedGroupsExtension;
import sun.security.util.SMUtil;

enum TLCPAuthentication implements SSLAuthentication
{
    SM2("EC", "EC");

    final String keyAlgorithm;
    final String[] keyTypes;

    private TLCPAuthentication(String string2, String ... stringArray) {
        this.keyAlgorithm = string2;
        this.keyTypes = stringArray;
    }

    @Override
    public SSLPossession createPossession(HandshakeContext handshakeContext) {
        return TLCPAuthentication.createPossession(handshakeContext, this.keyTypes);
    }

    @Override
    public SSLHandshake[] getRelatedHandshakers(HandshakeContext handshakeContext) {
        if (handshakeContext.negotiatedProtocol.isTLCP11()) {
            return new SSLHandshake[]{SSLHandshake.CERTIFICATE, SSLHandshake.CERTIFICATE_REQUEST};
        }
        return new SSLHandshake[0];
    }

    @Override
    public Map.Entry<Byte, HandshakeProducer>[] getHandshakeProducers(HandshakeContext handshakeContext) {
        if (handshakeContext.negotiatedProtocol.isTLCP11()) {
            return new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Byte, SSLHandshake>(SSLHandshake.CERTIFICATE.id, SSLHandshake.CERTIFICATE)};
        }
        return new Map.Entry[0];
    }

    public static SSLPossession createPossession(HandshakeContext handshakeContext, String[] stringArray) {
        if (handshakeContext.sslConfig.isClientMode) {
            return TLCPAuthentication.createClientPossession((ClientHandshakeContext)handshakeContext, stringArray);
        }
        return TLCPAuthentication.createServerPossession((ServerHandshakeContext)handshakeContext, stringArray);
    }

    private static SSLPossession createClientPossession(ClientHandshakeContext clientHandshakeContext, String[] stringArray) {
        X509ExtendedKeyManager x509ExtendedKeyManager = clientHandshakeContext.sslContext.getX509KeyManager();
        for (String string : stringArray) {
            String[] stringArray2 = x509ExtendedKeyManager.getClientAliases(string, clientHandshakeContext.peerSupportedAuthorities == null ? null : (Principal[])clientHandshakeContext.peerSupportedAuthorities.clone());
            if (stringArray2 == null || stringArray2.length == 0) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                    SSLLogger.finest("No X.509 cert selected for " + Arrays.toString(stringArray), new Object[0]);
                }
                return null;
            }
            PossessionEntry possessionEntry = null;
            PossessionEntry possessionEntry2 = null;
            Object object = stringArray2;
            int n = ((String[])object).length;
            for (int i = 0; i < n; ++i) {
                String string2 = object[i];
                PossessionEntry possessionEntry3 = TLCPAuthentication.clientPossEntry(clientHandshakeContext, string, x509ExtendedKeyManager, string2);
                if (possessionEntry3 == null) continue;
                if (possessionEntry == null && SMUtil.isSignCert((X509Certificate)possessionEntry3.popCert)) {
                    possessionEntry = possessionEntry3;
                } else if (SMUtil.isEncCert((X509Certificate)possessionEntry3.popCert)) {
                    possessionEntry2 = possessionEntry3;
                }
                if (possessionEntry != null && possessionEntry2 != null) break;
            }
            if ((object = TLCPAuthentication.createPossession(possessionEntry, possessionEntry2)) == null) continue;
            return object;
        }
        return null;
    }

    private static PossessionEntry clientPossEntry(ClientHandshakeContext clientHandshakeContext, String string, X509ExtendedKeyManager x509ExtendedKeyManager, String string2) {
        PrivateKey privateKey = x509ExtendedKeyManager.getPrivateKey(string2);
        if (privateKey == null) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.finest(string2 + " is not a private key entry", new Object[0]);
            }
            return null;
        }
        X509Certificate[] x509CertificateArray = x509ExtendedKeyManager.getCertificateChain(string2);
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.finest(string2 + " is a private key entry with no cert chain stored", new Object[0]);
            }
            return null;
        }
        String string3 = privateKey.getAlgorithm();
        if (!Arrays.asList(string).contains(string3)) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.fine(string2 + " private key algorithm " + string3 + " not in request list", new Object[0]);
            }
            return null;
        }
        PublicKey publicKey = x509CertificateArray[0].getPublicKey();
        String string4 = publicKey.getAlgorithm();
        if (!string3.equals(string4)) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.fine(string2 + " private or public key is not of same algorithm: " + string3 + " vs " + string4, new Object[0]);
            }
            return null;
        }
        if (!TLCPAuthentication.checkPublicKey(string2, publicKey, clientHandshakeContext)) {
            return null;
        }
        return new PossessionEntry(privateKey, x509CertificateArray);
    }

    private static SSLPossession createServerPossession(ServerHandshakeContext serverHandshakeContext, String[] stringArray) {
        X509ExtendedKeyManager x509ExtendedKeyManager = serverHandshakeContext.sslContext.getX509KeyManager();
        for (String string : stringArray) {
            String[] stringArray2 = x509ExtendedKeyManager.getServerAliases(string, serverHandshakeContext.peerSupportedAuthorities == null ? null : (Principal[])serverHandshakeContext.peerSupportedAuthorities.clone());
            if (stringArray2 == null || stringArray2.length == 0) {
                if (!SSLLogger.isOn || !SSLLogger.isOn("ssl")) continue;
                SSLLogger.finest("No X.509 cert selected for " + string, new Object[0]);
                continue;
            }
            PossessionEntry possessionEntry = null;
            PossessionEntry possessionEntry2 = null;
            Object object = stringArray2;
            int n = ((String[])object).length;
            for (int i = 0; i < n; ++i) {
                String string2 = object[i];
                PossessionEntry possessionEntry3 = TLCPAuthentication.serverPossEntry(serverHandshakeContext, string, x509ExtendedKeyManager, string2);
                if (possessionEntry3 == null) continue;
                if (possessionEntry == null && SMUtil.isSignCert((X509Certificate)possessionEntry3.popCert)) {
                    possessionEntry = possessionEntry3;
                } else if (SMUtil.isEncCert((X509Certificate)possessionEntry3.popCert)) {
                    possessionEntry2 = possessionEntry3;
                }
                if (possessionEntry != null && possessionEntry2 != null) break;
            }
            if ((object = TLCPAuthentication.createPossession(possessionEntry, possessionEntry2)) == null) continue;
            return object;
        }
        return null;
    }

    private static TLCP11Possession createPossession(PossessionEntry possessionEntry, PossessionEntry possessionEntry2) {
        if (possessionEntry == null) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.warning("No X.509 sign cert selected", new Object[0]);
            }
            return null;
        }
        if (possessionEntry2 == null && SMUtil.isEncCert((X509Certificate)possessionEntry.popCert)) {
            possessionEntry2 = possessionEntry;
        }
        if (possessionEntry2 == null) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.warning("No X.509 enc cert selected", new Object[0]);
            }
            return null;
        }
        return new TLCP11Possession(possessionEntry, possessionEntry2);
    }

    private static PossessionEntry serverPossEntry(ServerHandshakeContext serverHandshakeContext, String string, X509ExtendedKeyManager x509ExtendedKeyManager, String string2) {
        PrivateKey privateKey = x509ExtendedKeyManager.getPrivateKey(string2);
        if (privateKey == null) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.finest(string2 + " is not a private key entry", new Object[0]);
            }
            return null;
        }
        X509Certificate[] x509CertificateArray = x509ExtendedKeyManager.getCertificateChain(string2);
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.finest(string2 + " is not a certificate entry", new Object[0]);
            }
            return null;
        }
        PublicKey publicKey = x509CertificateArray[0].getPublicKey();
        if (!privateKey.getAlgorithm().equals(string) || !publicKey.getAlgorithm().equals(string)) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.fine(string2 + " private or public key is not of " + string + " algorithm", new Object[0]);
            }
            return null;
        }
        if (!serverHandshakeContext.negotiatedProtocol.useTLS13PlusSpec() && string.equals("EC") && !TLCPAuthentication.checkPublicKey(string2, publicKey, serverHandshakeContext)) {
            return null;
        }
        return new PossessionEntry(privateKey, x509CertificateArray);
    }

    private static boolean checkPublicKey(String string, PublicKey publicKey, HandshakeContext handshakeContext) {
        if (!(publicKey instanceof ECPublicKey)) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.warning(string + " public key is not an instance of ECPublicKey", new Object[0]);
            }
            return false;
        }
        ECParameterSpec eCParameterSpec = ((ECPublicKey)publicKey).getParams();
        SupportedGroupsExtension.NamedGroup namedGroup = SupportedGroupsExtension.NamedGroup.valueOf(eCParameterSpec);
        if (namedGroup != SupportedGroupsExtension.NamedGroup.CURVESM2) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.warning("Unsupported named group (" + (Object)((Object)namedGroup) + ") used in the " + string + " certificate", new Object[0]);
            }
            return false;
        }
        return true;
    }

    static final class TLCP11Credentials
    implements SSLCredentials {
        final PublicKey popSignPublicKey;
        final X509Certificate[] popSignCerts;
        final X509Certificate popSignCert;
        final PublicKey popEncPublicKey;
        final X509Certificate[] popEncCerts;
        final X509Certificate popEncCert;

        TLCP11Credentials(PublicKey publicKey, X509Certificate[] x509CertificateArray, PublicKey publicKey2, X509Certificate[] x509CertificateArray2) {
            this.popSignPublicKey = publicKey;
            this.popSignCerts = x509CertificateArray;
            this.popSignCert = x509CertificateArray[0];
            this.popEncPublicKey = publicKey2;
            this.popEncCerts = x509CertificateArray2;
            this.popEncCert = x509CertificateArray2[0];
        }
    }

    static final class PossessionEntry {
        final PrivateKey popPrivateKey;
        final X509Certificate[] popCerts;
        final X509Certificate popCert;
        final PublicKey popPublicKey;

        PossessionEntry(PrivateKey privateKey, X509Certificate[] x509CertificateArray) {
            this.popPrivateKey = privateKey;
            this.popCerts = x509CertificateArray;
            this.popCert = x509CertificateArray[0];
            this.popPublicKey = this.popCert.getPublicKey();
        }
    }

    static final class TLCP11Possession
    implements SSLPossession {
        final PrivateKey popSignPrivateKey;
        final X509Certificate[] popSignCerts;
        final X509Certificate popSignCert;
        final PublicKey popSignPublicKey;
        final PrivateKey popEncPrivateKey;
        final X509Certificate[] popEncCerts;
        final X509Certificate popEncCert;
        final PublicKey popEncPublicKey;

        TLCP11Possession(PrivateKey privateKey, X509Certificate[] x509CertificateArray, PrivateKey privateKey2, X509Certificate[] x509CertificateArray2) {
            this.popSignPrivateKey = privateKey;
            this.popSignCerts = x509CertificateArray;
            if (x509CertificateArray != null && x509CertificateArray.length > 0) {
                this.popSignCert = x509CertificateArray[0];
                this.popSignPublicKey = this.popSignCert.getPublicKey();
            } else {
                this.popSignCert = null;
                this.popSignPublicKey = null;
            }
            this.popEncPrivateKey = privateKey2;
            this.popEncCerts = x509CertificateArray2;
            if (x509CertificateArray2 != null && x509CertificateArray2.length > 0) {
                this.popEncCert = x509CertificateArray2[0];
                this.popEncPublicKey = this.popEncCert.getPublicKey();
            } else {
                this.popEncCert = null;
                this.popEncPublicKey = null;
            }
        }

        TLCP11Possession(PossessionEntry possessionEntry, PossessionEntry possessionEntry2) {
            this.popSignPrivateKey = possessionEntry.popPrivateKey;
            this.popSignCerts = possessionEntry.popCerts;
            this.popSignCert = possessionEntry.popCert;
            this.popSignPublicKey = possessionEntry.popPublicKey;
            this.popEncPrivateKey = possessionEntry2.popPrivateKey;
            this.popEncCerts = possessionEntry2.popCerts;
            this.popEncCert = possessionEntry2.popCert;
            this.popEncPublicKey = possessionEntry2.popPublicKey;
        }

        ECParameterSpec getECParameterSpec() {
            return this.getECParameterSpec(this.popSignPrivateKey, this.popSignCerts);
        }

        ECParameterSpec getECParameterSpec(PrivateKey privateKey, X509Certificate[] x509CertificateArray) {
            PublicKey publicKey;
            if (privateKey == null || !"EC".equals(privateKey.getAlgorithm())) {
                return null;
            }
            if (privateKey instanceof ECKey) {
                return ((ECKey)((Object)privateKey)).getParams();
            }
            if (x509CertificateArray != null && x509CertificateArray.length != 0 && (publicKey = x509CertificateArray[0].getPublicKey()) instanceof ECKey) {
                return ((ECKey)((Object)publicKey)).getParams();
            }
            return null;
        }
    }
}

