/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.DHClientKeyExchange;
import sun.security.ssl.DHKeyExchange;
import sun.security.ssl.DHServerKeyExchange;
import sun.security.ssl.ECDHClientKeyExchange;
import sun.security.ssl.ECDHKeyExchange;
import sun.security.ssl.ECDHServerKeyExchange;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.HandshakeProducer;
import sun.security.ssl.JsseJce;
import sun.security.ssl.KrbClientKeyExchange;
import sun.security.ssl.KrbKeyExchange;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.RSAClientKeyExchange;
import sun.security.ssl.RSAKeyExchange;
import sun.security.ssl.RSAServerKeyExchange;
import sun.security.ssl.SSLAuthentication;
import sun.security.ssl.SSLConsumer;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLHandshakeBinding;
import sun.security.ssl.SSLKeyAgreement;
import sun.security.ssl.SSLKeyAgreementGenerator;
import sun.security.ssl.SSLKeyDerivation;
import sun.security.ssl.SSLPossession;
import sun.security.ssl.SSLPossessionGenerator;
import sun.security.ssl.ServerHandshakeContext;
import sun.security.ssl.SupportedGroupsExtension;
import sun.security.ssl.TLCPAuthentication;
import sun.security.ssl.TLCPKeyExchange;
import sun.security.ssl.X509Authentication;

final class SSLKeyExchange
implements SSLKeyAgreementGenerator,
SSLHandshakeBinding {
    private final SSLAuthentication authentication;
    private final SSLKeyAgreement keyAgreement;

    SSLKeyExchange(SSLAuthentication sSLAuthentication, SSLKeyAgreement sSLKeyAgreement) {
        this.authentication = sSLAuthentication;
        this.keyAgreement = sSLKeyAgreement;
    }

    SSLPossession[] createPossessions(HandshakeContext handshakeContext) {
        SSLPossession[] sSLPossessionArray;
        Object object;
        SSLPossession sSLPossession = null;
        if (this.authentication != null) {
            sSLPossession = this.authentication.createPossession(handshakeContext);
            if (sSLPossession == null) {
                return new SSLPossession[0];
            }
            if (handshakeContext instanceof ServerHandshakeContext) {
                object = (ServerHandshakeContext)handshakeContext;
                ((ServerHandshakeContext)object).interimAuthn = sSLPossession;
            }
        }
        if (this.keyAgreement == T12KeyAgreement.RSA_EXPORT) {
            SSLPossession[] sSLPossessionArray2;
            X509Authentication.X509Possession x509Possession = (X509Authentication.X509Possession)sSLPossession;
            if (JsseJce.getRSAKeyLength(x509Possession.popCerts[0].getPublicKey()) > 512) {
                SSLPossession[] sSLPossessionArray3;
                object = this.keyAgreement.createPossession(handshakeContext);
                if (object == null) {
                    return new SSLPossession[0];
                }
                if (this.authentication != null) {
                    SSLPossession[] sSLPossessionArray4 = new SSLPossession[2];
                    sSLPossessionArray4[0] = sSLPossession;
                    sSLPossessionArray3 = sSLPossessionArray4;
                    sSLPossessionArray4[1] = object;
                } else {
                    SSLPossession[] sSLPossessionArray5 = new SSLPossession[1];
                    sSLPossessionArray3 = sSLPossessionArray5;
                    sSLPossessionArray5[0] = object;
                }
                return sSLPossessionArray3;
            }
            if (this.authentication != null) {
                SSLPossession[] sSLPossessionArray6 = new SSLPossession[1];
                sSLPossessionArray2 = sSLPossessionArray6;
                sSLPossessionArray6[0] = sSLPossession;
            } else {
                sSLPossessionArray2 = new SSLPossession[]{};
            }
            return sSLPossessionArray2;
        }
        object = this.keyAgreement.createPossession(handshakeContext);
        if (object == null) {
            if (this.keyAgreement == T12KeyAgreement.RSA || this.keyAgreement == T12KeyAgreement.ECDH || this.keyAgreement == TLCPKeyExchange.TLCP11KeyAgreement.SM2) {
                SSLPossession[] sSLPossessionArray7;
                if (this.authentication != null) {
                    SSLPossession[] sSLPossessionArray8 = new SSLPossession[1];
                    sSLPossessionArray7 = sSLPossessionArray8;
                    sSLPossessionArray8[0] = sSLPossession;
                } else {
                    sSLPossessionArray7 = new SSLPossession[]{};
                }
                return sSLPossessionArray7;
            }
            return new SSLPossession[0];
        }
        if (this.authentication != null) {
            SSLPossession[] sSLPossessionArray9 = new SSLPossession[2];
            sSLPossessionArray9[0] = sSLPossession;
            sSLPossessionArray = sSLPossessionArray9;
            sSLPossessionArray9[1] = object;
        } else {
            SSLPossession[] sSLPossessionArray10 = new SSLPossession[1];
            sSLPossessionArray = sSLPossessionArray10;
            sSLPossessionArray10[0] = object;
        }
        return sSLPossessionArray;
    }

    @Override
    public SSLKeyDerivation createKeyDerivation(HandshakeContext handshakeContext) throws IOException {
        return this.keyAgreement.createKeyDerivation(handshakeContext);
    }

    @Override
    public SSLHandshake[] getRelatedHandshakers(HandshakeContext handshakeContext) {
        SSLHandshake[] sSLHandshakeArray = this.authentication != null ? this.authentication.getRelatedHandshakers(handshakeContext) : null;
        SSLHandshake[] sSLHandshakeArray2 = this.keyAgreement.getRelatedHandshakers(handshakeContext);
        if (sSLHandshakeArray == null || sSLHandshakeArray.length == 0) {
            return sSLHandshakeArray2;
        }
        if (sSLHandshakeArray2 == null || sSLHandshakeArray2.length == 0) {
            return sSLHandshakeArray;
        }
        SSLHandshake[] sSLHandshakeArray3 = Arrays.copyOf(sSLHandshakeArray, sSLHandshakeArray.length + sSLHandshakeArray2.length);
        System.arraycopy(sSLHandshakeArray2, 0, sSLHandshakeArray3, sSLHandshakeArray.length, sSLHandshakeArray2.length);
        return sSLHandshakeArray3;
    }

    @Override
    public Map.Entry<Byte, HandshakeProducer>[] getHandshakeProducers(HandshakeContext handshakeContext) {
        Map.Entry<Byte, HandshakeProducer>[] entryArray = this.authentication != null ? this.authentication.getHandshakeProducers(handshakeContext) : null;
        Map.Entry<Byte, HandshakeProducer>[] entryArray2 = this.keyAgreement.getHandshakeProducers(handshakeContext);
        if (entryArray == null || entryArray.length == 0) {
            return entryArray2;
        }
        if (entryArray2 == null || entryArray2.length == 0) {
            return entryArray;
        }
        Map.Entry<Byte, HandshakeProducer>[] entryArray3 = Arrays.copyOf(entryArray, entryArray.length + entryArray2.length);
        System.arraycopy(entryArray2, 0, entryArray3, entryArray.length, entryArray2.length);
        return entryArray3;
    }

    @Override
    public Map.Entry<Byte, SSLConsumer>[] getHandshakeConsumers(HandshakeContext handshakeContext) {
        Map.Entry<Byte, SSLConsumer>[] entryArray = this.authentication != null ? this.authentication.getHandshakeConsumers(handshakeContext) : null;
        Map.Entry<Byte, SSLConsumer>[] entryArray2 = this.keyAgreement.getHandshakeConsumers(handshakeContext);
        if (entryArray == null || entryArray.length == 0) {
            return entryArray2;
        }
        if (entryArray2 == null || entryArray2.length == 0) {
            return entryArray;
        }
        Map.Entry<Byte, SSLConsumer>[] entryArray3 = Arrays.copyOf(entryArray, entryArray.length + entryArray2.length);
        System.arraycopy(entryArray2, 0, entryArray3, entryArray.length, entryArray2.length);
        return entryArray3;
    }

    static SSLKeyExchange valueOf(CipherSuite.KeyExchange keyExchange, ProtocolVersion protocolVersion) {
        if (keyExchange == null || protocolVersion == null) {
            return null;
        }
        switch (keyExchange) {
            case K_RSA: {
                return SSLKeyExRSA.KE;
            }
            case K_RSA_EXPORT: {
                return SSLKeyExRSAExport.KE;
            }
            case K_DHE_DSS: {
                return SSLKeyExDHEDSS.KE;
            }
            case K_DHE_DSS_EXPORT: {
                return SSLKeyExDHEDSSExport.KE;
            }
            case K_DHE_RSA: {
                if (protocolVersion.useTLS12PlusSpec()) {
                    return SSLKeyExDHERSAOrPSS.KE;
                }
                return SSLKeyExDHERSA.KE;
            }
            case K_DHE_RSA_EXPORT: {
                return SSLKeyExDHERSAExport.KE;
            }
            case K_DH_ANON: {
                return SSLKeyExDHANON.KE;
            }
            case K_DH_ANON_EXPORT: {
                return SSLKeyExDHANONExport.KE;
            }
            case K_ECDH_ECDSA: {
                return SSLKeyExECDHECDSA.KE;
            }
            case K_ECDH_RSA: {
                return SSLKeyExECDHRSA.KE;
            }
            case K_ECDHE_ECDSA: {
                return SSLKeyExECDHEECDSA.KE;
            }
            case K_ECDHE_RSA: {
                if (protocolVersion.useTLS12PlusSpec()) {
                    return SSLKeyExECDHERSAOrPSS.KE;
                }
                return SSLKeyExECDHERSA.KE;
            }
            case K_ECDH_ANON: {
                return SSLKeyExECDHANON.KE;
            }
            case K_KRB5: {
                return SSLKeyExKRB5.KE;
            }
            case K_KRB5_EXPORT: {
                return SSLKeyExKRB5EXPORT.KE;
            }
            case K_SM2: {
                return TLCPKeyExSM2.KE;
            }
            case K_SM2E: {
                return TLCPKeyExSM2E.KE;
            }
        }
        return null;
    }

    static SSLKeyExchange valueOf(SupportedGroupsExtension.NamedGroup namedGroup) {
        T13KeyAgreement t13KeyAgreement = T13KeyAgreement.valueOf(namedGroup);
        if (t13KeyAgreement != null) {
            return new SSLKeyExchange(null, T13KeyAgreement.valueOf(namedGroup));
        }
        return null;
    }

    private static final class T13KeyAgreement
    implements SSLKeyAgreement {
        private final SupportedGroupsExtension.NamedGroup namedGroup;
        static final Map<SupportedGroupsExtension.NamedGroup, T13KeyAgreement> supportedKeyShares = new HashMap<SupportedGroupsExtension.NamedGroup, T13KeyAgreement>();

        private T13KeyAgreement(SupportedGroupsExtension.NamedGroup namedGroup) {
            this.namedGroup = namedGroup;
        }

        static T13KeyAgreement valueOf(SupportedGroupsExtension.NamedGroup namedGroup) {
            return supportedKeyShares.get((Object)namedGroup);
        }

        @Override
        public SSLPossession createPossession(HandshakeContext handshakeContext) {
            if (this.namedGroup.type == SupportedGroupsExtension.NamedGroupType.NAMED_GROUP_ECDHE) {
                return new ECDHKeyExchange.ECDHEPossession(this.namedGroup, handshakeContext.sslContext.getSecureRandom());
            }
            if (this.namedGroup.type == SupportedGroupsExtension.NamedGroupType.NAMED_GROUP_FFDHE) {
                return new DHKeyExchange.DHEPossession(this.namedGroup, handshakeContext.sslContext.getSecureRandom());
            }
            return null;
        }

        @Override
        public SSLKeyDerivation createKeyDerivation(HandshakeContext handshakeContext) throws IOException {
            if (this.namedGroup.type == SupportedGroupsExtension.NamedGroupType.NAMED_GROUP_ECDHE) {
                return ECDHKeyExchange.ecdheKAGenerator.createKeyDerivation(handshakeContext);
            }
            if (this.namedGroup.type == SupportedGroupsExtension.NamedGroupType.NAMED_GROUP_FFDHE) {
                return DHKeyExchange.kaGenerator.createKeyDerivation(handshakeContext);
            }
            return null;
        }

        static {
            for (SupportedGroupsExtension.NamedGroup namedGroup : SupportedGroupsExtension.SupportedGroups.supportedNamedGroups) {
                supportedKeyShares.put(namedGroup, new T13KeyAgreement(namedGroup));
            }
        }
    }

    private static enum T12KeyAgreement implements SSLKeyAgreement
    {
        RSA("rsa", null, RSAKeyExchange.kaGenerator),
        RSA_EXPORT("rsa_export", RSAKeyExchange.poGenerator, RSAKeyExchange.kaGenerator),
        DHE("dhe", DHKeyExchange.poGenerator, DHKeyExchange.kaGenerator),
        DHE_EXPORT("dhe_export", DHKeyExchange.poExportableGenerator, DHKeyExchange.kaGenerator),
        ECDH("ecdh", null, ECDHKeyExchange.ecdhKAGenerator),
        ECDHE("ecdhe", ECDHKeyExchange.poGenerator, ECDHKeyExchange.ecdheKAGenerator),
        KRB5("krb5", KrbKeyExchange.poGenerator, KrbKeyExchange.kaGenerator),
        KRB5_EXPORT("krb5_export", KrbKeyExchange.poGenerator, KrbKeyExchange.kaGenerator);

        final String name;
        final SSLPossessionGenerator possessionGenerator;
        final SSLKeyAgreementGenerator keyAgreementGenerator;

        private T12KeyAgreement(String string2, SSLPossessionGenerator sSLPossessionGenerator, SSLKeyAgreementGenerator sSLKeyAgreementGenerator) {
            this.name = string2;
            this.possessionGenerator = sSLPossessionGenerator;
            this.keyAgreementGenerator = sSLKeyAgreementGenerator;
        }

        @Override
        public SSLPossession createPossession(HandshakeContext handshakeContext) {
            if (this.possessionGenerator != null) {
                return this.possessionGenerator.createPossession(handshakeContext);
            }
            return null;
        }

        @Override
        public SSLKeyDerivation createKeyDerivation(HandshakeContext handshakeContext) throws IOException {
            return this.keyAgreementGenerator.createKeyDerivation(handshakeContext);
        }

        @Override
        public SSLHandshake[] getRelatedHandshakers(HandshakeContext handshakeContext) {
            if (!handshakeContext.negotiatedProtocol.useTLS13PlusSpec() && this.possessionGenerator != null) {
                return new SSLHandshake[]{SSLHandshake.SERVER_KEY_EXCHANGE};
            }
            return new SSLHandshake[0];
        }

        @Override
        public Map.Entry<Byte, HandshakeProducer>[] getHandshakeProducers(HandshakeContext handshakeContext) {
            if (handshakeContext.negotiatedProtocol.useTLS13PlusSpec()) {
                return new Map.Entry[0];
            }
            if (handshakeContext.sslConfig.isClientMode) {
                switch (this) {
                    case RSA: 
                    case RSA_EXPORT: {
                        return new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Byte, HandshakeProducer>(SSLHandshake.CLIENT_KEY_EXCHANGE.id, RSAClientKeyExchange.rsaHandshakeProducer)};
                    }
                    case DHE: 
                    case DHE_EXPORT: {
                        return new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Byte, DHClientKeyExchange.DHClientKeyExchangeProducer>(SSLHandshake.CLIENT_KEY_EXCHANGE.id, DHClientKeyExchange.dhHandshakeProducer)};
                    }
                    case ECDH: {
                        return new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Byte, HandshakeProducer>(SSLHandshake.CLIENT_KEY_EXCHANGE.id, ECDHClientKeyExchange.ecdhHandshakeProducer)};
                    }
                    case ECDHE: {
                        return new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Byte, HandshakeProducer>(SSLHandshake.CLIENT_KEY_EXCHANGE.id, ECDHClientKeyExchange.ecdheHandshakeProducer)};
                    }
                    case KRB5: 
                    case KRB5_EXPORT: {
                        return new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Byte, HandshakeProducer>(SSLHandshake.CLIENT_KEY_EXCHANGE.id, KrbClientKeyExchange.krbHandshakeProducer)};
                    }
                }
            } else {
                switch (this) {
                    case RSA_EXPORT: {
                        return new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Byte, HandshakeProducer>(SSLHandshake.SERVER_KEY_EXCHANGE.id, RSAServerKeyExchange.rsaHandshakeProducer)};
                    }
                    case DHE: 
                    case DHE_EXPORT: {
                        return new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Byte, HandshakeProducer>(SSLHandshake.SERVER_KEY_EXCHANGE.id, DHServerKeyExchange.dhHandshakeProducer)};
                    }
                    case ECDHE: {
                        return new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Byte, HandshakeProducer>(SSLHandshake.SERVER_KEY_EXCHANGE.id, ECDHServerKeyExchange.ecdheHandshakeProducer)};
                    }
                }
            }
            return new Map.Entry[0];
        }

        @Override
        public Map.Entry<Byte, SSLConsumer>[] getHandshakeConsumers(HandshakeContext handshakeContext) {
            if (handshakeContext.negotiatedProtocol.useTLS13PlusSpec()) {
                return new Map.Entry[0];
            }
            if (handshakeContext.sslConfig.isClientMode) {
                switch (this) {
                    case RSA_EXPORT: {
                        return new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Byte, SSLConsumer>(SSLHandshake.SERVER_KEY_EXCHANGE.id, RSAServerKeyExchange.rsaHandshakeConsumer)};
                    }
                    case DHE: 
                    case DHE_EXPORT: {
                        return new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Byte, SSLConsumer>(SSLHandshake.SERVER_KEY_EXCHANGE.id, DHServerKeyExchange.dhHandshakeConsumer)};
                    }
                    case ECDHE: {
                        return new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Byte, SSLConsumer>(SSLHandshake.SERVER_KEY_EXCHANGE.id, ECDHServerKeyExchange.ecdheHandshakeConsumer)};
                    }
                }
            } else {
                switch (this) {
                    case RSA: 
                    case RSA_EXPORT: {
                        return new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Byte, SSLConsumer>(SSLHandshake.CLIENT_KEY_EXCHANGE.id, RSAClientKeyExchange.rsaHandshakeConsumer)};
                    }
                    case DHE: 
                    case DHE_EXPORT: {
                        return new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Byte, DHClientKeyExchange.DHClientKeyExchangeConsumer>(SSLHandshake.CLIENT_KEY_EXCHANGE.id, DHClientKeyExchange.dhHandshakeConsumer)};
                    }
                    case ECDH: {
                        return new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Byte, SSLConsumer>(SSLHandshake.CLIENT_KEY_EXCHANGE.id, ECDHClientKeyExchange.ecdhHandshakeConsumer)};
                    }
                    case ECDHE: {
                        return new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Byte, SSLConsumer>(SSLHandshake.CLIENT_KEY_EXCHANGE.id, ECDHClientKeyExchange.ecdheHandshakeConsumer)};
                    }
                    case KRB5: 
                    case KRB5_EXPORT: {
                        return new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Byte, SSLConsumer>(SSLHandshake.CLIENT_KEY_EXCHANGE.id, KrbClientKeyExchange.krbHandshakeConsumer)};
                    }
                }
            }
            return new Map.Entry[0];
        }
    }

    private static class TLCPKeyExSM2E {
        private static final SSLKeyExchange KE = new SSLKeyExchange(TLCPAuthentication.SM2, TLCPKeyExchange.TLCP11KeyAgreement.SM2E);

        private TLCPKeyExSM2E() {
        }
    }

    private static class TLCPKeyExSM2 {
        private static final SSLKeyExchange KE = new SSLKeyExchange(TLCPAuthentication.SM2, TLCPKeyExchange.TLCP11KeyAgreement.SM2);

        private TLCPKeyExSM2() {
        }
    }

    private static class SSLKeyExKRB5EXPORT {
        private static SSLKeyExchange KE = new SSLKeyExchange(null, T12KeyAgreement.KRB5_EXPORT);

        private SSLKeyExKRB5EXPORT() {
        }
    }

    private static class SSLKeyExKRB5 {
        private static SSLKeyExchange KE = new SSLKeyExchange(null, T12KeyAgreement.KRB5);

        private SSLKeyExKRB5() {
        }
    }

    private static class SSLKeyExECDHANON {
        private static SSLKeyExchange KE = new SSLKeyExchange(null, T12KeyAgreement.ECDHE);

        private SSLKeyExECDHANON() {
        }
    }

    private static class SSLKeyExECDHERSAOrPSS {
        private static SSLKeyExchange KE = new SSLKeyExchange(X509Authentication.RSA_OR_PSS, T12KeyAgreement.ECDHE);

        private SSLKeyExECDHERSAOrPSS() {
        }
    }

    private static class SSLKeyExECDHERSA {
        private static SSLKeyExchange KE = new SSLKeyExchange(X509Authentication.RSA, T12KeyAgreement.ECDHE);

        private SSLKeyExECDHERSA() {
        }
    }

    private static class SSLKeyExECDHEECDSA {
        private static SSLKeyExchange KE = new SSLKeyExchange(X509Authentication.EC, T12KeyAgreement.ECDHE);

        private SSLKeyExECDHEECDSA() {
        }
    }

    private static class SSLKeyExECDHRSA {
        private static SSLKeyExchange KE = new SSLKeyExchange(X509Authentication.EC, T12KeyAgreement.ECDH);

        private SSLKeyExECDHRSA() {
        }
    }

    private static class SSLKeyExECDHECDSA {
        private static SSLKeyExchange KE = new SSLKeyExchange(X509Authentication.EC, T12KeyAgreement.ECDH);

        private SSLKeyExECDHECDSA() {
        }
    }

    private static class SSLKeyExDHANONExport {
        private static SSLKeyExchange KE = new SSLKeyExchange(null, T12KeyAgreement.DHE_EXPORT);

        private SSLKeyExDHANONExport() {
        }
    }

    private static class SSLKeyExDHANON {
        private static SSLKeyExchange KE = new SSLKeyExchange(null, T12KeyAgreement.DHE);

        private SSLKeyExDHANON() {
        }
    }

    private static class SSLKeyExDHERSAExport {
        private static SSLKeyExchange KE = new SSLKeyExchange(X509Authentication.RSA, T12KeyAgreement.DHE_EXPORT);

        private SSLKeyExDHERSAExport() {
        }
    }

    private static class SSLKeyExDHERSAOrPSS {
        private static SSLKeyExchange KE = new SSLKeyExchange(X509Authentication.RSA_OR_PSS, T12KeyAgreement.DHE);

        private SSLKeyExDHERSAOrPSS() {
        }
    }

    private static class SSLKeyExDHERSA {
        private static SSLKeyExchange KE = new SSLKeyExchange(X509Authentication.RSA, T12KeyAgreement.DHE);

        private SSLKeyExDHERSA() {
        }
    }

    private static class SSLKeyExDHEDSSExport {
        private static SSLKeyExchange KE = new SSLKeyExchange(X509Authentication.DSA, T12KeyAgreement.DHE_EXPORT);

        private SSLKeyExDHEDSSExport() {
        }
    }

    private static class SSLKeyExDHEDSS {
        private static SSLKeyExchange KE = new SSLKeyExchange(X509Authentication.DSA, T12KeyAgreement.DHE);

        private SSLKeyExDHEDSS() {
        }
    }

    private static class SSLKeyExRSAExport {
        private static SSLKeyExchange KE = new SSLKeyExchange(X509Authentication.RSA, T12KeyAgreement.RSA_EXPORT);

        private SSLKeyExRSAExport() {
        }
    }

    private static class SSLKeyExRSA {
        private static SSLKeyExchange KE = new SSLKeyExchange(X509Authentication.RSA, T12KeyAgreement.RSA);

        private SSLKeyExRSA() {
        }
    }
}

