/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.SM2SignatureParameterSpec;
import java.text.MessageFormat;
import java.util.Locale;
import sun.misc.HexDumpEncoder;
import sun.security.ssl.Alert;
import sun.security.ssl.ClientHandshakeContext;
import sun.security.ssl.ConnectionContext;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.HandshakeProducer;
import sun.security.ssl.Record;
import sun.security.ssl.SSLConsumer;
import sun.security.ssl.SSLCredentials;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.ServerHandshakeContext;
import sun.security.ssl.SignatureScheme;
import sun.security.ssl.TLCPAuthentication;
import sun.security.ssl.Utilities;

final class SM2ServerKeyExchange {
    static final SSLConsumer sm2HandshakeConsumer = new SM2ServerKeyExchangeConsumer();
    static final HandshakeProducer sm2HandshakeProducer = new SM2ServerKeyExchangeProducer();

    SM2ServerKeyExchange() {
    }

    private static final class SM2ServerKeyExchangeConsumer
    implements SSLConsumer {
        private SM2ServerKeyExchangeConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, ByteBuffer byteBuffer) throws IOException {
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            SM2ServerKeyExchangeMessage sM2ServerKeyExchangeMessage = new SM2ServerKeyExchangeMessage(clientHandshakeContext, byteBuffer);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Consuming SM2 ServerKeyExchange handshake message", sM2ServerKeyExchangeMessage);
            }
        }
    }

    private static final class SM2ServerKeyExchangeProducer
    implements HandshakeProducer {
        private SM2ServerKeyExchangeProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            SM2ServerKeyExchangeMessage sM2ServerKeyExchangeMessage = new SM2ServerKeyExchangeMessage(serverHandshakeContext);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Produced SM2 ServerKeyExchange handshake message", sM2ServerKeyExchangeMessage);
            }
            sM2ServerKeyExchangeMessage.write(serverHandshakeContext.handshakeOutput);
            serverHandshakeContext.handshakeOutput.flush();
            return null;
        }
    }

    private static final class SM2ServerKeyExchangeMessage
    extends SSLHandshake.HandshakeMessage {
        private final byte[] paramsSignature;
        private final boolean useExplicitSigAlgorithm;
        private final SignatureScheme signatureScheme;

        SM2ServerKeyExchangeMessage(HandshakeContext handshakeContext) throws IOException {
            super(handshakeContext);
            Object object;
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)handshakeContext;
            TLCPAuthentication.TLCP11Possession tLCP11Possession = null;
            for (Object object2 : serverHandshakeContext.handshakePossessions) {
                if (!(object2 instanceof TLCPAuthentication.TLCP11Possession)) continue;
                tLCP11Possession = (TLCPAuthentication.TLCP11Possession)object2;
                break;
            }
            if (tLCP11Possession == null) {
                throw serverHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "No SM2 credentials negotiated for server key exchange");
            }
            this.useExplicitSigAlgorithm = serverHandshakeContext.negotiatedProtocol.useTLS12PlusSpec();
            if (this.useExplicitSigAlgorithm) {
                if (serverHandshakeContext.peerRequestedSignatureSchemes == null || !serverHandshakeContext.peerRequestedSignatureSchemes.contains((Object)SignatureScheme.SM2SIG_SM3)) {
                    throw serverHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "No supported signature algorithm for " + tLCP11Possession.popSignPrivateKey.getAlgorithm() + " key");
                }
                this.signatureScheme = SignatureScheme.SM2SIG_SM3;
            } else {
                this.signatureScheme = null;
            }
            try {
                Object object2;
                object2 = Signature.getInstance(SignatureScheme.SM2SIG_SM3.algorithm);
                ((Signature)object2).setParameter((AlgorithmParameterSpec)new SM2SignatureParameterSpec((ECPublicKey)tLCP11Possession.popSignPublicKey));
                ((Signature)object2).initSign(tLCP11Possession.popSignPrivateKey);
                SM2ServerKeyExchangeMessage.updateSignature((Signature)object2, serverHandshakeContext.clientHelloRandom.randomBytes, serverHandshakeContext.serverHelloRandom.randomBytes, tLCP11Possession.popEncCert);
                object = ((Signature)object2).sign();
            }
            catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | SignatureException | CertificateEncodingException generalSecurityException) {
                throw serverHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Failed to sign SM2 parameters: " + tLCP11Possession.popSignPrivateKey.getAlgorithm(), generalSecurityException);
            }
            this.paramsSignature = (byte[])object;
        }

        SM2ServerKeyExchangeMessage(HandshakeContext handshakeContext, ByteBuffer byteBuffer) throws IOException {
            super(handshakeContext);
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)handshakeContext;
            TLCPAuthentication.TLCP11Credentials tLCP11Credentials = null;
            for (SSLCredentials sSLCredentials : clientHandshakeContext.handshakeCredentials) {
                if (!(sSLCredentials instanceof TLCPAuthentication.TLCP11Credentials)) continue;
                tLCP11Credentials = (TLCPAuthentication.TLCP11Credentials)sSLCredentials;
                break;
            }
            if (tLCP11Credentials == null) {
                throw clientHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "No SM2 credentials negotiated for server key exchange");
            }
            this.useExplicitSigAlgorithm = clientHandshakeContext.negotiatedProtocol.useTLS12PlusSpec();
            if (this.useExplicitSigAlgorithm) {
                int n = Record.getInt16(byteBuffer);
                this.signatureScheme = SignatureScheme.valueOf(n);
                if (this.signatureScheme == null) {
                    throw clientHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Invalid signature algorithm (" + n + ") used in SM2 ServerKeyExchange handshake message");
                }
                if (!clientHandshakeContext.localSupportedSignAlgs.contains((Object)this.signatureScheme)) {
                    throw clientHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Unsupported signature algorithm (" + this.signatureScheme.name + ") used in SM2 ServerKeyExchange handshake message");
                }
            } else {
                this.signatureScheme = null;
            }
            this.paramsSignature = Record.getBytes16(byteBuffer);
            try {
                Signature signature = Signature.getInstance(SignatureScheme.SM2SIG_SM3.algorithm);
                signature.setParameter((AlgorithmParameterSpec)new SM2SignatureParameterSpec((ECPublicKey)tLCP11Credentials.popSignCert.getPublicKey()));
                signature.initVerify(tLCP11Credentials.popSignPublicKey);
                SM2ServerKeyExchangeMessage.updateSignature(signature, clientHandshakeContext.clientHelloRandom.randomBytes, clientHandshakeContext.serverHelloRandom.randomBytes, tLCP11Credentials.popEncCert);
                if (!signature.verify(this.paramsSignature)) {
                    throw clientHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Invalid SM2 ServerKeyExchange signature");
                }
            }
            catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | SignatureException | CertificateEncodingException generalSecurityException) {
                throw clientHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Cannot verify SM2 ServerKeyExchange signature", generalSecurityException);
            }
        }

        @Override
        public SSLHandshake handshakeType() {
            return SSLHandshake.SERVER_KEY_EXCHANGE;
        }

        @Override
        public int messageLength() {
            int n = 2 + this.paramsSignature.length;
            if (this.useExplicitSigAlgorithm) {
                n += SignatureScheme.sizeInRecord();
            }
            return n;
        }

        @Override
        public void send(HandshakeOutStream handshakeOutStream) throws IOException {
            if (this.useExplicitSigAlgorithm) {
                handshakeOutStream.putInt16(this.signatureScheme.id);
            }
            handshakeOutStream.putBytes16(this.paramsSignature);
        }

        public String toString() {
            if (this.useExplicitSigAlgorithm) {
                MessageFormat messageFormat = new MessageFormat("\"SM2E ServerKeyExchange\": '{'\n  \"digital signature\":  '{'\n    \"signature algorithm\": \"{0}\"\n    \"signature\": '{'\n{1}\n    '}',\n  '}'\n'}'", Locale.ENGLISH);
                HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                Object[] objectArray = new Object[]{this.signatureScheme.name, Utilities.indent(hexDumpEncoder.encodeBuffer(this.paramsSignature), "      ")};
                return messageFormat.format(objectArray);
            }
            MessageFormat messageFormat = new MessageFormat("\"SM2 ServerKeyExchange\": '{'\n  \"digital signature\":  '{'\n    \"signature\": '{'\n{0}\n    '}',\n  '}'\n'}'", Locale.ENGLISH);
            HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
            Object[] objectArray = new Object[]{Utilities.indent(hexDumpEncoder.encodeBuffer(this.paramsSignature), "      ")};
            return messageFormat.format(objectArray);
        }

        private static void updateSignature(Signature signature, byte[] byArray, byte[] byArray2, X509Certificate x509Certificate) throws SignatureException, CertificateEncodingException {
            signature.update(byArray);
            signature.update(byArray2);
            byte[] byArray3 = x509Certificate.getEncoded();
            int n = byArray3.length;
            signature.update((byte)(n >> 16 & 0xFF));
            signature.update((byte)(n >> 8 & 0xFF));
            signature.update((byte)(n & 0xFF));
            signature.update(byArray3);
        }
    }
}

