/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.net.ssl.SSLHandshakeException;
import sun.security.internal.spec.TlsRsaPremasterSecretParameterSpec;
import sun.security.ssl.Alert;
import sun.security.ssl.ClientHandshakeContext;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.SSLCredentials;
import sun.security.ssl.SSLKeyAgreementGenerator;
import sun.security.ssl.SSLKeyDerivation;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLMasterKeyDerivation;
import sun.security.ssl.SSLPossession;
import sun.security.ssl.SSLPossessionGenerator;
import sun.security.ssl.ServerHandshakeContext;
import sun.security.util.KeyUtil;

final class SM2KeyExchange {
    static final SSLPossessionGenerator sm2PoGenerator = new SM2PossessionGenerator();
    static final SSLKeyAgreementGenerator sm2KAGenerator = new SM2KAGenerator();

    SM2KeyExchange() {
    }

    private static final class SM2KAGenerator
    implements SSLKeyAgreementGenerator {
        private SM2KAGenerator() {
        }

        @Override
        public SSLKeyDerivation createKeyDerivation(HandshakeContext handshakeContext) throws IOException {
            SM2PremasterSecret sM2PremasterSecret = null;
            if (handshakeContext instanceof ClientHandshakeContext) {
                for (SSLPossession sSLPossession : handshakeContext.handshakePossessions) {
                    if (!(sSLPossession instanceof SM2PremasterSecret)) continue;
                    sM2PremasterSecret = (SM2PremasterSecret)sSLPossession;
                    break;
                }
            } else {
                for (SSLCredentials sSLCredentials : handshakeContext.handshakeCredentials) {
                    if (!(sSLCredentials instanceof SM2PremasterSecret)) continue;
                    sM2PremasterSecret = (SM2PremasterSecret)sSLCredentials;
                    break;
                }
            }
            if (sM2PremasterSecret == null) {
                throw handshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "No sufficient SM2 key agreement parameters negotiated");
            }
            return new SM2KAKeyDerivation(handshakeContext, sM2PremasterSecret.premasterSecret);
        }

        private static final class SM2KAKeyDerivation
        implements SSLKeyDerivation {
            private final HandshakeContext context;
            private final SecretKey preMasterSecret;

            SM2KAKeyDerivation(HandshakeContext handshakeContext, SecretKey secretKey) {
                this.context = handshakeContext;
                this.preMasterSecret = secretKey;
            }

            @Override
            public SecretKey deriveKey(String string, AlgorithmParameterSpec algorithmParameterSpec) throws IOException {
                SSLMasterKeyDerivation sSLMasterKeyDerivation = SSLMasterKeyDerivation.valueOf(this.context.negotiatedProtocol);
                if (sSLMasterKeyDerivation == null) {
                    throw new SSLHandshakeException("No expected master key derivation for protocol: " + this.context.negotiatedProtocol.name);
                }
                SSLKeyDerivation sSLKeyDerivation = sSLMasterKeyDerivation.createKeyDerivation(this.context, this.preMasterSecret);
                return sSLKeyDerivation.deriveKey("MasterSecret", algorithmParameterSpec);
            }
        }
    }

    static final class SM2PremasterSecret
    implements SSLPossession,
    SSLCredentials {
        final SecretKey premasterSecret;

        SM2PremasterSecret(SecretKey secretKey) {
            this.premasterSecret = secretKey;
        }

        byte[] getEncoded(PublicKey publicKey, SecureRandom secureRandom) throws GeneralSecurityException {
            Cipher cipher = Cipher.getInstance("SM2");
            cipher.init(3, (Key)publicKey, secureRandom);
            return cipher.wrap(this.premasterSecret);
        }

        static SM2PremasterSecret createPremasterSecret(ClientHandshakeContext clientHandshakeContext) throws GeneralSecurityException {
            String string = clientHandshakeContext.negotiatedProtocol.useTLS12PlusSpec() ? "SunTls12RsaPremasterSecret" : "SunTlsRsaPremasterSecret";
            KeyGenerator keyGenerator = KeyGenerator.getInstance(string);
            TlsRsaPremasterSecretParameterSpec tlsRsaPremasterSecretParameterSpec = new TlsRsaPremasterSecretParameterSpec(clientHandshakeContext.clientHelloVersion, clientHandshakeContext.negotiatedProtocol.id);
            keyGenerator.init(tlsRsaPremasterSecretParameterSpec, clientHandshakeContext.sslContext.getSecureRandom());
            return new SM2PremasterSecret(keyGenerator.generateKey());
        }

        static SM2PremasterSecret decode(ServerHandshakeContext serverHandshakeContext, PrivateKey privateKey, byte[] byArray) throws GeneralSecurityException {
            boolean bl;
            Object object;
            byte[] byArray2 = null;
            Cipher cipher = Cipher.getInstance("SM2");
            try {
                cipher.init(4, (Key)privateKey, new TlsRsaPremasterSecretParameterSpec(serverHandshakeContext.clientHelloVersion, serverHandshakeContext.negotiatedProtocol.id), serverHandshakeContext.sslContext.getSecureRandom());
                object = cipher.getProvider().getName();
                bl = !KeyUtil.isOracleJCEProvider((String)object);
            }
            catch (UnsupportedOperationException | InvalidKeyException exception) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.warning("The Cipher provider " + SM2PremasterSecret.safeProviderName(cipher) + " caused exception: " + exception.getMessage(), new Object[0]);
                }
                bl = true;
            }
            if (bl) {
                cipher = Cipher.getInstance("SM2");
                cipher.init(2, privateKey);
                boolean bl2 = false;
                try {
                    byArray2 = cipher.doFinal(byArray);
                }
                catch (BadPaddingException badPaddingException) {
                    bl2 = true;
                }
                byArray2 = KeyUtil.checkTlsPreMasterSecretKey(serverHandshakeContext.clientHelloVersion, serverHandshakeContext.negotiatedProtocol.id, serverHandshakeContext.sslContext.getSecureRandom(), byArray2, bl2);
                object = SM2PremasterSecret.generatePremasterSecret(serverHandshakeContext.clientHelloVersion, serverHandshakeContext.negotiatedProtocol.id, byArray2, serverHandshakeContext.sslContext.getSecureRandom());
            } else {
                object = (SecretKey)cipher.unwrap(byArray, "TlsRsaPremasterSecret", 3);
            }
            return new SM2PremasterSecret((SecretKey)object);
        }

        private static String safeProviderName(Cipher cipher) {
            try {
                return cipher.getProvider().toString();
            }
            catch (Exception exception) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Retrieving The Cipher provider name caused exception ", exception);
                }
                try {
                    return ((Object)cipher).toString() + " (provider name not available)";
                }
                catch (Exception exception2) {
                    if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                        SSLLogger.fine("Retrieving The Cipher name caused exception ", exception2);
                    }
                    return "(cipher/provider names not available)";
                }
            }
        }

        private static SecretKey generatePremasterSecret(int n, int n2, byte[] byArray, SecureRandom secureRandom) throws GeneralSecurityException {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Generating a premaster secret", new Object[0]);
            }
            try {
                String string = n >= ProtocolVersion.TLS12.id ? "SunTls12RsaPremasterSecret" : "SunTlsRsaPremasterSecret";
                KeyGenerator keyGenerator = KeyGenerator.getInstance(string);
                keyGenerator.init(new TlsRsaPremasterSecretParameterSpec(n, n2, byArray), secureRandom);
                return keyGenerator.generateKey();
            }
            catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException generalSecurityException) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("ECC premaster secret generation error:", new Object[0]);
                    generalSecurityException.printStackTrace(System.out);
                }
                throw new GeneralSecurityException("Could not generate premaster secret", generalSecurityException);
            }
        }
    }

    private static final class SM2PossessionGenerator
    implements SSLPossessionGenerator {
        private SM2PossessionGenerator() {
        }

        @Override
        public SSLPossession createPossession(HandshakeContext handshakeContext) {
            return null;
        }
    }
}

