/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.SunJCE;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public final class SM4KeyGenerator
extends KeyGeneratorSpi {
    private SecureRandom random;

    @Override
    protected void engineInit(SecureRandom secureRandom) {
        this.random = secureRandom;
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("No need parameters");
    }

    @Override
    protected void engineInit(int n, SecureRandom secureRandom) {
        if (n != 128) {
            throw new InvalidParameterException("The key size must be 128-bits");
        }
        this.engineInit(secureRandom);
    }

    @Override
    protected SecretKey engineGenerateKey() {
        if (this.random == null) {
            this.random = SunJCE.getRandom();
        }
        byte[] byArray = new byte[16];
        this.random.nextBytes(byArray);
        return new SecretKeySpec(byArray, "SM4");
    }
}

