/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.SunJCE;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public final class HmacSM3KeyGenerator
extends KeyGeneratorSpi {
    private int keySize = 32;
    private SecureRandom random;

    @Override
    protected void engineInit(SecureRandom secureRandom) {
        this.random = secureRandom;
        this.keySize = 32;
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("No parameter is needed");
    }

    @Override
    protected void engineInit(int n, SecureRandom secureRandom) {
        if (n < 128) {
            throw new InvalidParameterException("Key size must be 128-bits at least");
        }
        this.keySize = n + 7 >> 3;
        this.random = secureRandom;
    }

    @Override
    protected SecretKey engineGenerateKey() {
        if (this.random == null) {
            this.random = SunJCE.getRandom();
        }
        byte[] byArray = new byte[this.keySize];
        this.random.nextBytes(byArray);
        return new SecretKeySpec(byArray, "HmacSM3");
    }
}

