/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.Locale;
import sun.misc.HexDumpEncoder;
import sun.security.ssl.Alert;
import sun.security.ssl.ClientHandshakeContext;
import sun.security.ssl.ConnectionContext;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.HandshakeProducer;
import sun.security.ssl.Record;
import sun.security.ssl.SSLConsumer;
import sun.security.ssl.SSLCredentials;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLPossession;
import sun.security.ssl.ServerHandshakeContext;
import sun.security.ssl.SignatureScheme;
import sun.security.ssl.TLCPAuthentication;
import sun.security.ssl.Utilities;
import sun.security.util.SMUtil;

final class TLCPCertificateVerify {
    static final SSLConsumer tlcp11HandshakeConsumer = new TLCP11CertificateVerifyConsumer();
    static final HandshakeProducer tlcp11HandshakeProducer = new TLCP11CertificateVerifyProducer();

    TLCPCertificateVerify() {
    }

    private static final class TLCP11CertificateVerifyConsumer
    implements SSLConsumer {
        private TLCP11CertificateVerifyConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, ByteBuffer byteBuffer) throws IOException {
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            serverHandshakeContext.handshakeConsumers.remove(SSLHandshake.CERTIFICATE_VERIFY.id);
            if (serverHandshakeContext.handshakeConsumers.containsKey(SSLHandshake.CLIENT_KEY_EXCHANGE.id)) {
                throw serverHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Unexpected CertificateVerify handshake message");
            }
            TLCP11CertificateVerifyMessage tLCP11CertificateVerifyMessage = new TLCP11CertificateVerifyMessage((HandshakeContext)serverHandshakeContext, byteBuffer);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Consuming CertificateVerify handshake message", tLCP11CertificateVerifyMessage);
            }
        }
    }

    private static final class TLCP11CertificateVerifyProducer
    implements HandshakeProducer {
        private TLCP11CertificateVerifyProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            TLCPAuthentication.TLCP11Possession tLCP11Possession = null;
            for (SSLPossession sSLPossession : clientHandshakeContext.handshakePossessions) {
                if (!(sSLPossession instanceof TLCPAuthentication.TLCP11Possession)) continue;
                tLCP11Possession = (TLCPAuthentication.TLCP11Possession)sSLPossession;
                break;
            }
            if (tLCP11Possession == null || tLCP11Possession.popSignPrivateKey == null) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("No X.509 credentials negotiated for CertificateVerify", new Object[0]);
                }
                return null;
            }
            TLCP11CertificateVerifyMessage tLCP11CertificateVerifyMessage = new TLCP11CertificateVerifyMessage((HandshakeContext)clientHandshakeContext, tLCP11Possession);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Produced CertificateVerify handshake message", tLCP11CertificateVerifyMessage);
            }
            tLCP11CertificateVerifyMessage.write(clientHandshakeContext.handshakeOutput);
            clientHandshakeContext.handshakeOutput.flush();
            return null;
        }
    }

    private static final class TLCP11CertificateVerifyMessage
    extends SSLHandshake.HandshakeMessage {
        private final byte[] signature;

        TLCP11CertificateVerifyMessage(HandshakeContext handshakeContext, TLCPAuthentication.TLCP11Possession tLCP11Possession) throws IOException {
            super(handshakeContext);
            byte[] byArray;
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)handshakeContext;
            try {
                Signature signature = SignatureScheme.SM2SIG_SM3.getSigner(tLCP11Possession.popSignPrivateKey, tLCP11Possession.popSignPublicKey, false);
                signature.update(clientHandshakeContext.handshakeHash.digest());
                byArray = signature.sign();
            }
            catch (SignatureException signatureException) {
                throw clientHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Cannot produce CertificateVerify signature", signatureException);
            }
            this.signature = byArray;
        }

        TLCP11CertificateVerifyMessage(HandshakeContext handshakeContext, ByteBuffer byteBuffer) throws IOException {
            super(handshakeContext);
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)handshakeContext;
            if (byteBuffer.remaining() < 2) {
                throw serverHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Invalid CertificateVerify message: no sufficient data");
            }
            TLCPAuthentication.TLCP11Credentials tLCP11Credentials = null;
            for (SSLCredentials sSLCredentials : serverHandshakeContext.handshakeCredentials) {
                if (!(sSLCredentials instanceof TLCPAuthentication.TLCP11Credentials)) continue;
                tLCP11Credentials = (TLCPAuthentication.TLCP11Credentials)sSLCredentials;
                break;
            }
            if (tLCP11Credentials == null || tLCP11Credentials.popSignPublicKey == null) {
                throw serverHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "No X509 credentials negotiated for CertificateVerify");
            }
            this.signature = Record.getBytes16(byteBuffer);
            if (!SMUtil.isSMCert((X509Certificate)tLCP11Credentials.popSignCert)) {
                throw serverHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Only support SM certificate");
            }
            try {
                Signature signature = SignatureScheme.SM2SIG_SM3.getVerifier(tLCP11Credentials.popSignPublicKey);
                signature.update(serverHandshakeContext.handshakeHash.digest());
                if (!signature.verify(this.signature)) {
                    throw serverHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Invalid CertificateVerify signature");
                }
            }
            catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException generalSecurityException) {
                throw serverHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Unsupported signature algorithm (sm2sig_sm3) used in CertificateVerify handshake message", generalSecurityException);
            }
            catch (InvalidKeyException | SignatureException generalSecurityException) {
                throw serverHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Cannot verify CertificateVerify signature", generalSecurityException);
            }
        }

        @Override
        public SSLHandshake handshakeType() {
            return SSLHandshake.CERTIFICATE_VERIFY;
        }

        @Override
        public int messageLength() {
            return 2 + this.signature.length;
        }

        @Override
        public void send(HandshakeOutStream handshakeOutStream) throws IOException {
            handshakeOutStream.putBytes16(this.signature);
        }

        public String toString() {
            MessageFormat messageFormat = new MessageFormat("\"CertificateVerify\": '{'\n  \"signature algorithm\": sm2sig_sm3\n  \"signature\": '{'\n{0}\n  '}'\n'}'", Locale.ENGLISH);
            HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
            Object[] objectArray = new Object[]{Utilities.indent(hexDumpEncoder.encodeBuffer(this.signature), "    ")};
            return messageFormat.format(objectArray);
        }
    }
}

