/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.security.auth.x500.X500Principal;
import sun.security.ssl.Alert;
import sun.security.ssl.CertificateRequest;
import sun.security.ssl.CertificateStatus;
import sun.security.ssl.ClientHandshakeContext;
import sun.security.ssl.ConnectionContext;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.HandshakeProducer;
import sun.security.ssl.Record;
import sun.security.ssl.SSLConsumer;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLPossession;
import sun.security.ssl.ServerHandshakeContext;
import sun.security.ssl.TLCPAuthentication;

final class TLCPCertificateRequest {
    static final SSLConsumer tlcp11HandshakeConsumer = new TLCP11CertificateRequestConsumer();
    static final HandshakeProducer tlcp11HandshakeProducer = new TLCP11CertificateRequestProducer();

    TLCPCertificateRequest() {
    }

    private static final class TLCP11CertificateRequestConsumer
    implements SSLConsumer {
        private TLCP11CertificateRequestConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, ByteBuffer byteBuffer) throws IOException {
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            clientHandshakeContext.handshakeConsumers.remove(SSLHandshake.CERTIFICATE_REQUEST.id);
            clientHandshakeContext.receivedCertReq = true;
            if (clientHandshakeContext.handshakeConsumers.containsKey(SSLHandshake.CERTIFICATE.id)) {
                throw clientHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Unexpected CertificateRequest handshake message");
            }
            SSLConsumer sSLConsumer = (SSLConsumer)clientHandshakeContext.handshakeConsumers.remove(SSLHandshake.CERTIFICATE_STATUS.id);
            if (sSLConsumer != null) {
                CertificateStatus.handshakeAbsence.absent(connectionContext, null);
            }
            TLCP11CertificateRequestMessage tLCP11CertificateRequestMessage = new TLCP11CertificateRequestMessage((HandshakeContext)clientHandshakeContext, byteBuffer);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Consuming CertificateRequest handshake message", tLCP11CertificateRequestMessage);
            }
            clientHandshakeContext.handshakeProducers.put(SSLHandshake.CERTIFICATE.id, SSLHandshake.CERTIFICATE);
            clientHandshakeContext.peerSupportedAuthorities = tLCP11CertificateRequestMessage.getAuthorities();
            SSLPossession sSLPossession = TLCPAuthentication.createPossession(clientHandshakeContext, new String[]{"EC"});
            if (sSLPossession == null) {
                return;
            }
            clientHandshakeContext.handshakePossessions.add(sSLPossession);
            clientHandshakeContext.handshakeProducers.put(SSLHandshake.CERTIFICATE_VERIFY.id, SSLHandshake.CERTIFICATE_VERIFY);
        }
    }

    private static final class TLCP11CertificateRequestProducer
    implements HandshakeProducer {
        private TLCP11CertificateRequestProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            X509Certificate[] x509CertificateArray = serverHandshakeContext.sslContext.getX509TrustManager().getAcceptedIssuers();
            TLCP11CertificateRequestMessage tLCP11CertificateRequestMessage = new TLCP11CertificateRequestMessage((HandshakeContext)serverHandshakeContext, x509CertificateArray);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Produced CertificateRequest handshake message", tLCP11CertificateRequestMessage);
            }
            tLCP11CertificateRequestMessage.write(serverHandshakeContext.handshakeOutput);
            serverHandshakeContext.handshakeOutput.flush();
            serverHandshakeContext.handshakeConsumers.put(SSLHandshake.CERTIFICATE.id, SSLHandshake.CERTIFICATE);
            serverHandshakeContext.handshakeConsumers.put(SSLHandshake.CERTIFICATE_VERIFY.id, SSLHandshake.CERTIFICATE_VERIFY);
            return null;
        }
    }

    static final class TLCP11CertificateRequestMessage
    extends SSLHandshake.HandshakeMessage {
        final byte[] types;
        final List<byte[]> authorities;

        TLCP11CertificateRequestMessage(HandshakeContext handshakeContext, X509Certificate[] x509CertificateArray) throws IOException {
            super(handshakeContext);
            this.types = new byte[]{CertificateRequest.ClientCertificateType.ECDSA_SIGN.id, CertificateRequest.ClientCertificateType.RSA_SIGN.id};
            this.authorities = new ArrayList<byte[]>(x509CertificateArray.length);
            for (X509Certificate x509Certificate : x509CertificateArray) {
                X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
                this.authorities.add(x500Principal.getEncoded());
            }
        }

        TLCP11CertificateRequestMessage(HandshakeContext handshakeContext, ByteBuffer byteBuffer) throws IOException {
            super(handshakeContext);
            int n;
            int n2 = n = handshakeContext.negotiatedProtocol.isTLCP11() ? 4 : 8;
            if (byteBuffer.remaining() < n) {
                throw handshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Invalid CertificateRequest handshake message: no sufficient data");
            }
            this.types = Record.getBytes8(byteBuffer);
            if (byteBuffer.remaining() < 2) {
                throw handshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Invalid CertificateRequest handshake message: no sufficient data");
            }
            int n3 = Record.getInt16(byteBuffer);
            if (n3 > byteBuffer.remaining()) {
                throw handshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Invalid CertificateRequest message: no sufficient data");
            }
            if (n3 > 0) {
                this.authorities = new LinkedList<byte[]>();
                while (n3 > 0) {
                    byte[] byArray = Record.getBytes16(byteBuffer);
                    n3 -= 2 + byArray.length;
                    this.authorities.add(byArray);
                }
            } else {
                this.authorities = Collections.emptyList();
            }
        }

        String[] getKeyTypes() {
            return CertificateRequest.ClientCertificateType.getKeyTypes(this.types);
        }

        X500Principal[] getAuthorities() {
            X500Principal[] x500PrincipalArray = new X500Principal[this.authorities.size()];
            int n = 0;
            for (byte[] byArray : this.authorities) {
                x500PrincipalArray[n++] = new X500Principal(byArray);
            }
            return x500PrincipalArray;
        }

        @Override
        public SSLHandshake handshakeType() {
            return SSLHandshake.CERTIFICATE_REQUEST;
        }

        @Override
        public int messageLength() {
            int n = 1 + this.types.length + 2;
            for (byte[] byArray : this.authorities) {
                n += byArray.length + 2;
            }
            return n;
        }

        @Override
        public void send(HandshakeOutStream handshakeOutStream) throws IOException {
            handshakeOutStream.putBytes8(this.types);
            int n = 0;
            for (byte[] byArray : this.authorities) {
                n += byArray.length + 2;
            }
            handshakeOutStream.putInt16(n);
            for (byte[] byArray : this.authorities) {
                handshakeOutStream.putBytes16(byArray);
            }
        }

        public String toString() {
            MessageFormat messageFormat = new MessageFormat("\"CertificateRequest\": '{'\n  \"certificate types\": {0}\n  \"certificate authorities\": {1}\n'}'", Locale.ENGLISH);
            ArrayList<String> arrayList = new ArrayList<String>(this.types.length);
            for (byte by : this.types) {
                arrayList.add(CertificateRequest.ClientCertificateType.nameOf(by));
            }
            Object object = new ArrayList(this.authorities.size());
            for (byte[] byArray : this.authorities) {
                X500Principal x500Principal = new X500Principal(byArray);
                object.add(x500Principal.toString());
            }
            Object[] objectArray = new Object[]{arrayList, object};
            return messageFormat.format(objectArray);
        }
    }
}

