/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.SSLHandshakeException;
import sun.security.internal.spec.TlsKeyMaterialParameterSpec;
import sun.security.internal.spec.TlsKeyMaterialSpec;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.CipherType;
import sun.security.ssl.HKDF;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.JsseJce;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.Record;
import sun.security.ssl.SSLCipher;
import sun.security.ssl.SSLKeyDerivation;
import sun.security.ssl.SSLKeyDerivationGenerator;

enum SSLTrafficKeyDerivation implements SSLKeyDerivationGenerator
{
    SSL30("kdf_ssl30", new S30TrafficKeyDerivationGenerator()),
    TLS10("kdf_tls10", new T10TrafficKeyDerivationGenerator()),
    TLS12("kdf_tls12", new T12TrafficKeyDerivationGenerator()),
    TLS13("kdf_tls13", new T13TrafficKeyDerivationGenerator());

    final String name;
    final SSLKeyDerivationGenerator keyDerivationGenerator;

    private SSLTrafficKeyDerivation(String string2, SSLKeyDerivationGenerator sSLKeyDerivationGenerator) {
        this.name = string2;
        this.keyDerivationGenerator = sSLKeyDerivationGenerator;
    }

    static SSLTrafficKeyDerivation valueOf(ProtocolVersion protocolVersion) {
        switch (protocolVersion) {
            case SSL30: {
                return SSL30;
            }
            case TLS10: 
            case TLS11: {
                return TLS10;
            }
            case TLCP11: 
            case TLS12: {
                return TLS12;
            }
            case TLS13: {
                return TLS13;
            }
        }
        return null;
    }

    @Override
    public SSLKeyDerivation createKeyDerivation(HandshakeContext handshakeContext, SecretKey secretKey) throws IOException {
        return this.keyDerivationGenerator.createKeyDerivation(handshakeContext, secretKey);
    }

    static final class LegacyTrafficKeyDerivation
    implements SSLKeyDerivation {
        private final HandshakeContext context;
        private final SecretKey masterSecret;
        private final TlsKeyMaterialSpec keyMaterialSpec;

        LegacyTrafficKeyDerivation(HandshakeContext handshakeContext, SecretKey secretKey) {
            CipherSuite.HashAlg hashAlg;
            String string;
            this.context = handshakeContext;
            this.masterSecret = secretKey;
            CipherSuite cipherSuite = handshakeContext.negotiatedCipherSuite;
            ProtocolVersion protocolVersion = handshakeContext.negotiatedProtocol;
            int n = cipherSuite.macAlg.size;
            boolean bl = cipherSuite.exportable;
            SSLCipher sSLCipher = cipherSuite.bulkCipher;
            int n2 = bl ? sSLCipher.expandedKeySize : 0;
            byte by = protocolVersion.major;
            byte by2 = protocolVersion.minor;
            if (protocolVersion.id >= ProtocolVersion.TLS12.id || protocolVersion.isTLCP11()) {
                string = "SunTls12KeyMaterial";
                hashAlg = cipherSuite.hashAlg;
            } else {
                string = "SunTlsKeyMaterial";
                hashAlg = CipherSuite.HashAlg.H_NONE;
            }
            int n3 = sSLCipher.ivSize;
            if (sSLCipher.cipherType == CipherType.AEAD_CIPHER) {
                n3 = sSLCipher.fixedIvSize;
            } else if (sSLCipher.cipherType == CipherType.BLOCK_CIPHER && protocolVersion.useTLS11PlusSpec()) {
                n3 = 0;
            }
            TlsKeyMaterialParameterSpec tlsKeyMaterialParameterSpec = new TlsKeyMaterialParameterSpec(secretKey, by & 0xFF, by2 & 0xFF, handshakeContext.clientHelloRandom.randomBytes, handshakeContext.serverHelloRandom.randomBytes, sSLCipher.algorithm, sSLCipher.keySize, n2, n3, n, hashAlg.name, hashAlg.hashLength, hashAlg.blockSize);
            try {
                KeyGenerator keyGenerator = JsseJce.getKeyGenerator(string);
                keyGenerator.init(tlsKeyMaterialParameterSpec);
                this.keyMaterialSpec = (TlsKeyMaterialSpec)keyGenerator.generateKey();
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new ProviderException(generalSecurityException);
            }
        }

        SecretKey getTrafficKey(String string) {
            switch (string) {
                case "clientMacKey": {
                    return this.keyMaterialSpec.getClientMacKey();
                }
                case "serverMacKey": {
                    return this.keyMaterialSpec.getServerMacKey();
                }
                case "clientWriteKey": {
                    return this.keyMaterialSpec.getClientCipherKey();
                }
                case "serverWriteKey": {
                    return this.keyMaterialSpec.getServerCipherKey();
                }
                case "clientWriteIv": {
                    IvParameterSpec ivParameterSpec = this.keyMaterialSpec.getClientIv();
                    return ivParameterSpec == null ? null : new SecretKeySpec(ivParameterSpec.getIV(), "TlsIv");
                }
                case "serverWriteIv": {
                    IvParameterSpec ivParameterSpec = this.keyMaterialSpec.getServerIv();
                    return ivParameterSpec == null ? null : new SecretKeySpec(ivParameterSpec.getIV(), "TlsIv");
                }
            }
            return null;
        }

        @Override
        public SecretKey deriveKey(String string, AlgorithmParameterSpec algorithmParameterSpec) throws IOException {
            return this.getTrafficKey(string);
        }
    }

    private static enum KeySchedule {
        TlsKey("key", false),
        TlsIv("iv", true),
        TlsUpdateNplus1("traffic upd", false);

        private final byte[] label;
        private final boolean isIv;

        private KeySchedule(String string2, boolean bl) {
            this.label = ("tls13 " + string2).getBytes();
            this.isIv = bl;
        }

        int getKeyLength(CipherSuite cipherSuite) {
            if (this == TlsUpdateNplus1) {
                return cipherSuite.hashAlg.hashLength;
            }
            return this.isIv ? cipherSuite.bulkCipher.ivSize : cipherSuite.bulkCipher.keySize;
        }

        String getAlgorithm(CipherSuite cipherSuite, String string) {
            return this.isIv ? string : cipherSuite.bulkCipher.algorithm;
        }
    }

    static final class T13TrafficKeyDerivation
    implements SSLKeyDerivation {
        private final CipherSuite cs;
        private final SecretKey secret;

        T13TrafficKeyDerivation(HandshakeContext handshakeContext, SecretKey secretKey) {
            this.secret = secretKey;
            this.cs = handshakeContext.negotiatedCipherSuite;
        }

        @Override
        public SecretKey deriveKey(String string, AlgorithmParameterSpec algorithmParameterSpec) throws IOException {
            KeySchedule keySchedule = KeySchedule.valueOf(string);
            try {
                HKDF hKDF = new HKDF(this.cs.hashAlg.name);
                byte[] byArray = T13TrafficKeyDerivation.createHkdfInfo(keySchedule.label, keySchedule.getKeyLength(this.cs));
                return hKDF.expand(this.secret, byArray, keySchedule.getKeyLength(this.cs), keySchedule.getAlgorithm(this.cs, string));
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw (SSLHandshakeException)new SSLHandshakeException("Could not generate secret").initCause(generalSecurityException);
            }
        }

        private static byte[] createHkdfInfo(byte[] byArray, int n) throws IOException {
            byte[] byArray2 = new byte[4 + byArray.length];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray2);
            try {
                Record.putInt16(byteBuffer, n);
                Record.putBytes8(byteBuffer, byArray);
                Record.putInt8(byteBuffer, 0);
            }
            catch (IOException iOException) {
                throw new RuntimeException("Unexpected exception", iOException);
            }
            return byArray2;
        }
    }

    private static final class T13TrafficKeyDerivationGenerator
    implements SSLKeyDerivationGenerator {
        private T13TrafficKeyDerivationGenerator() {
        }

        @Override
        public SSLKeyDerivation createKeyDerivation(HandshakeContext handshakeContext, SecretKey secretKey) throws IOException {
            return new T13TrafficKeyDerivation(handshakeContext, secretKey);
        }
    }

    private static final class T12TrafficKeyDerivationGenerator
    implements SSLKeyDerivationGenerator {
        private T12TrafficKeyDerivationGenerator() {
        }

        @Override
        public SSLKeyDerivation createKeyDerivation(HandshakeContext handshakeContext, SecretKey secretKey) throws IOException {
            return new LegacyTrafficKeyDerivation(handshakeContext, secretKey);
        }
    }

    private static final class T10TrafficKeyDerivationGenerator
    implements SSLKeyDerivationGenerator {
        private T10TrafficKeyDerivationGenerator() {
        }

        @Override
        public SSLKeyDerivation createKeyDerivation(HandshakeContext handshakeContext, SecretKey secretKey) throws IOException {
            return new LegacyTrafficKeyDerivation(handshakeContext, secretKey);
        }
    }

    private static final class S30TrafficKeyDerivationGenerator
    implements SSLKeyDerivationGenerator {
        private S30TrafficKeyDerivationGenerator() {
        }

        @Override
        public SSLKeyDerivation createKeyDerivation(HandshakeContext handshakeContext, SecretKey secretKey) throws IOException {
            return new LegacyTrafficKeyDerivation(handshakeContext, secretKey);
        }
    }
}

