/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;
import javax.net.ssl.SSLHandshakeException;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.HKDF;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.Record;
import sun.security.ssl.SSLKeyDerivation;

final class SSLSecretDerivation
implements SSLKeyDerivation {
    private static final byte[] sha256EmptyDigest = new byte[]{-29, -80, -60, 66, -104, -4, 28, 20, -102, -5, -12, -56, -103, 111, -71, 36, 39, -82, 65, -28, 100, -101, -109, 76, -92, -107, -103, 27, 120, 82, -72, 85};
    private static final byte[] sha384EmptyDigest = new byte[]{56, -80, 96, -89, 81, -84, -106, 56, 76, -39, 50, 126, -79, -79, -29, 106, 33, -3, -73, 17, 20, -66, 7, 67, 76, 12, -57, -65, 99, -10, -31, -38, 39, 78, -34, -65, -25, 111, 101, -5, -43, 26, -46, -15, 72, -104, -71, 91};
    private static final byte[] sm3EmptyDigest = new byte[]{26, -78, 29, -125, 85, -49, -95, 127, -114, 97, 25, 72, 49, -24, 26, -113, 34, -66, -56, -57, 40, -2, -5, 116, 126, -48, 53, -21, 80, -126, -86, 43};
    private final HandshakeContext context;
    private final String hkdfAlg;
    private final CipherSuite.HashAlg hashAlg;
    private final SecretKey secret;
    private final byte[] transcriptHash;

    SSLSecretDerivation(HandshakeContext handshakeContext, SecretKey secretKey) {
        this.context = handshakeContext;
        this.secret = secretKey;
        this.hashAlg = handshakeContext.negotiatedCipherSuite.hashAlg;
        this.hkdfAlg = "HKDF-Expand/Hmac" + this.hashAlg.name.replace("-", "");
        handshakeContext.handshakeHash.update();
        this.transcriptHash = handshakeContext.handshakeHash.digest();
    }

    SSLSecretDerivation forContext(HandshakeContext handshakeContext) {
        return new SSLSecretDerivation(handshakeContext, this.secret);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public SecretKey deriveKey(String string, AlgorithmParameterSpec algorithmParameterSpec) throws IOException {
        SecretSchedule secretSchedule = SecretSchedule.valueOf(string);
        try {
            byte[] byArray;
            if (secretSchedule == SecretSchedule.TlsSaltSecret) {
                if (this.hashAlg == CipherSuite.HashAlg.H_SHA256) {
                    byArray = sha256EmptyDigest;
                } else if (this.hashAlg == CipherSuite.HashAlg.H_SHA384) {
                    byArray = sha384EmptyDigest;
                } else {
                    if (this.hashAlg != CipherSuite.HashAlg.H_SM3) throw new SSLHandshakeException("Unexpected unsupported hash algorithm: " + string);
                    byArray = sm3EmptyDigest;
                }
            } else {
                byArray = this.transcriptHash;
            }
            byte[] byArray2 = SSLSecretDerivation.createHkdfInfo(secretSchedule.label, byArray, this.hashAlg.hashLength);
            HKDF hKDF = new HKDF(this.hashAlg.name);
            return hKDF.expand(this.secret, byArray2, this.hashAlg.hashLength, string);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw (SSLHandshakeException)new SSLHandshakeException("Could not generate secret").initCause(generalSecurityException);
        }
    }

    public static byte[] createHkdfInfo(byte[] byArray, byte[] byArray2, int n) {
        byte[] byArray3 = new byte[4 + byArray.length + byArray2.length];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray3);
        try {
            Record.putInt16(byteBuffer, n);
            Record.putBytes8(byteBuffer, byArray);
            Record.putBytes8(byteBuffer, byArray2);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unexpected exception", iOException);
        }
        return byArray3;
    }

    private static enum SecretSchedule {
        TlsSaltSecret("derived"),
        TlsExtBinderKey("ext binder"),
        TlsResBinderKey("res binder"),
        TlsClientEarlyTrafficSecret("c e traffic"),
        TlsEarlyExporterMasterSecret("e exp master"),
        TlsClientHandshakeTrafficSecret("c hs traffic"),
        TlsServerHandshakeTrafficSecret("s hs traffic"),
        TlsClientAppTrafficSecret("c ap traffic"),
        TlsServerAppTrafficSecret("s ap traffic"),
        TlsExporterMasterSecret("exp master"),
        TlsResumptionMasterSecret("res master");

        private final byte[] label;

        private SecretSchedule(String string2) {
            this.label = ("tls13 " + string2).getBytes();
        }
    }
}

