/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.net.ssl.SSLHandshakeException;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.SSLKeyDerivation;
import sun.security.ssl.SSLMasterKeyDerivation;

final class SM2KAKeyDerivation
implements SSLKeyDerivation {
    private final String algorithmName;
    private final HandshakeContext context;
    private final ECPrivateKey localEphemeralPrivateKey;
    private final ECPublicKey peerEphemeralPublicKey;

    SM2KAKeyDerivation(String string, HandshakeContext handshakeContext, ECPrivateKey eCPrivateKey, ECPublicKey eCPublicKey) {
        this.algorithmName = string;
        this.context = handshakeContext;
        this.localEphemeralPrivateKey = eCPrivateKey;
        this.peerEphemeralPublicKey = eCPublicKey;
    }

    @Override
    public SecretKey deriveKey(String string, AlgorithmParameterSpec algorithmParameterSpec) throws IOException {
        try {
            KeyAgreement keyAgreement = KeyAgreement.getInstance(this.algorithmName);
            keyAgreement.init(this.localEphemeralPrivateKey, algorithmParameterSpec, null);
            keyAgreement.doPhase(this.peerEphemeralPublicKey, true);
            SecretKey secretKey = keyAgreement.generateSecret("TlsPremasterSecret");
            SSLMasterKeyDerivation sSLMasterKeyDerivation = SSLMasterKeyDerivation.valueOf(this.context.negotiatedProtocol);
            if (sSLMasterKeyDerivation == null) {
                throw new SSLHandshakeException("No expected master key derivation for protocol: " + this.context.negotiatedProtocol.name);
            }
            SSLKeyDerivation sSLKeyDerivation = sSLMasterKeyDerivation.createKeyDerivation(this.context, secretKey);
            return sSLKeyDerivation.deriveKey("MasterSecret", algorithmParameterSpec);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw (SSLHandshakeException)new SSLHandshakeException("Could not generate secret").initCause(generalSecurityException);
        }
    }
}

