/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.security.AlgorithmConstraints;
import java.security.CryptoPrimitive;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.SM2KeyAgreementParamSpec;
import java.util.EnumSet;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.net.ssl.SSLHandshakeException;
import sun.security.ssl.Alert;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.JsseJce;
import sun.security.ssl.SM2KAKeyDerivation;
import sun.security.ssl.SSLCredentials;
import sun.security.ssl.SSLKeyAgreementGenerator;
import sun.security.ssl.SSLKeyDerivation;
import sun.security.ssl.SSLPossession;
import sun.security.ssl.SSLPossessionGenerator;
import sun.security.ssl.ServerHandshakeContext;
import sun.security.ssl.SupportedGroupsExtension;
import sun.security.ssl.TLCPAuthentication;
import sun.security.util.ECUtil;

public class SM2EKeyExchange {
    static final SSLPossessionGenerator sm2ePoGenerator = new SM2EPossessionGenerator();
    static final SSLKeyAgreementGenerator sm2eKAGenerator = new SM2EKAGenerator();

    private static final class SM2EKAGenerator
    implements SSLKeyAgreementGenerator {
        private SM2EKAGenerator() {
        }

        @Override
        public SSLKeyDerivation createKeyDerivation(HandshakeContext handshakeContext) throws IOException {
            SM2EPossession sM2EPossession = null;
            SM2ECredentials sM2ECredentials = null;
            for (SSLPossession sSLPossession : handshakeContext.handshakePossessions) {
                if (!(sSLPossession instanceof SM2EPossession)) continue;
                SupportedGroupsExtension.NamedGroup namedGroup = ((SM2EPossession)sSLPossession).namedGroup;
                for (SSLCredentials sSLCredentials : handshakeContext.handshakeCredentials) {
                    if (!(sSLCredentials instanceof SM2ECredentials) || !namedGroup.equals((Object)((SM2ECredentials)sSLCredentials).namedGroup)) continue;
                    sM2ECredentials = (SM2ECredentials)sSLCredentials;
                    break;
                }
                if (sM2ECredentials == null) continue;
                sM2EPossession = (SM2EPossession)sSLPossession;
                break;
            }
            if (sM2EPossession == null || sM2ECredentials == null) {
                throw handshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "No sufficient SM2 key agreement parameters negotiated");
            }
            return new SM2KAKeyDerivation("SM2", handshakeContext, sM2EPossession.ephemeralPrivateKey, sM2ECredentials.ephemeralPublicKey);
        }
    }

    private static final class SM2EPossessionGenerator
    implements SSLPossessionGenerator {
        private SM2EPossessionGenerator() {
        }

        @Override
        public SSLPossession createPossession(HandshakeContext handshakeContext) {
            SupportedGroupsExtension.NamedGroup namedGroup = null;
            namedGroup = handshakeContext.clientRequestedNamedGroups != null && !handshakeContext.clientRequestedNamedGroups.isEmpty() ? SupportedGroupsExtension.SupportedGroups.getPreferredGroup(handshakeContext.negotiatedProtocol, handshakeContext.algorithmConstraints, SupportedGroupsExtension.NamedGroupType.NAMED_GROUP_ECDHE, handshakeContext.clientRequestedNamedGroups) : SupportedGroupsExtension.SupportedGroups.getPreferredGroup(handshakeContext.negotiatedProtocol, handshakeContext.algorithmConstraints, SupportedGroupsExtension.NamedGroupType.NAMED_GROUP_ECDHE);
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)handshakeContext;
            TLCPAuthentication.TLCP11Possession tLCP11Possession = null;
            if (serverHandshakeContext.interimAuthn instanceof TLCPAuthentication.TLCP11Possession) {
                tLCP11Possession = (TLCPAuthentication.TLCP11Possession)serverHandshakeContext.interimAuthn;
            }
            if (namedGroup == SupportedGroupsExtension.NamedGroup.CURVESM2) {
                return new SM2EPossession(tLCP11Possession, namedGroup, handshakeContext.sslContext.getSecureRandom());
            }
            return null;
        }
    }

    static final class SM2EPossession
    implements SSLPossession {
        final ECPrivateKey ephemeralPrivateKey;
        final ECPublicKey ephemeralPublicKey;
        final ECPrivateKey popEncPrivateKey;
        final ECPublicKey popEncPublicKey;
        final SupportedGroupsExtension.NamedGroup namedGroup;

        SM2EPossession(TLCPAuthentication.TLCP11Possession tLCP11Possession, SupportedGroupsExtension.NamedGroup namedGroup, SecureRandom secureRandom) {
            try {
                KeyPairGenerator keyPairGenerator = JsseJce.getKeyPairGenerator("EC");
                ECGenParameterSpec eCGenParameterSpec = (ECGenParameterSpec)namedGroup.getParameterSpec();
                keyPairGenerator.initialize(eCGenParameterSpec, secureRandom);
                KeyPair keyPair = keyPairGenerator.generateKeyPair();
                this.ephemeralPrivateKey = (ECPrivateKey)keyPair.getPrivate();
                this.ephemeralPublicKey = (ECPublicKey)keyPair.getPublic();
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new RuntimeException("Could not generate SM2 keypair", generalSecurityException);
            }
            this.popEncPrivateKey = (ECPrivateKey)tLCP11Possession.popEncPrivateKey;
            this.popEncPublicKey = (ECPublicKey)tLCP11Possession.popEncPublicKey;
            this.namedGroup = namedGroup;
        }

        @Override
        public byte[] encode() {
            return ECUtil.encodePoint(this.ephemeralPublicKey.getW(), this.ephemeralPublicKey.getParams().getCurve());
        }

        SecretKey getAgreedSecret(ECPublicKey eCPublicKey, boolean bl) throws SSLHandshakeException {
            try {
                SM2KeyAgreementParamSpec sM2KeyAgreementParamSpec = new SM2KeyAgreementParamSpec(this.popEncPrivateKey, this.popEncPublicKey, eCPublicKey, bl, 32);
                KeyAgreement keyAgreement = KeyAgreement.getInstance("SM2");
                keyAgreement.init((Key)this.ephemeralPrivateKey, (AlgorithmParameterSpec)sM2KeyAgreementParamSpec);
                keyAgreement.doPhase(eCPublicKey, true);
                return keyAgreement.generateSecret("TlsPremasterSecret");
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw (SSLHandshakeException)new SSLHandshakeException("Could not generate secret").initCause(generalSecurityException);
            }
        }

        SecretKey getAgreedSecret(byte[] byArray, boolean bl) throws SSLHandshakeException {
            try {
                ECParameterSpec eCParameterSpec = this.ephemeralPublicKey.getParams();
                ECPoint eCPoint = ECUtil.decodePoint(byArray, eCParameterSpec.getCurve());
                KeyFactory keyFactory = KeyFactory.getInstance("SM2");
                ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(eCPoint, eCParameterSpec);
                ECPublicKey eCPublicKey = (ECPublicKey)keyFactory.generatePublic(eCPublicKeySpec);
                return this.getAgreedSecret(eCPublicKey, bl);
            }
            catch (IOException | GeneralSecurityException exception) {
                throw (SSLHandshakeException)new SSLHandshakeException("Could not generate secret").initCause(exception);
            }
        }

        void checkConstraints(AlgorithmConstraints algorithmConstraints, byte[] byArray) throws SSLHandshakeException {
            try {
                ECParameterSpec eCParameterSpec = this.ephemeralPublicKey.getParams();
                ECPoint eCPoint = ECUtil.decodePoint(byArray, eCParameterSpec.getCurve());
                ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(eCPoint, eCParameterSpec);
                KeyFactory keyFactory = KeyFactory.getInstance("SM2");
                ECPublicKey eCPublicKey = (ECPublicKey)keyFactory.generatePublic(eCPublicKeySpec);
                if (!algorithmConstraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), eCPublicKey)) {
                    throw new SSLHandshakeException("ECPublicKey does not comply to algorithm constraints");
                }
            }
            catch (IOException | GeneralSecurityException exception) {
                throw (SSLHandshakeException)new SSLHandshakeException("Could not generate ECPublicKey").initCause(exception);
            }
        }
    }

    static final class SM2ECredentials
    implements SSLCredentials {
        final ECPublicKey ephemeralPublicKey;
        final SupportedGroupsExtension.NamedGroup namedGroup;

        SM2ECredentials(ECPublicKey eCPublicKey, SupportedGroupsExtension.NamedGroup namedGroup) {
            this.ephemeralPublicKey = eCPublicKey;
            this.namedGroup = namedGroup;
        }

        static SM2ECredentials valueOf(SupportedGroupsExtension.NamedGroup namedGroup, byte[] byArray) throws IOException, GeneralSecurityException {
            if (namedGroup != SupportedGroupsExtension.NamedGroup.CURVESM2) {
                throw new RuntimeException("Credentials decoding: Not named group curveSM2");
            }
            if (byArray == null || byArray.length == 0) {
                return null;
            }
            ECParameterSpec eCParameterSpec = JsseJce.getECParameterSpec(namedGroup.oid);
            if (eCParameterSpec == null) {
                return null;
            }
            ECPoint eCPoint = JsseJce.decodePoint(byArray, eCParameterSpec.getCurve());
            KeyFactory keyFactory = KeyFactory.getInstance("SM2");
            ECPublicKey eCPublicKey = (ECPublicKey)keyFactory.generatePublic(new ECPublicKeySpec(eCPoint, eCParameterSpec));
            return new SM2ECredentials(eCPublicKey, namedGroup);
        }
    }
}

