/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.SM2ParameterSpec;
import java.text.MessageFormat;
import java.util.Locale;
import javax.crypto.SecretKey;
import sun.misc.HexDumpEncoder;
import sun.security.ssl.Alert;
import sun.security.ssl.ClientHandshakeContext;
import sun.security.ssl.ConnectionContext;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.HandshakeProducer;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.Record;
import sun.security.ssl.SM2KeyExchange;
import sun.security.ssl.SSLConsumer;
import sun.security.ssl.SSLCredentials;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLKeyDerivation;
import sun.security.ssl.SSLKeyExchange;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLTrafficKeyDerivation;
import sun.security.ssl.ServerHandshakeContext;
import sun.security.ssl.TLCPAuthentication;
import sun.security.ssl.Utilities;

final class SM2ClientKeyExchange {
    static final SSLConsumer sm2HandshakeConsumer = new SM2ClientKeyExchangeConsumer();
    static final HandshakeProducer sm2HandshakeProducer = new SM2ClientKeyExchangeProducer();

    SM2ClientKeyExchange() {
    }

    private static final class SM2ClientKeyExchangeConsumer
    implements SSLConsumer {
        private SM2ClientKeyExchangeConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, ByteBuffer byteBuffer) throws IOException {
            Object object2;
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            TLCPAuthentication.TLCP11Possession tLCP11Possession = null;
            for (Object object2 : serverHandshakeContext.handshakePossessions) {
                if (!(object2 instanceof TLCPAuthentication.TLCP11Possession)) continue;
                tLCP11Possession = (TLCPAuthentication.TLCP11Possession)object2;
                break;
            }
            if (tLCP11Possession == null) {
                throw serverHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "No SM2 possessions negotiated for client key exchange");
            }
            PrivateKey privateKey = tLCP11Possession.popEncPrivateKey;
            if (!privateKey.getAlgorithm().equals("EC")) {
                throw serverHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Not SM2 private key for client key exchange");
            }
            object2 = new SM2ClientKeyExchangeMessage(serverHandshakeContext, byteBuffer);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Consuming SM2 ClientKeyExchange handshake message", object2);
            }
            try {
                SM2KeyExchange.SM2PremasterSecret sM2PremasterSecret = SM2KeyExchange.SM2PremasterSecret.decode(serverHandshakeContext, privateKey, ((SM2ClientKeyExchangeMessage)object2).encrypted);
                serverHandshakeContext.handshakeCredentials.add(sM2PremasterSecret);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw serverHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Cannot decode SM2 premaster secret", generalSecurityException);
            }
            SSLKeyExchange sSLKeyExchange = SSLKeyExchange.valueOf(serverHandshakeContext.negotiatedCipherSuite.keyExchange, serverHandshakeContext.negotiatedProtocol);
            if (sSLKeyExchange == null) {
                throw serverHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key exchange type");
            }
            SSLKeyDerivation sSLKeyDerivation = sSLKeyExchange.createKeyDerivation(serverHandshakeContext);
            SecretKey secretKey = sSLKeyDerivation.deriveKey("MasterSecret", null);
            serverHandshakeContext.handshakeSession.setMasterSecret(secretKey);
            SSLTrafficKeyDerivation sSLTrafficKeyDerivation = SSLTrafficKeyDerivation.valueOf(serverHandshakeContext.negotiatedProtocol);
            if (sSLTrafficKeyDerivation == null) {
                throw serverHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key derivation: " + (Object)((Object)serverHandshakeContext.negotiatedProtocol));
            }
            serverHandshakeContext.handshakeKeyDerivation = sSLTrafficKeyDerivation.createKeyDerivation(serverHandshakeContext, secretKey);
        }
    }

    private static final class SM2ClientKeyExchangeProducer
    implements HandshakeProducer {
        private SM2ClientKeyExchangeProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            SM2ClientKeyExchangeMessage sM2ClientKeyExchangeMessage;
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            TLCPAuthentication.TLCP11Credentials tLCP11Credentials = null;
            for (SSLCredentials sSLCredentials : clientHandshakeContext.handshakeCredentials) {
                if (!(sSLCredentials instanceof TLCPAuthentication.TLCP11Credentials)) continue;
                tLCP11Credentials = (TLCPAuthentication.TLCP11Credentials)sSLCredentials;
                break;
            }
            if (tLCP11Credentials == null) {
                throw clientHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "No SM2 credentials negotiated for client key exchange");
            }
            ECPublicKey eCPublicKey = (ECPublicKey)tLCP11Credentials.popEncPublicKey;
            if (!eCPublicKey.getAlgorithm().equals("EC") || eCPublicKey.getParams() instanceof SM2ParameterSpec) {
                throw clientHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Not SM2 public key for client key exchange");
            }
            try {
                SSLCredentials sSLCredentials;
                sSLCredentials = SM2KeyExchange.SM2PremasterSecret.createPremasterSecret(clientHandshakeContext);
                clientHandshakeContext.handshakePossessions.add(sSLCredentials);
                sM2ClientKeyExchangeMessage = new SM2ClientKeyExchangeMessage(clientHandshakeContext, (SM2KeyExchange.SM2PremasterSecret)sSLCredentials, eCPublicKey);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw clientHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Cannot generate SM2 premaster secret", generalSecurityException);
            }
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Produced SM2 ClientKeyExchange handshake message", sM2ClientKeyExchangeMessage);
            }
            sM2ClientKeyExchangeMessage.write(clientHandshakeContext.handshakeOutput);
            clientHandshakeContext.handshakeOutput.flush();
            SSLKeyExchange sSLKeyExchange = SSLKeyExchange.valueOf(clientHandshakeContext.negotiatedCipherSuite.keyExchange, clientHandshakeContext.negotiatedProtocol);
            if (sSLKeyExchange == null) {
                throw clientHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key exchange type");
            }
            SSLKeyDerivation sSLKeyDerivation = sSLKeyExchange.createKeyDerivation(clientHandshakeContext);
            SecretKey secretKey = sSLKeyDerivation.deriveKey("MasterSecret", null);
            clientHandshakeContext.handshakeSession.setMasterSecret(secretKey);
            SSLTrafficKeyDerivation sSLTrafficKeyDerivation = SSLTrafficKeyDerivation.valueOf(clientHandshakeContext.negotiatedProtocol);
            if (sSLTrafficKeyDerivation == null) {
                throw clientHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key derivation: " + (Object)((Object)clientHandshakeContext.negotiatedProtocol));
            }
            clientHandshakeContext.handshakeKeyDerivation = sSLTrafficKeyDerivation.createKeyDerivation(clientHandshakeContext, secretKey);
            return null;
        }
    }

    private static final class SM2ClientKeyExchangeMessage
    extends SSLHandshake.HandshakeMessage {
        final int protocolVersion;
        final byte[] encrypted;

        SM2ClientKeyExchangeMessage(HandshakeContext handshakeContext, SM2KeyExchange.SM2PremasterSecret sM2PremasterSecret, PublicKey publicKey) throws GeneralSecurityException {
            super(handshakeContext);
            this.protocolVersion = handshakeContext.clientHelloVersion;
            this.encrypted = sM2PremasterSecret.getEncoded(publicKey, handshakeContext.sslContext.getSecureRandom());
        }

        SM2ClientKeyExchangeMessage(HandshakeContext handshakeContext, ByteBuffer byteBuffer) throws IOException {
            super(handshakeContext);
            if (byteBuffer.remaining() < 2) {
                throw handshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Invalid SM2 ClientKeyExchange message: insufficient data");
            }
            this.protocolVersion = handshakeContext.clientHelloVersion;
            this.encrypted = Record.getBytes16(byteBuffer);
        }

        @Override
        public SSLHandshake handshakeType() {
            return SSLHandshake.CLIENT_KEY_EXCHANGE;
        }

        @Override
        public int messageLength() {
            return this.encrypted.length + 2;
        }

        @Override
        public void send(HandshakeOutStream handshakeOutStream) throws IOException {
            handshakeOutStream.putBytes16(this.encrypted);
        }

        public String toString() {
            MessageFormat messageFormat = new MessageFormat("\"SM2 ClientKeyExchange\": '{'\n  \"client_version\":  {0}\n  \"encncrypted\": '{'\n{1}\n  '}'\n'}'", Locale.ENGLISH);
            HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
            Object[] objectArray = new Object[]{ProtocolVersion.nameOf(this.protocolVersion), Utilities.indent(hexDumpEncoder.encodeBuffer(this.encrypted), "    ")};
            return messageFormat.format(objectArray);
        }
    }
}

