/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.TlsPrfGenerator;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import sun.security.internal.spec.TlsKeyMaterialParameterSpec;
import sun.security.internal.spec.TlsKeyMaterialSpec;

public final class TlsKeyMaterialGenerator
extends KeyGeneratorSpi {
    private static final String MSG = "TlsKeyMaterialGenerator must be initialized using a TlsKeyMaterialParameterSpec";
    private TlsKeyMaterialParameterSpec spec;
    private int protocolVersion;

    @Override
    protected void engineInit(SecureRandom secureRandom) {
        throw new InvalidParameterException(MSG);
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof TlsKeyMaterialParameterSpec)) {
            throw new InvalidAlgorithmParameterException(MSG);
        }
        this.spec = (TlsKeyMaterialParameterSpec)algorithmParameterSpec;
        if (!"RAW".equals(this.spec.getMasterSecret().getFormat())) {
            throw new InvalidAlgorithmParameterException("Key format must be RAW");
        }
        this.protocolVersion = this.spec.getMajorVersion() << 8 | this.spec.getMinorVersion();
        if ((this.protocolVersion < 768 || this.protocolVersion > 771) && this.protocolVersion != 257) {
            throw new InvalidAlgorithmParameterException("Only SSL 3.0, TLS 1.0/1.1/1.2, TLCP 1.1 supported");
        }
    }

    @Override
    protected void engineInit(int n, SecureRandom secureRandom) {
        throw new InvalidParameterException(MSG);
    }

    @Override
    protected SecretKey engineGenerateKey() {
        if (this.spec == null) {
            throw new IllegalStateException("TlsKeyMaterialGenerator must be initialized");
        }
        try {
            return this.engineGenerateKey0();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new ProviderException(generalSecurityException);
        }
    }

    private SecretKey engineGenerateKey0() throws GeneralSecurityException {
        byte[] byArray;
        byte[] byArray2 = this.spec.getMasterSecret().getEncoded();
        byte[] byArray3 = this.spec.getClientRandom();
        byte[] byArray4 = this.spec.getServerRandom();
        SecretKeySpec secretKeySpec = null;
        SecretKeySpec secretKeySpec2 = null;
        SecretKeySpec secretKeySpec3 = null;
        SecretKeySpec secretKeySpec4 = null;
        IvParameterSpec ivParameterSpec = null;
        IvParameterSpec ivParameterSpec2 = null;
        int n = this.spec.getMacKeyLength();
        int n2 = this.spec.getExpandedCipherKeyLength();
        boolean bl = n2 != 0;
        int n3 = this.spec.getCipherKeyLength();
        int n4 = this.spec.getIvLength();
        int n5 = n + n3 + (bl ? 0 : n4);
        byte[] byArray5 = new byte[n5 <<= 1];
        MessageDigest messageDigest = null;
        MessageDigest messageDigest2 = null;
        if (this.protocolVersion >= 771 || this.protocolVersion == 257) {
            byArray = TlsPrfGenerator.concat(byArray4, byArray3);
            byArray5 = TlsPrfGenerator.doTLS12PRF(byArray2, TlsPrfGenerator.LABEL_KEY_EXPANSION, byArray, n5, this.spec.getPRFHashAlg(), this.spec.getPRFHashLength(), this.spec.getPRFBlockSize());
        } else if (this.protocolVersion >= 769) {
            messageDigest = MessageDigest.getInstance("MD5");
            messageDigest2 = MessageDigest.getInstance("SHA1");
            byArray = TlsPrfGenerator.concat(byArray4, byArray3);
            byArray5 = TlsPrfGenerator.doTLS10PRF(byArray2, TlsPrfGenerator.LABEL_KEY_EXPANSION, byArray, n5, messageDigest, messageDigest2);
        } else {
            messageDigest = MessageDigest.getInstance("MD5");
            messageDigest2 = MessageDigest.getInstance("SHA1");
            byArray5 = new byte[n5];
            byArray = new byte[20];
            int n6 = 0;
            for (int i = n5; i > 0; i -= 16) {
                messageDigest2.update(TlsPrfGenerator.SSL3_CONST[n6]);
                messageDigest2.update(byArray2);
                messageDigest2.update(byArray4);
                messageDigest2.update(byArray3);
                messageDigest2.digest(byArray, 0, 20);
                messageDigest.update(byArray2);
                messageDigest.update(byArray);
                if (i >= 16) {
                    messageDigest.digest(byArray5, n6 << 4, 16);
                } else {
                    messageDigest.digest(byArray, 0, 16);
                    System.arraycopy(byArray, 0, byArray5, n6 << 4, i);
                }
                ++n6;
            }
        }
        int n7 = 0;
        if (n != 0) {
            byte[] byArray6 = new byte[n];
            System.arraycopy(byArray5, n7, byArray6, 0, n);
            secretKeySpec = new SecretKeySpec(byArray6, "Mac");
            System.arraycopy(byArray5, n7 += n, byArray6, 0, n);
            n7 += n;
            secretKeySpec2 = new SecretKeySpec(byArray6, "Mac");
        }
        if (n3 == 0) {
            return new TlsKeyMaterialSpec(secretKeySpec, secretKeySpec2);
        }
        String string = this.spec.getCipherAlgorithm();
        byte[] byArray7 = new byte[n3];
        System.arraycopy(byArray5, n7, byArray7, 0, n3);
        byte[] byArray8 = new byte[n3];
        System.arraycopy(byArray5, n7 += n3, byArray8, 0, n3);
        n7 += n3;
        if (!bl) {
            secretKeySpec3 = new SecretKeySpec(byArray7, string);
            secretKeySpec4 = new SecretKeySpec(byArray8, string);
            if (n4 != 0) {
                byte[] byArray9 = new byte[n4];
                System.arraycopy(byArray5, n7, byArray9, 0, n4);
                ivParameterSpec = new IvParameterSpec(byArray9);
                System.arraycopy(byArray5, n7 += n4, byArray9, 0, n4);
                n7 += n4;
                ivParameterSpec2 = new IvParameterSpec(byArray9);
            }
        } else {
            if (this.protocolVersion >= 770) {
                throw new RuntimeException("Internal Error:  TLS 1.1+ should not be negotiatingexportable ciphersuites");
            }
            if (this.protocolVersion == 769) {
                byte[] byArray10 = TlsPrfGenerator.concat(byArray3, byArray4);
                byte[] byArray11 = TlsPrfGenerator.doTLS10PRF(byArray7, TlsPrfGenerator.LABEL_CLIENT_WRITE_KEY, byArray10, n2, messageDigest, messageDigest2);
                secretKeySpec3 = new SecretKeySpec(byArray11, string);
                byArray11 = TlsPrfGenerator.doTLS10PRF(byArray8, TlsPrfGenerator.LABEL_SERVER_WRITE_KEY, byArray10, n2, messageDigest, messageDigest2);
                secretKeySpec4 = new SecretKeySpec(byArray11, string);
                if (n4 != 0) {
                    byArray11 = new byte[n4];
                    byte[] byArray12 = TlsPrfGenerator.doTLS10PRF(null, TlsPrfGenerator.LABEL_IV_BLOCK, byArray10, n4 << 1, messageDigest, messageDigest2);
                    System.arraycopy(byArray12, 0, byArray11, 0, n4);
                    ivParameterSpec = new IvParameterSpec(byArray11);
                    System.arraycopy(byArray12, n4, byArray11, 0, n4);
                    ivParameterSpec2 = new IvParameterSpec(byArray11);
                }
            } else {
                byte[] byArray13 = new byte[n2];
                messageDigest.update(byArray7);
                messageDigest.update(byArray3);
                messageDigest.update(byArray4);
                System.arraycopy(messageDigest.digest(), 0, byArray13, 0, n2);
                secretKeySpec3 = new SecretKeySpec(byArray13, string);
                messageDigest.update(byArray8);
                messageDigest.update(byArray4);
                messageDigest.update(byArray3);
                System.arraycopy(messageDigest.digest(), 0, byArray13, 0, n2);
                secretKeySpec4 = new SecretKeySpec(byArray13, string);
                if (n4 != 0) {
                    byArray13 = new byte[n4];
                    messageDigest.update(byArray3);
                    messageDigest.update(byArray4);
                    System.arraycopy(messageDigest.digest(), 0, byArray13, 0, n4);
                    ivParameterSpec = new IvParameterSpec(byArray13);
                    messageDigest.update(byArray4);
                    messageDigest.update(byArray3);
                    System.arraycopy(messageDigest.digest(), 0, byArray13, 0, n4);
                    ivParameterSpec2 = new IvParameterSpec(byArray13);
                }
            }
        }
        return new TlsKeyMaterialSpec(secretKeySpec, secretKeySpec2, secretKeySpec3, ivParameterSpec, secretKeySpec4, ivParameterSpec2);
    }
}

