/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ec;

import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.security.interfaces.ECKey;
import java.security.spec.ECPoint;
import java.security.spec.SM2ParameterSpec;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import sun.security.ec.ECOperations;
import sun.security.ec.SM2PrivateKey;
import sun.security.ec.SM2PublicKey;
import sun.security.provider.SM3Engine;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.SMUtil;

final class SM2Engine {
    private SM2PublicKey publicKey;
    private SM2PrivateKey privateKey;
    private SecureRandom random;
    private boolean encrypted;
    private SM3Engine sm3;

    SM2Engine() {
    }

    public void init(boolean bl, ECKey eCKey, SecureRandom secureRandom) {
        this.publicKey = null;
        this.privateKey = null;
        this.sm3 = null;
        if (bl) {
            this.publicKey = (SM2PublicKey)eCKey;
        } else {
            this.privateKey = (SM2PrivateKey)eCKey;
        }
        this.random = secureRandom;
        this.encrypted = bl;
        this.sm3 = new SM3Engine();
    }

    public boolean encrypted() {
        return this.encrypted;
    }

    public byte[] processBlock(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        if (!SM2Engine.checkInputBound(byArray, n, n2)) {
            throw new BadPaddingException("Invalid input");
        }
        if (this.encrypted) {
            return this.encrypt(byArray, n, n2);
        }
        return this.decrypt(byArray, n, n2);
    }

    private byte[] encrypt(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        ECPoint eCPoint;
        byte[] byArray2;
        ECPoint eCPoint2;
        byte[] byArray3;
        byte[] byArray4 = new byte[n2];
        System.arraycopy(byArray, n, byArray4, 0, byArray4.length);
        do {
            byArray2 = this.nextK();
            eCPoint = ECOperations.toECPoint(ECOperations.SM2OPS.multiply(ECOperations.SM2OPS.toAffPoint(SM2ParameterSpec.GENERATOR), byArray2));
        } while (SM2Engine.isAllZero(byArray3 = this.kdf(eCPoint2 = ECOperations.toECPoint(ECOperations.SM2OPS.multiply(ECOperations.SM2OPS.toAffPoint(this.publicKey.getW()), byArray2)), byArray4.length)));
        this.xor(byArray4, byArray3);
        byArray2 = new byte[32];
        this.sm3.update(SMUtil.bigIntToBytes32((BigInteger)eCPoint2.getAffineX()));
        this.sm3.update(byArray, n, n2);
        this.sm3.update(SMUtil.bigIntToBytes32((BigInteger)eCPoint2.getAffineY()));
        this.sm3.doFinal(byArray2);
        return this.c(eCPoint, byArray2, byArray4);
    }

    private byte[] c(ECPoint eCPoint, byte[] byArray, byte[] byArray2) throws BadPaddingException {
        DerValue[] derValueArray = new DerValue[]{new DerValue(2, eCPoint.getAffineX().toByteArray()), new DerValue(2, eCPoint.getAffineY().toByteArray()), new DerValue(4, byArray), new DerValue(4, byArray2)};
        DerOutputStream derOutputStream = new DerOutputStream();
        try {
            derOutputStream.putSequence(derValueArray);
        }
        catch (IOException iOException) {
            throw new BadPaddingException("Encode SM2 ciphertext failed");
        }
        return derOutputStream.toByteArray();
    }

    private static boolean isAllZero(byte[] byArray) {
        boolean bl = byArray.length > 0;
        for (byte by : byArray) {
            bl &= by == 0;
        }
        return bl;
    }

    private byte[] decrypt(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        byte[] byArray2;
        byte[] byArray3;
        byte[] byArray4;
        byte[] byArray5;
        DerValue[] derValueArray;
        DerInputStream derInputStream;
        byte[] byArray6 = new byte[n2];
        System.arraycopy(byArray, n, byArray6, 0, n2);
        try {
            derInputStream = new DerInputStream(byArray6);
            derValueArray = derInputStream.getSequence(2);
        }
        catch (IOException iOException) {
            throw new BadPaddingException("Decode SM2 ciphertext failed");
        }
        if (derValueArray.length != 4 || derInputStream.available() != 0) {
            throw new BadPaddingException("Invalid encoding for SM2 ciphertext");
        }
        try {
            byArray5 = derValueArray[0].getDataBytes();
            byArray4 = derValueArray[1].getDataBytes();
            byArray3 = derValueArray[2].getDataBytes();
            byArray2 = derValueArray[3].getDataBytes();
        }
        catch (IOException iOException) {
            throw new BadPaddingException("Invalid SM2 ciphertext");
        }
        ECPoint eCPoint = new ECPoint(new BigInteger(1, byArray5), new BigInteger(1, byArray4));
        byte[] byArray7 = SMUtil.toByteArrayLE((BigInteger)SM2ParameterSpec.COFACTOR);
        ECPoint eCPoint2 = ECOperations.toECPoint(ECOperations.SM2OPS.multiply(ECOperations.SM2OPS.toAffPoint(eCPoint), byArray7));
        if (!ECOperations.SM2OPS.checkOrder(eCPoint2)) {
            throw new BadPaddingException("The peer public point is invalid");
        }
        byte[] byArray8 = SMUtil.toByteArrayLE((BigInteger)this.privateKey.getS());
        ECPoint eCPoint3 = ECOperations.toECPoint(ECOperations.SM2OPS.multiply(ECOperations.SM2OPS.toAffPoint(eCPoint), byArray8));
        byte[] byArray9 = this.kdf(eCPoint3, byArray2.length);
        if (SM2Engine.isAllZero(byArray9)) {
            throw new BadPaddingException("Derived key is zero");
        }
        this.xor(byArray2, byArray9);
        byte[] byArray10 = new byte[32];
        this.sm3.update(SMUtil.bigIntToBytes32((BigInteger)eCPoint3.getAffineX()));
        this.sm3.update(byArray2);
        this.sm3.update(SMUtil.bigIntToBytes32((BigInteger)eCPoint3.getAffineY()));
        this.sm3.doFinal(byArray10);
        boolean bl = MessageDigest.isEqual(byArray10, byArray3);
        Arrays.fill(byArray5, (byte)0);
        Arrays.fill(byArray4, (byte)0);
        Arrays.fill(byArray3, (byte)0);
        if (!bl) {
            Arrays.fill(byArray2, (byte)0);
            throw new BadPaddingException("Invalid ciphertext");
        }
        return byArray2;
    }

    private void xor(byte[] byArray, byte[] byArray2) {
        for (int i = 0; i < byArray.length; ++i) {
            int n = i;
            byArray[n] = (byte)(byArray[n] ^ byArray2[i]);
        }
    }

    private byte[] nextK() {
        return ECOperations.SM2OPS.generatePrivateScalar(this.random);
    }

    private byte[] kdf(ECPoint eCPoint, int n) {
        byte[] byArray = SMUtil.bigIntToBytes32((BigInteger)eCPoint.getAffineX());
        byte[] byArray2 = SMUtil.bigIntToBytes32((BigInteger)eCPoint.getAffineY());
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return this.kdf(byArray3, n);
    }

    private byte[] kdf(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = new byte[32];
        int n2 = n % 32;
        int n3 = (n + 32 - 1) / 32;
        for (int i = 1; i <= n3; ++i) {
            this.sm3.update(byArray);
            this.sm3.update(SMUtil.intToBytes4((int)i));
            this.sm3.doFinal(byArray3);
            int n4 = i == n3 && n2 != 0 ? n2 : 32;
            System.arraycopy(byArray3, 0, byArray2, (i - 1) * 32, n4);
        }
        return byArray2;
    }

    private static boolean checkInputBound(byte[] byArray, int n, int n2) {
        return byArray != null && n >= 0 && n2 > 0 && byArray.length >= n + n2;
    }
}

