/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ec;

import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.SM2ParameterSpec;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import sun.security.ec.ConstructKeys;
import sun.security.ec.SM2Engine;
import sun.security.ec.SM2PrivateKey;
import sun.security.ec.SM2PublicKey;
import sun.security.jca.JCAUtil;

public final class SM2Cipher
extends CipherSpi {
    private static final byte[] B0 = new byte[0];
    private final SM2Engine engine = new SM2Engine();
    private final Buffer buffer = new Buffer();

    @Override
    public void engineSetMode(String string) throws NoSuchAlgorithmException {
        if (!string.equalsIgnoreCase("none")) {
            throw new NoSuchAlgorithmException("Mode must be none");
        }
    }

    @Override
    public void engineSetPadding(String string) throws NoSuchPaddingException {
        if (!string.equalsIgnoreCase("NoPadding")) {
            throw new NoSuchPaddingException("Padding must be NoPadding");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        SecureRandom secureRandom2;
        this.buffer.reset();
        SecureRandom secureRandom3 = secureRandom2 = secureRandom != null ? secureRandom : JCAUtil.getSecureRandom();
        if (n == 1 || n == 3) {
            if (!(key instanceof ECPublicKey)) throw new InvalidKeyException("Only accept ECPublicKey for encryption");
            SM2PublicKey sM2PublicKey = new SM2PublicKey((ECPublicKey)key);
            this.engine.init(true, sM2PublicKey, secureRandom2);
            return;
        } else {
            if (n != 2 && n != 4) return;
            if (!(key instanceof ECPrivateKey)) throw new InvalidKeyException("Only accept ECPrivateKey for decryption");
            SM2PrivateKey sM2PrivateKey = new SM2PrivateKey((ECPrivateKey)key);
            BigInteger bigInteger = sM2PrivateKey.getS();
            if (bigInteger.compareTo(BigInteger.ZERO) <= 0 || bigInteger.compareTo(SM2ParameterSpec.ORDER) >= 0) {
                throw new InvalidKeyException("The private key must be within the range [1, n - 1]");
            }
            this.engine.init(false, sM2PrivateKey, secureRandom2);
        }
    }

    @Override
    public void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.engineInit(n, key, secureRandom);
    }

    @Override
    public void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameters != null) {
            throw new InvalidAlgorithmParameterException("Not need AlgorithmParameters");
        }
        this.engineInit(n, key, secureRandom);
    }

    @Override
    public byte[] engineUpdate(byte[] byArray, int n, int n2) {
        this.buffer.write(byArray, n, n2);
        return B0;
    }

    @Override
    public int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        this.buffer.write(byArray, n, n2);
        return 0;
    }

    @Override
    public byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        this.update(byArray, n, n2);
        return this.doFinal();
    }

    @Override
    public int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        int n4 = this.engineGetOutputSize(this.buffer.size());
        if (n4 > byArray2.length - n3) {
            throw new ShortBufferException("Need " + n4 + " bytes for output");
        }
        this.update(byArray, n, n2);
        byte[] byArray3 = this.doFinal();
        int n5 = byArray3.length;
        System.arraycopy(byArray3, 0, byArray2, n3, n5);
        Arrays.fill(byArray3, (byte)0);
        return byArray3.length;
    }

    @Override
    public byte[] engineWrap(Key key) throws InvalidKeyException, IllegalBlockSizeException {
        byte[] byArray = key.getEncoded();
        if (byArray == null || byArray.length == 0) {
            throw new InvalidKeyException("No encoded key");
        }
        try {
            byte[] byArray2 = this.engineDoFinal(byArray, 0, byArray.length);
            return byArray2;
        }
        catch (BadPaddingException badPaddingException) {
            throw new InvalidKeyException("Wrap key failed", badPaddingException);
        }
        finally {
            Arrays.fill(byArray, (byte)0);
        }
    }

    @Override
    public Key engineUnwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] byArray2;
        if (byArray == null || byArray.length == 0) {
            throw new InvalidKeyException("No wrapped key");
        }
        try {
            byArray2 = this.engineDoFinal(byArray, 0, byArray.length);
        }
        catch (BadPaddingException | IllegalBlockSizeException generalSecurityException) {
            throw new InvalidKeyException("Unwrap key failed", generalSecurityException);
        }
        return ConstructKeys.constructKey(byArray2, string, n);
    }

    private void update(byte[] byArray, int n, int n2) {
        if (byArray == null || n2 == 0) {
            return;
        }
        this.buffer.write(byArray, n, n2);
    }

    private byte[] doFinal() throws BadPaddingException, IllegalBlockSizeException {
        try {
            byte[] byArray = this.buffer.toByteArray();
            byte[] byArray2 = this.engine.processBlock(byArray, 0, byArray.length);
            return byArray2;
        }
        finally {
            this.buffer.reset();
        }
    }

    @Override
    public AlgorithmParameters engineGetParameters() {
        return null;
    }

    @Override
    public byte[] engineGetIV() {
        return null;
    }

    @Override
    public int engineGetBlockSize() {
        return 0;
    }

    @Override
    public int engineGetOutputSize(int n) {
        int n2 = 97;
        return this.engine.encrypted() ? n + n2 : Math.max(0, n - n2);
    }

    @Override
    public int engineGetKeySize(Key key) {
        return 256;
    }

    private static final class Buffer
    extends ByteArrayOutputStream {
        private Buffer() {
        }

        @Override
        public void reset() {
            Arrays.fill(this.buf, (byte)0);
            super.reset();
        }
    }
}

