/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ec;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

final class ConstructKeys {
    ConstructKeys() {
    }

    private static final PublicKey constructPublicKey(byte[] byArray, String string) throws InvalidKeyException, NoSuchAlgorithmException {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(string);
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
            return keyFactory.generatePublic(x509EncodedKeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new NoSuchAlgorithmException("No installed providers can create keys for the " + string + "algorithm", noSuchAlgorithmException);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException("Cannot construct public key", invalidKeySpecException);
        }
    }

    private static final PrivateKey constructPrivateKey(byte[] byArray, String string) throws InvalidKeyException, NoSuchAlgorithmException {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(string);
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
            return keyFactory.generatePrivate(pKCS8EncodedKeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new NoSuchAlgorithmException("No installed providers can create keys for the " + string + "algorithm", noSuchAlgorithmException);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException("Cannot construct private key", invalidKeySpecException);
        }
    }

    private static final SecretKey constructSecretKey(byte[] byArray, String string) {
        return new SecretKeySpec(byArray, string);
    }

    static final Key constructKey(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
        switch (n) {
            case 3: {
                return ConstructKeys.constructSecretKey(byArray, string);
            }
            case 2: {
                return ConstructKeys.constructPrivateKey(byArray, string);
            }
            case 1: {
                return ConstructKeys.constructPublicKey(byArray, string);
            }
        }
        throw new InvalidKeyException("Unknown keytype " + n);
    }
}

