/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.security.DigestException;
import java.security.MessageDigest;
import sun.security.provider.SM3Engine;

public final class SM3MessageDigest
extends MessageDigest
implements Cloneable {
    private SM3Engine engine = new SM3Engine();

    public SM3MessageDigest() {
        super("SM3");
    }

    @Override
    protected int engineGetDigestLength() {
        return 32;
    }

    @Override
    protected void engineUpdate(byte by) {
        this.engine.update(by);
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        if (n < 0 || n2 < 0 || n > byArray.length - n2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.engine.update(byArray, n, n2);
    }

    @Override
    protected byte[] engineDigest() {
        byte[] byArray = new byte[32];
        this.engine.doFinal(byArray);
        return byArray;
    }

    @Override
    protected int engineDigest(byte[] byArray, int n, int n2) throws DigestException {
        if (n2 != 32) {
            throw new DigestException("The length must be 32-bytes");
        }
        this.engine.doFinal(byArray, n);
        return 32;
    }

    @Override
    protected void engineReset() {
        this.engine.reset();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SM3MessageDigest sM3MessageDigest = (SM3MessageDigest)super.clone();
        sM3MessageDigest.engine = this.engine.clone();
        return sM3MessageDigest;
    }
}

