/*
 * Decompiled with CFR 0.152.
 */
package java.security.spec;

import java.math.BigInteger;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.SM2ParameterSpec;
import java.util.Arrays;

public final class SM2PublicKeySpec
extends ECPublicKeySpec {
    public SM2PublicKeySpec(ECPoint eCPoint) {
        super(eCPoint, SM2ParameterSpec.instance());
    }

    public SM2PublicKeySpec(byte[] byArray) {
        this(SM2PublicKeySpec.pubPoint(byArray));
    }

    private static ECPoint pubPoint(byte[] byArray) {
        if (byArray.length != 65) {
            throw new IllegalArgumentException("The encoded public key must be 65-bytes: " + byArray.length);
        }
        if (byArray[0] != 4) {
            throw new IllegalArgumentException("The encoded public key must start with 0x04");
        }
        BigInteger bigInteger = new BigInteger(1, Arrays.copyOfRange(byArray, 1, 33));
        BigInteger bigInteger2 = new BigInteger(1, Arrays.copyOfRange(byArray, 33, 65));
        return new ECPoint(bigInteger, bigInteger2);
    }
}

